/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.EOFException;
import java.io.IOException;
import org.netbeans.lib.cvsclient.event.BinaryMessageEvent;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class MessageBinaryResponse
implements Response {
    private static final int CHUNK_SIZE = 262144;

    public void process(LoggedDataInputStream loggedDataInputStream, ResponseServices responseServices) throws ResponseException {
        try {
            int n;
            String string = loggedDataInputStream.readLine();
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ResponseException(numberFormatException);
            }
            int n2 = Math.min(n, 262144);
            byte[] byArray = new byte[n2];
            while (n > 0) {
                int n3 = loggedDataInputStream.read(byArray, 0, n2);
                if (n3 == -1) {
                    throw new ResponseException("EOF", ResponseException.getLocalMessage("CommandException.EndOfFile", null));
                }
                n2 = Math.min(n -= n3, 262144);
                BinaryMessageEvent binaryMessageEvent = new BinaryMessageEvent(this, byArray, n3);
                responseServices.getEventManager().fireCVSEvent(binaryMessageEvent);
            }
        }
        catch (EOFException eOFException) {
            throw new ResponseException(eOFException, ResponseException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (IOException iOException) {
            throw new ResponseException(iOException);
        }
    }

    public boolean isTerminalResponse() {
        return false;
    }
}

