/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.Fullname;
import net.java.html.json.tests.GC;
import net.java.html.json.tests.PhaseExecutor;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public class GCKnockoutTest {
    private final PhaseExecutor[] phases = new PhaseExecutor[]{null};

    @KOTest
    public void noLongerNeededArrayElementsCanDisappear() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            BrwsrCtx ctx = Utils.newContext(GCKnockoutTest.class);
            Object exp = Utils.exposeHTML(GCKnockoutTest.class, "<ul id='ul' data-bind='foreach: all'>\n  <li data-bind='text: firstName'/>\n</ul>\n");
            GC m = (GC)Models.bind((Object)new GC(), (BrwsrCtx)ctx);
            m.getAll().add((Fullname)Models.bind((Object)new Fullname("Jarda", "Tulach"), (BrwsrCtx)ctx));
            Models.applyBindings((Object)m);
            return new Data(m, ctx);
        }).then(data -> {
            int cnt = Utils.countChildren(GCKnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            GC m = data.m;
            m.getAll().add((Fullname)Models.bind((Object)new Fullname("HTML", "Java"), (BrwsrCtx)data.ctx));
        }).then(data -> {
            int cnt = Utils.countChildren(GCKnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Now two " + cnt);
            data.removed = data.m.getAll().remove(0);
        }).then(data -> {
            int cnt = Utils.countChildren(GCKnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "Again One " + cnt);
            WeakReference<Cloneable> ref = new WeakReference<Fullname>(data.removed);
            data.removed = null;
            this.assertGC(ref, "Can removed object disappear?");
            ref = new WeakReference<GC>(data.m);
            data.m = null;
            this.assertNotGC(ref, "Root model cannot GC");
        }).finalize(data -> Utils.exposeHTML(GCKnockoutTest.class, "")).start();
    }

    private void assertGC(Reference<?> ref, String msg) throws Exception {
        for (int i = 0; i < 100; ++i) {
            if (ref.get() == null) {
                return;
            }
            String gc = "var max = arguments[0];\nvar arr = [];\nfor (var i = 0; i < max; i++) {\n  arr.push(i);\n}\nreturn arr.length;";
            Object cnt = Utils.executeScript(GCKnockoutTest.class, gc, Math.pow(2.0, i));
            System.gc();
            System.runFinalization();
        }
        throw new OutOfMemoryError(msg);
    }

    private void assertNotGC(Reference<?> ref, String msg) throws Exception {
        for (int i = 0; i < 10; ++i) {
            if (ref.get() == null) {
                throw new IllegalStateException(msg);
            }
            String gc = "var max = arguments[0];\nvar arr = [];\nfor (var i = 0; i < max; i++) {\n  arr.push(i);\n}\nreturn arr.length;";
            Object cnt = Utils.executeScript(GCKnockoutTest.class, gc, Math.pow(2.0, i));
            System.gc();
            System.runFinalization();
        }
    }

    class Data {
        GC m;
        BrwsrCtx ctx;
        Fullname removed;

        Data(GC m, BrwsrCtx ctx) {
            this.m = m;
            this.ctx = ctx;
        }
    }

    static class FullnameCntrl {
        FullnameCntrl() {
        }
    }
}

