/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.Fullname;
import net.java.html.json.tests.GC;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public class GCKnockoutTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KOTest
    public void noLongerNeededArrayElementsCanDisappear() throws Exception {
        BrwsrCtx ctx = Utils.newContext(GCKnockoutTest.class);
        Object exp = Utils.exposeHTML(GCKnockoutTest.class, "<ul id='ul' data-bind='foreach: all'>\n  <li data-bind='text: firstName'/>\n</ul>\n");
        try {
            GC m = (GC)Models.bind((Object)new GC(), (BrwsrCtx)ctx);
            m.getAll().add((Fullname)Models.bind((Object)new Fullname("Jarda", "Tulach"), (BrwsrCtx)ctx));
            Models.applyBindings((Object)m);
            int cnt = Utils.countChildren(GCKnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "One child, but was " + cnt);
            m.getAll().add((Fullname)Models.bind((Object)new Fullname("HTML", "Java"), (BrwsrCtx)ctx));
            cnt = Utils.countChildren(GCKnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 2, "Now two " + cnt);
            Fullname removed = m.getAll().remove(0);
            cnt = Utils.countChildren(GCKnockoutTest.class, "ul");
            Utils.assertEquals(cnt, 1, "Again One " + cnt);
            WeakReference<Cloneable> ref = new WeakReference<Fullname>(removed);
            removed = null;
            this.assertGC(ref, "Can removed object disappear?");
            ref = new WeakReference<GC>(m);
            m = null;
            this.assertNotGC(ref, "Root model cannot GC");
        }
        finally {
            Utils.exposeHTML(GCKnockoutTest.class, "");
        }
    }

    private void assertGC(Reference<?> ref, String msg) throws Exception {
        for (int i = 0; i < 100; ++i) {
            if (ref.get() == null) {
                return;
            }
            String gc = "var max = arguments[0];\nvar arr = [];\nfor (var i = 0; i < max; i++) {\n  arr.push(i);\n}\nreturn arr.length;";
            Object cnt = Utils.executeScript(GCKnockoutTest.class, gc, Math.pow(2.0, i));
            System.gc();
            System.runFinalization();
        }
        throw new OutOfMemoryError(msg);
    }

    private void assertNotGC(Reference<?> ref, String msg) throws Exception {
        for (int i = 0; i < 10; ++i) {
            if (ref.get() == null) {
                throw new IllegalStateException(msg);
            }
            String gc = "var max = arguments[0];\nvar arr = [];\nfor (var i = 0; i < max; i++) {\n  arr.push(i);\n}\nreturn arr.length;";
            Object cnt = Utils.executeScript(GCKnockoutTest.class, gc, Math.pow(2.0, i));
            System.gc();
            System.runFinalization();
        }
    }

    static class FullnameCntrl {
        FullnameCntrl() {
        }
    }
}

