/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.People;
import net.java.html.json.tests.Person;
import net.java.html.json.tests.Sex;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public final class ConvertTypesTest {
    private static InputStream createIS(String prefix, boolean includeSex, boolean includeAddress, int array, String suffix) throws UnsupportedEncodingException {
        int repeat;
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (array != -1) {
            sb.append("[\n");
            repeat = array;
        } else {
            repeat = 1;
        }
        for (int i = 0; i < repeat; ++i) {
            sb.append("{ \"firstName\" : \"son\",\n");
            sb.append("  \"lastName\" : \"dj\" \n");
            if (includeSex) {
                sb.append(",  \"sex\" : \"MALE\" \n");
            }
            if (includeAddress) {
                sb.append(",  \"address\" : { \"street\" : \"Schnirchova\" } \n");
            }
            sb.append("}\n");
            if (i >= array - 1) continue;
            sb.append(",");
        }
        if (array != -1) {
            sb.append(']');
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
    }

    private static Object createJSON(boolean includeSex) throws UnsupportedEncodingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("firstName", "son");
        map.put("lastName", "dj");
        if (includeSex) {
            map.put("sex", "MALE");
        }
        return Utils.createObject(map, ConvertTypesTest.class);
    }

    @KOTest
    public void testConvertToPeople() throws Exception {
        Object o = ConvertTypesTest.createJSON(true);
        Person p = (Person)Models.fromRaw((BrwsrCtx)ConvertTypesTest.newContext(), Person.class, (Object)o);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
        Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Sex: " + (Object)((Object)p.getSex()));
    }

    @KOTest
    public void parseConvertToPeople() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(null, true, false, -1, null);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
        Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Sex: " + (Object)((Object)p.getSex()));
    }

    @KOTest
    public void parseConvertToPeopleWithAddress() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(null, true, true, -1, null);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
        Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Sex: " + (Object)((Object)p.getSex()));
        Utils.assertNotNull(p.getAddress(), "Some address provided");
        Utils.assertEquals(p.getAddress().getStreet(), "Schnirchova", "Is Schnirchova: " + p.getAddress());
    }

    @KOTest
    public void parseConvertToPeopleWithAddressIntoAnArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(null, true, true, -1, null);
        ArrayList arr = new ArrayList();
        Models.parse((BrwsrCtx)c, Person.class, (InputStream)o, arr);
        Utils.assertEquals(arr.size(), 1, "There is one item in " + arr);
        Person p = (Person)arr.get(0);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
        Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Sex: " + (Object)((Object)p.getSex()));
        Utils.assertNotNull(p.getAddress(), "Some address provided");
        Utils.assertEquals(p.getAddress().getStreet(), "Schnirchova", "Is Schnirchova: " + p.getAddress());
    }

    @KOTest
    public void parseNullValue() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"firstName\" : \"son\",\n");
        sb.append("  \"lastName\" : null } \n");
        ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)is);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertNull(p.getLastName(), "Last name: " + p.getLastName());
    }

    @KOTest
    public void parseNullArrayValue() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        StringBuilder sb = new StringBuilder();
        sb.append("[ null, { \"firstName\" : \"son\",\n");
        sb.append("  \"lastName\" : null } ]\n");
        ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
        ArrayList arr = new ArrayList();
        Models.parse((BrwsrCtx)c, Person.class, (InputStream)is, arr);
        Utils.assertEquals(arr.size(), 2, "There are two items in " + arr);
        Utils.assertNull(arr.get(0), "first is null " + arr);
        Person p = (Person)arr.get(1);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertNull(p.getLastName(), "Last name: " + p.getLastName());
    }

    @KOTest
    public void testConvertToPeopleWithoutSex() throws Exception {
        Object o = ConvertTypesTest.createJSON(false);
        Person p = (Person)Models.fromRaw((BrwsrCtx)ConvertTypesTest.newContext(), Person.class, (Object)o);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
        Utils.assertNull((Object)p.getSex(), "No sex: " + (Object)((Object)p.getSex()));
    }

    @KOTest
    public void parseConvertToPeopleWithoutSex() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(null, false, false, -1, null);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
        Utils.assertNull((Object)p.getSex(), "No sex: " + (Object)((Object)p.getSex()));
    }

    @KOTest
    public void parseConvertToPeopleWithAddressOnArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(null, true, true, 1, null);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
        Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Sex: " + (Object)((Object)p.getSex()));
        Utils.assertNotNull(p.getAddress(), "Some address provided");
        Utils.assertEquals(p.getAddress().getStreet(), "Schnirchova", "Is Schnirchova: " + p.getAddress());
    }

    @KOTest
    public void parseConvertToPeopleWithoutSexOnArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(null, false, false, 1, null);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
        Utils.assertNull((Object)p.getSex(), "No sex: " + (Object)((Object)p.getSex()));
    }

    @KOTest
    public void parseFirstElementFromAbiggerArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(null, false, false, 5, null);
        Person p = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
        Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
        Utils.assertNull((Object)p.getSex(), "No sex: " + (Object)((Object)p.getSex()));
    }

    @KOTest
    public void parseAllElementFromAbiggerArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(null, false, false, 5, null);
        ArrayList res = new ArrayList();
        Models.parse((BrwsrCtx)c, Person.class, (InputStream)o, res);
        Utils.assertEquals(res.size(), 5, "Five elements found" + res);
        for (Person p : res) {
            Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
            Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
            Utils.assertNull((Object)p.getSex(), "No sex: " + (Object)((Object)p.getSex()));
        }
    }

    @KOTest
    public void parseFiveElementsAsAnArray() throws Exception {
        this.doParseInnerArray(5, 5);
    }

    @KOTest
    public void parseInnerElementAsAnArray() throws Exception {
        this.doParseInnerArray(-1, 1);
    }

    private void doParseInnerArray(int array, int expect) throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS("{ \"info\" : ", false, false, array, "}");
        ArrayList res = new ArrayList();
        Models.parse((BrwsrCtx)c, People.class, (InputStream)o, res);
        Utils.assertEquals(res.size(), 1, "One people" + res);
        int cnt = 0;
        for (Person p : ((People)res.get(0)).getInfo()) {
            Utils.assertEquals("son", p.getFirstName(), "First name: " + p.getFirstName());
            Utils.assertEquals("dj", p.getLastName(), "Last name: " + p.getLastName());
            Utils.assertNull((Object)p.getSex(), "No sex: " + (Object)((Object)p.getSex()));
            ++cnt;
        }
        Utils.assertEquals(cnt, expect, "Person found in info");
    }

    @KOTest
    public void parseOnEmptyArray() throws Exception {
        BrwsrCtx c = ConvertTypesTest.newContext();
        InputStream o = ConvertTypesTest.createIS(null, false, false, 0, null);
        try {
            Models.parse((BrwsrCtx)c, Person.class, (InputStream)o);
        }
        catch (EOFException ex) {
            return;
        }
        throw new IllegalStateException("Should throw end of file exception, as the array is empty");
    }

    private static BrwsrCtx newContext() {
        return Utils.newContext(ConvertTypesTest.class);
    }
}

