/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import net.java.html.BrwsrCtx;
import net.java.html.json.tests.Address;
import net.java.html.json.tests.PersonImpl;
import net.java.html.json.tests.Sex;
import org.apidesign.html.json.spi.Proto;

public final class Person
implements Cloneable {
    private static final Html4JavaType TYPE = new Html4JavaType();
    private final Proto proto;
    private String prop_firstName;
    private String prop_lastName;
    private Sex prop_sex;
    private Address prop_address;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullName() {
        String arg1 = this.getFirstName();
        String arg2 = this.getLastName();
        try {
            this.proto.acquireLock();
            String string = PersonImpl.fullName(arg1, arg2);
            return string;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSexType() {
        Sex arg1 = this.getSex();
        try {
            this.proto.acquireLock();
            String string = PersonImpl.sexType(arg1);
            return string;
        }
        finally {
            this.proto.releaseLock();
        }
    }

    public String getFirstName() {
        this.proto.verifyUnlocked();
        return this.prop_firstName;
    }

    public void setFirstName(String v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_firstName, v)) {
            return;
        }
        this.prop_firstName = v;
        this.proto.valueHasMutated("firstName");
        this.proto.valueHasMutated("fullName");
    }

    public String getLastName() {
        this.proto.verifyUnlocked();
        return this.prop_lastName;
    }

    public void setLastName(String v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_lastName, v)) {
            return;
        }
        this.prop_lastName = v;
        this.proto.valueHasMutated("lastName");
        this.proto.valueHasMutated("fullName");
    }

    public Sex getSex() {
        this.proto.verifyUnlocked();
        return this.prop_sex;
    }

    public void setSex(Sex v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame((Object)this.prop_sex, (Object)v)) {
            return;
        }
        this.prop_sex = v;
        this.proto.valueHasMutated("sex");
        this.proto.valueHasMutated("sexType");
    }

    public Address getAddress() {
        this.proto.verifyUnlocked();
        return this.prop_address;
    }

    public void setAddress(Address v) {
        this.proto.verifyUnlocked();
        if (TYPE.isSame(this.prop_address, v)) {
            return;
        }
        this.prop_address = v;
        this.proto.valueHasMutated("address");
    }

    private void changeSex(Object data, Object ev) {
        PersonImpl.changeSex(this);
    }

    private static Class<PersonImpl> modelFor() {
        return null;
    }

    private Person(BrwsrCtx context) {
        this.proto = TYPE.createProto(this, context);
    }

    public Person() {
        this(BrwsrCtx.findDefault(Person.class));
        this.prop_address = new Address();
    }

    public Person(String firstName, String lastName, Sex sex, Address address) {
        this(BrwsrCtx.findDefault(Person.class));
        this.prop_firstName = firstName;
        this.prop_lastName = lastName;
        this.prop_sex = sex;
        this.prop_address = address;
    }

    private Person(BrwsrCtx c, Object json) {
        this(c);
        Object[] ret = new Object[4];
        this.proto.extract(json, new String[]{"firstName", "lastName", "sex", "address"}, ret);
        this.prop_firstName = (String)ret[0];
        this.prop_lastName = (String)ret[1];
        try {
            this.prop_sex = ret[2] == null ? null : Sex.valueOf(TYPE.stringValue(ret[2]));
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        this.prop_address = (Address)this.proto.read(Address.class, ret[3]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append('\"').append("firstName").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_firstName));
        sb.append(',');
        sb.append('\"').append("lastName").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_lastName));
        sb.append(',');
        sb.append('\"').append("sex").append('\"').append(":");
        sb.append(TYPE.toJSON((Object)this.prop_sex));
        sb.append(',');
        sb.append('\"').append("address").append('\"').append(":");
        sb.append(TYPE.toJSON(this.prop_address));
        sb.append('}');
        return sb.toString();
    }

    public Person clone() {
        return this.clone(this.proto.getContext());
    }

    private Person clone(BrwsrCtx ctx) {
        Person ret = new Person(ctx);
        ret.prop_firstName = this.prop_firstName;
        ret.prop_lastName = this.prop_lastName;
        ret.prop_sex = this.prop_sex;
        ret.prop_address = this.prop_address == null ? null : this.prop_address.clone();
        return ret;
    }

    public Person applyBindings() {
        this.proto.applyBindings();
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        Person p = (Person)o;
        if (!TYPE.isSame(this.prop_firstName, p.prop_firstName)) {
            return false;
        }
        if (!TYPE.isSame(this.prop_lastName, p.prop_lastName)) {
            return false;
        }
        if (!TYPE.isSame((Object)this.prop_sex, (Object)p.prop_sex)) {
            return false;
        }
        return TYPE.isSame(this.prop_address, p.prop_address);
    }

    public int hashCode() {
        int h = Person.class.getName().hashCode();
        h = TYPE.hashPlus(this.prop_firstName, h);
        h = TYPE.hashPlus(this.prop_lastName, h);
        h = TYPE.hashPlus((Object)this.prop_sex, h);
        h = TYPE.hashPlus(this.prop_address, h);
        return h;
    }

    private static class Html4JavaType
    extends Proto.Type<Person> {
        private Html4JavaType() {
            super(Person.class, PersonImpl.class, 6, 1);
            this.registerProperty("fullName", 0, true);
            this.registerProperty("sexType", 1, true);
            this.registerProperty("firstName", 2, false);
            this.registerProperty("lastName", 3, false);
            this.registerProperty("sex", 4, false);
            this.registerProperty("address", 5, false);
            this.registerFunction("changeSex", 0);
        }

        public void setValue(Person data, int type, Object value) {
            switch (type) {
                case 2: {
                    data.setFirstName((String)TYPE.extractValue(String.class, value));
                    return;
                }
                case 3: {
                    data.setLastName((String)TYPE.extractValue(String.class, value));
                    return;
                }
                case 4: {
                    data.setSex((Sex)((Object)TYPE.extractValue(Sex.class, value)));
                    return;
                }
                case 5: {
                    data.setAddress((Address)TYPE.extractValue(Address.class, value));
                    return;
                }
            }
        }

        public Object getValue(Person data, int type) {
            switch (type) {
                case 0: {
                    return data.getFullName();
                }
                case 1: {
                    return data.getSexType();
                }
                case 2: {
                    return data.getFirstName();
                }
                case 3: {
                    return data.getLastName();
                }
                case 4: {
                    return data.getSex();
                }
                case 5: {
                    return data.getAddress();
                }
            }
            throw new UnsupportedOperationException();
        }

        public void call(Person model, int type, Object data, Object ev) {
            switch (type) {
                case 0: {
                    model.changeSex(data, ev);
                    return;
                }
            }
            throw new UnsupportedOperationException();
        }

        public Proto protoFor(Object obj) {
            return ((Person)obj).proto;
        }

        public void onChange(Person model, int type) {
            throw new UnsupportedOperationException();
        }

        public void onMessage(Person model, int index, int type, Object data) {
            throw new UnsupportedOperationException("index: " + index + " type: " + type);
        }

        public Person read(BrwsrCtx c, Object json) {
            return new Person(c, json);
        }

        public Person cloneTo(Person o, BrwsrCtx c) {
            return o.clone(c);
        }
    }
}

