/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.Namespace;
import java.io.PrintWriter;

public final class ScriptEnvironment {
    private final PrintWriter err;
    private final Namespace namespace = new Namespace();
    final boolean constAsVar;
    final boolean dumpOnError;
    final boolean earlyLvalueError;
    final boolean emptyStatements;
    final boolean es6;
    final boolean es7;
    final boolean jsx;
    final FunctionStatementBehavior functionStatement;
    final boolean syntaxExtensions;
    final boolean scripting;
    final boolean shebang;
    final boolean strict;
    final boolean functionDeclarationHoisting;

    private ScriptEnvironment(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, FunctionStatementBehavior functionStatementBehavior, PrintWriter printWriter) {
        this.err = printWriter;
        this.constAsVar = bl10;
        this.dumpOnError = printWriter != null;
        this.earlyLvalueError = bl5;
        this.emptyStatements = bl6;
        this.functionStatement = functionStatementBehavior;
        this.syntaxExtensions = bl7;
        this.strict = bl;
        this.scripting = bl8;
        this.shebang = bl9;
        this.es6 = bl2;
        this.es7 = bl3;
        this.jsx = bl4;
        this.functionDeclarationHoisting = bl11;
    }

    PrintWriter getErr() {
        return this.err;
    }

    Namespace getNamespace() {
        return this.namespace;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean constAsVar;
        private boolean earlyLvalueError = true;
        private boolean emptyStatements;
        private boolean es6 = true;
        private boolean es7 = false;
        private boolean jsx = false;
        private boolean syntaxExtensions = true;
        private boolean scripting;
        private boolean shebang;
        private boolean strict;
        private boolean functionDeclarationHoisting;
        private FunctionStatementBehavior functionStatementBehavior = FunctionStatementBehavior.ERROR;
        private PrintWriter dumpOnError;

        private Builder() {
        }

        public Builder constAsVar(boolean bl) {
            this.constAsVar = bl;
            return this;
        }

        public Builder earlyLvalueError(boolean bl) {
            this.earlyLvalueError = bl;
            return this;
        }

        public Builder emptyStatements(boolean bl) {
            this.emptyStatements = bl;
            return this;
        }

        public Builder es6(boolean bl) {
            this.es6 = bl;
            return this;
        }

        public Builder es7(boolean bl) {
            this.es7 = bl;
            return this;
        }

        public Builder jsx(boolean bl) {
            this.jsx = bl;
            return this;
        }

        public Builder syntaxExtensions(boolean bl) {
            this.syntaxExtensions = bl;
            return this;
        }

        public Builder scripting(boolean bl) {
            this.scripting = bl;
            return this;
        }

        public Builder shebang(boolean bl) {
            this.shebang = bl;
            return this;
        }

        public Builder strict(boolean bl) {
            this.strict = bl;
            return this;
        }

        public Builder functionStatementBehavior(FunctionStatementBehavior functionStatementBehavior) {
            this.functionStatementBehavior = functionStatementBehavior;
            return this;
        }

        public Builder dumpOnError(PrintWriter printWriter) {
            this.dumpOnError = printWriter;
            return this;
        }

        public Builder functionDeclarationHoisting(boolean bl) {
            this.functionDeclarationHoisting = bl;
            return this;
        }

        public ScriptEnvironment build() {
            return new ScriptEnvironment(this.strict, this.es6, this.es7, this.jsx, this.earlyLvalueError, this.emptyStatements, this.syntaxExtensions, this.scripting, this.shebang, this.constAsVar, this.functionDeclarationHoisting, this.functionStatementBehavior, this.dumpOnError);
        }
    }

    public static enum FunctionStatementBehavior {
        ACCEPT,
        WARNING,
        ERROR;

    }
}

