/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;

public final class TernaryNode
extends Expression {
    private final Expression test;
    private final JoinPredecessorExpression trueExpr;
    private final JoinPredecessorExpression falseExpr;

    public TernaryNode(long l, Expression expression, JoinPredecessorExpression joinPredecessorExpression, JoinPredecessorExpression joinPredecessorExpression2) {
        super(l, joinPredecessorExpression2.getFinish());
        this.test = expression;
        this.trueExpr = joinPredecessorExpression;
        this.falseExpr = joinPredecessorExpression2;
    }

    private TernaryNode(TernaryNode ternaryNode, Expression expression, JoinPredecessorExpression joinPredecessorExpression, JoinPredecessorExpression joinPredecessorExpression2) {
        super(ternaryNode);
        this.test = expression;
        this.trueExpr = joinPredecessorExpression;
        this.falseExpr = joinPredecessorExpression2;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterTernaryNode(this)) {
            Expression expression = (Expression)this.getTest().accept(nodeVisitor);
            JoinPredecessorExpression joinPredecessorExpression = (JoinPredecessorExpression)this.trueExpr.accept(nodeVisitor);
            JoinPredecessorExpression joinPredecessorExpression2 = (JoinPredecessorExpression)this.falseExpr.accept(nodeVisitor);
            return nodeVisitor.leaveTernaryNode(this.setTest(expression).setTrueExpression(joinPredecessorExpression).setFalseExpression(joinPredecessorExpression2));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterTernaryNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        TokenType tokenType = this.tokenType();
        boolean bl2 = tokenType.needsParens(this.getTest().tokenType(), true);
        boolean bl3 = tokenType.needsParens(this.getTrueExpression().tokenType(), false);
        boolean bl4 = tokenType.needsParens(this.getFalseExpression().tokenType(), false);
        if (bl2) {
            stringBuilder.append('(');
        }
        this.getTest().toString(stringBuilder, bl);
        if (bl2) {
            stringBuilder.append(')');
        }
        stringBuilder.append(" ? ");
        if (bl3) {
            stringBuilder.append('(');
        }
        this.getTrueExpression().toString(stringBuilder, bl);
        if (bl3) {
            stringBuilder.append(')');
        }
        stringBuilder.append(" : ");
        if (bl4) {
            stringBuilder.append('(');
        }
        this.getFalseExpression().toString(stringBuilder, bl);
        if (bl4) {
            stringBuilder.append(')');
        }
    }

    public Expression getTest() {
        return this.test;
    }

    public JoinPredecessorExpression getTrueExpression() {
        return this.trueExpr;
    }

    public JoinPredecessorExpression getFalseExpression() {
        return this.falseExpr;
    }

    public TernaryNode setTest(Expression expression) {
        if (this.test == expression) {
            return this;
        }
        return new TernaryNode(this, expression, this.trueExpr, this.falseExpr);
    }

    public TernaryNode setTrueExpression(JoinPredecessorExpression joinPredecessorExpression) {
        if (this.trueExpr == joinPredecessorExpression) {
            return this;
        }
        return new TernaryNode(this, this.test, joinPredecessorExpression, this.falseExpr);
    }

    public TernaryNode setFalseExpression(JoinPredecessorExpression joinPredecessorExpression) {
        if (this.falseExpr == joinPredecessorExpression) {
            return this;
        }
        return new TernaryNode(this, this.test, this.trueExpr, joinPredecessorExpression);
    }
}

