/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.ImportSpecifierNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public class NamedImportsNode
extends Node {
    private final List<ImportSpecifierNode> importSpecifiers;

    public NamedImportsNode(long l, int n, int n2, List<ImportSpecifierNode> list) {
        super(l, n, n2);
        this.importSpecifiers = list;
    }

    private NamedImportsNode(NamedImportsNode namedImportsNode, List<ImportSpecifierNode> list) {
        super(namedImportsNode);
        this.importSpecifiers = list;
    }

    public List<ImportSpecifierNode> getImportSpecifiers() {
        return Collections.unmodifiableList(this.importSpecifiers);
    }

    public NamedImportsNode setImportSpecifiers(List<ImportSpecifierNode> list) {
        if (this.importSpecifiers == list) {
            return this;
        }
        return new NamedImportsNode(this, list);
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterNamedImportsNode(this)) {
            return nodeVisitor.leaveNamedImportsNode(this.setImportSpecifiers(Node.accept(nodeVisitor, this.importSpecifiers)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterNamedImportsNode(this);
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('{');
        for (int i = 0; i < this.importSpecifiers.size(); ++i) {
            this.importSpecifiers.get(i).toString(stringBuilder, bl);
            if (i >= this.importSpecifiers.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
    }
}

