/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.Namespace;
import com.oracle.js.parser.Parser;
import com.oracle.js.parser.ParserContextBaseNode;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.Module;
import java.util.HashSet;
import java.util.List;

class ParserContextFunctionNode
extends ParserContextBaseNode {
    private final String name;
    private final IdentNode ident;
    private final Namespace namespace;
    private final int line;
    private final FunctionNode.Kind kind;
    private List<IdentNode> parameters;
    private final long token;
    private long lastToken;
    private Object endParserState;
    private HashSet<String> parameterBoundNames;
    private IdentNode duplicateParameterBinding;
    private boolean simpleParameterList = true;
    private Module module;

    ParserContextFunctionNode(long l, IdentNode identNode, String string, Namespace namespace, int n, FunctionNode.Kind kind, List<IdentNode> list) {
        this.ident = identNode;
        this.namespace = namespace;
        this.line = n;
        this.kind = kind;
        this.name = string;
        this.parameters = list;
        this.token = l;
    }

    public String getName() {
        return this.name;
    }

    public IdentNode getIdent() {
        return this.ident;
    }

    public boolean isProgram() {
        return this.getFlag(8192) != 0;
    }

    public boolean isStrict() {
        return this.getFlag(4) != 0;
    }

    public boolean hasNestedEval() {
        return this.getFlag(64) != 0;
    }

    public boolean hasScopeBlock() {
        return this.getFlag(128) != 0;
    }

    public String uniqueName(String string) {
        return this.namespace.uniqueName(string);
    }

    public int getLineNumber() {
        return this.line;
    }

    public FunctionNode.Kind getKind() {
        return this.kind;
    }

    public List<IdentNode> getParameters() {
        return this.parameters;
    }

    void setParameters(List<IdentNode> list) {
        this.parameters = list;
    }

    public void setLastToken(long l) {
        this.lastToken = l;
    }

    public long getLastToken() {
        return this.lastToken;
    }

    public Object getEndParserState() {
        return this.endParserState;
    }

    public void setEndParserState(Object object) {
        this.endParserState = object;
    }

    public int getId() {
        return this.isProgram() ? -1 : Token.descPosition(this.token);
    }

    public boolean isMethod() {
        return this.getFlag(0x100000) != 0;
    }

    public boolean isClassConstructor() {
        return this.getFlag(0x200000) != 0;
    }

    public boolean isSubclassConstructor() {
        return this.getFlag(0x400000) != 0;
    }

    boolean addParameterBinding(IdentNode identNode) {
        if (Parser.isArguments(identNode)) {
            this.setFlag(256);
        }
        if (this.parameterBoundNames == null) {
            this.parameterBoundNames = new HashSet();
        }
        if (this.parameterBoundNames.add(identNode.getName())) {
            return true;
        }
        this.duplicateParameterBinding = identNode;
        return false;
    }

    public IdentNode getDuplicateParameterBinding() {
        return this.duplicateParameterBinding;
    }

    public boolean isSimpleParameterList() {
        return this.simpleParameterList;
    }

    public void setSimpleParameterList(boolean bl) {
        this.simpleParameterList = bl;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public boolean isAsync() {
        return this.getFlag(0x2000000) != 0;
    }
}

