/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Cancellable;
import org.openide.util.Parameters;
import org.openide.util.WeakSet;

public final class RequestProcessor
implements ScheduledExecutorService {
    private static final RequestProcessor DEFAULT;
    private static final TickTac TICK;
    private static final Logger logger;
    private static final RequestProcessor UNLIMITED;
    private static int counter;
    private static final boolean SLOW;
    String name;
    volatile boolean stopped = false;
    volatile boolean finishAwaitingTasks = false;
    private final Object processorLock = new Object();
    private HashSet<Processor> processors = new HashSet();
    private List<Item> queue = new LinkedList<Item>();
    private int running = 0;
    private int throughput;
    private Map<Class<? extends Runnable>, AtomicInteger> inParallel;
    private final int warnParallel;
    private boolean interruptThread;
    private boolean enableStackTraces;

    public RequestProcessor() {
        this(null, 1);
    }

    public RequestProcessor(String name) {
        this(name, 1);
    }

    public RequestProcessor(Class<?> forClass) {
        this(forClass.getName());
    }

    public RequestProcessor(String name, int throughput) {
        this(name, throughput, false);
    }

    public RequestProcessor(String name, int throughput, boolean interruptThread) {
        this(name, throughput, interruptThread, SLOW);
    }

    public RequestProcessor(String name, int throughput, boolean interruptThread, boolean enableStackTraces) {
        this(name, throughput, interruptThread, enableStackTraces, 0);
    }

    private RequestProcessor(String name, int throughput, boolean interruptThread, boolean enableStackTraces, int warnParallel) {
        this.throughput = throughput;
        this.name = name != null ? name : "OpenIDE-request-processor-" + counter++;
        this.interruptThread = interruptThread;
        this.enableStackTraces = enableStackTraces;
        this.warnParallel = warnParallel;
    }

    public static RequestProcessor getDefault() {
        return UNLIMITED;
    }

    @Override
    public void execute(Runnable command) {
        this.post(command);
    }

    public Task post(Runnable run) {
        return this.post(run, 0, 1);
    }

    public Task post(Runnable run, int timeToWait) {
        return this.post(run, timeToWait, 1);
    }

    public Task post(Runnable run, int timeToWait, int priority) {
        Task task = new Task(run, priority);
        task.schedule(timeToWait);
        return task;
    }

    public Task create(Runnable run) {
        return this.create(run, false);
    }

    public Task create(Runnable run, boolean initiallyFinished) {
        Task t = new Task(run);
        t.markCreated();
        if (initiallyFinished) {
            t.notifyFinished();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestProcessorThread() {
        Thread c = Thread.currentThread();
        Object object = this.processorLock;
        synchronized (object) {
            return c instanceof Processor && this.processors.contains((Processor)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this == UNLIMITED || this == DEFAULT) {
            throw new IllegalArgumentException("Can't stop shared RP's");
        }
        Object object = this.processorLock;
        synchronized (object) {
            this.stopped = true;
            for (Processor p : this.processors) {
                p.interrupt();
            }
        }
    }

    @Deprecated
    public static Task postRequest(Runnable run) {
        return DEFAULT.post(run);
    }

    @Deprecated
    public static Task postRequest(Runnable run, int timeToWait) {
        return DEFAULT.post(run, timeToWait);
    }

    @Deprecated
    public static Task postRequest(Runnable run, int timeToWait, int priority) {
        return DEFAULT.post(run, timeToWait, priority);
    }

    @Deprecated
    public static Task createRequest(Runnable run) {
        return DEFAULT.create(run);
    }

    static Logger logger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Item item) {
        boolean wasNull;
        Logger em = RequestProcessor.logger();
        boolean loggable = em.isLoggable(Level.FINE);
        Object object = this.processorLock;
        synchronized (object) {
            boolean bl = wasNull = item.getTask() == null;
            if (!wasNull) {
                this.prioritizedEnqueue(item);
                if (this.running < this.throughput) {
                    ++this.running;
                    Processor proc = Processor.get();
                    this.processors.add(proc);
                    proc.setName(this.name);
                    proc.attachTo(this);
                }
            }
        }
        if (loggable) {
            if (wasNull) {
                em.log(Level.FINE, "Null task for item {0}", item);
            } else {
                em.log(Level.FINE, "Item enqueued: {0} status: {1}", new Object[]{item.action, item.enqueued});
            }
        }
    }

    private void prioritizedEnqueue(Item item) {
        int iprio = item.getPriority();
        if (this.queue.isEmpty()) {
            this.queue.add(item);
            item.enqueued = true;
            return;
        }
        if (iprio > this.queue.get(this.queue.size() - 1).getPriority()) {
            ListIterator<Item> it = this.queue.listIterator();
            while (it.hasNext()) {
                Item next = it.next();
                if (iprio <= next.getPriority()) continue;
                it.set(item);
                it.add(next);
                item.enqueued = true;
                return;
            }
            throw new IllegalStateException("Prioritized enqueue failed!");
        }
        this.queue.add(item);
        item.enqueued = true;
    }

    Task askForWork(Processor worker, String debug) {
        if (this.queue.isEmpty() || this.stopped && !this.finishAwaitingTasks) {
            this.processors.remove(worker);
            Processor.put(worker, debug);
            --this.running;
            return null;
        }
        Item i = this.queue.remove(0);
        Task t = i.getTask();
        i.clear(worker);
        return t;
    }

    @Override
    public void shutdown() {
        if (this == UNLIMITED) {
            throw new IllegalStateException("Cannot shut down the default request processor");
        }
        this.stopped = true;
        this.finishAwaitingTasks = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        if (this == UNLIMITED) {
            throw new IllegalStateException("Cannot shut down the default request processor");
        }
        this.stop();
        Object object = this.processorLock;
        synchronized (object) {
            ArrayList<Runnable> result = new ArrayList<Runnable>(this.queue.size());
            for (Item item : this.queue) {
                Task task = item.getTask();
                if (task == null || task.run == null) continue;
                Runnable r = task.run;
                if (r instanceof RunnableWrapper) {
                    Runnable other = ((RunnableWrapper)((Object)r)).getRunnable();
                    r = other == null ? r : other;
                }
                result.add(r);
            }
            return result;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.stopped;
    }

    @Override
    public boolean isTerminated() {
        boolean result = true;
        Set<Processor> set = this.collectProcessors(new HashSet<Processor>());
        for (Processor p : set) {
            if (!p.isAlive() || !p.belongsTo(this)) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        Parameters.notNull("unit", (Object)unit);
        long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        boolean result = this.stopped;
        long doneTime = System.currentTimeMillis() + timeoutMillis;
        Set<Processor> procs = new HashSet<Processor>();
        block0: do {
            if ((procs = this.collectProcessors(procs)).isEmpty()) {
                return true;
            }
            for (Processor p : procs) {
                long remaining = doneTime - System.currentTimeMillis();
                if (remaining <= 0L) {
                    result = this.collectProcessors(procs).isEmpty();
                    break block0;
                }
                if (p.belongsTo(this)) {
                    p.join(remaining);
                }
                result = !p.isAlive() || !p.belongsTo(this);
            }
            procs.clear();
        } while (!procs.isEmpty());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Processor> collectProcessors(Set<Processor> procs) {
        procs.clear();
        Object object = this.processorLock;
        synchronized (object) {
            for (Processor p : this.processors) {
                if (!p.belongsTo(this)) continue;
                procs.add(p);
            }
        }
        return procs;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Parameters.notNull("task", task);
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        RPFutureTask<T> result = new RPFutureTask<T>(task);
        Task t = this.create(result);
        result.setTask(t);
        t.schedule(0);
        return result;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T predefinedResult) {
        Parameters.notNull("task", task);
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        RPFutureTask<T> result = new RPFutureTask<T>(task, predefinedResult);
        Task t = this.create(result);
        result.setTask(t);
        t.schedule(0);
        return result;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, null);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        Parameters.notNull("tasks", tasks);
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        CountDownLatch wait = new CountDownLatch(tasks.size());
        for (Callable<T> c : tasks) {
            if (c == null) {
                throw new NullPointerException("Contains null tasks: " + tasks);
            }
            WaitableCallable<T> delegate = new WaitableCallable<T>(c, wait);
            result.add(this.submit(delegate));
        }
        wait.await();
        return result;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Parameters.notNull("unit", (Object)unit);
        Parameters.notNull("tasks", tasks);
        CountDownLatch wait = new CountDownLatch(tasks.size());
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> callable : tasks) {
            if (callable == null) {
                throw new NullPointerException("Contains null tasks: " + tasks);
            }
            WaitableCallable<T> delegate = new WaitableCallable<T>(callable, wait);
            result.add(this.submit(delegate));
        }
        if (!wait.await(timeout, unit)) {
            for (Future future : result) {
                RPFutureTask ft = (RPFutureTask)future;
                ft.cancel(true);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        Parameters.notNull("tasks", tasks);
        CountDownLatch wait = new CountDownLatch(1);
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        AtomicReference ref = new AtomicReference();
        try {
            for (Callable<T> callable : tasks) {
                if (callable == null) {
                    throw new NullPointerException("Contains null tasks: " + tasks);
                }
                WaitableCallable<T> delegate = new WaitableCallable<T>(callable, ref, wait);
                result.add(this.submit(delegate));
            }
            wait.await();
        }
        finally {
            for (Future future : result) {
                RPFutureTask ft = (RPFutureTask)future;
                ft.cancel(true);
            }
        }
        return (T)ref.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Parameters.notNull("unit", (Object)unit);
        Parameters.notNull("tasks", tasks);
        CountDownLatch wait = new CountDownLatch(1);
        ArrayList<Future<T>> result = new ArrayList<Future<T>>(tasks.size());
        AtomicReference ref = new AtomicReference();
        try {
            for (Callable<T> callable : tasks) {
                if (callable == null) {
                    throw new NullPointerException("Contains null tasks: " + tasks);
                }
                WaitableCallable<T> delegate = new WaitableCallable<T>(callable, ref, wait);
                result.add(this.submit(delegate));
            }
            wait.await(timeout, unit);
        }
        finally {
            for (Future future : result) {
                RPFutureTask ft = (RPFutureTask)future;
                ft.cancel(true);
            }
        }
        return (T)ref.get();
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        Parameters.notNull("command", command);
        Parameters.notNull("unit", (Object)unit);
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay: " + delay);
        }
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        long delayMillis = TimeUnit.MILLISECONDS.convert(delay, unit);
        ScheduledRPFutureTask<Object> result = new ScheduledRPFutureTask<Object>(command, null, delayMillis);
        Task t = this.create(result);
        result.setTask(t);
        t.schedule(delayMillis);
        return result;
    }

    public <T> ScheduledFuture<T> schedule(Callable<T> callable, long delay, TimeUnit unit) {
        Parameters.notNull("unit", (Object)unit);
        Parameters.notNull("callable", callable);
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay: " + delay);
        }
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        long delayMillis = TimeUnit.MILLISECONDS.convert(delay, unit);
        ScheduledRPFutureTask<T> result = new ScheduledRPFutureTask<T>(callable, delayMillis);
        Task t = this.create(result);
        result.setTask(t);
        t.schedule(delayMillis);
        return result;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleFixed(command, initialDelay, period, unit, false);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduleFixed(command, initialDelay, delay, unit, true);
    }

    private ScheduledFuture<?> scheduleFixed(Runnable command, long initialDelay, long period, TimeUnit unit, boolean fixedDelay) {
        Task t;
        Parameters.notNull("unit", (Object)unit);
        Parameters.notNull("command", command);
        if (period < 0L) {
            throw new IllegalArgumentException("Negative delay: " + period);
        }
        if (initialDelay < 0L) {
            throw new IllegalArgumentException("Negative initialDelay: " + initialDelay);
        }
        if (this.stopped) {
            throw new RejectedExecutionException("Request Processor already stopped");
        }
        long initialDelayMillis = TimeUnit.MILLISECONDS.convert(initialDelay, unit);
        long periodMillis = TimeUnit.MILLISECONDS.convert(period, unit);
        TaskFutureWrapper wrap = fixedDelay ? new FixedDelayTask(command, initialDelayMillis, periodMillis) : new FixedRateTask(command, initialDelay, periodMillis);
        wrap.t = t = this.create(wrap);
        t.cancelled = wrap.cancelled;
        t.schedule(initialDelayMillis);
        return wrap;
    }

    static {
        Processor.class.hashCode();
        DEFAULT = new RequestProcessor();
        TICK = new TickTac();
        TICK.start();
        logger = Logger.getLogger("org.openide.util.RequestProcessor");
        counter = 0;
        boolean slow = false;
        if (!$assertionsDisabled) {
            slow = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        UNLIMITED = new RequestProcessor("Default RequestProcessor", 50, false, SLOW, (SLOW = slow) ? 3 : 0);
    }

    private static final class TickTac
    extends Thread
    implements Comparator<Item> {
        private final PriorityQueue<Item> queue;

        public TickTac() {
            super("RequestProcessor queue manager");
            this.setDaemon(true);
            this.queue = new PriorityQueue<Item>(128, this);
        }

        @Override
        public int compare(Item o1, Item o2) {
            if (o1.when < o2.when) {
                return -1;
            }
            if (o1.when > o2.when) {
                return 1;
            }
            return 0;
        }

        final synchronized void schedule(Item localItem, long delay) {
            localItem.when = System.currentTimeMillis() + delay;
            this.queue.add(localItem);
            this.notifyAll();
        }

        final synchronized void cancel(Item localItem) {
            this.queue.remove(localItem);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Item first;
                        if ((first = this.obtainFirst()) == null) {
                            continue;
                        }
                        first.owner.enqueue(first);
                    }
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
        }

        private synchronized Item obtainFirst() throws InterruptedException {
            Item first = this.queue.poll();
            if (first == null) {
                this.wait();
                return null;
            }
            long delay = first.when - System.currentTimeMillis();
            if (delay > 0L) {
                this.queue.add(first);
                this.wait(delay);
                return null;
            }
            return first;
        }
    }

    private static class Processor
    extends Thread {
        private static final Stack<Processor> pool = new Stack();
        private static final int INACTIVE_TIMEOUT = 60000;
        private RequestProcessor source;
        private Task todo;
        private boolean idle = true;
        private final Object lock = new Object();
        private static final Set<Class<? extends Runnable>> warnedClasses = Collections.synchronizedSet(new WeakSet());

        public Processor() {
            super(Processor.getTopLevelThreadGroup(), "Inactive RequestProcessor thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Processor get() {
            Stack<Processor> stack = pool;
            synchronized (stack) {
                if (pool.isEmpty()) {
                    Processor proc = new Processor();
                    proc.idle = false;
                    proc.start();
                    return proc;
                }
                assert (Processor.checkAccess(Processor.getTopLevelThreadGroup()));
                Processor proc = pool.pop();
                proc.idle = false;
                return proc;
            }
        }

        private static boolean checkAccess(ThreadGroup g) throws SecurityException {
            g.checkAccess();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void put(Processor proc, String last) {
            Stack<Processor> stack = pool;
            synchronized (stack) {
                proc.setName("Inactive RequestProcessor thread [Was:" + proc.getName() + "/" + last + "]");
                proc.idle = true;
                pool.push(proc);
            }
        }

        void setPrio(int priority) {
            if (priority != this.getPriority()) {
                this.setPriority(priority);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachTo(RequestProcessor src) {
            Object object = this.lock;
            synchronized (object) {
                this.source = src;
                this.lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean belongsTo(RequestProcessor r) {
            Object object = this.lock;
            synchronized (object) {
                return this.source == r;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                RequestProcessor current = null;
                Object object = this.lock;
                synchronized (object) {
                    try {
                        if (this.source == null) {
                            this.lock.wait(60000L);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    current = this.source;
                    this.source = null;
                    if (current == null) {
                        Stack<Processor> e = pool;
                        synchronized (e) {
                            if (this.idle) {
                                pool.remove(this);
                                break;
                            }
                            continue;
                        }
                    }
                }
                String debug = null;
                Logger em = RequestProcessor.logger();
                boolean loggable = em.isLoggable(Level.FINE);
                if (loggable) {
                    em.log(Level.FINE, "Begining work {0}", this.getName());
                }
                while (true) {
                    Object object2 = current.processorLock;
                    synchronized (object2) {
                        this.todo = current.askForWork(this, debug);
                        if (this.todo == null) {
                            break;
                        }
                    }
                    this.setPrio(this.todo.getPriority());
                    try {
                        if (loggable) {
                            em.log(Level.FINE, "  Executing {0}", this.todo);
                        }
                        this.registerParallel(this.todo, current);
                        this.todo.run();
                        if (loggable) {
                            em.log(Level.FINE, "  Execution finished in {0}", this.getName());
                        }
                        debug = this.todo.debug();
                    }
                    catch (OutOfMemoryError oome) {
                        em.log(Level.SEVERE, null, oome);
                    }
                    catch (StackOverflowError e) {
                        Processor.doNotify(this.todo, e);
                    }
                    catch (ThreadDeath t) {
                    }
                    catch (Throwable t) {
                        Processor.doNotify(this.todo, t);
                    }
                    finally {
                        this.unregisterParallel(this.todo, current);
                    }
                    object2 = current.processorLock;
                    synchronized (object2) {
                        this.todo = null;
                        Thread.interrupted();
                    }
                }
                if (!loggable) continue;
                em.log(Level.FINE, "Work finished {0}", this.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void doEvaluate(Task t, Object processorLock, RequestProcessor src) {
            Task previous = this.todo;
            boolean interrupted = Thread.interrupted();
            try {
                this.todo = t;
                t.run();
            }
            finally {
                Object object = processorLock;
                synchronized (object) {
                    this.todo = previous;
                    if ((interrupted || this.todo.item == null) && src.interruptThread) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void interruptTask(Task t, RequestProcessor src) {
            if (t != this.todo) {
                return;
            }
            if (src.interruptThread) {
                this.interrupt();
            }
        }

        boolean interrupt(Task t, RequestProcessor src) {
            if (t != this.todo) {
                return false;
            }
            this.interrupt();
            return true;
        }

        private static void doNotify(Task todo, Throwable ex) {
            Item item;
            if (SLOW && (item = todo.item) != null && item.message == null) {
                item.message = "task failed due to: " + ex;
                item.initCause(ex);
                ex = item;
            }
            RequestProcessor.logger().log(Level.SEVERE, "Error in RequestProcessor " + todo.debug(), ex);
        }

        static ThreadGroup getTopLevelThreadGroup() {
            PrivilegedAction<ThreadGroup> run = new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup current = Thread.currentThread().getThreadGroup();
                    while (current.getParent() != null) {
                        current = current.getParent();
                    }
                    return current;
                }
            };
            ThreadGroup orig = AccessController.doPrivileged(run);
            ThreadGroup nuova = null;
            try {
                Class<?> appContext = Class.forName("sun.awt.AppContext");
                Method instance = appContext.getMethod("getAppContext", new Class[0]);
                Method getTG = appContext.getMethod("getThreadGroup", new Class[0]);
                nuova = (ThreadGroup)getTG.invoke(instance.invoke(null, new Object[0]), new Object[0]);
            }
            catch (Exception exception) {
                RequestProcessor.logger().log(Level.FINE, "Cannot access sun.awt.AppContext", exception);
                return orig;
            }
            assert (nuova != null);
            if (nuova != orig) {
                RequestProcessor.logger().log(Level.WARNING, "AppContext group {0} differs from originally used {1}", new Object[]{nuova, orig});
            }
            return nuova;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerParallel(Task todo, RequestProcessor rp) {
            AtomicInteger number;
            if (rp.warnParallel == 0 || todo.run == null) {
                return;
            }
            Class<?> c = todo.run.getClass();
            Object object = rp.processorLock;
            synchronized (object) {
                if (rp.inParallel == null) {
                    rp.inParallel = new WeakHashMap();
                }
                if ((number = (AtomicInteger)rp.inParallel.get(c)) == null) {
                    number = new AtomicInteger(1);
                    rp.inParallel.put(c, number);
                } else {
                    number.incrementAndGet();
                }
            }
            if (number.get() >= rp.warnParallel && warnedClasses.add(c)) {
                String msg = "Too many " + c.getName() + " (" + number + ") in shared RequestProcessor; create your own";
                IllegalStateException ex = null;
                Item itm = todo.item;
                if (itm != null) {
                    ex = new IllegalStateException(msg);
                    ex.setStackTrace(itm.getStackTrace());
                }
                RequestProcessor.logger().log(Level.WARNING, msg, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregisterParallel(Task todo, RequestProcessor rp) {
            if (rp.warnParallel == 0 || todo.run == null) {
                return;
            }
            Object object = rp.processorLock;
            synchronized (object) {
                Class<?> c = todo.run.getClass();
                ((AtomicInteger)rp.inParallel.get(c)).decrementAndGet();
            }
        }
    }

    private static class SlowItem
    extends Item {
        SlowItem(Task task, RequestProcessor rp) {
            super(task, rp);
        }

        @Override
        public Throwable fillInStackTrace() {
            Throwable ret = super.fillInStackTrace();
            StackTraceElement[] arr = ret.getStackTrace();
            for (int i = 1; i < arr.length; ++i) {
                if (arr[i].getClassName().startsWith("java.lang") || arr[i].getClassName().startsWith(RequestProcessor.class.getName())) continue;
                ret.setStackTrace(Arrays.asList(arr).subList(i - 1, arr.length).toArray(new StackTraceElement[0]));
                break;
            }
            return ret;
        }
    }

    private static class FastItem
    extends Item {
        FastItem(Task task, RequestProcessor rp) {
            super(task, rp);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class CreatedItem
    extends Item {
        public CreatedItem(Task task, RequestProcessor rp) {
            super(task, rp);
        }

        @Override
        boolean clearOrNew(boolean canBeNew) {
            return canBeNew;
        }

        @Override
        boolean clear(Processor processor) {
            return false;
        }

        @Override
        boolean isNew() {
            return true;
        }
    }

    private static class Item
    extends Exception {
        private final RequestProcessor owner;
        Object action;
        boolean enqueued;
        String message;
        long when;

        Item(Task task, RequestProcessor rp) {
            this.action = task;
            this.owner = rp;
        }

        final Task getTask() {
            Object a = this.action;
            return a instanceof Task ? (Task)a : null;
        }

        boolean clearOrNew(boolean canBeNew) {
            return this.clear(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean clear(Processor processor) {
            boolean ret;
            Object object = this.owner.processorLock;
            synchronized (object) {
                this.action = processor;
                ret = this.enqueued ? this.owner.queue.remove(this) : true;
            }
            TICK.cancel(this);
            return ret;
        }

        boolean isNew() {
            return false;
        }

        final Processor getProcessor() {
            Object a = this.action;
            return a instanceof Processor ? (Processor)a : null;
        }

        final int getPriority() {
            return this.getTask().getPriority();
        }

        @Override
        public final String getMessage() {
            return this.message;
        }
    }

    public final class Task
    extends org.openide.util.Task
    implements Cancellable {
        private Item item;
        private int priority;
        private long time;
        private Thread lastThread;
        private AtomicBoolean cancelled;

        Task(Runnable run) {
            super(run);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
        }

        Task(Runnable run, int priority) {
            super(run);
            this.priority = 1;
            this.time = 0L;
            this.lastThread = null;
            if (priority < 1) {
                priority = 1;
            }
            if (priority > 10) {
                priority = 10;
            }
            this.priority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Class<Task> clazz = Task.class;
                synchronized (Task.class) {
                    while (this.lastThread != null) {
                        try {
                            Task.class.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.lastThread = Thread.currentThread();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    this.notifyRunning();
                    this.run.run();
                }
            }
            finally {
                Item scheduled = this.item;
                if (scheduled == null || scheduled.isNew() || scheduled.getTask() != this) {
                    this.notifyFinished();
                }
                Class<Task> clazz = Task.class;
                synchronized (Task.class) {
                    this.lastThread = null;
                    Task.class.notifyAll();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                }
            }
            {
                return;
            }
        }

        public int getDelay() {
            long delay = this.time - System.currentTimeMillis();
            if (delay < 0L) {
                return 0;
            }
            if (delay > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)delay;
        }

        public void schedule(int delay) {
            this.schedule((long)delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(long delay) {
            Item localItem;
            if (RequestProcessor.this.stopped) {
                throw new IllegalStateException("RequestProcessor already stopped!");
            }
            this.time = System.currentTimeMillis() + delay;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                if (this.cancelled != null) {
                    this.cancelled.set(false);
                }
                this.notifyRunning();
                if (this.item != null) {
                    this.item.clear(null);
                }
                localItem = this.item = RequestProcessor.this.enableStackTraces ? new SlowItem(this, RequestProcessor.this) : new FastItem(this, RequestProcessor.this);
            }
            if (delay == 0L) {
                RequestProcessor.this.enqueue(localItem);
            } else {
                TICK.schedule(localItem, delay);
            }
        }

        private void markCreated() {
            assert (this.item == null);
            this.item = new CreatedItem(this, null);
        }

        @Override
        public boolean cancel() {
            return this.cancelOrNew(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cancelOrNew(boolean canBeNew) {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean success;
                if (this.item == null) {
                    success = false;
                } else {
                    Processor p = this.item.getProcessor();
                    success = this.item.clearOrNew(canBeNew);
                    if (p != null) {
                        p.interruptTask(this, RequestProcessor.this);
                        this.item = null;
                    }
                    if (success) {
                        this.item = null;
                    }
                }
                if (success) {
                    this.notifyFinished();
                }
                return success;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancel(boolean interrupt) {
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                boolean success;
                if (this.cancelled != null) {
                    boolean wasCancelled;
                    boolean bl = wasCancelled = !this.cancelled.getAndSet(true);
                    if (wasCancelled) {
                        return false;
                    }
                }
                if (this.item == null) {
                    success = false;
                } else {
                    Processor p = this.item.getProcessor();
                    success = this.item.clear(null);
                    if (p != null) {
                        if (interrupt) {
                            success = p.interrupt(this, RequestProcessor.this);
                        } else {
                            p.interruptTask(this, RequestProcessor.this);
                        }
                        if (success) {
                            this.item = null;
                        }
                    }
                }
                if (success) {
                    this.notifyFinished();
                }
                return success;
            }
        }

        public int getPriority() {
            return this.priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPriority(int priority) {
            if (this.priority == priority) {
                return;
            }
            if (priority < 1) {
                priority = 1;
            }
            if (priority > 10) {
                priority = 10;
            }
            this.priority = priority;
            Object object = RequestProcessor.this.processorLock;
            synchronized (object) {
                if (this.item == null) {
                    return;
                }
                if (RequestProcessor.this.queue.remove(this.item)) {
                    RequestProcessor.this.prioritizedEnqueue(this.item);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitFinished() {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean toRun;
                boolean runAtAll;
                Logger em = RequestProcessor.logger();
                boolean loggable = em.isLoggable(Level.FINE);
                if (loggable) {
                    em.log(Level.FINE, "Task.waitFinished on {0} from other task in RP: {1}", new Object[]{this, Thread.currentThread().getName()});
                }
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    runAtAll = this.cancelOrNew(true);
                    boolean bl = toRun = runAtAll && (this.item == null || this.item.clear(null));
                    if (loggable) {
                        em.log(Level.FINE, "    ## finished: {0}", this.isFinished());
                        em.log(Level.FINE, "    ## item: {0}", this.item);
                    }
                }
                if (toRun) {
                    if (loggable) {
                        em.fine("    ## running it synchronously");
                    }
                    Processor processor = (Processor)Thread.currentThread();
                    processor.doEvaluate(this, RequestProcessor.this.processorLock, RequestProcessor.this);
                } else {
                    if (loggable) {
                        em.fine("    ## not running it synchronously");
                    }
                    if (runAtAll && this.lastThread != Thread.currentThread()) {
                        if (loggable) {
                            em.log(Level.FINE, "    ## waiting for it to be finished: {0} now: {1}", new Object[]{this.lastThread, Thread.currentThread()});
                        }
                        super.waitFinished();
                    }
                }
                if (loggable) {
                    em.fine("    ## exiting waitFinished");
                }
            } else {
                super.waitFinished();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean waitFinished(long timeout) throws InterruptedException {
            if (RequestProcessor.this.isRequestProcessorThread()) {
                boolean toRun;
                Object object = RequestProcessor.this.processorLock;
                synchronized (object) {
                    toRun = this.cancelOrNew(true);
                }
                if (toRun) {
                    throw new InterruptedException("Cannot wait with timeout " + timeout + " from the RequestProcessor thread for task: " + this);
                }
                if (this.lastThread != Thread.currentThread()) {
                    return super.waitFinished(timeout);
                }
                return true;
            }
            return super.waitFinished(timeout);
        }

        @Override
        public String toString() {
            return "RequestProcessor.Task [" + RequestProcessor.this.name + ", " + this.priority + "] for " + super.toString();
        }
    }

    private static final class ScheduledRPFutureTask<T>
    extends RPFutureTask<T>
    implements ScheduledFuture<T> {
        protected final long delayMillis;

        ScheduledRPFutureTask(Callable<T> c, long delayMillis) {
            super(c);
            this.delayMillis = delayMillis;
        }

        ScheduledRPFutureTask(Runnable r, T result, long delayMillis) {
            super(r, result);
            this.delayMillis = delayMillis;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.delayMillis, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            long otherDelayMillis = o.getDelay(TimeUnit.MILLISECONDS);
            return (int)(this.delayMillis - otherDelayMillis);
        }
    }

    private static class RPFutureTask<T>
    extends FutureTask<T>
    implements RunnableWrapper {
        protected volatile Task task;
        private final Runnable runnable;
        private final Cancellable cancellable;

        RPFutureTask(Callable<T> c) {
            super(c);
            this.runnable = null;
            this.cancellable = c instanceof Cancellable ? (Cancellable)((Object)c) : null;
        }

        RPFutureTask(Runnable r, T result) {
            super(r, result);
            this.runnable = r;
            this.cancellable = r instanceof Cancellable ? (Cancellable)((Object)r) : null;
        }

        void setTask(Task task) {
            this.task = task;
        }

        RPFutureTask(Callable<T> c, T predefinedResult) {
            this(c);
            this.set(predefinedResult);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result;
            boolean bl = result = this.cancellable == null ? true : this.cancellable.cancel();
            if (result) {
                boolean taskCancelled = this.task.cancel();
                boolean superCancel = super.cancel(mayInterruptIfRunning);
                result = taskCancelled && superCancel;
            }
            return result;
        }

        @Override
        public Runnable getRunnable() {
            return this.runnable;
        }
    }

    private static final class WaitableCallable<T>
    implements Callable<T>,
    Cancellable {
        private final CountDownLatch countdown;
        private final Callable<T> delegate;
        private final AtomicReference<T> ref;
        private volatile boolean failed;

        WaitableCallable(Callable<T> delegate, CountDownLatch countdown) {
            this(delegate, null, countdown);
        }

        WaitableCallable(Callable<T> delegate, AtomicReference<T> ref, CountDownLatch countdown) {
            this.delegate = delegate;
            this.countdown = countdown;
            this.ref = ref;
        }

        boolean failed() {
            return this.failed;
        }

        @Override
        public T call() throws Exception {
            try {
                T result = this.delegate.call();
                if (this.ref != null) {
                    this.ref.set(result);
                }
                T t = result;
                return t;
            }
            catch (RuntimeException e) {
                this.failed = true;
                throw e;
            }
            catch (Error e) {
                this.failed = true;
                throw e;
            }
            finally {
                if (!this.failed || this.ref == null) {
                    this.countdown.countDown();
                }
            }
        }

        @Override
        public boolean cancel() {
            return this.delegate instanceof Cancellable ? ((Cancellable)((Object)this.delegate)).cancel() : true;
        }
    }

    private static interface RunnableWrapper {
        public Runnable getRunnable();
    }

    private static final class FixedDelayTask
    extends TaskFutureWrapper {
        private final AtomicLong nextRunTime = new AtomicLong();

        FixedDelayTask(Runnable run, long initialDelay, long period) {
            super(run, initialDelay, period);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long next = this.nextRunTime.get();
            return unit.convert(next - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void run() {
            if (!this.fini()) {
                this.toRun.run();
            }
            if (!this.fini()) {
                this.reschedule();
            }
        }

        private boolean fini() {
            boolean result = this.cancelled.get() || Thread.currentThread().isInterrupted();
            return result;
        }

        private void reschedule() {
            this.nextRunTime.set(System.currentTimeMillis() + this.period);
            if (!this.fini()) {
                this.t.schedule((int)this.period);
            }
        }
    }

    private static final class FixedRateTask
    extends TaskFutureWrapper {
        private final Object runLock = new Object();
        private final Object timeLock = new Object();
        private int runCount;
        private long nextRunTime;
        private long start = Long.MIN_VALUE;
        volatile boolean firstRun = true;

        FixedRateTask(Runnable run, long initialDelay, long period) {
            super(run, initialDelay, period);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            if (this.firstRun) {
                object = this.timeLock;
                synchronized (object) {
                    this.start = System.currentTimeMillis();
                    this.firstRun = false;
                }
            }
            try {
                object = this.runLock;
                synchronized (object) {
                    this.toRun.run();
                }
            }
            catch (RuntimeException e) {
                this.cancel(true);
                throw e;
            }
            this.reschedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reschedule() {
            boolean canContinue;
            long interval;
            Object object = this.timeLock;
            synchronized (object) {
                this.nextRunTime = this.start + (this.initialDelay + this.period * (long)this.runCount);
                ++this.runCount;
                interval = Math.max(0L, this.nextRunTime - System.currentTimeMillis());
            }
            boolean bl = canContinue = !this.cancelled.get() && !Thread.currentThread().isInterrupted();
            if (canContinue) {
                this.t.schedule(interval);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getDelay(TimeUnit unit) {
            long delay;
            if (this.isCancelled()) {
                return Long.MAX_VALUE;
            }
            Object object = this.timeLock;
            synchronized (object) {
                delay = Math.min(0L, this.nextRunTime - System.currentTimeMillis());
            }
            return unit.convert(delay, TimeUnit.MILLISECONDS);
        }
    }

    private static abstract class TaskFutureWrapper
    implements ScheduledFuture<Void>,
    Runnable,
    RunnableWrapper {
        volatile Task t;
        protected final Runnable toRun;
        protected final long initialDelay;
        protected final long period;
        final AtomicBoolean cancelled = new AtomicBoolean();

        TaskFutureWrapper(Runnable run, long initialDelay, long period) {
            this.toRun = run;
            this.initialDelay = initialDelay;
            this.period = period;
        }

        @Override
        public final Runnable getRunnable() {
            return this.toRun;
        }

        @Override
        public int compareTo(Delayed o) {
            long other = o.getDelay(TimeUnit.MILLISECONDS);
            long ours = this.getDelay(TimeUnit.MILLISECONDS);
            return (int)(ours - other);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean result = true;
            if (this.toRun instanceof Cancellable) {
                result = ((Cancellable)((Object)this.toRun)).cancel();
            }
            if (result) {
                result = this.t.cancel(mayInterruptIfRunning);
            }
            return result;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled.get();
        }

        @Override
        public boolean isDone() {
            return this.cancelled.get() || this.t.isFinished();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
            this.t.waitFinished();
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
            long millis = TimeUnit.MILLISECONDS.convert(timeout, unit);
            this.t.waitFinished(millis);
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
            return null;
        }
    }
}

