/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.util;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public final class ProxyURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private final Map<String, Lookup.Result<URLStreamHandler>> results = new HashMap<String, Lookup.Result<URLStreamHandler>>();
    private final Map<String, URLStreamHandler> handlers = new HashMap<String, URLStreamHandler>();
    private static final Set<String> STANDARD_PROTOCOLS = new HashSet<String>(Arrays.asList("jar", "file", "http", "https", "resource"));

    @Override
    public synchronized URLStreamHandler createURLStreamHandler(final String protocol) {
        if (STANDARD_PROTOCOLS.contains(protocol)) {
            return null;
        }
        if (!this.results.containsKey(protocol)) {
            final Lookup.Result result = Lookups.forPath((String)("URLStreamHandler/" + protocol)).lookupResult(URLStreamHandler.class);
            LookupListener listener = new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent ev) {
                    ProxyURLStreamHandlerFactory proxyURLStreamHandlerFactory = ProxyURLStreamHandlerFactory.this;
                    synchronized (proxyURLStreamHandlerFactory) {
                        Collection instances = result.allInstances();
                        ProxyURLStreamHandlerFactory.this.handlers.put(protocol, instances.isEmpty() ? null : (URLStreamHandler)instances.iterator().next());
                    }
                }
            };
            result.addLookupListener(listener);
            listener.resultChanged(null);
            this.results.put(protocol, (Lookup.Result<URLStreamHandler>)result);
        }
        return this.handlers.get(protocol);
    }
}

