/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.openide.filesystems.declmime.MIMEResolverImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class MIMEResolverProcessor
extends LayerGeneratingProcessor {
    private static final String SUFFIX = ".xml";

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(MIMEResolver.Registration.class.getCanonicalName());
        set.add(MIMEResolver.ExtensionRegistration.class.getCanonicalName());
        set.add(MIMEResolver.NamespaceRegistration.class.getCanonicalName());
        return set;
    }

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        Annotation r;
        for (Element element : roundEnv.getElementsAnnotatedWith(MIMEResolver.Registration.class)) {
            r = element.getAnnotation(MIMEResolver.Registration.class);
            this.registerDefinition(element, r.resource(), (MIMEResolver.Registration)r);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(MIMEResolver.ExtensionRegistration.class)) {
            r = element.getAnnotation(MIMEResolver.ExtensionRegistration.class);
            this.registerExt(element, (MIMEResolver.ExtensionRegistration)r);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(MIMEResolver.NamespaceRegistration.class)) {
            r = element.getAnnotation(MIMEResolver.NamespaceRegistration.class);
            this.registerNamespace(element, (MIMEResolver.NamespaceRegistration)r);
        }
        return true;
    }

    private void registerExt(Element e, MIMEResolver.ExtensionRegistration r) throws LayerGenerationException {
        LayerBuilder b = this.layer(e);
        LayerBuilder.File f = b.file("Services/MIMEResolver/" + this.getName(e).replace('.', '-') + "-Extension" + SUFFIX);
        f.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        f.stringvalue("instanceClass", MIMEResolver.class.getName());
        f.stringvalue("mimeType", r.mimeType());
        int cnt = 0;
        for (String ext : r.extension()) {
            f.stringvalue("ext." + cnt++, ext);
        }
        f.position(r.position());
        f.bundlevalue("displayName", r.displayName());
        f.write();
    }

    private void registerDefinition(Element e, String relRes, MIMEResolver.Registration r) throws LayerGenerationException {
        String absRes = LayerBuilder.absolutizeResource(e, relRes);
        LayerBuilder b = this.layer(e);
        javax.tools.FileObject fo = b.validateResource(absRes, e, r, null, false);
        LayerBuilder.File f = b.file("Services/MIMEResolver/" + this.getName(e).replace('.', '-') + "-Registration" + SUFFIX);
        f.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        f.stringvalue("instanceClass", MIMEResolver.class.getName());
        f.serialvalue("bytes", this.generateInstanceResolver(fo, e));
        f.position(r.position());
        f.bundlevalue("displayName", r.displayName());
        f.write();
    }

    private byte[] generateInstanceResolver(javax.tools.FileObject fo, Element e) throws LayerGenerationException {
        try {
            int ch;
            InputStream is = fo.openInputStream();
            FileObject tmp = FileUtil.createMemoryFileSystem().getRoot().createData("resolver.xml");
            OutputStream os = tmp.getOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            os.close();
            is.close();
            byte[] almostResult = MIMEResolverImpl.toStream(MIMEResolverImpl.forDescriptor(tmp, false));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(almostResult);
            oos.close();
            return out.toByteArray();
        }
        catch (IOException ex) {
            LayerGenerationException le = new LayerGenerationException("Cannot process " + fo, e);
            le.initCause(ex);
            throw le;
        }
    }

    private void registerNamespace(Element e, MIMEResolver.NamespaceRegistration r) throws LayerGenerationException {
        LayerBuilder b = this.layer(e);
        LayerBuilder.File f = b.file("Services/MIMEResolver/" + this.getName(e).replace('.', '-') + "-Namespace" + SUFFIX);
        f.methodvalue("instanceCreate", MIMEResolver.class.getName(), "create");
        f.stringvalue("instanceClass", MIMEResolver.class.getName());
        f.stringvalue("mimeType", r.mimeType());
        int cnt = 0;
        for (String ext : r.doctypePublicId()) {
            f.stringvalue("doctype." + cnt++, ext);
        }
        cnt = 0;
        for (String ext : r.checkedExtension()) {
            f.stringvalue("ext." + cnt++, ext);
        }
        cnt = 0;
        for (String ext : r.acceptedExtension()) {
            f.stringvalue("accept." + cnt++, ext);
        }
        cnt = 0;
        f.stringvalue("element", r.elementName());
        for (String ext : r.elementNS()) {
            f.stringvalue("ns." + cnt++, ext);
        }
        f.position(r.position());
        f.bundlevalue("displayName", r.displayName());
        f.write();
    }

    private String getName(Element e) {
        if (e.getKind().isClass() || e.getKind().isInterface()) {
            return this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
        }
        if (e.getKind() == ElementKind.PACKAGE) {
            return e.getSimpleName().toString();
        }
        return this.getName(e.getEnclosingElement()) + '.' + e.getSimpleName();
    }
}

