/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.netbeans.modules.xml.retriever.catalog.CatalogElement;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;

public class CatalogEntryImpl
implements CatalogEntry {
    private CatalogElement entryType;
    private String source;
    private String target;
    private CatalogModel thisCatModel = null;
    private HashMap<String, String> extraAttributeMap = null;

    public CatalogEntryImpl(CatalogElement entryType, String mappingEntity, String mappedEntity) {
        this.entryType = entryType;
        this.source = mappingEntity;
        this.target = mappedEntity;
    }

    public CatalogEntryImpl(CatalogElement entryType, String mappingEntity, String mappedEntity, HashMap<String, String> extraAttribMap) {
        this.entryType = entryType;
        this.source = mappingEntity;
        this.target = mappedEntity;
        this.extraAttributeMap = extraAttribMap;
    }

    @Override
    public CatalogElement getEntryType() {
        return this.entryType;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public HashMap<String, String> getExtraAttributeMap() {
        return this.extraAttributeMap;
    }

    @Override
    public boolean isValid() {
        if (this.thisCatModel == null) {
            return false;
        }
        ModelSource ms = null;
        try {
            ms = this.thisCatModel.getModelSource(new URI(this.source), null);
        }
        catch (URISyntaxException ex) {
            return false;
        }
        catch (CatalogModelException ex) {
            return false;
        }
        return ms != null;
    }

    public void setCatalogModel(CatalogModel thisCatModel) {
        this.thisCatModel = thisCatModel;
    }
}

