/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.project.libraries.LibraryDeclarationConvertor;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandler;
import org.netbeans.modules.project.libraries.Util;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class LibraryDeclarationParser
implements ContentHandler,
EntityResolver {
    private static final String LIBRARY_DEF_1 = "-//NetBeans//DTD Library Declaration 1.0//EN";
    private static final String LIBRARY_DTD_1 = "http://www.netbeans.org/dtds/library-declaration-1_0.dtd";
    static final String LIBRARY_NS2 = "http://www.netbeans.org/ns/library-declaration/2";
    static final String LIBRARY_NS3 = "http://www.netbeans.org/ns/library-declaration/3";
    static final String VER_1 = "1.0";
    static final String VER_2 = "2.0";
    static final String VER_3 = "3.0";
    private static final String LIBRARY = "library";
    private static final String VERSION = "version";
    private static final String VOLUME = "volume";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    private static final String RESOURCE = "resource";
    private static final String NAME = "name";
    private static final String BUNDLE = "localizing-bundle";
    private static final String DISPLAY_NAME = "display-name";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY = "property";
    private static final String VALUE = "value";
    private StringBuffer buffer;
    private final LibraryDeclarationConvertor parslet;
    private final LibraryDeclarationHandler handler;
    private Stack<Object[]> context;
    private String expectedNS;
    private final AtomicBoolean used = new AtomicBoolean();

    public LibraryDeclarationParser(LibraryDeclarationHandler handler, LibraryDeclarationConvertor parslet) {
        this.parslet = parslet;
        this.handler = handler;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void startDocument() throws SAXException {
        this.handler.startDocument();
    }

    @Override
    public final void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    @Override
    public final void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qname, ns, new AttributesImpl(attrs)});
        if (VOLUME.equals(qname)) {
            this.handler.start_volume(attrs);
        } else if (LIBRARY.equals(qname)) {
            this.expectedNS = this.handler.start_library(ns, attrs);
        } else if (PROPERTIES.equals(qname) && LibraryDeclarationParser.supportsProperties(ns)) {
            this.handler.start_properties(attrs);
        } else if (PROPERTY.equals(qname) && LibraryDeclarationParser.supportsProperties(ns)) {
            this.handler.start_property(attrs);
        }
    }

    @Override
    public final void endElement(String ns, String name, String qname) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if (VOLUME.equals(qname)) {
            this.handler.end_volume();
        } else if (LIBRARY.equals(qname)) {
            this.handler.end_library();
        } else if (PROPERTIES.equals(qname) && LibraryDeclarationParser.supportsProperties(ns)) {
            this.handler.end_properties();
        } else if (PROPERTY.equals(qname) && LibraryDeclarationParser.supportsProperties(ns)) {
            this.handler.end_property();
        }
    }

    @Override
    public final void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    @Override
    public final void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = this.context.peek();
        String here = (String)ctx[0];
        String ns = (String)ctx[1];
        Attributes attrs = (Attributes)ctx[2];
        if (!this.expectedNS.equals(ns)) {
            throw new SAXException("Invalid librray descriptor namespace");
        }
        if (DESCRIPTION.equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_description(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if (TYPE.equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_type(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if (RESOURCE.equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_resource(this.parslet.parseResource(this.buffer.length() == 0 ? null : this.buffer.toString()), attrs);
        } else if (NAME.equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_name(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if (BUNDLE.equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_localizingBundle(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if (DISPLAY_NAME.equals(here) && LibraryDeclarationParser.supportsDisplayName(ns)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_displayName(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if (VALUE.equals(here) && LibraryDeclarationParser.supportsProperties(ns)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_value(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        if (this.used.getAndSet(true)) {
            throw new IllegalStateException("The LibraryDeclarationParser was already used, create a new instance");
        }
        try {
            XMLReader parser = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            parser.setContentHandler(this);
            parser.setErrorHandler(this.getDefaultErrorHandler());
            parser.setEntityResolver(this);
            parser.parse(input);
        }
        finally {
            if (!this.context.empty()) {
                this.context.clear();
            }
            if (this.buffer.length() > 0) {
                this.buffer.delete(0, this.buffer.length());
            }
            this.expectedNS = null;
        }
    }

    protected ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (LIBRARY_DEF_1.equals(publicId)) {
            ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
            return new InputSource(is);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeLibraryDefinition(@NonNull FileObject definitionFile, @NonNull LibraryImplementation library, @NonNull LibraryTypeProvider libraryTypeProvider) throws IOException {
        LibraryDeclarationParser.validateLibraryContent(library, libraryTypeProvider);
        Document doc = Util.supportsDisplayName(library) ? (Util.supportsProperties(library) ? LibraryDeclarationParser.createLibraryDefinition3(library, libraryTypeProvider) : LibraryDeclarationParser.createLibraryDefinition2(library, libraryTypeProvider)) : LibraryDeclarationParser.createLibraryDefinition1(library, libraryTypeProvider);
        OutputStream os = definitionFile.getOutputStream();
        try {
            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
        }
        finally {
            os.close();
        }
    }

    private static void validateLibraryContent(@NonNull LibraryImplementation library, @NonNull LibraryTypeProvider libraryTypeProvider) {
        for (String vtype : libraryTypeProvider.getSupportedVolumeTypes()) {
            LibrariesModel.convertURLsToURIs(library.getContent(vtype));
        }
    }

    private static Document createLibraryDefinition1(@NonNull LibraryImplementation library, @NonNull LibraryTypeProvider libraryTypeProvider) {
        String displayname;
        String localizingBundle;
        Document doc = XMLUtil.createDocument((String)LIBRARY, null, (String)LIBRARY_DEF_1, (String)LIBRARY_DTD_1);
        Element libraryE = doc.getDocumentElement();
        libraryE.setAttribute(VERSION, VER_1);
        libraryE.appendChild(doc.createElement(NAME)).appendChild(doc.createTextNode(library.getName()));
        libraryE.appendChild(doc.createElement(TYPE)).appendChild(doc.createTextNode(library.getType()));
        String description = library.getDescription();
        if (description != null && description.length() > 0) {
            libraryE.appendChild(doc.createElement(DESCRIPTION)).appendChild(doc.createTextNode(description));
        }
        if ((localizingBundle = library.getLocalizingBundle()) != null && localizingBundle.length() > 0) {
            libraryE.appendChild(doc.createElement(BUNDLE)).appendChild(doc.createTextNode(localizingBundle));
        }
        if ((displayname = Util.getDisplayName(library)) != null) {
            libraryE.appendChild(doc.createElement(DISPLAY_NAME)).appendChild(doc.createTextNode(displayname));
        }
        for (String vtype : libraryTypeProvider.getSupportedVolumeTypes()) {
            Element volumeE = (Element)libraryE.appendChild(doc.createElement(VOLUME));
            volumeE.appendChild(doc.createElement(TYPE)).appendChild(doc.createTextNode(vtype));
            List<URL> volume = library.getContent(vtype);
            if (volume == null) continue;
            for (URL url : volume) {
                volumeE.appendChild(doc.createElement(RESOURCE)).appendChild(doc.createTextNode(url.toString()));
            }
        }
        return doc;
    }

    private static Document createLibraryDefinition2(@NonNull LibraryImplementation library, @NonNull LibraryTypeProvider libraryTypeProvider) {
        String displayname;
        String localizingBundle;
        Document doc = XMLUtil.createDocument((String)LIBRARY, (String)LIBRARY_NS2, null, null);
        Element libraryE = doc.getDocumentElement();
        libraryE.setAttribute(VERSION, VER_2);
        libraryE.appendChild(doc.createElementNS(LIBRARY_NS2, NAME)).appendChild(doc.createTextNode(library.getName()));
        libraryE.appendChild(doc.createElementNS(LIBRARY_NS2, TYPE)).appendChild(doc.createTextNode(library.getType()));
        String description = library.getDescription();
        if (description != null && description.length() > 0) {
            libraryE.appendChild(doc.createElementNS(LIBRARY_NS2, DESCRIPTION)).appendChild(doc.createTextNode(description));
        }
        if ((localizingBundle = library.getLocalizingBundle()) != null && localizingBundle.length() > 0) {
            libraryE.appendChild(doc.createElementNS(LIBRARY_NS2, BUNDLE)).appendChild(doc.createTextNode(localizingBundle));
        }
        if ((displayname = Util.getDisplayName(library)) != null) {
            libraryE.appendChild(doc.createElementNS(LIBRARY_NS2, DISPLAY_NAME)).appendChild(doc.createTextNode(displayname));
        }
        for (String vtype : libraryTypeProvider.getSupportedVolumeTypes()) {
            Element volumeE = (Element)libraryE.appendChild(doc.createElementNS(LIBRARY_NS2, VOLUME));
            volumeE.appendChild(doc.createElementNS(LIBRARY_NS2, TYPE)).appendChild(doc.createTextNode(vtype));
            List<URL> volume = library.getContent(vtype);
            if (volume == null) continue;
            for (URL url : volume) {
                volumeE.appendChild(doc.createElementNS(LIBRARY_NS2, RESOURCE)).appendChild(doc.createTextNode(url.toString()));
            }
        }
        return doc;
    }

    private static Document createLibraryDefinition3(@NonNull LibraryImplementation library, @NonNull LibraryTypeProvider libraryTypeProvider) {
        String displayname;
        String localizingBundle;
        Document doc = XMLUtil.createDocument((String)LIBRARY, (String)LIBRARY_NS3, null, null);
        Element libraryE = doc.getDocumentElement();
        libraryE.setAttribute(VERSION, VER_3);
        libraryE.appendChild(doc.createElementNS(LIBRARY_NS3, NAME)).appendChild(doc.createTextNode(library.getName()));
        libraryE.appendChild(doc.createElementNS(LIBRARY_NS3, TYPE)).appendChild(doc.createTextNode(library.getType()));
        String description = library.getDescription();
        if (description != null && description.length() > 0) {
            libraryE.appendChild(doc.createElementNS(LIBRARY_NS3, DESCRIPTION)).appendChild(doc.createTextNode(description));
        }
        if ((localizingBundle = library.getLocalizingBundle()) != null && localizingBundle.length() > 0) {
            libraryE.appendChild(doc.createElementNS(LIBRARY_NS3, BUNDLE)).appendChild(doc.createTextNode(localizingBundle));
        }
        if ((displayname = Util.getDisplayName(library)) != null) {
            libraryE.appendChild(doc.createElementNS(LIBRARY_NS3, DISPLAY_NAME)).appendChild(doc.createTextNode(displayname));
        }
        for (String vtype : libraryTypeProvider.getSupportedVolumeTypes()) {
            Element volumeE = (Element)libraryE.appendChild(doc.createElementNS(LIBRARY_NS3, VOLUME));
            volumeE.appendChild(doc.createElementNS(LIBRARY_NS3, TYPE)).appendChild(doc.createTextNode(vtype));
            List<URL> volume = library.getContent(vtype);
            if (volume == null) continue;
            for (URL url : volume) {
                volumeE.appendChild(doc.createElementNS(LIBRARY_NS3, RESOURCE)).appendChild(doc.createTextNode(url.toString()));
            }
        }
        Map<String, String> properties = Util.getProperties(library);
        assert (properties != null) : "LibraryImplementation: " + library + " returned null properties.";
        Element propertiesNode = (Element)libraryE.appendChild(doc.createElementNS(LIBRARY_NS3, PROPERTIES));
        for (Map.Entry<String, String> e : properties.entrySet()) {
            Element propertyNode = (Element)propertiesNode.appendChild(doc.createElementNS(LIBRARY_NS3, PROPERTY));
            propertyNode.appendChild(doc.createElementNS(LIBRARY_NS3, NAME)).appendChild(doc.createTextNode(e.getKey()));
            propertyNode.appendChild(doc.createElementNS(LIBRARY_NS3, VALUE)).appendChild(doc.createTextNode(e.getValue()));
        }
        return doc;
    }

    private static boolean supportsDisplayName(@NullAllowed String ns) {
        return LIBRARY_NS2.equals(ns) || LIBRARY_NS3.equals(ns);
    }

    private static boolean supportsProperties(@NullAllowed String ns) {
        return LIBRARY_NS3.equals(ns);
    }
}

