/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class GlobFileBuiltQuery
implements FileBuiltQueryImplementation {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.spi.project.support.ant.GlobFileBuiltQuery");
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final String[] fromPrefixes;
    private final String[] fromSuffixes;
    private final String[] toPrefixes;
    private final String[] toSuffixes;
    private static final Reference<StatusImpl> NONE = new WeakReference<Object>(null);
    private final Map<FileObject, Reference<StatusImpl>> statuses = new WeakHashMap<FileObject, Reference<StatusImpl>>();
    private static final RequestProcessor RP = new RequestProcessor(StatusImpl.class.getName());

    public GlobFileBuiltQuery(AntProjectHelper helper, PropertyEvaluator eval, String[] from, String[] to) throws IllegalArgumentException {
        this.helper = helper;
        this.eval = eval;
        int l = from.length;
        if (to.length != l) {
            throw new IllegalArgumentException("Non-matching lengths");
        }
        this.fromPrefixes = new String[l];
        this.fromSuffixes = new String[l];
        this.toPrefixes = new String[l];
        this.toSuffixes = new String[l];
        for (int i = 0; i < l; ++i) {
            int idx = from[i].indexOf(42);
            if (idx == -1 || idx != from[i].lastIndexOf(42)) {
                throw new IllegalArgumentException("Zero or multiple asterisks in " + from[i]);
            }
            this.fromPrefixes[i] = from[i].substring(0, idx);
            this.fromSuffixes[i] = from[i].substring(idx + 1);
            idx = to[i].indexOf(42);
            if (idx == -1 || idx != to[i].lastIndexOf(42)) {
                throw new IllegalArgumentException("Zero or multiple asterisks in " + to[i]);
            }
            this.toPrefixes[i] = to[i].substring(0, idx);
            this.toSuffixes[i] = to[i].substring(idx + 1);
        }
    }

    public synchronized FileBuiltQuery.Status getStatus(FileObject file) {
        StatusImpl status;
        Reference<StatusImpl> r = this.statuses.get(file);
        if (r == NONE) {
            return null;
        }
        StatusImpl statusImpl = status = r != null ? r.get() : null;
        if (status == null) {
            status = this.createStatus(file);
            if (status != null) {
                this.statuses.put(file, new WeakReference<StatusImpl>(status));
            } else {
                this.statuses.put(file, NONE);
            }
        }
        return status;
    }

    private File findTarget(FileObject file) {
        File sourceF = FileUtil.toFile((FileObject)file);
        if (sourceF == null) {
            if (err.isLoggable(1)) {
                err.log("Not a disk file: " + file);
            }
            return null;
        }
        String source = sourceF.getAbsolutePath();
        for (int i = 0; i < this.fromPrefixes.length; ++i) {
            String remainder;
            String prefixEval = this.eval.evaluate(this.fromPrefixes[i]);
            if (prefixEval == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.fromPrefixes[i] + " evaluates to null");
                continue;
            }
            String suffixEval = this.eval.evaluate(this.fromSuffixes[i]);
            if (suffixEval == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.fromSuffixes[i] + " evaluates to null");
                continue;
            }
            boolean endsWithSlash = prefixEval.endsWith("/");
            String prefixF = this.helper.resolveFile(prefixEval).getAbsolutePath();
            if (endsWithSlash && !prefixF.endsWith(File.separator)) {
                prefixF = prefixF + File.separatorChar;
            }
            if (!source.startsWith(prefixF) || !(remainder = source.substring(prefixF.length())).endsWith(suffixEval.replace('/', File.separatorChar))) continue;
            String particular = remainder.substring(0, remainder.length() - suffixEval.length());
            String toPrefixEval = this.eval.evaluate(this.toPrefixes[i]);
            if (toPrefixEval == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.toPrefixes[i] + " evaluates to null");
                continue;
            }
            String toSuffixEval = this.eval.evaluate(this.toSuffixes[i]);
            if (toSuffixEval == null) {
                if (!err.isLoggable(1)) continue;
                err.log(this.toSuffixes[i] + " evaluates to null");
                continue;
            }
            File target = this.helper.resolveFile(toPrefixEval + particular + toSuffixEval);
            if (err.isLoggable(1)) {
                err.log("Found target for " + source + ": " + target);
            }
            return target;
        }
        if (err.isLoggable(1)) {
            err.log("No match for path " + source + " among " + Arrays.asList(this.fromPrefixes) + " " + Arrays.asList(this.fromSuffixes));
        }
        return null;
    }

    private StatusImpl createStatus(FileObject file) {
        File target = this.findTarget(file);
        if (target != null) {
            try {
                DataObject source = DataObject.find((FileObject)file);
                return new StatusImpl(source, file, target);
            }
            catch (DataObjectNotFoundException e) {
                Logger.getLogger(GlobFileBuiltQuery.class.getName()).log(Level.FINE, null, e);
                return null;
            }
        }
        return null;
    }

    private final class StatusImpl
    implements FileBuiltQuery.Status,
    PropertyChangeListener,
    FileChangeListener,
    Runnable {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private Boolean built = null;
        private final DataObject source;
        private File target;
        private FileChangeListener targetListener;

        StatusImpl(DataObject source, FileObject sourceFO, File target) {
            this.source = source;
            this.source.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.source));
            sourceFO.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)sourceFO));
            this.target = target;
            this.targetListener = new FileChangeListener(){

                public void fileFolderCreated(FileEvent fe) {
                }

                public void fileDataCreated(FileEvent fe) {
                    StatusImpl.this.update();
                }

                public void fileChanged(FileEvent fe) {
                    StatusImpl.this.update();
                }

                public void fileDeleted(FileEvent fe) {
                    StatusImpl.this.update();
                }

                public void fileRenamed(FileRenameEvent fe) {
                    StatusImpl.this.update();
                }

                public void fileAttributeChanged(FileAttributeEvent fe) {
                    StatusImpl.this.update();
                }
            };
            FileUtil.addFileChangeListener((FileChangeListener)this.targetListener, (File)target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isBuilt() {
            boolean b;
            boolean doFire = false;
            GlobFileBuiltQuery globFileBuiltQuery = GlobFileBuiltQuery.this;
            synchronized (globFileBuiltQuery) {
                b = this.isReallyBuilt();
                if (this.built != null && this.built != b) {
                    doFire = true;
                }
                this.built = b;
                if (err.isLoggable(1)) {
                    err.log("isBuilt: " + b + " from " + this);
                }
            }
            if (doFire) {
                this.cs.fireChange();
            }
            return b;
        }

        private boolean isReallyBuilt() {
            long sourceTime;
            if (!this.source.isValid()) {
                if (err.isLoggable(1)) {
                    err.log("invalid: " + this);
                }
                return false;
            }
            if (this.source.isModified()) {
                if (err.isLoggable(1)) {
                    err.log("modified: " + this);
                }
                return false;
            }
            if (this.target == null) {
                if (err.isLoggable(1)) {
                    err.log("no target matching " + this);
                }
                return false;
            }
            long targetTime = this.target.lastModified();
            if (targetTime >= (sourceTime = this.source.getPrimaryFile().lastModified().getTime())) {
                return true;
            }
            if (err.isLoggable(1)) {
                err.log("out of date (target: " + targetTime + " vs. source: " + sourceTime + "): " + this);
            }
            return false;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        private void update() {
            RP.post((Runnable)this);
        }

        @Override
        public void run() {
            this.isBuilt();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (evt.getSource() instanceof DataObject);
            if ("modified".equals(evt.getPropertyName())) {
                this.update();
            }
        }

        public void fileChanged(FileEvent fe) {
            this.update();
        }

        public void fileDeleted(FileEvent fe) {
            this.update();
        }

        public void fileRenamed(FileRenameEvent fe) {
            File target2 = GlobFileBuiltQuery.this.findTarget(this.source.getPrimaryFile());
            if (!Utilities.compareObjects((Object)this.target, (Object)target2)) {
                if (this.target != null) {
                    FileUtil.removeFileChangeListener((FileChangeListener)this.targetListener, (File)this.target);
                }
                if (target2 != null) {
                    FileUtil.addFileChangeListener((FileChangeListener)this.targetListener, (File)target2);
                }
                this.target = target2;
            }
            this.update();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public String toString() {
            return "GFBQ.StatusImpl[" + this.source.getPrimaryFile() + " -> " + this.target + "]";
        }
    }
}

