/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.modules.project.ant.ProjectLibraryProvider;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.SubprojectProviderImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbCollections;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ReferenceHelper {
    static final String REFS_NAME = "references";
    static final String REF_NAME = "reference";
    static final String REFS_NS = "http://www.netbeans.org/ns/ant-project-references/1";
    static final String REFS_NS2 = "http://www.netbeans.org/ns/ant-project-references/2";
    private Set<String> extraBaseDirectories = new HashSet<String>();
    private final AntProjectHelper h;
    final PropertyEvaluator eval;
    private final AuxiliaryConfiguration aux;
    private static final Pattern FOREIGN_FILE_REFERENCE = Pattern.compile("\\$\\{reference\\.([^.${}]+)\\.([^.${}]+)\\.([\\d&&[^.${}]]+)\\}");
    private static final Pattern FOREIGN_FILE_REFERENCE_OLD = Pattern.compile("\\$\\{reference\\.([^.${}]+)\\.([^.${}]+)\\}");
    private static final Pattern FOREIGN_PLAIN_FILE_REFERENCE = Pattern.compile("\\$\\{file\\.reference\\.([^${}]+)\\}");
    private static final Pattern LIBRARY_REFERENCE = Pattern.compile("\\$\\{libs\\.([^${}]+)\\.[^${}]+\\}");

    public ReferenceHelper(AntProjectHelper helper, AuxiliaryConfiguration aux, PropertyEvaluator eval) {
        this.h = helper;
        this.aux = aux;
        this.eval = eval;
    }

    private Element loadReferences() {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        Element references = this.aux.getConfigurationFragment(REFS_NAME, REFS_NS2, true);
        if (references == null) {
            references = this.aux.getConfigurationFragment(REFS_NAME, REFS_NS, true);
        }
        return references;
    }

    private void storeReferences(Element references) {
        assert (ProjectManager.mutex().isWriteAccess());
        assert (references != null && references.getLocalName().equals(REFS_NAME) && (REFS_NS.equals(references.getNamespaceURI()) || REFS_NS2.equals(references.getNamespaceURI())));
        this.aux.putConfigurationFragment(references, true);
    }

    private void removeOldReferences() {
        assert (ProjectManager.mutex().isWriteAccess());
        this.aux.removeConfigurationFragment(REFS_NAME, REFS_NS, true);
    }

    @Deprecated
    public boolean addReference(AntArtifact artifact) throws IllegalArgumentException {
        Object[] ret = this.addReference0(artifact, artifact.getArtifactLocations()[0]);
        return (Boolean)ret[0];
    }

    private Object[] addReference0(final AntArtifact artifact, final URI location) throws IllegalArgumentException {
        return (Object[])ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object[]>(){

            public Object[] run() {
                String propertiesFile;
                String refPath;
                RawReference ref;
                int index = ReferenceHelper.this.findLocationIndex(artifact, location);
                Project forProj = artifact.getProject();
                if (forProj == null) {
                    throw new IllegalArgumentException("No project associated with " + artifact);
                }
                File forProjDir = FileUtil.toFile((FileObject)forProj.getProjectDirectory());
                assert (forProjDir != null) : forProj.getProjectDirectory();
                String projName = ReferenceHelper.getUsableReferenceID(ProjectUtils.getInformation((Project)forProj).getName());
                String forProjName = ReferenceHelper.this.findReferenceID(projName, "project.", forProjDir.getAbsolutePath());
                if (forProjName == null) {
                    forProjName = ReferenceHelper.this.generateUniqueID(projName, "project.", forProjDir.getAbsolutePath());
                }
                File scriptFile = artifact.getScriptLocation();
                if (ReferenceHelper.canUseVersion10(artifact, forProjDir)) {
                    URI scriptLocation;
                    String rel = PropertyUtils.relativizeFile(forProjDir, scriptFile);
                    try {
                        scriptLocation = new URI(null, null, rel, null);
                    }
                    catch (URISyntaxException ex) {
                        scriptLocation = BaseUtilities.toURI((File)forProjDir).relativize(BaseUtilities.toURI((File)scriptFile));
                    }
                    ref = new RawReference(forProjName, artifact.getType(), scriptLocation, artifact.getTargetName(), artifact.getCleanTargetName(), artifact.getID());
                } else {
                    String scriptLocation;
                    if (scriptFile.getAbsolutePath().startsWith(forProjDir.getAbsolutePath())) {
                        String rel = PropertyUtils.relativizeFile(forProjDir, scriptFile);
                        assert (rel != null) : "Relativization must succeed for files: " + forProjDir + " " + scriptFile;
                        scriptLocation = "${project." + forProjName + "}/" + rel;
                    } else {
                        scriptLocation = "build.script.reference." + forProjName;
                        ReferenceHelper.this.setPathProperty(forProjDir, scriptFile, scriptLocation);
                        scriptLocation = "${" + scriptLocation + "}";
                    }
                    ref = new RawReference(forProjName, artifact.getType(), scriptLocation, artifact.getTargetName(), artifact.getCleanTargetName(), artifact.getID(), artifact.getProperties());
                }
                boolean success = ReferenceHelper.this.addRawReference0(ref);
                FileObject myProjDirFO = AntBasedProjectFactorySingleton.getProjectFor(ReferenceHelper.this.h).getProjectDirectory();
                File myProjDir = FileUtil.toFile((FileObject)myProjDirFO);
                if (ReferenceHelper.this.setPathProperty(myProjDir, forProjDir, "project." + forProjName)) {
                    success = true;
                }
                String forProjPathProp = "project." + forProjName;
                URI artFile = location;
                if (artFile.isAbsolute()) {
                    refPath = BaseUtilities.toFile((URI)artFile).getAbsolutePath();
                    propertiesFile = "nbproject/private/private.properties";
                } else {
                    refPath = "${" + forProjPathProp + "}/" + artFile.getPath();
                    propertiesFile = "nbproject/project.properties";
                }
                EditableProperties props = ReferenceHelper.this.h.getProperties(propertiesFile);
                String refPathProp = "reference." + forProjName + '.' + ReferenceHelper.getUsableReferenceID(artifact.getID());
                if (index > 0) {
                    refPathProp = refPathProp + "." + index;
                }
                if (!refPath.equals(props.getProperty(refPathProp))) {
                    props.put(refPathProp, refPath);
                    ReferenceHelper.this.h.putProperties(propertiesFile, props);
                    success = true;
                }
                return new Object[]{success, "${" + refPathProp + "}"};
            }
        });
    }

    private int findLocationIndex(AntArtifact artifact, URI location) throws IllegalArgumentException {
        if (location == null) {
            throw new IllegalArgumentException("location cannot be null");
        }
        URI[] uris = artifact.getArtifactLocations();
        for (int i = 0; i < uris.length; ++i) {
            if (!uris[i].equals(location)) continue;
            return i;
        }
        throw new IllegalArgumentException("location (" + location + ") must be in AntArtifact's locations (" + artifact + ")");
    }

    private static boolean canUseVersion10(AntArtifact aa, File projectDirectory) {
        if (aa.getArtifactLocations().length > 1) {
            return false;
        }
        if (aa.getProperties().keySet().size() > 0) {
            return false;
        }
        return aa.getScriptLocation().getAbsolutePath().startsWith(projectDirectory.getAbsolutePath());
    }

    private boolean setPathProperty(File base, File path, String propertyName) {
        Object[] values;
        String[] propertiesFiles;
        String relativePath = this.relativizeFileToExtraBaseFolders(path);
        if (relativePath != null) {
            propertiesFiles = new String[]{"nbproject/project.properties"};
            values = new String[]{relativePath};
        } else if (PropertyUtils.relativizeFile(base, path) != null) {
            relativePath = PropertyUtils.relativizeFile(base, path);
            assert (relativePath != null) : "These dirs are not really collocated: " + base + " & " + path;
            values = new String[]{relativePath};
            propertiesFiles = new String[]{"nbproject/project.properties"};
        } else {
            propertiesFiles = new String[]{"nbproject/private/private.properties"};
            values = new String[]{path.getAbsolutePath()};
        }
        assert (!Arrays.asList(values).contains(null)) : "values=" + Arrays.toString(values) + " base=" + base + " path=" + path;
        return this.setPathPropertyImpl(propertyName, (String[])values, propertiesFiles);
    }

    private boolean setPathProperty(String path, String propertyName) {
        String[] propertiesFiles = new String[]{"nbproject/project.properties"};
        String[] values = new String[]{path};
        return this.setPathPropertyImpl(propertyName, values, propertiesFiles);
    }

    private boolean setPathPropertyImpl(String propertyName, String[] values, String[] propertiesFiles) {
        String propertiesFile;
        EditableProperties props;
        boolean metadataChanged = false;
        for (int i = 0; i < propertiesFiles.length; ++i) {
            props = this.h.getProperties(propertiesFiles[i]);
            assert (props != null) : this.h.getProjectDirectory();
            if (values[i].equals(props.getProperty(propertyName))) continue;
            props.put(propertyName, values[i]);
            this.h.putProperties(propertiesFiles[i], props);
            metadataChanged = true;
        }
        if (propertiesFiles.length == 1 && (props = this.h.getProperties(propertiesFile = propertiesFiles[0].equals("nbproject/project.properties") ? "nbproject/private/private.properties" : "nbproject/project.properties")).remove(propertyName) != null) {
            this.h.putProperties(propertiesFile, props);
        }
        return metadataChanged;
    }

    public String addReference(AntArtifact artifact, URI location) throws IllegalArgumentException {
        Object[] ret = this.addReference0(artifact, location);
        return (String)ret[1];
    }

    public boolean isReferenced(final AntArtifact artifact, final URI location) throws IllegalArgumentException {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                int index = ReferenceHelper.this.findLocationIndex(artifact, location);
                Project forProj = artifact.getProject();
                if (forProj == null) {
                    throw new IllegalArgumentException("No project associated with " + artifact);
                }
                File forProjDir = FileUtil.toFile((FileObject)forProj.getProjectDirectory());
                assert (forProjDir != null) : forProj.getProjectDirectory();
                String projName = ReferenceHelper.getUsableReferenceID(ProjectUtils.getInformation((Project)forProj).getName());
                String forProjName = ReferenceHelper.this.findReferenceID(projName, "project.", forProjDir.getAbsolutePath());
                if (forProjName == null) {
                    return false;
                }
                RawReference ref = ReferenceHelper.this.getRawReference(forProjName, ReferenceHelper.getUsableReferenceID(artifact.getID()));
                if (ref == null) {
                    return false;
                }
                File script = ReferenceHelper.this.h.resolveFile(ReferenceHelper.this.eval.evaluate(ref.getScriptLocationValue()));
                if (!(artifact.getType().equals(ref.getArtifactType()) && artifact.getID().equals(ref.getID()) && artifact.getScriptLocation().equals(script) && artifact.getProperties().equals(ref.getProperties()) && artifact.getTargetName().equals(ref.getTargetName()) && artifact.getCleanTargetName().equals(ref.getCleanTargetName()))) {
                    return false;
                }
                String reference = "reference." + forProjName + '.' + ReferenceHelper.getUsableReferenceID(artifact.getID());
                if (index > 0) {
                    reference = reference + "." + index;
                }
                return ReferenceHelper.this.eval.getProperty(reference) != null;
            }
        });
    }

    public boolean addRawReference(final RawReference ref) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                try {
                    return ReferenceHelper.this.addRawReference0(ref);
                }
                catch (IllegalArgumentException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
                    return false;
                }
            }
        });
    }

    private boolean addRawReference0(RawReference ref) throws IllegalArgumentException {
        Element references = this.loadReferences();
        if (references == null) {
            references = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS(ref.getNS(), REFS_NAME);
        }
        boolean modified = false;
        if (references.getNamespaceURI().equals(REFS_NS) && ref.getNS().equals(REFS_NS2)) {
            references = this.upgradeTo20(references);
            this.removeOldReferences();
            modified = true;
        } else if (references.getNamespaceURI().equals(REFS_NS2) && ref.getNS().equals(REFS_NS)) {
            ref.upgrade();
        }
        if (modified |= ReferenceHelper.updateRawReferenceElement(ref, references)) {
            this.storeReferences(references);
        }
        return modified;
    }

    private Element upgradeTo20(Element references) {
        Element references20 = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS(REFS_NS2, REFS_NAME);
        RawReference[] rr = ReferenceHelper.getRawReferences(references);
        for (int i = 0; i < rr.length; ++i) {
            rr[i].upgrade();
            ReferenceHelper.updateRawReferenceElement(rr[i], references20);
        }
        return references20;
    }

    private static boolean updateRawReferenceElement(RawReference ref, Element references) throws IllegalArgumentException {
        Element nextRefEl = null;
        Iterator it = XMLUtil.findSubElements((Element)references).iterator();
        while (it.hasNext()) {
            Element testRefEl = (Element)it.next();
            RawReference testRef = RawReference.create(testRefEl);
            if (testRef.getForeignProjectName().compareTo(ref.getForeignProjectName()) > 0) {
                nextRefEl = testRefEl;
                break;
            }
            if (!testRef.getForeignProjectName().equals(ref.getForeignProjectName())) continue;
            if (testRef.getID().compareTo(ref.getID()) > 0) {
                nextRefEl = testRefEl;
                break;
            }
            if (!testRef.getID().equals(ref.getID())) continue;
            if (testRef.getArtifactType().equals(ref.getArtifactType()) && testRef.getScriptLocationValue().equals(ref.getScriptLocationValue()) && testRef.getProperties().equals(ref.getProperties()) && testRef.getTargetName().equals(ref.getTargetName()) && testRef.getCleanTargetName().equals(ref.getCleanTargetName())) {
                return false;
            }
            references.removeChild(testRefEl);
            if (it.hasNext()) {
                nextRefEl = (Element)it.next();
                break;
            }
            nextRefEl = null;
            break;
        }
        Element newRefEl = ref.toXml(references.getNamespaceURI(), references.getOwnerDocument());
        references.insertBefore(newRefEl, nextRefEl);
        return true;
    }

    @Deprecated
    public boolean removeReference(String foreignProjectName, String id) {
        return this.removeReference(foreignProjectName, id, false, null);
    }

    private boolean isLastReference(String ref) {
        Object[] ret = this.findArtifactAndLocation(ref);
        if (ret[0] == null || ret[1] == null) {
            return true;
        }
        AntArtifact aa = (AntArtifact)ret[0];
        URI uri = (URI)ret[1];
        URI[] uris = aa.getArtifactLocations();
        boolean lastReference = true;
        for (int i = 0; i < uris.length; ++i) {
            if (uris[i].equals(uri) || !this.isReferenced(aa, uris[i])) continue;
            lastReference = false;
            break;
        }
        return lastReference;
    }

    private boolean removeReference(final String foreignProjectName, final String id, final boolean escaped, final String reference) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                String refProp;
                boolean success = false;
                try {
                    if (ReferenceHelper.this.isLastReference("${" + reference + "}")) {
                        success = ReferenceHelper.this.removeRawReference0(foreignProjectName, id, escaped);
                    }
                }
                catch (IllegalArgumentException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
                    return false;
                }
                String[] PROPS_PATHS = new String[]{"nbproject/project.properties", "nbproject/private/private.properties"};
                if (success) {
                    RawReference[] refs = new RawReference[]{};
                    Element references = ReferenceHelper.this.loadReferences();
                    if (references != null) {
                        refs = ReferenceHelper.getRawReferences(references);
                    }
                    boolean deleteProjProp = true;
                    for (int i = 0; i < refs.length; ++i) {
                        if (!refs[i].getForeignProjectName().equals(foreignProjectName)) continue;
                        deleteProjProp = false;
                        break;
                    }
                    if (deleteProjProp) {
                        String projProp = "project." + foreignProjectName;
                        for (int i = 0; i < PROPS_PATHS.length; ++i) {
                            EditableProperties props = ReferenceHelper.this.h.getProperties(PROPS_PATHS[i]);
                            if (!props.containsKey(projProp)) continue;
                            props.remove(projProp);
                            ReferenceHelper.this.h.putProperties(PROPS_PATHS[i], props);
                            success = true;
                        }
                    }
                }
                if ((refProp = reference) == null) {
                    refProp = "reference." + foreignProjectName + '.' + ReferenceHelper.getUsableReferenceID(id);
                }
                String buildScriptProperty = "build.script.reference." + foreignProjectName;
                for (String path : PROPS_PATHS) {
                    EditableProperties props = ReferenceHelper.this.h.getProperties(path);
                    if (props.containsKey(refProp)) {
                        props.remove(refProp);
                        ReferenceHelper.this.h.putProperties(path, props);
                        success = true;
                    }
                    if (!props.containsKey(buildScriptProperty)) continue;
                    props.remove(buildScriptProperty);
                    ReferenceHelper.this.h.putProperties(path, props);
                    success = true;
                }
                return success;
            }
        });
    }

    @Deprecated
    public boolean removeReference(String fileReference) {
        return this.removeFileReference(fileReference);
    }

    private boolean removeFileReference(final String fileReference) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                boolean success = false;
                String[] PROPS_PATHS = new String[]{"nbproject/project.properties", "nbproject/private/private.properties"};
                String refProp = fileReference;
                if (refProp.startsWith("${") && refProp.endsWith("}")) {
                    refProp = refProp.substring(2, refProp.length() - 1);
                }
                for (String path : PROPS_PATHS) {
                    EditableProperties props = ReferenceHelper.this.h.getProperties(path);
                    if (!props.containsKey(refProp)) continue;
                    props.remove(refProp);
                    ReferenceHelper.this.h.putProperties(path, props);
                    success = true;
                }
                return success;
            }
        });
    }

    public boolean removeRawReference(final String foreignProjectName, final String id) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                try {
                    return ReferenceHelper.this.removeRawReference0(foreignProjectName, id, false);
                }
                catch (IllegalArgumentException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
                    return false;
                }
            }
        });
    }

    private boolean removeRawReference0(String foreignProjectName, String id, boolean escaped) throws IllegalArgumentException {
        Element references = this.loadReferences();
        if (references == null) {
            return false;
        }
        boolean success = ReferenceHelper.removeRawReferenceElement(foreignProjectName, id, references, escaped);
        if (success) {
            this.storeReferences(references);
        }
        return success;
    }

    private static boolean removeRawReferenceElement(String foreignProjectName, String id, Element references, boolean escaped) throws IllegalArgumentException {
        for (Element testRefEl : XMLUtil.findSubElements((Element)references)) {
            RawReference testRef = RawReference.create(testRefEl);
            String refID = testRef.getID();
            String refName = testRef.getForeignProjectName();
            if (escaped) {
                refID = ReferenceHelper.getUsableReferenceID(testRef.getID());
                refName = ReferenceHelper.getUsableReferenceID(testRef.getForeignProjectName());
            }
            if (refName.compareTo(foreignProjectName) > 0) {
                return false;
            }
            if (!refName.equals(foreignProjectName)) continue;
            if (refID.compareTo(id) > 0) {
                return false;
            }
            if (!refID.equals(id)) continue;
            references.removeChild(testRefEl);
            return true;
        }
        return false;
    }

    public RawReference[] getRawReferences() {
        return (RawReference[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<RawReference[]>(){

            public RawReference[] run() {
                Element references = ReferenceHelper.this.loadReferences();
                if (references != null) {
                    try {
                        return ReferenceHelper.getRawReferences(references);
                    }
                    catch (IllegalArgumentException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
                    }
                }
                return new RawReference[0];
            }
        });
    }

    private static RawReference[] getRawReferences(Element references) throws IllegalArgumentException {
        List subEls = XMLUtil.findSubElements((Element)references);
        ArrayList<RawReference> refs = new ArrayList<RawReference>(subEls.size());
        for (Element subEl : subEls) {
            refs.add(RawReference.create(subEl));
        }
        return refs.toArray(new RawReference[refs.size()]);
    }

    public RawReference getRawReference(String foreignProjectName, String id) {
        return this.getRawReference(foreignProjectName, id, false);
    }

    RawReference getRawReference(final String foreignProjectName, final String id, final boolean escaped) {
        return (RawReference)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<RawReference>(){

            public RawReference run() {
                Element references = ReferenceHelper.this.loadReferences();
                if (references != null) {
                    try {
                        return ReferenceHelper.getRawReference(foreignProjectName, id, references, escaped);
                    }
                    catch (IllegalArgumentException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
                    }
                }
                return null;
            }
        });
    }

    private static RawReference getRawReference(String foreignProjectName, String id, Element references, boolean escaped) throws IllegalArgumentException {
        for (Element subEl : XMLUtil.findSubElements((Element)references)) {
            RawReference ref = RawReference.create(subEl);
            String refID = ref.getID();
            String refName = ref.getForeignProjectName();
            if (escaped) {
                refID = ReferenceHelper.getUsableReferenceID(ref.getID());
                refName = ReferenceHelper.getUsableReferenceID(ref.getForeignProjectName());
            }
            if (!refName.equals(foreignProjectName) || !refID.equals(id)) continue;
            return ref;
        }
        return null;
    }

    public String createForeignFileReference(File file, String expectedArtifactType) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile((File)file));
        }
        return this.createForeignFileReferenceImpl(file.getAbsolutePath(), expectedArtifactType, true);
    }

    public String createForeignFileReferenceAsIs(String filepath, String expectedArtifactType) {
        return this.createForeignFileReferenceImpl(filepath, expectedArtifactType, false);
    }

    private String createForeignFileReferenceImpl(final String path, final String expectedArtifactType, final boolean performHeuristics) {
        FileObject myProjDirFO = this.h.getProjectDirectory();
        File myProjDir = FileUtil.toFile((FileObject)myProjDirFO);
        final File normalizedFile = FileUtil.normalizeFile((File)PropertyUtils.resolveFile(myProjDir, path));
        return (String)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                String prop;
                AntArtifact art = AntArtifactQuery.findArtifactFromFile(normalizedFile);
                if (art != null && art.getType().equals(expectedArtifactType) && art.getProject() != null) {
                    try {
                        return ReferenceHelper.this.createForeignFileReference(art);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new AssertionError((Object)iae);
                    }
                }
                File myProjDir = FileUtil.toFile((FileObject)AntBasedProjectFactorySingleton.getProjectFor(ReferenceHelper.this.h).getProjectDirectory());
                String fileID = normalizedFile.getName();
                if (normalizedFile.isDirectory() && normalizedFile.getParentFile() != null) {
                    fileID = normalizedFile.getParentFile().getName() + "-" + normalizedFile.getName();
                }
                if ((prop = ReferenceHelper.this.findReferenceID(fileID = PropertyUtils.getUsablePropertyName(fileID), "file.reference.", normalizedFile.getAbsolutePath())) == null) {
                    prop = ReferenceHelper.this.generateUniqueID(fileID, "file.reference.", normalizedFile.getAbsolutePath());
                }
                if (performHeuristics) {
                    ReferenceHelper.this.setPathProperty(myProjDir, normalizedFile, "file.reference." + prop);
                } else {
                    ReferenceHelper.this.setPathProperty(path, "file.reference." + prop);
                }
                return "${file.reference." + prop + '}';
            }
        });
    }

    public String createExtraForeignFileReferenceAsIs(final String path, final String property) {
        return (String)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                ReferenceHelper.this.setPathProperty(path, property);
                return "${" + property + '}';
            }
        });
    }

    private String relativizeFileToExtraBaseFolders(File f) {
        File base = FileUtil.toFile((FileObject)this.h.getProjectDirectory());
        String fileToRelativize = f.getAbsolutePath();
        for (String prop : this.extraBaseDirectories) {
            String path = this.eval.getProperty(prop);
            File extraBase = PropertyUtils.resolveFile(base, path);
            if (!(path = extraBase.getAbsolutePath()).endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (!fileToRelativize.startsWith(path)) continue;
            return "${" + prop + "}/" + fileToRelativize.substring(path.length()).replace('\\', '/');
        }
        return null;
    }

    public void addExtraBaseDirectory(final String propertyName) {
        if (propertyName == null || this.eval.getProperty(propertyName) == null) {
            throw new IllegalArgumentException("propertyName is null or such a property does not exist: " + propertyName);
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                ReferenceHelper.this.extraBaseDirectories.add(propertyName);
            }
        });
    }

    public void removeExtraBaseDirectory(final String propertyName) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (!ReferenceHelper.this.extraBaseDirectories.remove(propertyName)) {
                    throw new IllegalArgumentException("Non-existing extra base directory property: " + propertyName);
                }
                String tag = "${" + propertyName + "}";
                boolean shared = ReferenceHelper.this.h.getProperties("nbproject/project.properties").containsKey(propertyName);
                String value = ReferenceHelper.this.eval.getProperty(propertyName);
                EditableProperties propProj = ReferenceHelper.this.h.getProperties("nbproject/project.properties");
                EditableProperties propPriv = ReferenceHelper.this.h.getProperties("nbproject/private/private.properties");
                boolean modifiedProj = false;
                boolean modifiedPriv = false;
                Iterator<Map.Entry<String, String>> it = propProj.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, String> entry = it.next();
                    String val = entry.getValue();
                    int index = val.indexOf(tag);
                    if (index == -1) continue;
                    val = val.substring(0, index) + value + val.substring(index + tag.length());
                    if (shared) {
                        entry.setValue(val);
                    } else {
                        it.remove();
                        propPriv.put(entry.getKey(), val);
                        modifiedPriv = true;
                    }
                    modifiedProj = true;
                }
                if (modifiedProj) {
                    ReferenceHelper.this.h.putProperties("nbproject/project.properties", propProj);
                }
                if (modifiedPriv) {
                    ReferenceHelper.this.h.putProperties("nbproject/private/private.properties", propPriv);
                }
            }
        });
    }

    private String findReferenceID(String property, String prefix, String path) {
        Map<String, String> m = this.h.getStandardPropertyEvaluator().getProperties();
        for (Map.Entry<String, String> e : m.entrySet()) {
            String v;
            String key = e.getKey();
            if (!key.startsWith(prefix + property) || !path.equals(v = this.h.resolvePath(e.getValue()))) continue;
            return key.substring(prefix.length());
        }
        return null;
    }

    private String generateUniqueID(String property, String prefix, String value) {
        PropertyEvaluator pev = this.h.getStandardPropertyEvaluator();
        if (pev.getProperty(prefix + property) == null) {
            return property;
        }
        int i = 1;
        while (pev.getProperty(prefix + property + "-" + i) != null) {
            ++i;
        }
        return property + "-" + i;
    }

    @Deprecated
    public String createForeignFileReference(AntArtifact artifact) throws IllegalArgumentException {
        Object[] ret = this.addReference0(artifact, artifact.getArtifactLocations()[0]);
        return (String)ret[1];
    }

    private static String getUsableReferenceID(String ID) {
        return PropertyUtils.getUsablePropertyName(ID).replace('.', '_');
    }

    @Deprecated
    public AntArtifact getForeignFileReferenceAsArtifact(String reference) {
        Object[] ret = this.findArtifactAndLocation(reference);
        return (AntArtifact)ret[0];
    }

    public Object[] findArtifactAndLocation(final String reference) {
        return (Object[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Object[]>(){

            public Object[] run() {
                RawReference ref;
                AntArtifact aa = null;
                Matcher m = FOREIGN_FILE_REFERENCE.matcher(reference);
                boolean matches = m.matches();
                int index = 0;
                if (!matches) {
                    m = FOREIGN_FILE_REFERENCE_OLD.matcher(reference);
                    matches = m.matches();
                } else {
                    try {
                        index = Integer.parseInt(m.group(3));
                    }
                    catch (NumberFormatException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Could not parse reference ({0}) for the jar index. Expected number: {1}", new Object[]{reference, m.group(3)});
                        matches = false;
                    }
                }
                if (matches && (ref = ReferenceHelper.this.getRawReference(m.group(1), m.group(2), true)) != null) {
                    aa = ref.toAntArtifact(ReferenceHelper.this);
                }
                if (aa == null) {
                    return new Object[]{null, null};
                }
                if (index >= aa.getArtifactLocations().length) {
                    return new Object[]{null, null};
                }
                URI uri = aa.getArtifactLocations()[index];
                return new Object[]{aa, uri};
            }
        });
    }

    @Deprecated
    public void destroyForeignFileReference(String reference) {
        this.destroyReference(reference);
    }

    public boolean destroyReference(String reference) {
        Matcher m = FOREIGN_FILE_REFERENCE.matcher(reference);
        boolean matches = m.matches();
        if (!matches) {
            m = FOREIGN_FILE_REFERENCE_OLD.matcher(reference);
            matches = m.matches();
        }
        if (matches) {
            String forProjName = m.group(1);
            String id = m.group(2);
            return this.removeReference(forProjName, id, true, reference.substring(2, reference.length() - 1));
        }
        m = FOREIGN_PLAIN_FILE_REFERENCE.matcher(reference);
        if (m.matches()) {
            return this.removeFileReference(reference);
        }
        return false;
    }

    public SubprojectProvider createSubprojectProvider() {
        return new SubprojectProviderImpl(this);
    }

    AntProjectHelper getAntProjectHelper() {
        return this.h;
    }

    public void fixReferences(File originalPath) {
        Object value;
        boolean cont;
        String key;
        String[] prefixesToFix = new String[]{"file.reference.", "project."};
        EditableProperties pub = this.h.getProperties("nbproject/project.properties");
        EditableProperties priv = this.h.getProperties("nbproject/private/private.properties");
        File projectDir = FileUtil.toFile((FileObject)this.h.getProjectDirectory());
        ArrayList<String> pubRemove = new ArrayList<String>();
        ArrayList<String> privRemove = new ArrayList<String>();
        HashMap<String, String> pubAdd = new HashMap<String, String>();
        HashMap<String, String> privAdd = new HashMap<String, String>();
        for (Map.Entry<String, String> e : pub.entrySet()) {
            File absolutePath;
            String rel2;
            key = e.getKey();
            cont = false;
            for (String string : prefixesToFix) {
                if (!key.startsWith(string)) continue;
                cont = true;
                break;
            }
            if (!cont || ((String)(value = e.getValue())).startsWith("${") || (rel2 = PropertyUtils.relativizeFile(projectDir, absolutePath = FileUtil.normalizeFile((File)PropertyUtils.resolveFile(originalPath, (String)value)))) != null) continue;
            pubRemove.add(key);
            privAdd.put(key, absolutePath.getAbsolutePath());
        }
        for (Map.Entry<String, String> e : pub.entrySet()) {
            String rel;
            key = e.getKey();
            cont = false;
            value = prefixesToFix;
            int absolutePath = ((String[])value).length;
            for (int rel2 = 0; rel2 < absolutePath; ++rel2) {
                Object object = value[rel2];
                if (!key.startsWith((String)object)) continue;
                cont = true;
                break;
            }
            if (!cont || ((String)(value = e.getValue())).startsWith("${")) continue;
            File absolutePath2 = FileUtil.normalizeFile((File)PropertyUtils.resolveFile(originalPath, (String)value));
            if (absolutePath2.getAbsolutePath().startsWith(originalPath.getAbsolutePath())) {
                String relative = PropertyUtils.relativizeFile(originalPath, absolutePath2);
                absolutePath2 = FileUtil.normalizeFile((File)new File(projectDir, relative));
                if (priv.containsKey(key)) {
                    privRemove.add(key);
                    privAdd.put(key, absolutePath2.getAbsolutePath());
                }
            }
            if ((rel = PropertyUtils.relativizeFile(projectDir, absolutePath2)) == null) continue;
            pubAdd.put(key, rel);
        }
        pub.keySet().removeAll(pubRemove);
        priv.keySet().removeAll(privRemove);
        pub.putAll(pubAdd);
        priv.putAll(privAdd);
        this.h.putProperties("nbproject/project.properties", pub);
        this.h.putProperties("nbproject/private/private.properties", priv);
    }

    public String createLibraryReference(Library library, String volumeType) {
        if (library.getManager() == LibraryManager.getDefault()) {
            if (this.h.isSharableProject()) {
                throw new IllegalArgumentException("Project [" + this.h.getProjectDirectory() + "] is sharable and cannot reference global library " + library.getName());
            }
        } else if (!ProjectLibraryProvider.isReachableLibrary(library, this.h)) {
            throw new IllegalArgumentException("Project [" + this.h.getProjectDirectory() + "] cannot reference a library from " + library.getManager().getLocation());
        }
        return "${libs." + library.getName() + "." + volumeType + "}";
    }

    public LibraryManager getProjectLibraryManager() {
        return ProjectLibraryProvider.getProjectLibraryManager(this.h);
    }

    public static LibraryManager getProjectLibraryManager(Project p) {
        AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration((Project)p);
        File libFile = ProjectLibraryProvider.getLibrariesLocation(aux, FileUtil.toFile((FileObject)p.getProjectDirectory()));
        if (libFile != null) {
            try {
                return LibraryManager.forLocation((URL)BaseUtilities.toURI((File)libFile).toURL());
            }
            catch (MalformedURLException e) {
                Logger.getLogger(ReferenceHelper.class.getName()).info("library manager cannot be found for " + libFile + ". " + e.toString());
            }
        }
        return null;
    }

    public Library copyLibrary(Library lib) throws IOException {
        Parameters.notNull((CharSequence)"lib", (Object)lib);
        if (lib.getManager() != LibraryManager.getDefault()) {
            throw new IllegalArgumentException("cannot copy non-global library " + lib.getManager().getLocation());
        }
        if (!this.h.isSharableProject()) {
            return lib;
        }
        File mainPropertiesFile = this.h.resolveFile(this.h.getLibrariesLocation());
        return ReferenceHelper.copyLibrary(lib, mainPropertiesFile);
    }

    public static Library copyLibrary(@NonNull Library lib, @NonNull File librariesLocation) throws IOException {
        Parameters.notNull((CharSequence)"lib", (Object)lib);
        Parameters.notNull((CharSequence)"librariesLocation", (Object)librariesLocation);
        return ProjectLibraryProvider.copyLibrary(lib, BaseUtilities.toURI((File)librariesLocation).toURL(), true);
    }

    public Library findLibrary(String name) {
        LibraryManager mgr;
        Matcher m = LIBRARY_REFERENCE.matcher(name);
        if (m.matches()) {
            name = m.group(1);
        }
        if ((mgr = this.getProjectLibraryManager()) == null) {
            return LibraryManager.getDefault().getLibrary(name);
        }
        return mgr.getLibrary(name);
    }

    public static final class RawReference {
        private final String foreignProjectName;
        private final String artifactType;
        private URI scriptLocation;
        private String newScriptLocation;
        private final String targetName;
        private final String cleanTargetName;
        private final String artifactID;
        private final Properties props;
        private static final List<String> SUB_ELEMENT_NAMES = Arrays.asList("foreign-project", "artifact-type", "script", "target", "clean-target", "id");

        public RawReference(String foreignProjectName, String artifactType, URI scriptLocation, String targetName, String cleanTargetName, String artifactID) throws IllegalArgumentException {
            this(foreignProjectName, artifactType, scriptLocation, null, targetName, cleanTargetName, artifactID, new Properties());
        }

        public RawReference(String foreignProjectName, String artifactType, String newScriptLocation, String targetName, String cleanTargetName, String artifactID, Properties props) throws IllegalArgumentException {
            this(foreignProjectName, artifactType, null, newScriptLocation, targetName, cleanTargetName, artifactID, props);
        }

        private RawReference(String foreignProjectName, String artifactType, URI scriptLocation, String newScriptLocation, String targetName, String cleanTargetName, String artifactID, Properties props) throws IllegalArgumentException {
            this.foreignProjectName = foreignProjectName;
            this.artifactType = artifactType;
            if (scriptLocation != null && scriptLocation.isAbsolute()) {
                throw new IllegalArgumentException("Cannot use an absolute URI " + scriptLocation + " for script location");
            }
            this.scriptLocation = scriptLocation;
            this.newScriptLocation = newScriptLocation;
            this.targetName = targetName;
            this.cleanTargetName = cleanTargetName;
            this.artifactID = artifactID;
            this.props = props;
        }

        static RawReference create(Element xml) throws IllegalArgumentException {
            if (ReferenceHelper.REFS_NS.equals(xml.getNamespaceURI())) {
                return RawReference.create1(xml);
            }
            return RawReference.create2(xml);
        }

        private static RawReference create1(Element xml) throws IllegalArgumentException {
            if (!ReferenceHelper.REF_NAME.equals(xml.getLocalName()) || !ReferenceHelper.REFS_NS.equals(xml.getNamespaceURI())) {
                throw new IllegalArgumentException("bad element name: " + xml);
            }
            NodeList nl = xml.getElementsByTagNameNS("*", "*");
            if (nl.getLength() != 6) {
                throw new IllegalArgumentException("missing or extra data: " + xml);
            }
            String[] values = new String[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                if (!ReferenceHelper.REFS_NS.equals(el.getNamespaceURI())) {
                    throw new IllegalArgumentException("bad subelement ns: " + el);
                }
                String elName = el.getLocalName();
                int idx = SUB_ELEMENT_NAMES.indexOf(elName);
                if (idx == -1) {
                    throw new IllegalArgumentException("bad subelement name: " + elName);
                }
                String val = XMLUtil.findText((Node)el);
                if (val == null) {
                    throw new IllegalArgumentException("empty subelement: " + el);
                }
                if (values[idx] != null) {
                    throw new IllegalArgumentException("duplicate " + elName + ": " + values[idx] + " and " + val);
                }
                values[idx] = val;
            }
            assert (!Arrays.asList(values).contains(null));
            URI scriptLocation = URI.create(values[2]);
            return new RawReference(values[0], values[1], scriptLocation, values[3], values[4], values[5]);
        }

        private static RawReference create2(Element xml) throws IllegalArgumentException {
            Element el;
            if (!ReferenceHelper.REF_NAME.equals(xml.getLocalName()) || !ReferenceHelper.REFS_NS2.equals(xml.getNamespaceURI())) {
                throw new IllegalArgumentException("bad element name: " + xml);
            }
            List nl = XMLUtil.findSubElements((Element)xml);
            if (nl.size() < 6) {
                throw new IllegalArgumentException("missing or extra data: " + xml);
            }
            String[] values = new String[6];
            for (int i = 0; i < 6; ++i) {
                el = (Element)nl.get(i);
                if (!ReferenceHelper.REFS_NS2.equals(el.getNamespaceURI())) {
                    throw new IllegalArgumentException("bad subelement ns: " + el);
                }
                String elName = el.getLocalName();
                int idx = SUB_ELEMENT_NAMES.indexOf(elName);
                if (idx == -1) {
                    throw new IllegalArgumentException("bad subelement name: " + elName);
                }
                String val = XMLUtil.findText((Node)el);
                if (val == null) {
                    throw new IllegalArgumentException("empty subelement: " + el);
                }
                if (values[idx] != null) {
                    throw new IllegalArgumentException("duplicate " + elName + ": " + values[idx] + " and " + val);
                }
                values[idx] = val;
            }
            Properties props = new Properties();
            if (nl.size() == 7) {
                el = (Element)nl.get(6);
                if (!ReferenceHelper.REFS_NS2.equals(el.getNamespaceURI())) {
                    throw new IllegalArgumentException("bad subelement ns: " + el);
                }
                if (!"properties".equals(el.getLocalName())) {
                    throw new IllegalArgumentException("bad subelement. expected 'properties': " + el);
                }
                for (Element el2 : XMLUtil.findSubElements((Element)el)) {
                    String key = el2.getAttribute("name");
                    String value = XMLUtil.findText((Node)el2);
                    if (value == null) {
                        value = "";
                    }
                    props.setProperty(key, value);
                }
            }
            assert (!Arrays.asList(values).contains(null));
            return new RawReference(values[0], values[1], values[2], values[3], values[4], values[5], props);
        }

        Element toXml(String namespace, Document ownerDocument) {
            Element el = ownerDocument.createElementNS(namespace, ReferenceHelper.REF_NAME);
            String[] values = new String[]{this.foreignProjectName, this.artifactType, this.newScriptLocation != null ? this.newScriptLocation : this.scriptLocation.toString(), this.targetName, this.cleanTargetName, this.artifactID};
            for (int i = 0; i < 6; ++i) {
                Element subel = ownerDocument.createElementNS(namespace, SUB_ELEMENT_NAMES.get(i));
                subel.appendChild(ownerDocument.createTextNode(values[i]));
                el.appendChild(subel);
            }
            if (this.props.keySet().size() > 0) {
                assert (namespace.equals(ReferenceHelper.REFS_NS2)) : "can happen only in /2";
                Element propEls = ownerDocument.createElementNS(namespace, "properties");
                el.appendChild(propEls);
                for (String key : new TreeSet(NbCollections.checkedSetByFilter(this.props.keySet(), String.class, (boolean)true))) {
                    Element propEl = ownerDocument.createElementNS(namespace, "property");
                    propEl.appendChild(ownerDocument.createTextNode(this.props.getProperty(key)));
                    propEl.setAttribute("name", key);
                    propEls.appendChild(propEl);
                }
            }
            return el;
        }

        private String getNS() {
            if (this.newScriptLocation != null) {
                return ReferenceHelper.REFS_NS2;
            }
            return ReferenceHelper.REFS_NS;
        }

        public String getForeignProjectName() {
            return this.foreignProjectName;
        }

        public String getArtifactType() {
            return this.artifactType;
        }

        @Deprecated
        public URI getScriptLocation() {
            return this.scriptLocation;
        }

        public String getScriptLocationValue() {
            if (this.newScriptLocation != null) {
                return this.newScriptLocation;
            }
            return "${project." + this.foreignProjectName + "}/" + this.scriptLocation.toString();
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getCleanTargetName() {
            return this.cleanTargetName;
        }

        public String getID() {
            return this.artifactID;
        }

        public Properties getProperties() {
            return this.props;
        }

        public AntArtifact toAntArtifact(final ReferenceHelper helper) {
            return (AntArtifact)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<AntArtifact>(){

                public AntArtifact run() {
                    Project p;
                    AntProjectHelper h = helper.h;
                    String path = helper.eval.getProperty("project." + foreignProjectName);
                    if (path == null) {
                        return null;
                    }
                    FileObject foreignProjectDir = h.resolveFileObject(path);
                    if (foreignProjectDir == null) {
                        return null;
                    }
                    try {
                        p = ProjectManager.getDefault().findProject(foreignProjectDir);
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
                        return null;
                    }
                    if (p == null) {
                        return null;
                    }
                    return AntArtifactQuery.findArtifactByID(p, artifactID);
                }
            });
        }

        private void upgrade() {
            assert (this.newScriptLocation == null && this.scriptLocation != null) : "was already upgraded " + this;
            this.newScriptLocation = "${project." + this.foreignProjectName + "}/" + this.scriptLocation.toString();
            this.scriptLocation = null;
        }

        public String toString() {
            return "ReferenceHelper.RawReference<" + this.foreignProjectName + "," + this.artifactType + "," + this.newScriptLocation != null ? this.newScriptLocation : this.scriptLocation + "," + this.targetName + "," + this.cleanTargetName + "," + this.artifactID + ">";
        }
    }
}

