/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.fish.payara.micro.project.MicroApplication;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.openide.util.Lookup;

public class MicroActionsProvider
implements MavenActionsProvider {
    private static final String ACTION_MAPPINGS = "org/netbeans/modules/fish/payara/micro/project/resources/action-mapping.xml";
    private final AbstractMavenActionsProvider actionsProvider = new AbstractMavenActionsProvider(){

        protected InputStream getActionDefinitionStream() {
            return MicroActionsProvider.class.getClassLoader().getResourceAsStream(MicroActionsProvider.ACTION_MAPPINGS);
        }

        public boolean isActionEnable(String action, Project project, Lookup lookup) {
            NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            String packagingType = nbMavenProject.getPackagingType();
            if (!"war".equals(packagingType)) {
                return false;
            }
            switch (action) {
                case "run": 
                case "debug": 
                case "profile": 
                case "run.single.deploy": 
                case "debug.single.deploy": 
                case "profile.single.deploy": {
                    break;
                }
                default: {
                    return false;
                }
            }
            return MicroApplication.getInstance(project) != null;
        }
    };

    public RunConfig createConfigForDefaultAction(String actionName, Project project, Lookup lookup) {
        Preferences pref = ProjectUtils.getPreferences((Project)project, MicroApplication.class, (boolean)true);
        String microVersionText = pref.get("version", "");
        RunConfig config = this.actionsProvider.createConfigForDefaultAction(actionName, project, lookup);
        if (!microVersionText.isEmpty()) {
            config.setProperty("version.payara", microVersionText);
        }
        config.getGoals().addAll(MicroActionsProvider.getGoals(actionName));
        return config;
    }

    public NetbeansActionMapping getMappingForAction(String actionName, Project project) {
        return this.actionsProvider.getMappingForAction(actionName, project);
    }

    public boolean isActionEnable(String action, Project project, Lookup lookup) {
        return this.actionsProvider.isActionEnable(action, project, lookup);
    }

    public Set<String> getSupportedDefaultActions() {
        return this.actionsProvider.getSupportedDefaultActions();
    }

    public static List<String> getGoals(String actionName) {
        ArrayList<String> goals = new ArrayList<String>();
        if (null != actionName) {
            switch (actionName) {
                case "run": 
                case "run.single.deploy": {
                    goals.add("resources:resources");
                    goals.add("compiler:compile");
                    goals.add("war:exploded");
                    goals.add("payara-micro:stop");
                    goals.add("payara-micro:start");
                    break;
                }
                case "debug": 
                case "debug.single.deploy": 
                case "profile": 
                case "profile.single.deploy": {
                    goals.add("war:war");
                    goals.add("payara-micro:stop");
                    goals.add("payara-micro:start");
                    break;
                }
                case "micro-complie-explode": {
                    goals.add("resources:resources");
                    goals.add("compiler:compile");
                    goals.add("war:exploded");
                    break;
                }
                case "micro-explode": {
                    goals.add("war:exploded");
                    break;
                }
                case "micro-stop": {
                    goals.add("payara-micro:stop");
                    break;
                }
            }
        }
        return goals;
    }
}

