/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;

public final class Util {
    static Set<String> allMimeTypes;

    public static Set<String> getAllMimeTypes() {
        return allMimeTypes != null ? allMimeTypes : EditorSettings.getDefault().getAllMimeTypes();
    }

    public static boolean canBeParsed(String mimeType) {
        if (mimeType == null || "content/unknown".equals(mimeType) || !Util.getAllMimeTypes().contains(mimeType)) {
            return false;
        }
        int slashIdx = mimeType.indexOf(47);
        assert (slashIdx != -1) : "Invalid mimetype: '" + mimeType + "'";
        String type = mimeType.substring(0, slashIdx);
        return !(type.equals("application") ? !mimeType.equals("application/x-httpd-eruby") && !mimeType.equals("application/xml-dtd") : !type.equals("text"));
    }

    public static StackTraceElement findCaller(StackTraceElement[] elements, Object ... classesToFilterOut) {
        block0: for (StackTraceElement e : elements) {
            if (e.getClassName().equals(Util.class.getName()) || e.getClassName().startsWith("java.lang.")) continue;
            if (classesToFilterOut != null && classesToFilterOut.length > 0) {
                for (Object c : classesToFilterOut) {
                    if (c instanceof Class && e.getClassName().startsWith(((Class)c).getName()) || c instanceof String && e.getClassName().startsWith((String)c)) continue block0;
                }
            } else if (e.getClassName().startsWith("org.netbeans.modules.parsing.")) continue;
            return e;
        }
        return null;
    }

    public static URL resolveUrl(@NonNull URL root, @NonNull String relativePath, final @NullAllowed Boolean isDirectory) throws MalformedURLException, IllegalStateException {
        try {
            if ("file".equals(root.getProtocol())) {
                if (isDirectory == Boolean.FALSE && (relativePath.isEmpty() || relativePath.charAt(relativePath.length() - 1) == '/')) {
                    throw new IllegalStateException(MessageFormat.format("relativePath: {0}", relativePath));
                }
                return Utilities.toURI((File)new File(Utilities.toFile((URI)root.toURI()), relativePath){

                    @Override
                    public File getAbsoluteFile() {
                        if (this.isAbsolute()) {
                            return this;
                        }
                        return super.getAbsoluteFile();
                    }

                    @Override
                    public boolean isDirectory() {
                        return isDirectory == null ? super.isDirectory() : isDirectory.booleanValue();
                    }
                }).toURL();
            }
            return new URL(root, relativePath);
        }
        catch (URISyntaxException use) {
            MalformedURLException mue = new MalformedURLException("Can't resolve URL: root=" + root + ", relativePath=" + relativePath);
            mue.initCause(use);
            throw mue;
        }
    }

    public static URL resolveFile(@NonNull File file, @NonNull String relativePath, final @NullAllowed Boolean isDirectory) throws MalformedURLException {
        if (isDirectory == Boolean.FALSE && (relativePath.isEmpty() || relativePath.charAt(relativePath.length() - 1) == '/' || relativePath.charAt(relativePath.length() - 1) == File.separatorChar)) {
            throw new IllegalStateException(MessageFormat.format("relativePath: {0}", relativePath));
        }
        return Utilities.toURI((File)new File(file, relativePath){

            @Override
            public File getAbsoluteFile() {
                if (this.isAbsolute()) {
                    return this;
                }
                return super.getAbsoluteFile();
            }

            @Override
            public boolean isDirectory() {
                return isDirectory == null ? super.isDirectory() : isDirectory.booleanValue();
            }
        }).toURL();
    }

    public static boolean containsAny(Collection<? extends String> searchIn, Collection<? extends String> searchFor) {
        if (searchIn != null && searchFor != null) {
            for (String string : searchFor) {
                if (!searchIn.contains(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static FileObject getFileObject(Document doc) {
        Object sdp = doc.getProperty("stream");
        if (sdp instanceof FileObject) {
            return (FileObject)sdp;
        }
        if (sdp instanceof DataObject) {
            return ((DataObject)sdp).getPrimaryFile();
        }
        return null;
    }

    public static boolean isParentOf(@NonNull File folder, @NonNull File file) {
        return file.getAbsolutePath().startsWith(folder.getAbsolutePath());
    }

    private Util() {
    }
}

