/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.options.OptionsPanel;
import org.netbeans.modules.options.classic.OptionsAction;
import org.netbeans.modules.options.export.OptionsChooserPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public class OptionsDisplayerImpl {
    private static Dialog dialog;
    private static WeakReference<DialogDescriptor> descriptorRef;
    private static String title;
    private static Logger log;
    private boolean modal;
    static final LookupListener lookupListener;
    private JButton bOK;
    private JButton bClassic;
    private JButton btnExport;
    private JButton btnImport;

    public OptionsDisplayerImpl(boolean modal) {
        this.modal = modal;
        try {
            FileUtil.getConfigRoot().getFileSystem().addFileChangeListener((FileChangeListener)new DefaultFSListener());
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isOpen() {
        return dialog != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void selectCategory(String path) {
        DialogDescriptor descriptor = null;
        LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
        synchronized (lookupListener) {
            descriptor = (DialogDescriptor)descriptorRef.get();
        }
        if (descriptor != null) {
            OptionsPanel optionsPanel = (OptionsPanel)descriptor.getMessage();
            String categoryId = path.indexOf(47) == -1 ? path : path.substring(0, path.indexOf(47));
            String subpath = path.indexOf(47) == -1 ? null : path.substring(path.indexOf(47) + 1);
            optionsPanel.initCurrentCategory(categoryId, subpath);
        }
        dialog.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showOptionsDialog(String categoryID, String subpath) {
        if (this.isOpen()) {
            dialog.setVisible(true);
            dialog.toFront();
            log.fine("Front Options Dialog");
            return;
        }
        DialogDescriptor descriptor = null;
        LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
        synchronized (lookupListener) {
            descriptor = (DialogDescriptor)descriptorRef.get();
        }
        OptionsPanel optionsPanel = null;
        if (descriptor == null) {
            optionsPanel = categoryID == null ? new OptionsPanel() : new OptionsPanel(categoryID);
            this.bOK = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_OK");
            this.bOK.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_OKButton"));
            this.bClassic = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Classic");
            this.bClassic.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_ClassicButton"));
            this.btnExport = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Export");
            this.btnExport.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_Export"));
            this.btnImport = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Import");
            this.btnImport.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_Import"));
            this.updateButtons();
            boolean isMac = Utilities.isMac();
            Object[] options = new Object[]{isMac ? DialogDescriptor.CANCEL_OPTION : this.bOK, isMac ? this.bOK : DialogDescriptor.CANCEL_OPTION};
            descriptor = new DialogDescriptor((Object)optionsPanel, title, this.modal, options, DialogDescriptor.OK_OPTION, 0, null, null, false);
            descriptor.setAdditionalOptions(new Object[]{this.bClassic, this.btnExport, this.btnImport});
            descriptor.setHelpCtx(optionsPanel.getHelpCtx());
            OptionsPanelListener listener = new OptionsPanelListener(descriptor, optionsPanel, this.bOK, this.bClassic, this.btnExport, this.btnImport);
            descriptor.setButtonListener((ActionListener)listener);
            optionsPanel.addPropertyChangeListener(listener);
            LookupListener lookupListener2 = OptionsDisplayerImpl.lookupListener;
            synchronized (lookupListener2) {
                descriptorRef = new WeakReference<DialogDescriptor>(descriptor);
            }
            log.fine("Create new Options Dialog");
        } else {
            optionsPanel = (OptionsPanel)descriptor.getMessage();
            optionsPanel.update();
            log.fine("Reopen Options Dialog");
        }
        dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        optionsPanel.initCurrentCategory(categoryID, subpath);
        dialog.addWindowListener(new MyWindowListener(optionsPanel));
        Point userLocation = this.getUserLocation();
        if (userLocation != null) {
            dialog.setLocation(userLocation);
        }
        dialog.setVisible(true);
    }

    private void updateButtons() {
        if (this.bClassic != null) {
            this.bClassic.setVisible(this.advancedOptionsNotEmpty());
        }
        boolean optionsExportNotEmpty = this.optionsExportNotEmpty();
        if (this.btnExport != null) {
            this.btnExport.setVisible(optionsExportNotEmpty);
        }
        if (this.btnImport != null) {
            this.btnImport.setVisible(optionsExportNotEmpty);
        }
    }

    private boolean advancedOptionsNotEmpty() {
        FileObject servicesFO = FileUtil.getConfigFile((String)"UI/Services");
        if (servicesFO != null) {
            FileObject[] advancedOptions;
            for (FileObject advancedOption : advancedOptions = servicesFO.getChildren()) {
                Object hidden = advancedOption.getAttribute("hidden");
                if (hidden != null && ((Boolean)hidden).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean optionsExportNotEmpty() {
        FileObject optionsExportFO = FileUtil.getConfigFile((String)"OptionsExport");
        if (optionsExportFO != null) {
            FileObject[] categories;
            for (FileObject category : categories = optionsExportFO.getChildren()) {
                FileObject[] items;
                Object hiddenCategory = category.getAttribute("hidden");
                if (hiddenCategory != null && ((Boolean)hiddenCategory).booleanValue()) continue;
                for (FileObject item : items = category.getChildren()) {
                    Object hiddenItem = item.getAttribute("hidden");
                    if (hiddenItem != null && ((Boolean)hiddenItem).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Point getUserLocation() {
        Rectangle screenBounds = Utilities.getUsableScreenBounds();
        int x = NbPreferences.forModule(OptionsDisplayerImpl.class).getInt("OptionsX", Integer.MAX_VALUE);
        int y = NbPreferences.forModule(OptionsDisplayerImpl.class).getInt("OptionsY", Integer.MAX_VALUE);
        if ((double)x > screenBounds.getWidth() || (double)y > screenBounds.getHeight()) {
            return null;
        }
        return new Point(x, y);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(OptionsDisplayerImpl.class, (String)key);
    }

    private static Component loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)OptionsDisplayerImpl.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)OptionsDisplayerImpl.loc(key));
        }
        return c;
    }

    static {
        descriptorRef = new WeakReference<Object>(null);
        title = OptionsDisplayerImpl.loc("CTL_Options_Dialog_Title");
        log = Logger.getLogger(OptionsDisplayerImpl.class.getName());
        lookupListener = new LookupListenerImpl();
    }

    private class DefaultFSListener
    implements FileChangeListener {
        private DefaultFSListener() {
        }

        public void fileRenamed(FileRenameEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileChanged(FileEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileFolderCreated(FileEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileDataCreated(FileEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileDeleted(FileEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
            OptionsDisplayerImpl.this.updateButtons();
        }
    }

    private static class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
            synchronized (lookupListener) {
                descriptorRef = new WeakReference<Object>(null);
                if (dialog != null) {
                    dialog.setVisible(false);
                    dialog = null;
                }
            }
        }
    }

    class OpenOptionsListener
    implements ActionListener {
        OpenOptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            log.fine("Options Dialog - Back to modern.");
                            OptionsDisplayer.getDefault().open();
                        }
                    });
                }
            });
        }
    }

    private class MyWindowListener
    implements WindowListener {
        private OptionsPanel optionsPanel;
        private Dialog originalDialog;

        MyWindowListener(OptionsPanel optionsPanel) {
            this.optionsPanel = optionsPanel;
            this.originalDialog = dialog;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (dialog == null) {
                return;
            }
            log.fine("Options Dialog - windowClosing ");
            this.optionsPanel.cancel();
            OptionsDisplayerImpl.this.bOK.setEnabled(true);
            if (this.originalDialog == dialog) {
                dialog = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosed(WindowEvent e) {
            this.optionsPanel.storeUserSize();
            NbPreferences.forModule(OptionsDisplayerImpl.class).putInt("OptionsX", this.originalDialog.getX());
            NbPreferences.forModule(OptionsDisplayerImpl.class).putInt("OptionsY", this.originalDialog.getY());
            if (this.optionsPanel.needsReinit()) {
                LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
                synchronized (lookupListener) {
                    descriptorRef = new WeakReference<Object>(null);
                }
            }
            if (this.originalDialog == dialog) {
                dialog = null;
            }
            log.fine("Options Dialog - windowClosed");
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }
    }

    private class OptionsPanelListener
    implements PropertyChangeListener,
    ActionListener {
        private DialogDescriptor descriptor;
        private OptionsPanel optionsPanel;
        private JButton bOK;
        private JButton bClassic;
        private JButton btnExport;
        private JButton btnImport;

        OptionsPanelListener(DialogDescriptor descriptor, OptionsPanel optionsPanel, JButton bOK, JButton bClassic, JButton btnExport, JButton btnImport) {
            this.descriptor = descriptor;
            this.optionsPanel = optionsPanel;
            this.bOK = bOK;
            this.bClassic = bClassic;
            this.btnExport = btnExport;
            this.btnImport = btnImport;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("buranhelpCtx")) {
                this.descriptor.setHelpCtx(this.optionsPanel.getHelpCtx());
            } else if (ev.getPropertyName().equals("buranvalid")) {
                this.bOK.setEnabled(this.optionsPanel.dataValid());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!OptionsDisplayerImpl.this.isOpen()) {
                return;
            }
            if (e.getSource() == this.bOK) {
                log.fine("Options Dialog - Ok pressed.");
                Dialog d = dialog;
                dialog = null;
                this.optionsPanel.save();
                d.dispose();
                return;
            }
            if (e.getSource() == DialogDescriptor.CANCEL_OPTION || e.getSource() == DialogDescriptor.CLOSED_OPTION) {
                log.fine("Options Dialog - Cancel pressed.");
                Dialog d = dialog;
                dialog = null;
                this.optionsPanel.cancel();
                this.bOK.setEnabled(true);
                d.dispose();
                return;
            }
            if (e.getSource() == this.bClassic) {
                log.fine("Options Dialog - Classic pressed.");
                Dialog d = dialog;
                dialog = null;
                if (this.optionsPanel.isChanged()) {
                    NotifyDescriptor.Confirmation confirmationDescriptor = new NotifyDescriptor.Confirmation((Object)OptionsDisplayerImpl.loc("CTL_Some_values_changed"), 1, 3);
                    Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmationDescriptor);
                    if (result == NotifyDescriptor.YES_OPTION) {
                        this.optionsPanel.save();
                        d.dispose();
                    } else {
                        if (result != NotifyDescriptor.NO_OPTION) {
                            dialog = d;
                            return;
                        }
                        this.optionsPanel.cancel();
                        d.dispose();
                    }
                } else {
                    d.dispose();
                    this.optionsPanel.cancel();
                }
                try {
                    CallableSystemAction a = (CallableSystemAction)SystemAction.get(OptionsAction.class);
                    a.putValue("additionalActionName", (Object)OptionsDisplayerImpl.loc("CTL_Modern"));
                    a.putValue("optionsDialogTitle", (Object)OptionsDisplayerImpl.loc("CTL_Classic_Title"));
                    a.putValue("additionalActionListener", (Object)new OpenOptionsListener());
                    a.performAction();
                    return;
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
            }
            if (e.getSource() == this.btnExport) {
                OptionsChooserPanel.showExportDialog();
                return;
            }
            if (e.getSource() != this.btnImport) return;
            OptionsChooserPanel.showImportDialog();
        }
    }
}

