/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;

public class Formatter
implements ReformatTask {
    private static final Logger LOG = Logger.getLogger(Formatter.class.getName());
    private final Context ctx;

    public Formatter(Context ctx) {
        this.ctx = ctx;
    }

    public void reformat() throws BadLocationException {
        LSPBindings bindings;
        FileObject file = NbEditorUtilities.getFileObject((Document)this.ctx.document());
        if (file != null && (bindings = LSPBindings.getBindings(file)) != null) {
            Boolean documentFormatting = bindings.getInitResult().getCapabilities().getDocumentFormattingProvider();
            Boolean rangeFormatting = bindings.getInitResult().getCapabilities().getDocumentRangeFormattingProvider();
            if (rangeFormatting != null && rangeFormatting.booleanValue()) {
                this.rangeFormat(file, bindings);
            } else if (documentFormatting != null && documentFormatting.booleanValue()) {
                this.documentFormat(file, bindings);
            }
        }
    }

    private void rangeFormat(FileObject fo, LSPBindings bindings) throws BadLocationException {
        DocumentRangeFormattingParams drfp = new DocumentRangeFormattingParams();
        drfp.setTextDocument(new TextDocumentIdentifier(Utils.toURI(fo)));
        drfp.setOptions(new FormattingOptions(IndentUtils.indentLevelSize((Document)this.ctx.document()), IndentUtils.isExpandTabs((Document)this.ctx.document())));
        drfp.setRange(new Range(Utils.createPosition(this.ctx.document(), this.ctx.startOffset()), Utils.createPosition(this.ctx.document(), this.ctx.endOffset())));
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        try {
            edits = new ArrayList((Collection)bindings.getTextDocumentService().rangeFormatting(drfp).get());
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.INFO, String.format("LSP document rangeFormat failed for {0}", fo), ex);
        }
        this.applyTextEdits(edits);
    }

    private void documentFormat(FileObject fo, LSPBindings bindings) throws BadLocationException {
        DocumentFormattingParams dfp = new DocumentFormattingParams();
        dfp.setTextDocument(new TextDocumentIdentifier(Utils.toURI(fo)));
        dfp.setOptions(new FormattingOptions(IndentUtils.indentLevelSize((Document)this.ctx.document()), IndentUtils.isExpandTabs((Document)this.ctx.document())));
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        try {
            edits.addAll((Collection)bindings.getTextDocumentService().formatting(dfp).get());
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.INFO, String.format("LSP document format failed for {0}", fo), ex);
        }
        this.applyTextEdits(edits);
    }

    private void applyTextEdits(List<TextEdit> edits) {
        if (this.ctx.document() instanceof StyledDocument) {
            NbDocument.runAtomic((StyledDocument)((StyledDocument)this.ctx.document()), () -> Utils.applyEditsNoLock(this.ctx.document(), edits, this.ctx.startOffset(), this.ctx.endOffset()));
        } else {
            Utils.applyEditsNoLock(this.ctx.document(), edits, this.ctx.startOffset(), this.ctx.endOffset());
        }
    }

    public ExtraLock reformatLock() {
        return null;
    }

    public static class Factory
    implements ReformatTask.Factory {
        public ReformatTask createTask(Context context) {
            LSPBindings bindings;
            FileObject file = NbEditorUtilities.getFileObject((Document)context.document());
            if (file != null && (bindings = LSPBindings.getBindings(file)) != null) {
                return new Formatter(context);
            }
            return null;
        }
    }
}

