/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.xml.XMLUtil;

public class CompletionProviderImpl
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if ((queryType & 4) != 0) {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    try {
                        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                        if (file == null) {
                            return;
                        }
                        LSPBindings server = LSPBindings.getBindings(file);
                        if (server == null) {
                            return;
                        }
                        String uri = Utils.toURI(file);
                        SignatureHelpParams params = new SignatureHelpParams(new TextDocumentIdentifier(uri), Utils.createPosition(doc, caretOffset));
                        SignatureHelp help = (SignatureHelp)server.getTextDocumentService().signatureHelp(params).get();
                        if (help == null || help.getSignatures().isEmpty()) {
                            return;
                        }
                        StringBuilder signatures = new StringBuilder();
                        signatures.append("<html>");
                        for (SignatureInformation info : help.getSignatures()) {
                            if (info.getParameters().isEmpty()) {
                                signatures.append("No parameter.");
                                continue;
                            }
                            String sigSep = "";
                            int idx = 0;
                            for (ParameterInformation pi : info.getParameters()) {
                                if (idx == help.getActiveParameter()) {
                                    signatures.append("<b>");
                                }
                                signatures.append(sigSep);
                                signatures.append(pi.getLabel());
                                if (idx == help.getActiveParameter()) {
                                    signatures.append("</b>");
                                }
                                sigSep = ", ";
                                ++idx;
                            }
                        }
                        JToolTip tip = new JToolTip();
                        tip.setTipText(signatures.toString());
                        resultSet.setToolTip(tip);
                    }
                    catch (InterruptedException | BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        resultSet.finish();
                    }
                }
            }, component);
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void query(CompletionResultSet resultSet, final Document doc, final int caretOffset) {
                try {
                    boolean incomplete;
                    List items;
                    FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                    if (file == null) {
                        return;
                    }
                    final LSPBindings server = LSPBindings.getBindings(file);
                    if (server == null) {
                        return;
                    }
                    String uri = Utils.toURI(file);
                    CompletionParams params = new CompletionParams(new TextDocumentIdentifier(uri), Utils.createPosition(doc, caretOffset));
                    CountDownLatch l = new CountDownLatch(1);
                    Either completionResult = (Either)server.getTextDocumentService().completion(params).get();
                    if (completionResult == null) {
                        return;
                    }
                    if (completionResult.isLeft()) {
                        items = (List)completionResult.getLeft();
                        incomplete = true;
                    } else {
                        items = ((CompletionList)completionResult.getRight()).getItems();
                        incomplete = ((CompletionList)completionResult.getRight()).isIncomplete();
                    }
                    for (final CompletionItem i : items) {
                        final String insert = i.getInsertText() != null ? i.getInsertText() : i.getLabel();
                        final String leftLabel = CompletionProviderImpl.this.encode(i.getLabel());
                        final String rightLabel = i.getDetail() != null ? CompletionProviderImpl.this.encode(i.getDetail()) : null;
                        final String sortText = i.getSortText() != null ? i.getSortText() : i.getLabel();
                        CompletionItemKind kind = i.getKind();
                        Icon ic = Icons.getCompletionIcon(kind);
                        final ImageIcon icon = new ImageIcon(ImageUtilities.icon2Image((Icon)ic));
                        resultSet.addItem(new org.netbeans.spi.editor.completion.CompletionItem(){

                            public void defaultAction(JTextComponent jtc) {
                                this.commit("");
                            }

                            private void commit(String appendText) {
                                TextEdit te = i.getTextEdit();
                                NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), () -> {
                                    try {
                                        int endPos;
                                        if (te != null) {
                                            int start = Utils.getOffset(doc, te.getRange().getStart());
                                            int end = Utils.getOffset(doc, te.getRange().getEnd());
                                            doc.remove(start, end - start);
                                            doc.insertString(start, te.getNewText(), null);
                                            endPos = start + te.getNewText().length();
                                        } else {
                                            int[] identSpan;
                                            String toAdd = i.getInsertText();
                                            if (toAdd == null) {
                                                toAdd = i.getLabel();
                                            }
                                            String printSuffix = toAdd.substring((identSpan = Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)doc), (int)caretOffset)) != null ? caretOffset - identSpan[0] : 0);
                                            doc.insertString(caretOffset, printSuffix, null);
                                            endPos = caretOffset + printSuffix.length();
                                        }
                                        doc.insertString(endPos, appendText, null);
                                    }
                                    catch (BadLocationException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                });
                                Completion.get().hideDocumentation();
                                Completion.get().hideCompletion();
                            }

                            public void processKeyEvent(KeyEvent ke) {
                                if (ke.getID() == 400) {
                                    String commitText = String.valueOf(ke.getKeyChar());
                                    List commitCharacters = i.getCommitCharacters();
                                    if (commitCharacters != null && commitCharacters.contains(commitText)) {
                                        this.commit(commitText);
                                        ke.consume();
                                        if (CompletionProviderImpl.this.isTriggerCharacter(server, commitText)) {
                                            Completion.get().showCompletion();
                                        }
                                    }
                                }
                            }

                            public int getPreferredWidth(Graphics grphcs, Font font) {
                                return CompletionUtilities.getPreferredWidth((String)leftLabel, (String)rightLabel, (Graphics)grphcs, (Font)font);
                            }

                            public void render(Graphics grphcs, Font font, Color color, Color color1, int i2, int i1, boolean bln) {
                                CompletionUtilities.renderHtml((ImageIcon)icon, (String)leftLabel, (String)rightLabel, (Graphics)grphcs, (Font)font, (Color)color, (int)i2, (int)i1, (boolean)bln);
                            }

                            public CompletionTask createDocumentationTask() {
                                return new AsyncCompletionTask(new AsyncCompletionQuery(){

                                    protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                                        CompletionItem resolved;
                                        if ((i.getDetail() == null || i.getDocumentation() == null) && CompletionProviderImpl.this.hasCompletionResolve(server)) {
                                            CompletionItem temp;
                                            try {
                                                temp = (CompletionItem)server.getTextDocumentService().resolveCompletionItem(i).get();
                                            }
                                            catch (InterruptedException | ExecutionException ex) {
                                                Exceptions.printStackTrace((Throwable)ex);
                                                temp = i;
                                            }
                                            resolved = temp;
                                        } else {
                                            resolved = i;
                                        }
                                        if (resolved.getDocumentation() != null || resolved.getDetail() != null) {
                                            resultSet.setDocumentation(new CompletionDocumentation(){

                                                public String getText() {
                                                    StringBuilder documentation = new StringBuilder();
                                                    documentation.append("<html>\n");
                                                    if (resolved.getDetail() != null) {
                                                        documentation.append("<b>").append(CompletionProviderImpl.escape(resolved.getDetail())).append("</b>");
                                                        documentation.append("\n<p>");
                                                    }
                                                    if (resolved.getDocumentation() != null) {
                                                        MarkupContent content;
                                                        if (resolved.getDocumentation().isLeft()) {
                                                            content = new MarkupContent();
                                                            content.setKind("plaintext");
                                                            content.setValue((String)resolved.getDocumentation().getLeft());
                                                        } else {
                                                            content = (MarkupContent)resolved.getDocumentation().getRight();
                                                        }
                                                        switch (content.getKind()) {
                                                            default: {
                                                                documentation.append("<pre>\n").append(content.getValue()).append("\n</pre>");
                                                                break;
                                                            }
                                                            case "markdown": {
                                                                documentation.append(HtmlRenderer.builder().build().render((Node)Parser.builder().build().parse(content.getValue())));
                                                            }
                                                        }
                                                    }
                                                    return documentation.toString();
                                                }

                                                public URL getURL() {
                                                    return null;
                                                }

                                                public CompletionDocumentation resolveLink(String link) {
                                                    return null;
                                                }

                                                public Action getGotoSourceAction() {
                                                    return null;
                                                }
                                            });
                                        }
                                        resultSet.finish();
                                    }
                                });
                            }

                            public CompletionTask createToolTipTask() {
                                return null;
                            }

                            public boolean instantSubstitution(JTextComponent jtc) {
                                return false;
                            }

                            public int getSortPriority() {
                                return 100;
                            }

                            public CharSequence getSortText() {
                                return sortText;
                            }

                            public CharSequence getInsertPrefix() {
                                return insert;
                            }
                        });
                    }
                }
                catch (InterruptedException | BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    resultSet.finish();
                }
            }
        }, component);
    }

    private boolean hasCompletionResolve(LSPBindings server) {
        ServerCapabilities capabilities = server.getInitResult().getCapabilities();
        if (capabilities == null) {
            return false;
        }
        CompletionOptions completionProvider = capabilities.getCompletionProvider();
        if (completionProvider == null) {
            return false;
        }
        Boolean resolveProvider = completionProvider.getResolveProvider();
        return resolveProvider != null && resolveProvider != false;
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private String encode(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;");
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        FileObject file = NbEditorUtilities.getFileObject((Document)component.getDocument());
        if (file == null) {
            return 0;
        }
        LSPBindings server = LSPBindings.getBindings(file);
        if (server == null) {
            return 0;
        }
        return this.isTriggerCharacter(server, typedText) ? 1 : 0;
    }

    private boolean isTriggerCharacter(LSPBindings server, String text) {
        InitializeResult init = server.getInitResult();
        if (init == null) {
            return false;
        }
        ServerCapabilities capabilities = init.getCapabilities();
        if (capabilities == null) {
            return false;
        }
        CompletionOptions completionOptions = capabilities.getCompletionProvider();
        if (completionOptions == null) {
            return false;
        }
        List triggerCharacters = completionOptions.getTriggerCharacters();
        if (triggerCharacters == null) {
            return false;
        }
        return triggerCharacters.stream().anyMatch(trigger -> text.endsWith((String)trigger));
    }
}

