/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import org.netbeans.api.javahelp.Help;
import org.netbeans.modules.javahelp.Installer;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class HelpAction
extends AbstractAction {
    public HelpAction() {
        Installer.log.fine("HelpAction.initialize");
        this.putValue("OpenIDE-Transmodal-Action", true);
    }

    private static HelpCtx findHelpCtx() {
        TopComponent activeTC = TopComponent.getRegistry().getActivated();
        Window win = WindowActivatedDetector.getCurrentActivatedWindow();
        Window cont = activeTC != null && win != null && win.isAncestorOf((Component)activeTC) ? activeTC : win;
        if (cont == null) {
            return HelpCtx.DEFAULT_HELP;
        }
        Component focused = SwingUtilities.findFocusOwner(cont);
        HelpCtx help = HelpCtx.findHelp((Component)(focused == null ? cont : focused));
        Installer.log.log(Level.FINE, "HelpCtx {0} from {1}", new Object[]{help, focused});
        return help;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        HelpCtx help;
        Help h = (Help)Lookup.getDefault().lookup(Help.class);
        if (h == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final MenuElement[] path = MenuSelectionManager.defaultManager().getSelectedPath();
        if (path != null && path.length > 0 && !(path[0].getComponent() instanceof ComboPopup)) {
            help = HelpCtx.findHelp((Component)path[path.length - 1].getComponent());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuElement[] newPath = MenuSelectionManager.defaultManager().getSelectedPath();
                    if (newPath.length != path.length) {
                        return;
                    }
                    for (int i = 0; i < newPath.length; ++i) {
                        if (newPath[i] == path[i]) continue;
                        return;
                    }
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                }
            });
        } else {
            help = HelpAction.findHelpCtx();
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(HelpAction.class, (String)"CTL_OpeningHelp"));
        h.showHelp(help);
    }

    static class WindowActivatedDetector
    implements AWTEventListener {
        private static WeakReference<Window> currentWindowRef;
        private static WindowActivatedDetector detector;

        WindowActivatedDetector() {
        }

        static synchronized void install() {
            if (detector == null && !GraphicsEnvironment.isHeadless()) {
                detector = new WindowActivatedDetector();
                Toolkit.getDefaultToolkit().addAWTEventListener(detector, 64L);
            }
        }

        static synchronized void uninstall() {
            if (detector != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(detector);
                detector = null;
            }
        }

        static synchronized Window getCurrentActivatedWindow() {
            if (currentWindowRef != null) {
                return (Window)currentWindowRef.get();
            }
            return null;
        }

        private static synchronized void setCurrentActivatedWindow(Window w) {
            currentWindowRef = new WeakReference<Window>(w);
        }

        @Override
        public void eventDispatched(AWTEvent ev) {
            if (ev.getID() != 205) {
                return;
            }
            WindowActivatedDetector.setCurrentActivatedWindow(((WindowEvent)ev).getWindow());
        }

        static {
            detector = null;
        }
    }
}

