/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.java.source.ui.HTMLJavadocParser;
import org.netbeans.api.java.source.ui.snippet.HtmlStartEndTag;
import org.netbeans.api.java.source.ui.snippet.MarkupTagProcessor;
import org.netbeans.api.java.source.ui.snippet.SnippetTagCommentParser;
import org.netbeans.api.java.source.ui.snippet.SourceLineMeta;
import org.netbeans.modules.java.preprocessorbridge.api.JavaSourceUtil;
import org.netbeans.modules.java.source.JavadocHelper;
import org.netbeans.modules.java.source.TreeShims;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

public class ElementJavadoc {
    private static final String ASSOCIATE_JDOC = "associate-javadoc:";
    private static final String API = "/api";
    private static final Set<String> LANGS;
    private static final RequestProcessor RP;
    private final ClasspathInfo cpInfo;
    private final FileObject fileObject;
    private final ElementHandle<? extends Element> handle;
    private volatile CompletableFuture<String> content;
    private final Callable<Boolean> cancel;
    private Map<String, ElementHandle<? extends Element>> links = new HashMap<String, ElementHandle<? extends Element>>();
    private List<? extends ImportTree> imports;
    private String packageName;
    private String className;
    private int linkCounter = 0;
    private volatile URL docURL = null;
    private volatile URL docRoot = null;
    private volatile AbstractAction goToSource = null;
    private static final String APINOTE_TAG = "apiNote";
    private static final String IMPLSPEC_TAG = "implSpec";
    private static final String IMPLNOTE_TAG = "implNote";
    private static final Map<String, HtmlStartEndTag> HTML_TAGS;
    private static final Map<String, String> MARKUPTAG_MANDATORY_ATTRIBUTE;

    public static final ElementJavadoc create(CompilationInfo compilationInfo, Element element) {
        return ElementJavadoc.create(compilationInfo, element, null);
    }

    public static final ElementJavadoc create(CompilationInfo compilationInfo, Element element, Callable<Boolean> cancel) {
        return new ElementJavadoc(compilationInfo, element, null, cancel);
    }

    public String getText() {
        try {
            CompletableFuture<String> tmp = this.content;
            return tmp != null ? (String)tmp.get() : null;
        }
        catch (InterruptedException | ExecutionException ex) {
            return null;
        }
    }

    public Future<String> getTextAsync() {
        return this.content;
    }

    public URL getURL() {
        return this.docURL;
    }

    public ElementJavadoc resolveLink(String link) {
        if (link.startsWith(ASSOCIATE_JDOC)) {
            String root = link.substring(ASSOCIATE_JDOC.length());
            try {
                final CountDownLatch latch = new CountDownLatch(1);
                final AtomicBoolean success = new AtomicBoolean();
                SourceJavadocAttacher.attachJavadoc((URL)new URL(root), (SourceJavadocAttacher.AttachmentListener)new SourceJavadocAttacher.AttachmentListener(){

                    public void attachmentSucceeded() {
                        success.set(true);
                        latch.countDown();
                    }

                    public void attachmentFailed() {
                        latch.countDown();
                    }
                });
                if (!SwingUtilities.isEventDispatchThread()) {
                    latch.await();
                    return success.get() ? this.resolveElement(this.handle, link) : new ElementJavadoc(NbBundle.getMessage(ElementJavadoc.class, (String)"javadoc_attaching_failed"), this.cancel);
                }
            }
            catch (InterruptedException | MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
        ElementHandle<? extends Element> linkDoc = this.links.get(link);
        return this.resolveElement(linkDoc, link);
    }

    public String toString() {
        return String.format("ElementJavadoc[url=%s, handle=%s]", this.getURL(), this.handle);
    }

    private ElementJavadoc resolveElement(ElementHandle<?> handle, String link) {
        ElementJavadoc[] ret = new ElementJavadoc[1];
        try {
            JavaSource js;
            FileObject fo;
            FileObject fileObject = fo = handle != null ? SourceUtils.getFile(handle, (ClasspathInfo)this.cpInfo) : null;
            if (fo != null && fo.isFolder() && handle.getKind() == ElementKind.PACKAGE) {
                fo = fo.getFileObject("package-info", "java");
            }
            if (this.cpInfo == null && fo == null) {
                try {
                    URL u = this.getURL() != null ? new URL(this.getURL(), link) : new URL(link);
                    ret[0] = new ElementJavadoc(u, this.cancel);
                }
                catch (MalformedURLException u) {
                    // empty catch block
                }
                return ret[0];
            }
            JavaSource javaSource = fo != null ? JavaSource.forFileObject((FileObject)fo) : (js = this.fileObject != null ? JavaSource.forFileObject((FileObject)this.fileObject) : JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]));
            if (js != null) {
                js.runUserActionTask(controller -> {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    if (handle != null) {
                        ret[0] = new ElementJavadoc((CompilationInfo)controller, handle.resolve((CompilationInfo)controller), null, this.cancel);
                    } else {
                        int idx = link.indexOf(35);
                        URI uri = null;
                        try {
                            Element e;
                            uri = URI.create(idx < 0 ? link : link.substring(0, idx));
                            if (!uri.isAbsolute() && this.handle != null && (e = this.handle.resolve((CompilationInfo)controller)) != null) {
                                PackageElement pe = controller.getElements().getPackageOf(e);
                                uri = URI.create(FileObjects.resolveRelativePath((String)pe.getQualifiedName().toString(), (String)uri.getPath()));
                            }
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                        if (uri != null) {
                            String path;
                            int startIdx;
                            if (!uri.isAbsolute()) {
                                uri = uri.normalize();
                            }
                            startIdx = (startIdx = (path = uri.toString()).lastIndexOf("..")) < 0 ? 0 : startIdx + 3;
                            int endIdx = path.lastIndexOf(46);
                            if (endIdx >= 0) {
                                path = path.substring(startIdx, endIdx);
                            }
                            String clsName = path.replace('/', '.');
                            Element e = controller.getElements().getTypeElement(clsName);
                            if (e != null) {
                                URL u;
                                if (idx >= 0) {
                                    String fragment = link.substring(idx + 1);
                                    String name = (idx = fragment.indexOf(40)) < 0 ? fragment : fragment.substring(0, idx);
                                    for (Element element : e.getEnclosedElements()) {
                                        if (!element.getSimpleName().contentEquals(name) || !fragment.contentEquals(this.getFragment(element))) continue;
                                        e = element;
                                        break;
                                    }
                                }
                                if (uri.isAbsolute()) {
                                    u = new URL(link);
                                } else if (this.getURL() != null) {
                                    u = new URL(this.getURL(), link);
                                } else {
                                    return;
                                }
                                ret[0] = new ElementJavadoc((CompilationInfo)controller, e, u, this.cancel);
                            } else if (uri.isAbsolute()) {
                                ret[0] = new ElementJavadoc(uri.toURL(), this.cancel);
                            } else if (this.getURL() != null) {
                                try {
                                    ret[0] = new ElementJavadoc(new URL(this.getURL(), link), this.cancel);
                                }
                                catch (MalformedURLException malformedURLException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }, true);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        if (ret[0] != null) {
            try {
                while (this.cancel != null && !this.cancel.call().booleanValue()) {
                    try {
                        ret[0].getTextAsync().get(250L, TimeUnit.MILLISECONDS);
                        break;
                    }
                    catch (TimeoutException timeoutException) {
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret[0];
    }

    public Action getGotoSourceAction() {
        return this.goToSource;
    }

    private ElementJavadoc(CompilationInfo compilationInfo, Element element, URL url, Callable<Boolean> cancel) {
        this.cpInfo = compilationInfo.getClasspathInfo();
        this.fileObject = compilationInfo.getFileObject();
        this.handle = element == null ? null : ElementHandle.create((Element)element);
        this.cancel = cancel;
        this.packageName = compilationInfo.getCompilationUnit().getPackageName() != null ? compilationInfo.getCompilationUnit().getPackageName().toString() : "";
        this.imports = compilationInfo.getCompilationUnit().getImports();
        this.className = compilationInfo.getCompilationUnit().getSourceFile().getName().replaceFirst("[.][^.]+$", "");
        StringBuilder header = this.getElementHeader(element, compilationInfo);
        try {
            StringBuilder doc = this.getElementDoc(element, compilationInfo, header, url, true);
            if (doc == null) {
                this.computeDocURL(Collections.emptyList(), true, cancel);
                doc = header.append(this.noJavadocFound());
            }
            this.content = CompletableFuture.completedFuture(doc.toString());
        }
        catch (JavadocHelper.RemoteJavadocException re) {
            if (this.fileObject == null || JavaSource.forFileObject((FileObject)this.fileObject) == null) {
                header.append(this.noJavadocFound());
                this.content = CompletableFuture.completedFuture(header.toString());
                return;
            }
            this.content = CompletableFuture.supplyAsync(() -> {
                try {
                    JavaSourceUtil.Handle ch = JavaSourceUtil.createControllerHandle((FileObject)this.fileObject, null);
                    CompilationController c = (CompilationController)ch.getCompilationController();
                    c.toPhase(JavaSource.Phase.RESOLVED);
                    Element el = this.handle.resolve((CompilationInfo)c);
                    StringBuilder doc = this.getElementDoc(el, (CompilationInfo)c, header, url, false);
                    if (doc == null) {
                        this.computeDocURL(Collections.emptyList(), false, cancel);
                        doc = header.append(this.noJavadocFound());
                    }
                    return doc.toString();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }, (Executor)RP);
        }
    }

    private ElementJavadoc(URL url, Callable<Boolean> cancel) {
        assert (url != null);
        this.content = null;
        this.docURL = url;
        this.handle = null;
        this.cpInfo = null;
        this.fileObject = null;
        this.cancel = cancel;
    }

    private ElementJavadoc(String message, Callable<Boolean> cancel) {
        assert (message != null);
        this.content = CompletableFuture.completedFuture(message);
        this.docURL = null;
        this.handle = null;
        this.cpInfo = null;
        this.fileObject = null;
        this.cancel = cancel;
    }

    private StringBuilder getElementHeader(Element element, CompilationInfo info) {
        StringBuilder sb = new StringBuilder();
        if (element != null) {
            sb.append((CharSequence)this.getContainingClassOrPackageHeader(element, info.getElements(), info.getElementUtilities()));
            switch (element.getKind()) {
                case METHOD: 
                case CONSTRUCTOR: {
                    sb.append((CharSequence)this.getMethodHeader((ExecutableElement)element));
                    break;
                }
                case FIELD: 
                case ENUM_CONSTANT: {
                    sb.append((CharSequence)this.getFieldHeader((VariableElement)element));
                    break;
                }
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    sb.append((CharSequence)this.getClassHeader((TypeElement)element));
                    break;
                }
                case PACKAGE: {
                    sb.append((CharSequence)this.getPackageHeader((PackageElement)element));
                    break;
                }
                case MODULE: {
                    sb.append((CharSequence)this.getModuleHeader((ModuleElement)element));
                }
            }
        }
        return sb;
    }

    private StringBuilder getContainingClassOrPackageHeader(Element el, Elements elements, ElementUtilities eu) {
        StringBuilder sb = new StringBuilder();
        if (el.getKind() != ElementKind.PACKAGE && el.getKind() != ElementKind.MODULE) {
            TypeElement cls = eu.enclosingTypeElement(el);
            if (cls != null) {
                switch (cls.getEnclosingElement().getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: 
                    case PACKAGE: {
                        sb.append("<font size='+0'><b>");
                        this.createLink(sb, cls, this.makeNameLineBreakable(cls.getQualifiedName().toString()));
                        sb.append("</b></font>");
                    }
                }
            } else {
                PackageElement pkg = elements.getPackageOf(el);
                if (pkg != null) {
                    sb.append("<font size='+0'><b>");
                    this.createLink(sb, pkg, this.makeNameLineBreakable(pkg.getQualifiedName().toString()));
                    sb.append("</b></font>");
                }
            }
        }
        return sb;
    }

    private String makeNameLineBreakable(String name) {
        return name.replace(".", ".&#x200B;");
    }

    private StringBuilder getMethodHeader(ExecutableElement mdoc) {
        List<? extends TypeMirror> exs;
        Name name;
        Iterator<Element> it;
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        mdoc.getAnnotationMirrors().forEach(annotationDesc -> this.appendAnnotation(sb, (AnnotationMirror)annotationDesc, true));
        int len = sb.length();
        mdoc.getModifiers().stream().filter(modifier -> modifier != Modifier.NATIVE).forEachOrdered(modifier -> sb.append(modifier).append(' '));
        len = sb.length() - len;
        List<? extends TypeParameterElement> typeParameters = mdoc.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            sb.append("&lt;");
            it = typeParameters.iterator();
            while (it.hasNext()) {
                TypeParameterElement typeParam = it.next();
                len += this.appendType(sb, typeParam.asType(), false, true, false);
                if (!it.hasNext()) continue;
                sb.append(',');
                ++len;
            }
            sb.append("&gt; ");
            len += 3;
        }
        if (mdoc.getKind() == ElementKind.CONSTRUCTOR) {
            name = mdoc.getEnclosingElement().getSimpleName();
            len += name.length();
            sb.append("<b>").append(name).append("</b>");
        } else {
            len += this.appendType(sb, mdoc.getReturnType(), false, false, false);
            name = mdoc.getSimpleName();
            len += name.length();
            sb.append(" <b>").append(name).append("</b>");
        }
        if (mdoc.getEnclosingElement().getKind() != ElementKind.ANNOTATION_TYPE) {
            sb.append('(');
            ++len;
            it = mdoc.getParameters().iterator();
            while (it.hasNext()) {
                VariableElement param = (VariableElement)it.next();
                param.getAnnotationMirrors().forEach(annotationDesc -> this.appendAnnotation(sb, (AnnotationMirror)annotationDesc, true));
                boolean varArg = mdoc.isVarArgs() && !it.hasNext();
                this.appendType(sb, param.asType(), varArg, false, false);
                sb.append(' ').append(param.getSimpleName());
                if (!it.hasNext()) continue;
                sb.append(",<br>");
                this.appendSpace(sb, len);
            }
            sb.append(')');
        }
        if (!(exs = mdoc.getThrownTypes()).isEmpty()) {
            sb.append("<br>");
            len = Math.max(0, len - 7);
            this.appendSpace(sb, len);
            sb.append("throws ");
            Iterator<? extends TypeMirror> it2 = exs.iterator();
            while (it2.hasNext()) {
                TypeMirror ex = it2.next();
                this.appendType(sb, ex, false, false, false);
                if (!it2.hasNext()) continue;
                sb.append(",<br>");
                this.appendSpace(sb, len);
            }
        }
        sb.append("</pre>");
        return sb;
    }

    private StringBuilder getFieldHeader(VariableElement fdoc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        fdoc.getAnnotationMirrors().forEach(annotationDesc -> this.appendAnnotation(sb, (AnnotationMirror)annotationDesc, true));
        fdoc.getModifiers().forEach(modifier -> sb.append(modifier).append(' '));
        this.appendType(sb, fdoc.asType(), false, false, false);
        sb.append(" <b>").append(fdoc.getSimpleName()).append("</b>");
        String val = null;
        try {
            val = XMLUtil.toAttributeValue((String)fdoc.getConstantValue().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (val != null && val.length() > 0) {
            sb.append(" = ").append(val);
        }
        sb.append("</pre>");
        return sb;
    }

    private StringBuilder getClassHeader(TypeElement cdoc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        cdoc.getAnnotationMirrors().forEach(annotationDesc -> this.appendAnnotation(sb, (AnnotationMirror)annotationDesc, true));
        block9: for (Modifier modifier : cdoc.getModifiers()) {
            switch (cdoc.getKind()) {
                case ENUM: {
                    if (modifier != Modifier.FINAL) break;
                    continue block9;
                }
                case INTERFACE: 
                case ANNOTATION_TYPE: {
                    if (modifier != Modifier.ABSTRACT) break;
                    continue block9;
                }
            }
            sb.append((Object)modifier).append(' ');
        }
        switch (cdoc.getKind()) {
            case ANNOTATION_TYPE: {
                sb.append("@interface ");
                break;
            }
            case ENUM: {
                sb.append("enum ");
                break;
            }
            case INTERFACE: {
                sb.append("interface ");
                break;
            }
            default: {
                sb.append("class ");
            }
        }
        sb.append("<b>").append(cdoc.getSimpleName());
        List<? extends TypeParameterElement> typeParams = cdoc.getTypeParameters();
        if (!typeParams.isEmpty()) {
            sb.append("&lt;");
            Iterator<? extends TypeParameterElement> it = typeParams.iterator();
            while (it.hasNext()) {
                TypeParameterElement typeParam = it.next();
                this.appendType(sb, typeParam.asType(), false, true, false);
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append("&gt;");
        }
        sb.append("</b>");
        if (cdoc.getKind() != ElementKind.ANNOTATION_TYPE) {
            List<? extends TypeMirror> ifaces;
            TypeMirror supercls = cdoc.getSuperclass();
            if (supercls != null && supercls.getKind() != TypeKind.NONE) {
                sb.append("<br>extends ");
                this.appendType(sb, supercls, false, false, false);
            }
            if (!(ifaces = cdoc.getInterfaces()).isEmpty()) {
                sb.append(cdoc.getKind().isInterface() ? "<br>extends " : "<br>implements ");
                Iterator<? extends TypeMirror> it = ifaces.iterator();
                while (it.hasNext()) {
                    TypeMirror iface = it.next();
                    this.appendType(sb, iface, false, false, false);
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            }
        }
        sb.append("</pre>");
        return sb;
    }

    private StringBuilder getPackageHeader(PackageElement pdoc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        pdoc.getAnnotationMirrors().forEach(annotationDesc -> this.appendAnnotation(sb, (AnnotationMirror)annotationDesc, true));
        sb.append("package <b>").append(pdoc.getQualifiedName()).append("</b>");
        sb.append("</pre>");
        return sb;
    }

    private StringBuilder getModuleHeader(ModuleElement mdoc) {
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        mdoc.getAnnotationMirrors().forEach(annotationDesc -> this.appendAnnotation(sb, (AnnotationMirror)annotationDesc, true));
        sb.append("module <b>").append(mdoc.getQualifiedName()).append("</b>");
        sb.append("</pre>");
        return sb;
    }

    private void appendAnnotation(StringBuilder sb, AnnotationMirror annotationDesc, boolean topLevel) {
        DeclaredType annotationType = annotationDesc.getAnnotationType();
        if (annotationType != null && (!topLevel || this.isDocumented(annotationType))) {
            this.appendType(sb, annotationType, false, false, true);
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = annotationDesc.getElementValues();
            if (!values.isEmpty()) {
                sb.append('(');
                Iterator<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> it = values.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> value = it.next();
                    this.createLink(sb, value.getKey(), value.getKey().getSimpleName());
                    sb.append('=');
                    this.appendAnnotationValue(sb, value.getValue());
                    if (!it.hasNext()) continue;
                    sb.append(",");
                }
                sb.append(')');
            }
            if (topLevel) {
                sb.append("<br>");
            }
        }
    }

    private boolean isDocumented(DeclaredType annotationType) {
        return annotationType.asElement().getAnnotationMirrors().stream().anyMatch(annotationDesc -> "java.lang.annotation.Documented".contentEquals(((TypeElement)annotationDesc.getAnnotationType().asElement()).getQualifiedName()));
    }

    private void appendAnnotationValue(StringBuilder sb, AnnotationValue av) {
        Object value = av.getValue();
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() > 1) {
                sb.append('{');
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                AnnotationValue val = (AnnotationValue)it.next();
                this.appendAnnotationValue(sb, val);
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            if (list.size() > 1) {
                sb.append('}');
            }
        } else if (value instanceof String) {
            sb.append('\"').append(value).append('\"');
        } else if (value instanceof TypeMirror) {
            this.appendType(sb, (TypeMirror)value, false, false, false);
        } else if (value instanceof VariableElement) {
            this.createLink(sb, (VariableElement)value, ((VariableElement)value).getSimpleName());
        } else if (value instanceof AnnotationMirror) {
            this.appendAnnotation(sb, (AnnotationMirror)value, false);
        } else {
            sb.append(value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder getElementDoc(Element element, CompilationInfo info, StringBuilder header, URL url, boolean sync) throws JavadocHelper.RemoteJavadocException {
        StringBuilder sb = new StringBuilder();
        if (element != null) {
            List pages = JavadocHelper.getJavadoc((Element)element, (JavadocHelper.RemoteJavadocPolicy)(sync ? JavadocHelper.RemoteJavadocPolicy.SPECULATIVE : JavadocHelper.RemoteJavadocPolicy.USE), this.cancel);
            try {
                Map<Object, StringBuilder> doc;
                boolean localized = false;
                boolean remote = false;
                for (JavadocHelper.TextStream ts : pages) {
                    if (this.docURL == null && !ts.getLocations().isEmpty()) {
                        this.docURL = (URL)ts.getLocations().get(0);
                    }
                    if (this.docRoot == null) {
                        this.docRoot = ts.getDocRoot();
                    }
                    localized |= ElementJavadoc.isLocalized(ts.getLocations(), element);
                    remote |= ElementJavadoc.isRemote(ts, this.docURL);
                }
                if (!localized) {
                    this.assignSource(element, info, url, header);
                }
                sb.append((CharSequence)header);
                if (!localized && !(doc = this.getElementDocFromSource(element, info)).isEmpty()) {
                    StringBuilder params = new StringBuilder();
                    StringBuilder thrs = new StringBuilder();
                    doc.entrySet().forEach(entry -> {
                        if (entry.getKey() instanceof Element) {
                            thrs.append("<code>");
                            if (((Element)entry.getKey()).getKind() == ElementKind.TYPE_PARAMETER) {
                                thrs.append(((Element)entry.getKey()).getSimpleName());
                            } else {
                                this.createLink(thrs, (Element)entry.getKey(), ((Element)entry.getKey()).getSimpleName());
                            }
                            thrs.append("</code> - ");
                            thrs.append((CharSequence)entry.getValue());
                            thrs.append("<br>");
                        } else if (entry.getKey() instanceof Integer) {
                            params.append("<code>").append(this.getName(element, (Integer)entry.getKey())).append("</code> - ");
                            params.append((CharSequence)entry.getValue());
                            params.append("<br>");
                        }
                    });
                    sb.append("<p>");
                    if (doc.containsKey((Object)DocTree.Kind.DEPRECATED)) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-deprecated")).append("</b> <i>").append((CharSequence)doc.get((Object)DocTree.Kind.DEPRECATED)).append("</i><p>");
                    }
                    if (doc.containsKey(null)) {
                        sb.append((CharSequence)doc.get(null));
                    }
                    sb.append("<p>");
                    if (doc.containsKey(APINOTE_TAG)) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-apinote")).append("</b><blockquote>").append((CharSequence)doc.get(APINOTE_TAG)).append("</blockquote>");
                    }
                    if (doc.containsKey(IMPLSPEC_TAG)) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-implspec")).append("</b><blockquote>").append((CharSequence)doc.get(IMPLSPEC_TAG)).append("</blockquote>");
                    }
                    if (doc.containsKey(IMPLNOTE_TAG)) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-implnote")).append("</b><blockquote>").append((CharSequence)doc.get(IMPLNOTE_TAG)).append("</blockquote>");
                    }
                    if (params.length() > 0) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-params")).append("</b><blockquote>").append((CharSequence)params).append("</blockquote>");
                    }
                    if (doc.containsKey((Object)DocTree.Kind.PARAM)) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-typeparams")).append("</b><blockquote>").append((CharSequence)doc.get((Object)DocTree.Kind.PARAM)).append("</blockquote>");
                    }
                    if (doc.containsKey((Object)DocTree.Kind.RETURN)) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-returns")).append("</b><blockquote>").append((CharSequence)doc.get((Object)DocTree.Kind.RETURN)).append("</blockquote>");
                    }
                    if (thrs.length() > 0) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-throws")).append("</b><blockquote>").append((CharSequence)thrs).append("</blockquote>");
                    }
                    if (doc.containsKey((Object)DocTree.Kind.SINCE)) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-since")).append("</b><blockquote>").append((CharSequence)doc.get((Object)DocTree.Kind.SINCE)).append("</blockquote>");
                    }
                    if (doc.containsKey((Object)DocTree.Kind.SEE)) {
                        sb.append("<b>").append(NbBundle.getMessage(ElementJavadoc.class, (String)"JCD-see")).append("</b><blockquote>").append((CharSequence)doc.get((Object)DocTree.Kind.SEE)).append("</blockquote>");
                    }
                    this.computeDocURL(pages, sync, this.cancel);
                    StringBuilder stringBuilder = sb;
                    return stringBuilder;
                }
                if (sync && remote) {
                    throw new JavadocHelper.RemoteJavadocException(null);
                }
                for (JavadocHelper.TextStream page2 : pages) {
                    String jdText;
                    String string = page2 != null ? HTMLJavadocParser.getJavadocText(page2, false) : (jdText = this.getURL() != null ? HTMLJavadocParser.getJavadocText(this.getURL(), false) : null);
                    if (jdText == null) continue;
                    sb.append("<p>");
                    sb.append(jdText);
                    this.docURL = page2.getLocation();
                    StringBuilder stringBuilder = sb;
                    return stringBuilder;
                }
            }
            finally {
                pages.forEach(page -> page.close());
            }
            if (element.getKind() == ElementKind.METHOD) {
                return this.getInherited((ExecutableElement)element, (TypeElement)element.getEnclosingElement(), info, method -> {
                    try {
                        return this.getElementDoc((Element)method, info, header, url, sync);
                    }
                    catch (JavadocHelper.RemoteJavadocException rje) {
                        ElementJavadoc.sthrow(rje);
                        return null;
                    }
                });
            }
        }
        return null;
    }

    private Map<Object, StringBuilder> getElementDocFromSource(Element element, CompilationInfo info) {
        LinkedHashMap<Object, StringBuilder> ret = new LinkedHashMap<Object, StringBuilder>();
        ElementHandle eh = ElementHandle.create((Element)element);
        FileObject fo = SourceUtils.getFile((ElementHandle)eh, (ClasspathInfo)this.cpInfo);
        if (fo != null && fo.isFolder() && element.getKind() == ElementKind.PACKAGE) {
            fo = fo.getFileObject("package-info.java");
        }
        if (fo != null && fo != info.getFileObject()) {
            try {
                JavaSource js = JavaSource.forFileObject((FileObject)fo);
                if (js != null) {
                    HashMap out = new HashMap();
                    js.runUserActionTask(controller -> {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Element e = eh.resolve((CompilationInfo)controller);
                        if (e != null) {
                            this.getElementDocFromSource(e, (CompilationInfo)controller).entrySet().forEach(entry -> {
                                Object key = entry.getKey();
                                if (key instanceof Element) {
                                    key = ElementHandle.create((Element)((Element)key));
                                }
                                out.put(key, (StringBuilder)entry.getValue());
                            });
                        }
                    }, true);
                    out.entrySet().forEach(entry -> {
                        Object key = entry.getKey();
                        if (key instanceof ElementHandle) {
                            Element e = ((ElementHandle)key).resolve(info);
                            if (e != null) {
                                ret.put(e, (StringBuilder)entry.getValue());
                            }
                        } else {
                            ret.put(key, (StringBuilder)entry.getValue());
                        }
                    });
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return ret;
        }
        DocCommentTree doc = info.getDocTrees().getDocCommentTree(element);
        if (doc != null) {
            TreePath path = info.getDocTrees().getPath(element);
            List<? extends DocTree> body = doc.getFullBody();
            List<? extends DocTree> tags = doc.getBlockTags();
            final AtomicBoolean inheritedDocNeeded = new AtomicBoolean(false);
            Map inheritedDoc = null;
            Function<ExecutableElement, Map> funct = method -> this.getElementDocFromSource((Element)method, info);
            if (element.getKind() == ElementKind.METHOD) {
                if (body.isEmpty()) {
                    inheritedDocNeeded.set(true);
                } else {
                    new DocTreeScanner<Void, Void>(){

                        @Override
                        public Void visitInheritDoc(InheritDocTree node, Void p) {
                            inheritedDocNeeded.set(true);
                            return null;
                        }
                    }.scan(doc, null);
                }
                if (inheritedDocNeeded.get()) {
                    inheritedDoc = this.getInherited((ExecutableElement)element, (TypeElement)element.getEnclosingElement(), info, funct);
                }
            }
            if (body.isEmpty()) {
                StringBuilder inhBody;
                StringBuilder stringBuilder = inhBody = inheritedDoc != null ? (StringBuilder)inheritedDoc.get(null) : null;
                if (inhBody != null) {
                    ret.put(null, inhBody);
                }
            } else {
                ret.put(null, this.inlineTags(body, path, doc, info.getDocTrees(), inheritedDoc != null ? (CharSequence)inheritedDoc.get(null) : null));
            }
            block21: for (DocTree docTree : tags) {
                block1 : switch (docTree.getKind()) {
                    case PARAM: {
                        Integer idx;
                        List<? extends DocTree> desc;
                        StringBuilder sb;
                        ParamTree paramTag = (ParamTree)docTree;
                        if (paramTag.isTypeParameter()) {
                            sb = (StringBuilder)ret.get((Object)DocTree.Kind.PARAM);
                            if (sb == null) {
                                sb = new StringBuilder();
                                ret.put((Object)DocTree.Kind.PARAM, sb);
                            }
                            sb.append("<code>").append(paramTag.getName().getName()).append("</code>");
                            desc = paramTag.getDescription();
                            if (!desc.isEmpty()) {
                                sb.append(" - ");
                                sb.append((CharSequence)this.inlineTags(desc, path, doc, info.getDocTrees(), null));
                            }
                            sb.append("<br>");
                            break;
                        }
                        desc = paramTag.getDescription();
                        if (desc.isEmpty() || (idx = this.getIdx(element, paramTag.getName().getName())) == null) continue block21;
                        sb = (StringBuilder)ret.get(idx);
                        if (sb == null) {
                            sb = new StringBuilder();
                            ret.put(idx, sb);
                        }
                        sb.append((CharSequence)this.inlineTags(desc, path, doc, info.getDocTrees(), inheritedDoc != null ? (CharSequence)inheritedDoc.get(idx) : null));
                        break;
                    }
                    case THROWS: {
                        ThrowsTree throwsTag = (ThrowsTree)docTree;
                        Element e = info.getDocTrees().getElement(DocTreePath.getPath(path, doc, throwsTag.getExceptionName()));
                        if (e == null) break;
                        List<? extends DocTree> desc = throwsTag.getDescription();
                        if (desc.isEmpty()) continue block21;
                        StringBuilder sb = (StringBuilder)ret.get(e);
                        if (sb == null) {
                            sb = new StringBuilder();
                            ret.put(e, sb);
                        }
                        sb.append((CharSequence)this.inlineTags(desc, path, doc, info.getDocTrees(), inheritedDoc != null ? (CharSequence)inheritedDoc.get(e) : null));
                        break;
                    }
                    case RETURN: {
                        StringBuilder sb = (StringBuilder)ret.get((Object)DocTree.Kind.RETURN);
                        if (sb == null) {
                            sb = new StringBuilder();
                            ret.put((Object)DocTree.Kind.RETURN, sb);
                        }
                        sb.append((CharSequence)this.inlineTags(((ReturnTree)docTree).getDescription(), path, doc, info.getDocTrees(), inheritedDoc != null ? (CharSequence)inheritedDoc.get((Object)DocTree.Kind.RETURN) : null));
                        break;
                    }
                    case SEE: {
                        StringBuilder sb = (StringBuilder)ret.get((Object)DocTree.Kind.SEE);
                        if (sb == null) {
                            sb = new StringBuilder();
                            ret.put((Object)DocTree.Kind.SEE, sb);
                        }
                        SeeTree seeTag = (SeeTree)docTree;
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append((CharSequence)this.inlineTags(seeTag.getReference(), path, doc, info.getDocTrees(), null));
                        break;
                    }
                    case SINCE: {
                        StringBuilder sb = (StringBuilder)ret.get((Object)DocTree.Kind.SINCE);
                        if (sb == null) {
                            sb = new StringBuilder();
                            ret.put((Object)DocTree.Kind.SINCE, sb);
                        }
                        sb.append((CharSequence)this.inlineTags(((SinceTree)docTree).getBody(), path, doc, info.getDocTrees(), null));
                        break;
                    }
                    case DEPRECATED: {
                        StringBuilder sb = (StringBuilder)ret.get((Object)DocTree.Kind.DEPRECATED);
                        if (sb == null) {
                            sb = new StringBuilder();
                            ret.put((Object)DocTree.Kind.DEPRECATED, sb);
                        }
                        sb.append((CharSequence)this.inlineTags(((DeprecatedTree)docTree).getBody(), path, doc, info.getDocTrees(), null));
                        break;
                    }
                    case UNKNOWN_BLOCK_TAG: {
                        StringBuilder sb;
                        UnknownBlockTagTree unTag = (UnknownBlockTagTree)docTree;
                        switch (unTag.getTagName()) {
                            case "apiNote": {
                                sb = (StringBuilder)ret.get(APINOTE_TAG);
                                if (sb == null) {
                                    sb = new StringBuilder();
                                    ret.put(APINOTE_TAG, sb);
                                }
                                sb.append((CharSequence)this.inlineTags(unTag.getContent(), path, doc, info.getDocTrees(), null));
                                break block1;
                            }
                            case "implSpec": {
                                sb = (StringBuilder)ret.get(IMPLSPEC_TAG);
                                if (sb == null) {
                                    sb = new StringBuilder();
                                    ret.put(IMPLSPEC_TAG, sb);
                                }
                                sb.append((CharSequence)this.inlineTags(unTag.getContent(), path, doc, info.getDocTrees(), null));
                                break block1;
                            }
                            case "implNote": {
                                sb = (StringBuilder)ret.get(IMPLNOTE_TAG);
                                if (sb == null) {
                                    sb = new StringBuilder();
                                    ret.put(IMPLNOTE_TAG, sb);
                                }
                                sb.append((CharSequence)this.inlineTags(unTag.getContent(), path, doc, info.getDocTrees(), null));
                            }
                        }
                    }
                }
            }
            if (element.getKind() == ElementKind.METHOD) {
                if (!ret.containsKey((Object)DocTree.Kind.RETURN)) {
                    if (inheritedDoc == null && !inheritedDocNeeded.getAndSet(true)) {
                        inheritedDoc = this.getInherited((ExecutableElement)element, (TypeElement)element.getEnclosingElement(), info, funct);
                    }
                    if (inheritedDoc != null && inheritedDoc.containsKey((Object)DocTree.Kind.RETURN)) {
                        ret.put((Object)DocTree.Kind.RETURN, new StringBuilder((CharSequence)inheritedDoc.get((Object)DocTree.Kind.RETURN)));
                    }
                }
                for (int i = 0; i < ((ExecutableElement)element).getParameters().size(); ++i) {
                    if (ret.containsKey(i)) continue;
                    if (inheritedDoc == null && !inheritedDocNeeded.getAndSet(true)) {
                        inheritedDoc = this.getInherited((ExecutableElement)element, (TypeElement)element.getEnclosingElement(), info, funct);
                    }
                    if (inheritedDoc == null || !inheritedDoc.containsKey(i)) continue;
                    ret.put(i, new StringBuilder((CharSequence)inheritedDoc.get(i)));
                }
                for (TypeMirror typeMirror : ((ExecutableElement)element).getThrownTypes()) {
                    Element e = typeMirror.getKind() == TypeKind.TYPEVAR ? ((TypeVariable)typeMirror).asElement() : ((DeclaredType)typeMirror).asElement();
                    if (ret.containsKey(e)) continue;
                    if (inheritedDoc == null && !inheritedDocNeeded.getAndSet(true)) {
                        inheritedDoc = this.getInherited((ExecutableElement)element, (TypeElement)element.getEnclosingElement(), info, funct);
                    }
                    if (inheritedDoc == null || !inheritedDoc.containsKey(e)) continue;
                    ret.put(e, new StringBuilder((CharSequence)inheritedDoc.get(e)));
                }
            }
        }
        return ret;
    }

    private <T> T getInherited(ExecutableElement element, TypeElement type, CompilationInfo info, Function<ExecutableElement, T> funct) {
        Elements elements = info.getElements();
        for (TypeMirror typeMirror : type.getInterfaces()) {
            for (ExecutableElement method : ElementFilter.methodsIn(((DeclaredType)typeMirror).asElement().getEnclosedElements())) {
                ExecutableElement ret;
                if (!elements.overrides(element, method, (TypeElement)element.getEnclosingElement()) || (ret = funct.apply(method)) == null) continue;
                return (T)ret;
            }
        }
        for (TypeMirror typeMirror : type.getInterfaces()) {
            ExecutableElement ret = this.getInherited(element, (TypeElement)((DeclaredType)typeMirror).asElement(), info, funct);
            if (ret == null) continue;
            return (T)ret;
        }
        TypeMirror superclass = type.getSuperclass();
        if (superclass.getKind() == TypeKind.DECLARED) {
            for (ExecutableElement method : ElementFilter.methodsIn(((DeclaredType)superclass).asElement().getEnclosedElements())) {
                ExecutableElement ret;
                if (!elements.overrides(element, method, (TypeElement)element.getEnclosingElement()) || (ret = funct.apply(method)) == null) continue;
                return (T)ret;
            }
            return (T)this.getInherited(element, (TypeElement)((DeclaredType)superclass).asElement(), info, funct);
        }
        return null;
    }

    private void computeDocURL(final List<? extends JavadocHelper.TextStream> pages, boolean sync, final Callable<Boolean> cancel) {
        if (this.docURL == null) {
            class ComputeURL
            implements Callable<Void> {
                private final boolean remote;

                ComputeURL(boolean remote) {
                    this.remote = remote;
                }

                @Override
                public Void call() throws Exception {
                    if (cancel == null || cancel.call() != Boolean.TRUE) {
                        if (!this.remote && pages.size() > 1) {
                            throw new JavadocHelper.RemoteJavadocException(null);
                        }
                        for (JavadocHelper.TextStream page : pages) {
                            URL loc = page.getLocation(this.remote ? JavadocHelper.RemoteJavadocPolicy.USE : JavadocHelper.RemoteJavadocPolicy.EXCEPTION);
                            if (loc == null) continue;
                            ElementJavadoc.this.docURL = loc;
                            break;
                        }
                    }
                    return null;
                }
            }
            if (sync) {
                try {
                    new ComputeURL(false).call();
                }
                catch (JavadocHelper.RemoteJavadocException e) {
                    RP.submit((Callable)new ComputeURL(true));
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            } else {
                try {
                    new ComputeURL(true).call();
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private String noJavadocFound() {
        if (this.handle != null) {
            FileObject root;
            URL rootURL;
            FileObject resource;
            ArrayList<ClassPath> cps = new ArrayList<ClassPath>(2);
            ClassPath cp = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT);
            if (cp != null) {
                cps.add(cp);
            }
            if ((cp = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE)) != null) {
                cps.add(cp);
            }
            cp = ClassPathSupport.createProxyClassPath((ClassPath[])cps.toArray(new ClassPath[cps.size()]));
            String toSearch = SourceUtils.getJVMSignature(this.handle)[0].replace('.', '/');
            if (this.handle.getKind() != ElementKind.PACKAGE) {
                toSearch = toSearch + ".class";
            }
            if ((resource = cp.findResource(toSearch)) != null && JavadocForBinaryQuery.findJavadoc((URL)(rootURL = (root = cp.findOwnerRoot(resource)).toURL())).getRoots().length == 0) {
                FileObject userRoot = FileUtil.getArchiveFile((FileObject)root);
                if (userRoot == null) {
                    userRoot = root;
                }
                return NbBundle.getMessage(ElementJavadoc.class, (String)"javadoc_content_not_found_attach", (Object)rootURL.toExternalForm(), (Object)FileUtil.getFileDisplayName((FileObject)userRoot));
            }
        }
        return NbBundle.getMessage(ElementJavadoc.class, (String)"javadoc_content_not_found");
    }

    private StringBuilder inlineTags(List<? extends DocTree> tags, TreePath docPath, DocCommentTree doc, DocTrees trees, CharSequence inherited) {
        StringBuilder sb = new StringBuilder();
        block27: for (DocTree docTree : tags) {
            switch (docTree.getKind()) {
                case REFERENCE: {
                    ReferenceTree refTag = (ReferenceTree)docTree;
                    this.appendReference(sb, refTag, null, docPath, doc, trees);
                    continue block27;
                }
                case LINK_PLAIN: {
                    LinkTree linkTag = (LinkTree)docTree;
                    this.appendReference(sb, linkTag.getReference(), linkTag.getLabel(), docPath, doc, trees);
                    continue block27;
                }
                case LINK: {
                    LinkTree linkTag = (LinkTree)docTree;
                    sb.append("<code>");
                    this.appendReference(sb, linkTag.getReference(), linkTag.getLabel(), docPath, doc, trees);
                    sb.append("</code>");
                    continue block27;
                }
                case CODE: {
                    LiteralTree codeTag = (LiteralTree)docTree;
                    sb.append("<code>");
                    try {
                        sb.append(XMLUtil.toElementContent((String)codeTag.getBody().getBody()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    sb.append("</code>");
                    continue block27;
                }
                case LITERAL: {
                    LiteralTree literalTag = (LiteralTree)docTree;
                    try {
                        sb.append(XMLUtil.toElementContent((String)literalTag.getBody().getBody()));
                    }
                    catch (IOException iOException) {}
                    continue block27;
                }
                case VALUE: {
                    ValueTree valueTag = (ValueTree)docTree;
                    ReferenceTree ref = valueTag.getReference();
                    Element element = ref == null ? trees.getElement(docPath) : trees.getElement(DocTreePath.getPath(docPath, doc, ref));
                    if (element == null || !element.getKind().isField()) continue block27;
                    try {
                        sb.append(XMLUtil.toElementContent((String)((VariableElement)element).getConstantValue().toString()));
                    }
                    catch (IOException iOException) {}
                    continue block27;
                }
                case INHERIT_DOC: {
                    if (inherited == null) continue block27;
                    sb.append(inherited);
                    continue block27;
                }
                case START_ELEMENT: {
                    StartElementTree startTag = (StartElementTree)docTree;
                    List<? extends DocTree> attrs = startTag.getAttributes();
                    sb.append('<').append(startTag.getName()).append(attrs.isEmpty() ? "" : " ").append((CharSequence)this.inlineTags(attrs, docPath, doc, trees, null)).append(startTag.isSelfClosing() ? "/>" : ">");
                    continue block27;
                }
                case END_ELEMENT: {
                    EndElementTree endTag = (EndElementTree)docTree;
                    sb.append("</").append(endTag.getName()).append('>');
                    continue block27;
                }
                case ATTRIBUTE: {
                    String quote;
                    AttributeTree attrTag = (AttributeTree)docTree;
                    sb.append(attrTag.getName());
                    switch (attrTag.getValueKind()) {
                        case EMPTY: {
                            quote = null;
                            break;
                        }
                        case UNQUOTED: {
                            quote = "";
                            break;
                        }
                        case SINGLE: {
                            quote = "'";
                            break;
                        }
                        case DOUBLE: {
                            quote = "\"";
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    if (quote == null) continue block27;
                    sb.append("=").append(quote).append((CharSequence)this.inlineTags(attrTag.getValue(), docPath, doc, trees, null)).append(quote);
                    continue block27;
                }
                case DOC_ROOT: {
                    if (this.docRoot == null) continue block27;
                    sb.append(this.docRoot);
                    continue block27;
                }
                case ENTITY: {
                    EntityTree entityTag = (EntityTree)docTree;
                    sb.append('&').append(entityTag.getName()).append(';');
                    continue block27;
                }
                case TEXT: {
                    TextTree ttag = (TextTree)docTree;
                    sb.append(ttag.getBody());
                    continue block27;
                }
            }
            if (!docTree.getKind().toString().equals("SNIPPET")) continue;
            this.processDocSnippet(sb, docTree);
        }
        return sb;
    }

    private void processDocSnippet(StringBuilder sb, DocTree tag) {
        sb.append("<pre>");
        sb.append("<code>");
        List attributes = TreeShims.getSnippetDocTreeAttributes((DocTree)tag);
        TextTree text = TreeShims.getSnippetDocTreeText((DocTree)tag);
        SnippetTagCommentParser parser = new SnippetTagCommentParser();
        List<SourceLineMeta> parseResult = parser.parse(text.getBody());
        MarkupTagProcessor tagProcessor = new MarkupTagProcessor();
        MarkupTagProcessor.ProcessedTags tags = tagProcessor.process(parseResult);
        this.applyTags(parseResult, tags, sb);
        sb.append("</code>");
        sb.append("</pre>");
    }

    private void applyTags(List<SourceLineMeta> parseResult, MarkupTagProcessor.ProcessedTags tags, StringBuilder sb) {
        if (!tags.getErrorList().isEmpty()) {
            this.reportError(tags.getErrorList(), sb);
            return;
        }
        int lineCounter = 0;
        for (SourceLineMeta fullLineInfo : parseResult) {
            ++lineCounter;
            String codeLine = fullLineInfo.getSourceLineWithoutComment() != null ? fullLineInfo.getSourceLineWithoutComment() : fullLineInfo.getActualSourceLine();
            LinkedList<SourceLineCharterMapperToHtmlTag> eachCharList = new LinkedList<SourceLineCharterMapperToHtmlTag>();
            for (int pos = 0; pos < codeLine.length(); ++pos) {
                SourceLineCharterMapperToHtmlTag htmlCharMapper = new SourceLineCharterMapperToHtmlTag(new LinkedList<String>(), codeLine.charAt(pos), new ArrayList<String>());
                eachCharList.add(htmlCharMapper);
            }
            List<MarkupTagProcessor.ApplicableMarkupTag> attributes = tags.getMarkUpTagLineMapper().get(lineCounter);
            if (attributes != null) {
                for (MarkupTagProcessor.ApplicableMarkupTag attrib : attributes) {
                    if ((codeLine = this.applyTagsToHTML(codeLine, attrib.getAttributes(), attrib.getMarkupTagName(), sb, eachCharList)) != null) continue;
                    return;
                }
            }
            for (SourceLineCharterMapperToHtmlTag charMapper : eachCharList) {
                for (String startTag : charMapper.getStartTag()) {
                    sb.append(startTag);
                }
                sb.append(charMapper.getSourceChar() == '<' ? "&lt;" : Character.valueOf(charMapper.getSourceChar()));
                for (String endTag : charMapper.getEndTag()) {
                    sb.append(endTag);
                }
            }
            sb.append("\n");
        }
    }

    private String applyTagsToHTML(String codeLine, Map<String, String> tagAttributes, String markupTagName, StringBuilder sb, List<SourceLineCharterMapperToHtmlTag> eachCharList) {
        String tagAction = this.getTagAction(tagAttributes);
        if (!this.validateMarkupTagAttribute(markupTagName, tagAttributes, sb, tagAction)) {
            return null;
        }
        switch (markupTagName) {
            case "highlight": {
                String htmlHighlightType = tagAttributes.get("type") != null && !tagAttributes.get("type").trim().isEmpty() ? tagAttributes.get("type") : "bold";
                this.applyHighlightTag(codeLine, tagAction, htmlHighlightType, tagAttributes.get(tagAction), eachCharList);
                break;
            }
            case "replace": {
                codeLine = this.applyReplaceTag(codeLine, tagAction, tagAttributes.get("replacement"), tagAttributes.get(tagAction), eachCharList);
                break;
            }
            case "link": {
                this.applyLinkTag(codeLine, tagAction, tagAttributes.get("target"), tagAttributes.get(tagAction), eachCharList);
                break;
            }
        }
        return codeLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateMarkupTagAttribute(String markupTagName, Map<String, String> tagAttributes, StringBuilder sb, String tagAction) {
        ArrayList<String> errors = new ArrayList<String>();
        if (tagAttributes.get(tagAction) == null || tagAttributes.get(tagAction).isEmpty()) {
            String error = String.format("error: snippet markup: Invalid value <sub>^</sub><b><i>%s</b></i> for <sub>^</sub><b><i>%s</b></i> tag mark up attribute <sub>^</sub><b><i>%s</b></i>", tagAttributes.get(tagAction).trim().equals("") ? "Blank" : tagAttributes.get(tagAction), markupTagName, tagAction);
            errors.add(error);
        } else if (markupTagName.equals("highlight")) {
            List<String> validAttributeValues = Arrays.asList("italic", "bold", "highlighted");
            if (!tagAttributes.containsKey("type") || validAttributeValues.contains(tagAttributes.get("type"))) return true;
            errors.add(String.format("error: snippet markup: Invalid value <sub>^</sub><b><i>%s</b></i> for <sub>^</sub><b><i>%s</b></i> tag mark up attribute <sub>^</sub><b><i>%s</b></i>.<br>Valid values, such as bold, italic, or highlighted", tagAttributes.get("type"), markupTagName, "type"));
        } else if (!tagAttributes.containsKey(MARKUPTAG_MANDATORY_ATTRIBUTE.get(markupTagName))) {
            String error = String.format("error: snippet markup: Missing <sub>^</sub><b><i>%s</b></i> tag attribute : <sub>^</sub><b><i>%s</b></i>", markupTagName, MARKUPTAG_MANDATORY_ATTRIBUTE.get(markupTagName));
            errors.add(error);
        } else if (!tagAttributes.containsKey("replacement") && tagAttributes.get(MARKUPTAG_MANDATORY_ATTRIBUTE.get(markupTagName)) != null && tagAttributes.get(MARKUPTAG_MANDATORY_ATTRIBUTE.get(markupTagName)).trim().isEmpty()) {
            String error = String.format("error: snippet markup: Invalid <sub>^</sub><b><i>%s</b></i> tag <sub>^</sub><b><i>%s</b></i> attribute value", markupTagName, MARKUPTAG_MANDATORY_ATTRIBUTE.get(markupTagName));
            errors.add(error);
        }
        if (errors.isEmpty()) return true;
        this.reportError(errors, sb);
        return false;
    }

    private void reportError(List<String> errorList, StringBuilder sb) {
        errorList.iterator().forEachRemaining(error -> sb.append("<span style=\"color:red;\">" + error + "</span>").append("\n"));
    }

    private String getTagAction(Map<String, String> tagAttributes) {
        if (tagAttributes.containsKey("regex")) {
            return "regex";
        }
        if (tagAttributes.containsKey("substring")) {
            return "substring";
        }
        tagAttributes.put("regex", ".*");
        return "regex";
    }

    private void applyHighlightTag(String codeLine, String tagAction, String htmlHighlightType, String tagActionValue, List<SourceLineCharterMapperToHtmlTag> eachCharList) {
        block5: {
            HtmlStartEndTag htmlTag;
            block4: {
                htmlTag = HTML_TAGS.get(htmlHighlightType);
                if (!tagAction.equals("substring")) break block4;
                int fromIndex = 0;
                while (fromIndex != -1) {
                    if ((fromIndex = codeLine.indexOf(tagActionValue, fromIndex)) == -1) continue;
                    for (int t = fromIndex; t < fromIndex + tagActionValue.length(); ++t) {
                        List<String> startTag = eachCharList.get(t).getStartTag();
                        startTag.add(0, htmlTag.getStartTag());
                        List<String> endTag = eachCharList.get(t).getEndTag();
                        endTag.add(htmlTag.getEndTag());
                    }
                    fromIndex += tagActionValue.length();
                }
                break block5;
            }
            if (!tagAction.equals("regex")) break block5;
            Pattern p = Pattern.compile(tagActionValue);
            Matcher m = p.matcher(codeLine);
            while (m.find()) {
                for (int t = m.start(); t < m.end(); ++t) {
                    List<String> startTag = eachCharList.get(t).getStartTag();
                    startTag.add(0, htmlTag.getStartTag());
                    List<String> endTag = eachCharList.get(t).getEndTag();
                    endTag.add(htmlTag.getEndTag());
                }
            }
        }
    }

    private String applyReplaceTag(String codeLine, String tagAction, String replacement, String tagActionValue, List<SourceLineCharterMapperToHtmlTag> eachCharList) {
        if (tagAction.equals("substring")) {
            int fromIndex = 0;
            while (fromIndex != -1) {
                if ((fromIndex = codeLine.indexOf(tagActionValue, fromIndex)) == -1) continue;
                StringBuilder formattedLine = new StringBuilder(codeLine);
                for (int i = fromIndex; i < fromIndex + tagActionValue.length(); ++i) {
                    eachCharList.remove(fromIndex);
                }
                int counter = 0;
                for (int i = fromIndex; i < fromIndex + replacement.length(); ++i) {
                    SourceLineCharterMapperToHtmlTag htmlCharMapper = new SourceLineCharterMapperToHtmlTag(new LinkedList<String>(), replacement.charAt(counter), new ArrayList<String>());
                    eachCharList.add(i, htmlCharMapper);
                    ++counter;
                }
                formattedLine.replace(fromIndex, fromIndex + tagActionValue.length(), replacement);
                fromIndex += replacement.length();
                codeLine = formattedLine.toString();
            }
        } else if (tagAction.equals("regex")) {
            Pattern pattern = Pattern.compile(tagActionValue);
            Matcher matcher = pattern.matcher(codeLine);
            StringBuffer formattedLine = new StringBuffer();
            int start = 0;
            int end = 0;
            while (matcher.find()) {
                matcher.appendReplacement(formattedLine, replacement);
                end = formattedLine.length();
                for (int i = start += matcher.start(); i < start + matcher.end() - matcher.start(); ++i) {
                    eachCharList.remove(start);
                }
                int counter = 0;
                for (int i = start; i < end; ++i) {
                    SourceLineCharterMapperToHtmlTag htmlCharMapper = new SourceLineCharterMapperToHtmlTag(new LinkedList<String>(), replacement.charAt(counter), new ArrayList<String>());
                    eachCharList.add(i, htmlCharMapper);
                    ++counter;
                }
                start = end - matcher.end();
            }
            matcher.appendTail(formattedLine);
            codeLine = formattedLine.toString();
        }
        return codeLine;
    }

    private void applyLinkTag(String codeLine, String tagAction, String linkTarget, String tagActionValue, List<SourceLineCharterMapperToHtmlTag> eachCharList) {
        block8: {
            String linkHtmlEndTag;
            String linkHtmlStartTag;
            block7: {
                linkHtmlStartTag = "";
                linkHtmlEndTag = "";
                try {
                    linkTarget = linkTarget.startsWith("#") ? this.className + linkTarget : linkTarget;
                    String javaDocCodeBody = this.prepareJavaDocForSnippetMarkupLinkTag(linkTarget);
                    String fullClassCode = this.addImportsToSource(javaDocCodeBody);
                    JavaDocSnippetLinkTagFileObject docSnippetLinkTagFileObject = new JavaDocSnippetLinkTagFileObject(fullClassCode);
                    StringBuilder linkRef = new StringBuilder();
                    this.createSnippetMarkupLinkTag(linkRef, docSnippetLinkTagFileObject);
                    String link = linkRef.toString();
                    link = link.replace("<code>", "");
                    link = link.replace("</code>", "");
                    String linkValue = link.replaceAll("\\<.*?>", "");
                    linkHtmlStartTag = link.substring(0, link.indexOf(linkValue));
                    linkHtmlEndTag = link.substring(link.indexOf(linkValue) + linkValue.length());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                if (linkHtmlStartTag.equals("") || linkHtmlEndTag.equals("")) {
                    return;
                }
                if (!tagAction.equals("substring")) break block7;
                int fromIndex = 0;
                while (fromIndex != -1) {
                    if ((fromIndex = codeLine.indexOf(tagActionValue, fromIndex)) == -1) continue;
                    for (int t = fromIndex; t < fromIndex + tagActionValue.length(); ++t) {
                        List<String> startTag = eachCharList.get(t).getStartTag();
                        startTag.add(0, linkHtmlStartTag);
                        List<String> endTag = eachCharList.get(t).getEndTag();
                        endTag.add(linkHtmlEndTag);
                    }
                    fromIndex += tagActionValue.length();
                }
                break block8;
            }
            if (!tagAction.equals("regex")) break block8;
            Pattern p = Pattern.compile(tagActionValue);
            Matcher m = p.matcher(codeLine);
            while (m.find()) {
                for (int t = m.start(); t < m.end(); ++t) {
                    List<String> startTag = eachCharList.get(t).getStartTag();
                    startTag.add(0, linkHtmlStartTag);
                    List<String> endTag = eachCharList.get(t).getEndTag();
                    endTag.add(linkHtmlEndTag);
                }
            }
        }
    }

    private String addImportsToSource(String javaDocClassBody) {
        StringBuilder source = new StringBuilder();
        for (ImportTree importTree : this.imports) {
            if (importTree.getKind() != Tree.Kind.IMPORT) continue;
            source.append(importTree.toString()).append("\n");
        }
        source.append("import ").append(this.packageName).append(".*;");
        return source.append(javaDocClassBody).toString();
    }

    private String prepareJavaDocForSnippetMarkupLinkTag(String target) {
        return "public class JavaDocSnippetLinkTag {\n\n    /**\n     * {@link " + target + "}\n     */\n    void doc() {\n\n    }\n}";
    }

    private void createSnippetMarkupLinkTag(StringBuilder sb, JavaDocSnippetLinkTagFileObject fileObject) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StringBuilder prjClsPath = new StringBuilder();
        String prjSrcPath = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).toString();
        prjClsPath.append(prjSrcPath);
        for (ClassPath.Entry cpe : this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).entries()) {
            prjClsPath.append(";");
            prjClsPath.append(cpe.getRoot().getFileSystem().getDisplayName());
        }
        List<String> opt = Arrays.asList("-cp", prjClsPath.toString());
        JavacTask task = (JavacTask)compiler.getTask(null, null, null, opt, null, Arrays.asList(fileObject));
        DocTrees docTrees = DocTrees.instance(task);
        Iterable<? extends Element> docClass = task.analyze();
        block1: for (Element element : docClass) {
            for (Element element2 : element.getEnclosedElements()) {
                TreePath path = docTrees.getPath(element2);
                DocCommentTree doc = docTrees.getDocCommentTree(element2);
                if (doc == null) continue;
                List<? extends DocTree> body = doc.getFullBody();
                for (DocTree docTree : body) {
                    if (!(docTree instanceof LinkTree)) continue;
                    LinkTree linkTag = (LinkTree)docTree;
                    this.appendReference(sb, linkTag.getReference(), body, path, doc, docTrees);
                    break block1;
                }
                continue block1;
            }
        }
    }

    private void appendReference(StringBuilder sb, ReferenceTree ref, List<? extends DocTree> label, TreePath docPath, DocCommentTree doc, DocTrees trees) {
        Element element;
        String sig = ref.getSignature();
        if (sig != null && sig.length() > 0) {
            if (sig.charAt(0) == '#') {
                sig = sig.substring(1);
            }
            sig = sig.replace('#', '.');
        }
        if ((element = trees.getElement(DocTreePath.getPath(docPath, doc, ref))) != null) {
            this.createLink(sb, element, label == null || label.isEmpty() ? sig : this.inlineTags(label, docPath, doc, trees, null));
        } else {
            sb.append(label == null || label.isEmpty() ? sig : this.inlineTags(label, docPath, doc, trees, null));
        }
    }

    private void appendType(StringBuilder sb, TypeMirror type, boolean varArg) {
        switch (type.getKind()) {
            case ARRAY: {
                this.appendType(sb, ((ArrayType)type).getComponentType(), false);
                sb.append(varArg ? "..." : "[]");
                break;
            }
            case DECLARED: {
                sb.append(((TypeElement)((DeclaredType)type).asElement()).getQualifiedName());
                break;
            }
            default: {
                sb.append(type);
            }
        }
    }

    private void appendSpace(StringBuilder sb, int length) {
        while (length-- >= 0) {
            sb.append(' ');
        }
    }

    private int appendType(StringBuilder sb, TypeMirror type, boolean varArg, boolean typeVar, boolean annotation) {
        int len = 0;
        switch (type.getKind()) {
            case WILDCARD: {
                WildcardType wt = (WildcardType)type;
                sb.append('?');
                ++len;
                TypeMirror bound = wt.getExtendsBound();
                if (bound != null) {
                    sb.append(" extends ");
                    len += 9;
                    len += this.appendType(sb, bound, false, false, false);
                }
                if ((bound = wt.getSuperBound()) == null) break;
                sb.append(" super ");
                len += 7;
                len += this.appendType(sb, bound, false, false, false);
                break;
            }
            case TYPEVAR: {
                TypeVariable tv = (TypeVariable)type;
                len += this.createLink(sb, null, tv.asElement().getSimpleName());
                TypeMirror bound = tv.getUpperBound();
                if (!typeVar || bound == null || bound.getKind() == TypeKind.DECLARED && bound.getAnnotationMirrors().isEmpty() && "java.lang.Object".contentEquals(((TypeElement)((DeclaredType)bound).asElement()).getQualifiedName())) break;
                sb.append(" extends ");
                len += 9;
                len += this.appendType(sb, bound, false, false, false);
                break;
            }
            case INTERSECTION: {
                IntersectionType it = (IntersectionType)type;
                Iterator<? extends TypeMirror> iter = it.getBounds().iterator();
                while (iter.hasNext()) {
                    TypeMirror bound = iter.next();
                    len += this.appendType(sb, bound, false, false, false);
                    if (!iter.hasNext()) continue;
                    sb.append(" & ");
                    len += 3;
                }
                break;
            }
            case DECLARED: {
                DeclaredType dt = (DeclaredType)type;
                Element el = dt.asElement();
                len += this.createLink(sb, el, annotation && el.getKind() == ElementKind.ANNOTATION_TYPE ? "@" + el.getSimpleName() : el.getSimpleName());
                List<? extends TypeMirror> typeArgs = dt.getTypeArguments();
                if (typeArgs.isEmpty()) break;
                sb.append("&lt;");
                Iterator<? extends TypeMirror> iter = typeArgs.iterator();
                while (iter.hasNext()) {
                    TypeMirror typeArg = iter.next();
                    len += this.appendType(sb, typeArg, false, false, false);
                    if (!iter.hasNext()) continue;
                    sb.append(",");
                    ++len;
                }
                sb.append("&gt;");
                len += 2;
                break;
            }
            case ARRAY: {
                ArrayType at = (ArrayType)type;
                len += this.appendType(sb, at.getComponentType(), false, false, false);
                if (varArg) {
                    sb.append("...");
                    len += 3;
                    break;
                }
                sb.append("[]");
                len += 2;
                break;
            }
            case BOOLEAN: {
                sb.append("boolean");
                len += 7;
                break;
            }
            case CHAR: {
                sb.append("char");
                len += 4;
                break;
            }
            case BYTE: {
                sb.append("byte");
                len += 4;
                break;
            }
            case DOUBLE: {
                sb.append("double");
                len += 6;
                break;
            }
            case FLOAT: {
                sb.append("float");
                len += 5;
                break;
            }
            case INT: {
                sb.append("int");
                len += 3;
                break;
            }
            case LONG: {
                sb.append("long");
                len += 4;
                break;
            }
            case SHORT: {
                sb.append("short");
                len += 5;
                break;
            }
            case VOID: {
                sb.append("void");
                len += 4;
            }
        }
        return len;
    }

    private Integer getIdx(Element e, Name n) {
        if (e instanceof ExecutableElement && n != null) {
            int idx = 0;
            for (VariableElement variableElement : ((ExecutableElement)e).getParameters()) {
                if (n.contentEquals(variableElement.getSimpleName())) {
                    return idx;
                }
                ++idx;
            }
        }
        return null;
    }

    private Name getName(Element e, int idx) {
        return e instanceof ExecutableElement ? ((ExecutableElement)e).getParameters().get(idx).getSimpleName() : null;
    }

    private int createLink(StringBuilder sb, Element e, CharSequence text) {
        if (e != null && e.asType().getKind() != TypeKind.ERROR) {
            String link = "*" + this.linkCounter++;
            this.links.put(link, (ElementHandle<? extends Element>)ElementHandle.create((Element)e));
            sb.append("<a href='").append(link).append("'>");
        }
        sb.append(text);
        if (e != null) {
            sb.append("</a>");
        }
        return text.length();
    }

    private CharSequence getFragment(Element e) {
        StringBuilder sb = new StringBuilder();
        if (!e.getKind().isClass() && !e.getKind().isInterface()) {
            if (e.getKind() == ElementKind.CONSTRUCTOR) {
                sb.append(e.getEnclosingElement().getSimpleName());
            } else {
                sb.append(e.getSimpleName());
            }
            if (e.getKind() == ElementKind.METHOD || e.getKind() == ElementKind.CONSTRUCTOR) {
                ExecutableElement ee = (ExecutableElement)e;
                sb.append('(');
                Iterator<? extends VariableElement> it = ee.getParameters().iterator();
                while (it.hasNext()) {
                    VariableElement param = it.next();
                    this.appendType(sb, param.asType(), ee.isVarArgs() && !it.hasNext());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(')');
            }
        }
        return sb;
    }

    private static boolean isRemote(JavadocHelper.TextStream page, URL url) {
        if (page != null && page.getLocations().stream().anyMatch(loc -> loc.toString().startsWith("http"))) {
            return true;
        }
        return url != null ? url.toString().startsWith("http") : false;
    }

    private static boolean isLocalized(List<? extends URL> docUrls, Element element) {
        return docUrls.stream().anyMatch(docUrl -> ElementJavadoc.isLocalized(docUrl, element));
    }

    private static boolean isLocalized(URL docURL, Element element) {
        if (docURL == null) {
            return false;
        }
        Element pkg = element;
        while (pkg.getKind() != ElementKind.PACKAGE) {
            if ((pkg = pkg.getEnclosingElement()) != null) continue;
            return false;
        }
        String pkgBinName = ((PackageElement)pkg).getQualifiedName().toString();
        String surl = docURL.toString();
        int index = surl.lastIndexOf(47);
        if (index < 0) {
            return false;
        }
        if ((index -= pkgBinName.length() + 1) < 0) {
            return false;
        }
        if ((index -= API.length()) < 0 || !surl.regionMatches(index, API, 0, API.length())) {
            return false;
        }
        int index2 = surl.lastIndexOf(47, index - 1);
        if (index2 < 0) {
            return false;
        }
        String lang = surl.substring(index2 + 1, index);
        return LANGS.contains(lang);
    }

    private static <R, T extends Throwable> R sthrow(@NonNull Throwable t) throws T {
        throw t;
    }

    private void assignSource(@NonNull Element element, @NonNull CompilationInfo compilationInfo, @NullAllowed URL url, @NonNull StringBuilder content) {
        final FileObject fo = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationInfo.getClasspathInfo());
        if (fo != null) {
            if (this.docURL == null && this.goToSource == null) {
                content.insert(0, "<base href=\"" + fo.toURL() + "\"></base>");
            }
            this.goToSource = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ElementOpen.open(fo, (ElementHandle<? extends Element>)ElementJavadoc.this.handle);
                }
            };
        }
        if (url != null) {
            this.docURL = url;
        }
    }

    static {
        RP = new RequestProcessor(ElementJavadoc.class);
        Locale[] availableLocales = Locale.getAvailableLocales();
        HashSet<String> locNames = new HashSet<String>((int)((float)availableLocales.length / 0.75f) + 1);
        for (Locale locale : availableLocales) {
            locNames.add(locale.toString());
        }
        LANGS = Collections.unmodifiableSet(locNames);
        HTML_TAGS = new HashMap<String, HtmlStartEndTag>();
        HTML_TAGS.put("bold", new HtmlStartEndTag("<b>", "</b>"));
        HTML_TAGS.put("italic", new HtmlStartEndTag("<i>", "</i>"));
        HTML_TAGS.put("highlighted", new HtmlStartEndTag("<span style=\"background-color:yellow;\">", "</span>"));
        MARKUPTAG_MANDATORY_ATTRIBUTE = new HashMap<String, String>();
        MARKUPTAG_MANDATORY_ATTRIBUTE.put("link", "target");
        MARKUPTAG_MANDATORY_ATTRIBUTE.put("replace", "replacement");
    }

    private static class SourceLineCharterMapperToHtmlTag {
        List<String> startTag;
        char sourceChar;
        List<String> endTag;

        public List<String> getStartTag() {
            return this.startTag;
        }

        public void setStartTag(List<String> startTag) {
            this.startTag = startTag;
        }

        public char getSourceChar() {
            return this.sourceChar;
        }

        public void setSourceChar(char sourceChar) {
            this.sourceChar = sourceChar;
        }

        public List<String> getEndTag() {
            return this.endTag;
        }

        public void setEndTag(List<String> endTag) {
            this.endTag = endTag;
        }

        public SourceLineCharterMapperToHtmlTag(List<String> startTag, char sourceChar, List<String> endTag) {
            this.startTag = startTag;
            this.sourceChar = sourceChar;
            this.endTag = endTag;
        }
    }

    private static class JavaDocSnippetLinkTagFileObject
    extends SimpleJavaFileObject {
        private String text;

        public JavaDocSnippetLinkTagFileObject(String text) {
            super(URI.create("myfo:/JavaDocSnippetLinkTag.java"), JavaFileObject.Kind.SOURCE);
            this.text = text;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.text;
        }
    }
}

