/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.api.java.source.JavaSource;
import org.openide.util.NbPreferences;

public class CompilerSettings {
    public static final String ENABLE_LINT = "enable_lint";
    public static final String ENABLE_LINT_DEPRECATION = "enable_lint_deprecation";
    public static final String ENABLE_LINT_UNCHECKED = "enable_lint_unchecked";
    public static final String ENABLE_LINT_FALLTHROUGH = "enable_lint_fallthrough";
    public static final String ENABLE_LINT_SERIAL = "enable_lint_serial";
    public static final String ENABLE_LINT_FINALLY = "enable_lint_finally";
    public static final String ENABLE_LINT_CAST = "enable_lint_cast";
    public static final String ENABLE_LINT_DIVZERO = "enable_lint_dvizero";
    public static final String ENABLE_LINT_EMPTY = "enable_lint_empty";
    public static final String ENABLE_LINT_OVERRIDES = "enable_lint_overrides";
    public static final String ENABLE_LINT_RAWTYPES = "enable_lint_rawtypes";
    private static final Map<String, Boolean> DEFAULTS = new HashMap<String, Boolean>();

    private CompilerSettings() {
    }

    public static Preferences getNode() {
        return NbPreferences.forModule(JavaSource.class).node("compiler_settings");
    }

    public static String getCommandLine() {
        Preferences p = CompilerSettings.getNode();
        StringBuilder sb = new StringBuilder();
        if (CompilerSettings.get(p, ENABLE_LINT_DEPRECATION)) {
            sb.append("-Xlint:deprecation ");
        }
        if (CompilerSettings.get(p, ENABLE_LINT_UNCHECKED)) {
            sb.append("-Xlint:unchecked ");
        }
        if (CompilerSettings.get(p, ENABLE_LINT_FALLTHROUGH)) {
            sb.append("-Xlint:fallthrough ");
        }
        if (CompilerSettings.get(p, ENABLE_LINT_SERIAL)) {
            sb.append("-Xlint:serial ");
        }
        if (CompilerSettings.get(p, ENABLE_LINT_FINALLY)) {
            sb.append("-Xlint:finally ");
        }
        if (CompilerSettings.get(p, ENABLE_LINT_CAST)) {
            sb.append("-Xlint:cast ");
        }
        if (CompilerSettings.get(p, ENABLE_LINT_DIVZERO)) {
            sb.append("-Xlint:divzero ");
        }
        if (CompilerSettings.get(p, ENABLE_LINT_EMPTY)) {
            sb.append("-Xlint:empty ");
        }
        if (CompilerSettings.get(p, ENABLE_LINT_OVERRIDES)) {
            sb.append("-Xlint:overrides ");
        }
        if (CompilerSettings.get(p, ENABLE_LINT_RAWTYPES)) {
            sb.append("-Xlint:rawtypes ");
        }
        sb.append("-XDfindDiamond ");
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean get(Preferences p, String key) {
        return p.getBoolean(key, DEFAULTS.get(key));
    }

    static {
        DEFAULTS.put(ENABLE_LINT, false);
        DEFAULTS.put(ENABLE_LINT_DEPRECATION, false);
        DEFAULTS.put(ENABLE_LINT_UNCHECKED, false);
        DEFAULTS.put(ENABLE_LINT_FALLTHROUGH, false);
        DEFAULTS.put(ENABLE_LINT_SERIAL, false);
        DEFAULTS.put(ENABLE_LINT_FINALLY, false);
        DEFAULTS.put(ENABLE_LINT_CAST, false);
        DEFAULTS.put(ENABLE_LINT_DIVZERO, false);
        DEFAULTS.put(ENABLE_LINT_EMPTY, false);
        DEFAULTS.put(ENABLE_LINT_OVERRIDES, false);
        DEFAULTS.put(ENABLE_LINT_RAWTYPES, false);
    }
}

