/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.save;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;

public class Reindenter
implements IndentTask {
    private final org.netbeans.modules.editor.indent.spi.Context context;
    private CodeStyle cs;
    private TokenSequence<JavaTokenId> ts;
    private String text;
    private CompilationUnitTree cut;
    private SourcePositions sp;
    private Map<Integer, Integer> newIndents;
    private int currentEmbeddingStartOffset;
    private Embedding currentEmbedding;

    private Reindenter(org.netbeans.modules.editor.indent.spi.Context context) {
        this.context = context;
    }

    public void reindent() throws BadLocationException {
        this.ts = null;
        this.currentEmbedding = null;
        this.newIndents = new HashMap<Integer, Integer>();
        this.cs = CodeStyle.getDefault(this.context.document());
        for (Context.Region region : this.context.indentRegions()) {
            if (!this.initRegionData(region)) continue;
            HashSet<Integer> linesToAddStar = new HashSet<Integer>();
            LinkedList<Integer> startOffsets = this.getStartOffsets(region);
            ListIterator it = startOffsets.listIterator();
            while (it.hasNext()) {
                int originalEndOffset;
                int originalStartOffset = (Integer)it.next();
                if (it.hasNext()) {
                    originalEndOffset = (Integer)it.next() - 1;
                    it.previous();
                } else {
                    originalEndOffset = region.getEndOffset();
                }
                int startOffset = this.getEmbeddedOffset(originalStartOffset);
                int endOffset = this.getEmbeddedOffset(originalEndOffset);
                int delta = 0;
                if (this.cs.addLeadingStarInComment() && ((delta = this.ts.move(startOffset)) > 0 && this.ts.moveNext() || this.ts.movePrevious()) && EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT).contains(this.ts.token().id())) {
                    int idx;
                    String blockCommentLine = ((Object)this.ts.token().text()).toString();
                    if (delta > 0) {
                        idx = blockCommentLine.indexOf(10, delta);
                        blockCommentLine = (idx < 0 ? blockCommentLine.substring(delta) : blockCommentLine.substring(delta, idx)).trim();
                        int off = this.getOriginalOffset(this.ts.offset() + delta - 1);
                        int prevLineStartOffset = this.context.lineStartOffset(off < 0 ? originalStartOffset : off);
                        Integer prevLineIndent = this.newIndents.get(prevLineStartOffset);
                        this.newIndents.put(originalStartOffset, (prevLineIndent != null ? prevLineIndent.intValue() : this.context.lineIndent(prevLineStartOffset)) + (prevLineStartOffset > this.getOriginalOffset(this.ts.offset()) ? 0 : 1));
                    } else {
                        idx = blockCommentLine.lastIndexOf(10);
                        if (idx > 0) {
                            blockCommentLine = blockCommentLine.substring(idx).trim();
                        }
                        this.newIndents.put(originalStartOffset, this.getNewIndent(startOffset, endOffset) + 1);
                    }
                    if (blockCommentLine.startsWith("*")) continue;
                    linesToAddStar.add(originalStartOffset);
                    continue;
                }
                this.newIndents.put(originalStartOffset, this.getNewIndent(startOffset, endOffset));
            }
            while (!startOffsets.isEmpty()) {
                char c;
                int startOffset = startOffsets.removeLast();
                Integer newIndent = this.newIndents.get(startOffset);
                if (linesToAddStar.contains(startOffset)) {
                    this.context.modifyIndent(startOffset, 0);
                    this.context.document().insertString(startOffset, "* ", null);
                }
                this.context.modifyIndent(startOffset, newIndent.intValue());
                if (startOffsets.isEmpty()) continue;
                int len = 0;
                while ((c = this.text.charAt(startOffset - 2 - len)) != '\n' && Character.isWhitespace(c)) {
                    ++len;
                }
                if (len <= 0) continue;
                this.context.document().remove(startOffset - 1 - len, len);
            }
        }
    }

    public ExtraLock indentLock() {
        return "text/x-java".equals(this.context.mimePath()) ? null : new ExtraLock(){

            public void lock() {
                Utilities.acquireParserLock();
            }

            public void unlock() {
                Utilities.releaseParserLock();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initRegionData(final Context.Region region) {
        this.currentEmbeddingStartOffset = 0;
        if (this.ts == null || this.currentEmbedding != null && (!this.currentEmbedding.containsOriginalOffset(region.getStartOffset()) || !this.currentEmbedding.containsOriginalOffset(region.getEndOffset()))) {
            if ("text/x-java".equals(this.context.mimePath())) {
                this.ts = TokenHierarchy.get((Document)this.context.document()).tokenSequence(JavaTokenId.language());
                if (this.ts == null) {
                    return false;
                }
                ClassLoader origCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(Reindenter.class.getClassLoader());
                    JavacTaskImpl javacTask = (JavacTaskImpl)ToolProvider.getSystemJavaCompiler().getTask(null, null, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                        @Override
                        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                        }
                    }, Collections.singletonList("-proc:none"), null, Collections.emptySet());
                    Context ctx = javacTask.getContext();
                    JavaCompiler.instance((Context)ctx).genEndPos = true;
                    this.text = this.context.document().getText(0, this.context.document().getLength());
                    this.cut = (CompilationUnitTree)javacTask.parse(new JavaFileObject[]{FileObjects.memoryFileObject("", "", this.text)}).iterator().next();
                    this.sp = JavacTrees.instance(ctx).getSourcePositions();
                }
                catch (Exception ex) {
                    boolean ctx = false;
                    return ctx;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origCL);
                }
            }
            Source source = Source.create((Document)this.context.document());
            if (source == null) {
                return false;
            }
            for (TokenSequence tseq = TokenHierarchy.get((Document)this.context.document()).tokenSequence(); tseq != null && (region.getStartOffset() == 0 || tseq.moveNext()); tseq = tseq.embedded()) {
                tseq.move(region.getStartOffset());
                if (tseq.language() == JavaTokenId.language() || !tseq.moveNext() && !tseq.movePrevious()) break;
                this.currentEmbeddingStartOffset = tseq.offset();
            }
            try {
                ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result result = Reindenter.this.findEmbeddedJava(resultIterator, region);
                        if (result != null) {
                            CompilationController controller = CompilationController.get(result);
                            controller.toPhase(JavaSource.Phase.PARSED);
                            Reindenter.this.ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                            Reindenter.this.text = controller.getText();
                            Reindenter.this.cut = controller.getCompilationUnit();
                            Reindenter.this.sp = controller.getTrees().getSourcePositions();
                        }
                    }
                });
                if (this.ts == null) {
                    return false;
                }
            }
            catch (ParseException pe) {
                return false;
            }
        }
        return true;
    }

    private Parser.Result findEmbeddedJava(ResultIterator theMess, Context.Region region) throws ParseException {
        LinkedList<Embedding> todo = new LinkedList<Embedding>();
        for (Embedding embedding : theMess.getEmbeddings()) {
            if ("text/x-java".equals(embedding.getMimeType()) && embedding.containsOriginalOffset(region.getStartOffset()) && embedding.containsOriginalOffset(region.getEndOffset())) {
                this.currentEmbedding = embedding;
                return theMess.getResultIterator(this.currentEmbedding).getParserResult();
            }
            todo.add(embedding);
        }
        for (Embedding embedding : todo) {
            Parser.Result result = this.findEmbeddedJava(theMess.getResultIterator(embedding), region);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private LinkedList<Integer> getStartOffsets(Context.Region region) throws BadLocationException {
        int lso;
        LinkedList<Integer> offsets = new LinkedList<Integer>();
        int offset = region.getEndOffset();
        while (offset > 0 && (lso = this.context.lineStartOffset(offset)) >= region.getStartOffset()) {
            offsets.addFirst(lso);
            offset = lso - 1;
        }
        return offsets;
    }

    /*
     * WARNING - void declaration
     */
    private int getNewIndent(int startOffset, int endOffset) throws BadLocationException {
        LinkedList<? extends Tree> path = this.getPath(startOffset);
        if (path.isEmpty()) {
            return 0;
        }
        Tree last = path.get(0);
        int lastPos = (int)this.sp.getStartPosition(this.cut, last);
        int lastOriginalOffset = this.getOriginalOffset(lastPos);
        int lastLineStartOffset = this.context.lineStartOffset(lastOriginalOffset < 0 ? this.currentEmbeddingStartOffset : lastOriginalOffset);
        Integer newIndent = this.newIndents.get(lastLineStartOffset);
        int currentIndent = newIndent != null ? newIndent.intValue() : this.context.lineIndent(lastLineStartOffset);
        block0 : switch (last.getKind()) {
            case COMPILATION_UNIT: {
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION_TYPE: {
                JavaTokenId prevTokenId;
                JavaTokenId nextTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId javaTokenId = nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (nextTokenId != null && nextTokenId == JavaTokenId.RBRACE) {
                    if (!this.isLeftBraceOnNewLine(lastPos, startOffset)) break;
                    switch (this.cs.getClassDeclBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                Tree t = null;
                for (Tree tree : ((ClassTree)last).getMembers()) {
                    if (this.sp.getEndPosition(this.cut, tree) > (long)startOffset) break;
                    t = tree;
                }
                if (t != null) {
                    int i = this.getCurrentIndent(t);
                    currentIndent = i < 0 ? currentIndent + (this.cs.indentTopLevelClassMembers() ? this.cs.getIndentSize() : 0) : i;
                    break;
                }
                token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                JavaTokenId javaTokenId2 = prevTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (prevTokenId == null) break;
                switch (prevTokenId) {
                    case LBRACE: {
                        currentIndent += this.cs.indentTopLevelClassMembers() ? this.cs.getIndentSize() : 0;
                        break block0;
                    }
                    case COMMA: {
                        currentIndent = this.getMultilineIndent(((ClassTree)last).getImplementsClause(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineImplements(), true);
                        break block0;
                    }
                    case IDENTIFIER: 
                    case GT: 
                    case GTGT: 
                    case GTGTGT: {
                        if (nextTokenId == null || nextTokenId != JavaTokenId.LBRACE) break block0;
                        switch (this.cs.getClassDeclBracePlacement()) {
                            case NEW_LINE_INDENTED: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() / 2;
                            }
                        }
                        break block0;
                    }
                    default: {
                        currentIndent += this.cs.getContinuationIndentSize();
                    }
                }
                break;
            }
            case METHOD: {
                JavaTokenId prevTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                JavaTokenId javaTokenId = prevTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (prevTokenId == null) break;
                switch (prevTokenId) {
                    case COMMA: {
                        List<? extends ExpressionTree> thrws = ((MethodTree)last).getThrows();
                        if (!thrws.isEmpty() && this.sp.getStartPosition(this.cut, thrws.get(0)) < (long)token.offset()) {
                            currentIndent = this.getMultilineIndent(thrws, path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineThrows(), true);
                            break block0;
                        }
                        currentIndent = this.getMultilineIndent(((MethodTree)last).getParameters(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineMethodParams(), true);
                        break block0;
                    }
                    case IDENTIFIER: 
                    case GT: 
                    case GTGT: 
                    case GTGTGT: 
                    case RPAREN: {
                        token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                        if (token == null || token.token().id() != JavaTokenId.LBRACE) break;
                        switch (this.cs.getMethodDeclBracePlacement()) {
                            case NEW_LINE_INDENTED: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() / 2;
                            }
                        }
                        break block0;
                    }
                }
                currentIndent += this.cs.getContinuationIndentSize();
                break;
            }
            case VARIABLE: {
                Tree type = ((VariableTree)last).getType();
                if (type != null && type.getKind() != Tree.Kind.ERRONEOUS) {
                    TokenSequence<JavaTokenId> token;
                    ExpressionTree expressionTree = ((VariableTree)last).getInitializer();
                    if (expressionTree == null || expressionTree.getKind() != Tree.Kind.NEW_ARRAY || (token = this.findFirstNonWhitespaceToken(startOffset, lastPos)) == null || token.token().id() != JavaTokenId.EQ || (token = this.findFirstNonWhitespaceToken(startOffset, endOffset)) == null || token.token().id() != JavaTokenId.LBRACE) {
                        if (this.cs.alignMultilineAssignment()) {
                            int c = this.getColumn(last);
                            if (c < 0) break;
                            currentIndent = c;
                            break;
                        }
                        currentIndent += this.cs.getContinuationIndentSize();
                        break;
                    }
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                if ((last = ((VariableTree)last).getModifiers()) == null) break;
            }
            case MODIFIERS: {
                void var14_40;
                Object var14_39 = null;
                for (AnnotationTree annotationTree : ((ModifiersTree)last).getAnnotations()) {
                    if (this.sp.getEndPosition(this.cut, annotationTree) > (long)startOffset) break;
                    AnnotationTree annotationTree2 = annotationTree;
                }
                if (var14_40 != null && this.findFirstNonWhitespaceToken(startOffset, (int)this.sp.getEndPosition(this.cut, (Tree)var14_40)) == null) break;
                currentIndent += this.cs.getContinuationIndentSize();
                break;
            }
            case DO_WHILE_LOOP: {
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token == null || EnumSet.of(JavaTokenId.RBRACE, JavaTokenId.SEMICOLON).contains(token.token().id())) break;
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.DO), lastPos, currentIndent);
                break;
            }
            case ENHANCED_FOR_LOOP: {
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), (int)this.sp.getEndPosition(this.cut, ((EnhancedForLoopTree)last).getExpression()), currentIndent);
                break;
            }
            case FOR_LOOP: {
                LinkedList<Tree> forTrees = new LinkedList<Tree>();
                for (StatementTree statementTree : ((ForLoopTree)last).getInitializer()) {
                    if (this.sp.getEndPosition(this.cut, statementTree) > (long)startOffset) break;
                    forTrees.add(statementTree);
                }
                ExpressionTree expressionTree = ((ForLoopTree)last).getCondition();
                if (expressionTree != null && this.sp.getEndPosition(this.cut, expressionTree) <= (long)startOffset) {
                    forTrees.add(expressionTree);
                }
                for (ExpressionStatementTree expressionStatementTree : ((ForLoopTree)last).getUpdate()) {
                    if (this.sp.getEndPosition(this.cut, expressionStatementTree) > (long)startOffset) break;
                    forTrees.add(expressionStatementTree);
                }
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token != null && token.token().id() == JavaTokenId.SEMICOLON) {
                    currentIndent = this.getMultilineIndent(forTrees, path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineFor(), true);
                    break;
                }
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), forTrees.isEmpty() ? lastPos : (int)this.sp.getEndPosition(this.cut, (Tree)forTrees.getLast()), currentIndent);
                break;
            }
            case IF: {
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                if (token != null && token.token().id() == JavaTokenId.ELSE || (token = this.findFirstNonWhitespaceToken(startOffset, lastPos)) == null || EnumSet.of(JavaTokenId.RBRACE, JavaTokenId.SEMICOLON).contains(token.token().id())) break;
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN, JavaTokenId.ELSE), (int)this.sp.getEndPosition(this.cut, ((IfTree)last).getCondition()) - 1, currentIndent);
                break;
            }
            case SYNCHRONIZED: {
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), (int)this.sp.getEndPosition(this.cut, ((SynchronizedTree)last).getExpression()) - 1, currentIndent);
                break;
            }
            case TRY: {
                void var14_44;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                if (token != null && EnumSet.of(JavaTokenId.CATCH, JavaTokenId.FINALLY).contains(token.token().id()) || (token = this.findFirstNonWhitespaceToken(startOffset, lastPos)) == null || token.token().id() == JavaTokenId.RBRACE) break;
                Object var14_43 = null;
                for (Tree tree : ((TryTree)last).getResources()) {
                    if (this.sp.getEndPosition(this.cut, tree) > (long)startOffset) break;
                    Tree tree2 = tree;
                }
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.TRY, JavaTokenId.RPAREN, JavaTokenId.FINALLY), var14_44 != null ? (int)this.sp.getEndPosition(this.cut, (Tree)var14_44) : lastPos, currentIndent);
                break;
            }
            case CATCH: {
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), lastPos, currentIndent);
                break;
            }
            case WHILE_LOOP: {
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), (int)this.sp.getEndPosition(this.cut, ((WhileLoopTree)last).getCondition()) - 1, currentIndent);
                break;
            }
            case BLOCK: {
                int n;
                JavaTokenId nextTokenId;
                TokenSequence<JavaTokenId> token;
                boolean bl = ((BlockTree)last).isStatic();
                if (bl && (token = this.findFirstNonWhitespaceToken(startOffset, lastPos)) != null && token.token().id() == JavaTokenId.STATIC && token.offset() == lastPos) {
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId javaTokenId = nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (nextTokenId == null || nextTokenId != JavaTokenId.RBRACE) {
                    void var14_47;
                    boolean bl2;
                    Object var14_46 = null;
                    boolean bl3 = false;
                    for (StatementTree statementTree : ((BlockTree)last).getStatements()) {
                        if (this.sp.getEndPosition(this.cut, statementTree) > (long)startOffset) {
                            bl2 = statementTree.getKind() == Tree.Kind.LABELED_STATEMENT;
                            break;
                        }
                        StatementTree statementTree2 = statementTree;
                    }
                    if (bl2 && this.cs.absoluteLabelIndent()) {
                        currentIndent = 0;
                    } else if (var14_47 != null) {
                        int n2 = this.getCurrentIndent((Tree)var14_47);
                        currentIndent = n2 < 0 ? currentIndent + this.cs.getIndentSize() : n2;
                    } else if (bl) {
                        currentIndent += this.cs.getIndentSize();
                    } else if (this.isLeftBraceOnNewLine(lastPos, startOffset)) {
                        switch (path.get(1).getKind() == Tree.Kind.METHOD ? this.cs.getMethodDeclBracePlacement() : this.cs.getOtherBracePlacement()) {
                            case SAME_LINE: 
                            case NEW_LINE: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() - this.cs.getIndentSize() / 2;
                            }
                        }
                    } else {
                        int n3 = this.getCurrentIndent(path.get(1));
                        currentIndent = (n3 < 0 ? currentIndent : n3) + this.cs.getIndentSize();
                    }
                    if (nextTokenId != null && nextTokenId == JavaTokenId.LBRACE) {
                        switch (this.cs.getOtherBracePlacement()) {
                            case NEW_LINE_INDENTED: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() / 2;
                            }
                        }
                    }
                    break;
                }
                if (bl) {
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                if (this.isLeftBraceOnNewLine(lastPos, startOffset) || (n = this.getCurrentIndent(path.get(1))) < 0) break;
                currentIndent = n;
                break;
            }
            case SWITCH: {
                void var14_50;
                JavaTokenId nextTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId javaTokenId = nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (nextTokenId != null && nextTokenId == JavaTokenId.RBRACE) {
                    if (!this.isLeftBraceOnNewLine(lastPos, startOffset)) break;
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                Object var14_49 = null;
                for (CaseTree caseTree : ((SwitchTree)last).getCases()) {
                    if (this.sp.getEndPosition(this.cut, caseTree) > (long)startOffset) break;
                    CaseTree caseTree2 = caseTree;
                }
                if (var14_50 != null) {
                    int n = this.getCurrentIndent((Tree)var14_50);
                    int n4 = n < 0 ? currentIndent + (this.cs.indentCasesFromSwitch() ? this.cs.getIndentSize() : 0) : (currentIndent = n);
                    if (nextTokenId != null && EnumSet.of(JavaTokenId.CASE, JavaTokenId.DEFAULT).contains(nextTokenId)) break;
                    currentIndent += this.cs.getIndentSize();
                    break;
                }
                token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token != null && token.token().id() == JavaTokenId.LBRACE) {
                    currentIndent += this.cs.indentCasesFromSwitch() ? this.cs.getIndentSize() : 0;
                    break;
                }
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.RPAREN), (int)this.sp.getEndPosition(this.cut, ((SwitchTree)last).getExpression()) - 1, currentIndent);
                break;
            }
            case CASE: {
                void var14_53;
                Object var14_52 = null;
                for (StatementTree statementTree : ((CaseTree)last).getStatements()) {
                    if (this.sp.getEndPosition(this.cut, statementTree) > (long)startOffset) break;
                    StatementTree statementTree3 = statementTree;
                }
                if (var14_53 != null) {
                    int n = this.getCurrentIndent((Tree)var14_53);
                    currentIndent = n < 0 ? this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.COLON), (int)this.sp.getEndPosition(this.cut, ((CaseTree)last).getExpression()), currentIndent) : n;
                    break;
                }
                currentIndent = this.getStmtIndent(startOffset, endOffset, EnumSet.of(JavaTokenId.COLON), (int)this.sp.getEndPosition(this.cut, ((CaseTree)last).getExpression()), currentIndent);
                break;
            }
            case NEW_ARRAY: {
                JavaTokenId prevTokenId;
                JavaTokenId nextTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId javaTokenId = nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (nextTokenId == JavaTokenId.RBRACE) break;
                token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                JavaTokenId javaTokenId3 = prevTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (prevTokenId == null) break;
                switch (prevTokenId) {
                    case LBRACE: {
                        currentIndent += this.cs.getIndentSize();
                        break block0;
                    }
                    case COMMA: {
                        currentIndent = this.getMultilineIndent(((NewArrayTree)last).getInitializers(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineArrayInit(), false);
                        break block0;
                    }
                    case RBRACKET: {
                        if (nextTokenId != JavaTokenId.LBRACE) break;
                        switch (this.cs.getOtherBracePlacement()) {
                            case NEW_LINE_INDENTED: {
                                currentIndent += this.cs.getIndentSize();
                                break;
                            }
                            case NEW_LINE_HALF_INDENTED: {
                                currentIndent += this.cs.getIndentSize() / 2;
                            }
                        }
                        break block0;
                    }
                }
                currentIndent += this.cs.getContinuationIndentSize();
                break;
            }
            case NEW_CLASS: {
                JavaTokenId prevTokenId;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
                JavaTokenId nextTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                JavaTokenId javaTokenId = prevTokenId = token != null ? (JavaTokenId)token.token().id() : null;
                if (prevTokenId == JavaTokenId.RPAREN && nextTokenId == JavaTokenId.LBRACE) {
                    switch (this.cs.getOtherBracePlacement()) {
                        case NEW_LINE_INDENTED: {
                            currentIndent += this.cs.getIndentSize();
                            break;
                        }
                        case NEW_LINE_HALF_INDENTED: {
                            currentIndent += this.cs.getIndentSize() / 2;
                        }
                    }
                    break;
                }
                currentIndent = this.getContinuationIndent(path, currentIndent);
                break;
            }
            case METHOD_INVOCATION: {
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token != null && token.token().id() == JavaTokenId.COMMA) {
                    currentIndent = this.getMultilineIndent(((MethodInvocationTree)last).getArguments(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineCallArgs(), true);
                    break;
                }
                currentIndent = this.getContinuationIndent(path, currentIndent);
                break;
            }
            case ANNOTATION: {
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token != null && token.token().id() == JavaTokenId.COMMA) {
                    currentIndent = this.getMultilineIndent(((AnnotationTree)last).getArguments(), path, token.offset(), lastLineStartOffset, currentIndent, this.cs.alignMultilineAnnotationArgs(), true);
                    break;
                }
                currentIndent = this.getContinuationIndent(path, currentIndent);
                break;
            }
            case LABELED_STATEMENT: {
                void var14_56;
                Tree tree;
                TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, lastPos);
                if (token == null || token.token().id() != JavaTokenId.COLON) {
                    currentIndent = this.getContinuationIndent(path, currentIndent);
                    break;
                }
                if (!this.cs.absoluteLabelIndent() || (tree = path.get(1)).getKind() != Tree.Kind.BLOCK) break;
                Object var14_55 = null;
                for (StatementTree statementTree : ((BlockTree)tree).getStatements()) {
                    if (this.sp.getEndPosition(this.cut, statementTree) > (long)startOffset) break;
                    StatementTree statementTree4 = statementTree;
                }
                if (var14_56 != null) {
                    int n = this.getCurrentIndent((Tree)var14_56);
                    currentIndent = n < 0 ? currentIndent + this.cs.getIndentSize() : n;
                    break;
                }
                int n = this.getCurrentIndent(tree);
                currentIndent = (n < 0 ? currentIndent : n) + this.cs.getIndentSize();
                break;
            }
            default: {
                currentIndent = this.getContinuationIndent(path, currentIndent);
            }
        }
        return currentIndent;
    }

    private int getEmbeddedOffset(int offset) {
        return this.currentEmbedding != null ? this.currentEmbedding.getSnapshot().getEmbeddedOffset(offset) : offset;
    }

    private int getOriginalOffset(int offset) {
        return this.currentEmbedding != null ? this.currentEmbedding.getSnapshot().getOriginalOffset(offset) : offset;
    }

    private LinkedList<? extends Tree> getPath(int startOffset) {
        final LinkedList path = new LinkedList();
        if (this.ts.move(startOffset) == 0 && startOffset > 0 || !this.ts.moveNext()) {
            this.ts.movePrevious();
        }
        final int offset = this.ts.token().id() == JavaTokenId.IDENTIFIER || ((JavaTokenId)this.ts.token().id()).primaryCategory().startsWith("keyword") || ((JavaTokenId)this.ts.token().id()).primaryCategory().startsWith("string") || ((JavaTokenId)this.ts.token().id()).primaryCategory().equals("literal") ? this.ts.offset() : startOffset;
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree node, Void p) {
                if (node != null && Reindenter.this.sp.getStartPosition(Reindenter.this.cut, node) < (long)offset && Reindenter.this.sp.getEndPosition(Reindenter.this.cut, node) >= (long)offset) {
                    super.scan(node, p);
                    if (node.getKind() != Tree.Kind.ERRONEOUS || !path.isEmpty()) {
                        path.add(node);
                    }
                }
                return null;
            }
        }.scan((Tree)this.cut, (Void)null);
        if (path.isEmpty() || path.getFirst() == this.cut || this.sp.getEndPosition(this.cut, (Tree)path.getFirst()) > (long)offset) {
            return path;
        }
        if (!path.isEmpty() && this.ts.move(offset) == 0 && this.ts.movePrevious()) {
            switch ((JavaTokenId)this.ts.token().id()) {
                case RPAREN: {
                    if (EnumSet.of(Tree.Kind.ENHANCED_FOR_LOOP, new Tree.Kind[]{Tree.Kind.FOR_LOOP, Tree.Kind.IF, Tree.Kind.WHILE_LOOP, Tree.Kind.DO_WHILE_LOOP, Tree.Kind.TYPE_CAST, Tree.Kind.SYNCHRONIZED}).contains((Object)((Tree)path.getFirst()).getKind())) break;
                    path.removeFirst();
                    break;
                }
                case GT: 
                case GTGT: 
                case GTGTGT: {
                    if (EnumSet.of(Tree.Kind.MEMBER_SELECT, Tree.Kind.CLASS, Tree.Kind.GREATER_THAN).contains((Object)((Tree)path.getFirst()).getKind())) break;
                }
                case SEMICOLON: {
                    if (((Tree)path.getFirst()).getKind() == Tree.Kind.FOR_LOOP && (long)this.ts.offset() <= this.sp.getStartPosition(null, ((ForLoopTree)path.getFirst()).getUpdate().get(0))) break;
                }
                case RBRACE: {
                    path.removeFirst();
                    switch (((Tree)path.getFirst()).getKind()) {
                        case CATCH: {
                            path.removeFirst();
                        }
                        case METHOD: 
                        case ENHANCED_FOR_LOOP: 
                        case FOR_LOOP: 
                        case IF: 
                        case SYNCHRONIZED: 
                        case TRY: 
                        case WHILE_LOOP: {
                            path.removeFirst();
                        }
                    }
                }
            }
        }
        return path;
    }

    private TokenSequence<JavaTokenId> findFirstNonWhitespaceToken(int startOffset, int endOffset) {
        boolean backward;
        if (startOffset == endOffset) {
            return null;
        }
        this.ts.move(startOffset);
        boolean bl = backward = startOffset > endOffset;
        block3: while (backward ? this.ts.movePrevious() : this.ts.moveNext()) {
            if (backward && this.ts.offset() < endOffset || !backward && this.ts.offset() > endOffset) {
                return null;
            }
            switch ((JavaTokenId)this.ts.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: 
                case JAVADOC_COMMENT: {
                    continue block3;
                }
            }
            return this.ts;
        }
        return null;
    }

    private boolean isLeftBraceOnNewLine(int startOffset, int endOffset) {
        this.ts.move(startOffset);
        while (this.ts.moveNext()) {
            if (this.ts.offset() >= endOffset) {
                return false;
            }
            if (this.ts.token().id() != JavaTokenId.LBRACE) continue;
            if (!this.ts.movePrevious()) {
                return false;
            }
            return this.ts.token().id() == JavaTokenId.LINE_COMMENT || this.ts.token().id() == JavaTokenId.WHITESPACE && ((Object)this.ts.token().text()).toString().indexOf(10) >= 0;
        }
        return false;
    }

    private int getColumn(Tree tree) throws BadLocationException {
        int startOffset = this.getOriginalOffset((int)this.sp.getStartPosition(this.cut, tree));
        if (startOffset < 0) {
            return -1;
        }
        int lineStartOffset = this.context.lineStartOffset(startOffset);
        return this.getCol(this.context.document().getText(lineStartOffset, startOffset - lineStartOffset));
    }

    private int getCurrentIndent(Tree tree) throws BadLocationException {
        int startOffset = this.getOriginalOffset((int)this.sp.getStartPosition(this.cut, tree));
        if (startOffset < 0) {
            return -1;
        }
        int lineStartOffset = this.context.lineStartOffset(startOffset);
        Integer newIndent = this.newIndents.get(lineStartOffset);
        return newIndent != null ? newIndent.intValue() : this.context.lineIndent(lineStartOffset);
    }

    private int getContinuationIndent(LinkedList<? extends Tree> path, int currentIndent) throws BadLocationException {
        for (Tree tree : path) {
            switch (tree.getKind()) {
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: 
                case METHOD: 
                case VARIABLE: 
                case DO_WHILE_LOOP: 
                case ENHANCED_FOR_LOOP: 
                case FOR_LOOP: 
                case IF: 
                case SYNCHRONIZED: 
                case TRY: 
                case WHILE_LOOP: 
                case BLOCK: 
                case SWITCH: 
                case LABELED_STATEMENT: 
                case RETURN: 
                case THROW: 
                case EXPRESSION_STATEMENT: 
                case ASSERT: 
                case CONTINUE: 
                case BREAK: 
                case EMPTY_STATEMENT: {
                    int i = this.getCurrentIndent(tree);
                    return (i < 0 ? currentIndent : i) + this.cs.getContinuationIndentSize();
                }
                case ASSIGNMENT: 
                case MULTIPLY_ASSIGNMENT: 
                case DIVIDE_ASSIGNMENT: 
                case REMAINDER_ASSIGNMENT: 
                case PLUS_ASSIGNMENT: 
                case MINUS_ASSIGNMENT: 
                case LEFT_SHIFT_ASSIGNMENT: 
                case RIGHT_SHIFT_ASSIGNMENT: 
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: 
                case AND_ASSIGNMENT: 
                case XOR_ASSIGNMENT: 
                case OR_ASSIGNMENT: {
                    if (!this.cs.alignMultilineAssignment()) break;
                    int c = this.getColumn(tree);
                    return c < 0 ? currentIndent : c;
                }
                case AND: 
                case CONDITIONAL_AND: 
                case CONDITIONAL_OR: 
                case DIVIDE: 
                case EQUAL_TO: 
                case GREATER_THAN: 
                case GREATER_THAN_EQUAL: 
                case LEFT_SHIFT: 
                case LESS_THAN: 
                case LESS_THAN_EQUAL: 
                case MINUS: 
                case MULTIPLY: 
                case NOT_EQUAL_TO: 
                case OR: 
                case PLUS: 
                case REMAINDER: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: 
                case XOR: {
                    if (!this.cs.alignMultilineBinaryOp()) break;
                    int c = this.getColumn(tree);
                    return c < 0 ? currentIndent : c;
                }
                case CONDITIONAL_EXPRESSION: {
                    if (!this.cs.alignMultilineTernaryOp()) break;
                    int c = this.getColumn(tree);
                    return c < 0 ? currentIndent : c;
                }
            }
        }
        return currentIndent + this.cs.getContinuationIndentSize();
    }

    private int getStmtIndent(int startOffset, int endOffset, Set<JavaTokenId> expectedTokenIds, int expectedTokenOffset, int currentIndent) {
        TokenSequence<JavaTokenId> token = this.findFirstNonWhitespaceToken(startOffset, expectedTokenOffset);
        if (token != null && expectedTokenIds.contains(token.token().id())) {
            token = this.findFirstNonWhitespaceToken(startOffset, endOffset);
            if (token != null && token.token().id() == JavaTokenId.LBRACE) {
                switch (this.cs.getOtherBracePlacement()) {
                    case NEW_LINE_INDENTED: {
                        currentIndent += this.cs.getIndentSize();
                        break;
                    }
                    case NEW_LINE_HALF_INDENTED: {
                        currentIndent += this.cs.getIndentSize() / 2;
                    }
                }
            } else {
                currentIndent += this.cs.getIndentSize();
            }
        } else {
            currentIndent += this.cs.getContinuationIndentSize();
        }
        return currentIndent;
    }

    private int getMultilineIndent(List<? extends Tree> trees, LinkedList<? extends Tree> path, int commaOffset, int lastLineStartOffset, int currentIndent, boolean align, boolean addContinuationIndent) throws BadLocationException {
        Integer newIndent;
        int n;
        int startOffset;
        Tree tree = null;
        Tree first = null;
        for (Tree tree2 : trees) {
            if (first == null) {
                first = tree;
            }
            if (this.sp.getEndPosition(this.cut, tree2) > (long)commaOffset) break;
            tree = tree2;
        }
        currentIndent = tree != null && this.findFirstNonWhitespaceToken(commaOffset, (int)this.sp.getEndPosition(this.cut, tree)) == null ? ((startOffset = this.getOriginalOffset((int)this.sp.getStartPosition(this.cut, align ? first : tree))) < 0 ? (addContinuationIndent ? this.getContinuationIndent(path, currentIndent) : currentIndent + this.cs.getIndentSize()) : (lastLineStartOffset != (n = this.context.lineStartOffset(startOffset)) ? ((newIndent = this.newIndents.get(n)) != null ? newIndent.intValue() : this.context.lineIndent(n)) : (align ? this.getCol(this.context.document().getText(n, startOffset - n)) : (addContinuationIndent ? this.getContinuationIndent(path, currentIndent) : currentIndent + this.cs.getIndentSize())))) : (addContinuationIndent ? this.getContinuationIndent(path, currentIndent) : currentIndent + this.cs.getIndentSize());
        return currentIndent;
    }

    private int getCol(String text) {
        int col = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\t') {
                col += this.cs.getTabSize();
                col -= col % this.cs.getTabSize();
                continue;
            }
            ++col;
        }
        return col;
    }

    public static class Factory
    implements IndentTask.Factory {
        public IndentTask createTask(org.netbeans.modules.editor.indent.spi.Context context) {
            return new Reindenter(context);
        }
    }
}

