/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.pretty.CharBuffer;
import org.netbeans.modules.java.source.pretty.DanglingElseChecker;
import org.netbeans.modules.java.source.pretty.WidthEstimator;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.CasualDiff;
import org.netbeans.modules.java.source.save.DiffContext;
import org.netbeans.modules.java.source.save.Reformatter;
import org.netbeans.modules.java.source.transform.FieldGroupTree;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Exceptions;

public final class VeryPretty
extends JCTree.Visitor {
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    private static final String REPLACEMENT = "%[a-z]*%";
    private static final String ERROR = "<error>";
    private final CodeStyle cs;
    public final CharBuffer out;
    private final Names names;
    private final CommentHandler commentHandler;
    private final Symtab symbols;
    private final Types types;
    private final TreeInfo treeinfo;
    private final WidthEstimator widthEstimator;
    private final DanglingElseChecker danglingElseChecker;
    public Name enclClassName;
    private int indentSize;
    private int prec;
    private boolean printingMethodParams;
    private DiffContext diffContext;
    private CommentHandlerService comments;
    private int fromOffset = -1;
    private int toOffset = -1;
    private boolean containsError = false;
    private boolean insideAnnotation = false;
    private final Map<Tree, ?> tree2Tag;
    private final Map<Object, int[]> tag2Span;
    private final String origText;
    private int initialOffset = 0;
    public Set<Tree> oldTrees = Collections.emptySet();
    private static final Logger LOG = Logger.getLogger(CasualDiff.class.getName());
    private boolean reallyPrintAnnotations;

    public VeryPretty(DiffContext diffContext) {
        this(diffContext, diffContext.style, null, null, null);
    }

    public VeryPretty(DiffContext diffContext, CodeStyle cs) {
        this(diffContext, cs, null, null, null);
    }

    public VeryPretty(DiffContext diffContext, CodeStyle cs, Map<Tree, ?> tree2Tag, Map<?, int[]> tag2Span, String origText) {
        this(diffContext.context, cs, tree2Tag, tag2Span, origText);
        this.diffContext = diffContext;
    }

    public VeryPretty(DiffContext diffContext, CodeStyle cs, Map<Tree, ?> tree2Tag, Map<?, int[]> tag2Span, String origText, int initialOffset) {
        this(diffContext, cs, tree2Tag, tag2Span, origText);
        this.initialOffset = initialOffset;
    }

    private VeryPretty(Context context, CodeStyle cs, Map<Tree, ?> tree2Tag, Map<?, int[]> tag2Span, String origText) {
        this.names = Names.instance(context);
        this.enclClassName = this.names.empty;
        this.commentHandler = CommentHandlerService.instance(context);
        this.symbols = Symtab.instance(context);
        this.types = Types.instance(context);
        this.treeinfo = TreeInfo.instance((Context)context);
        this.widthEstimator = new WidthEstimator(context);
        this.danglingElseChecker = new DanglingElseChecker();
        this.prec = -1;
        this.cs = cs;
        this.out = new CharBuffer(cs.getRightMargin(), cs.getTabSize(), cs.expandTabToSpaces());
        this.indentSize = cs.getIndentSize();
        this.tree2Tag = tree2Tag;
        this.tag2Span = tag2Span;
        this.origText = origText;
        this.comments = CommentHandlerService.instance(context);
    }

    public void setInitialOffset(int offset) {
        this.initialOffset = offset < 0 ? 0 : offset;
    }

    public int getInitialOffset() {
        return this.initialOffset;
    }

    public String toString() {
        return this.out.toString();
    }

    public void toLeftMargin() {
        this.out.toLeftMargin();
    }

    public void reset(int margin) {
        this.out.setLength(0);
        this.out.leftMargin = margin;
    }

    public int getIndent() {
        return this.out.leftMargin;
    }

    public void setIndent(int indent) {
        this.out.leftMargin = indent;
    }

    public int indent() {
        int old = this.out.leftMargin;
        this.out.leftMargin = old + this.indentSize;
        return old;
    }

    public void undent(int old) {
        this.out.leftMargin = old;
    }

    public void newline() {
        this.out.nlTerm();
    }

    public void blankline() {
        this.out.blanklines(1);
    }

    public int setPrec(int prec) {
        int old = this.prec;
        this.prec = prec;
        return old;
    }

    public final void print(String s) {
        if (s == null) {
            return;
        }
        this.out.append(s);
    }

    public final void print(Name n) {
        if (n == null) {
            return;
        }
        this.out.appendUtf8(n.getByteArray(), n.getByteOffset(), n.getByteLength());
    }

    public void print(JCTree t) {
        if (t == null) {
            return;
        }
        this.blankLines(t, true);
        this.toLeftMargin();
        this.printPrecedingComments(t, true);
        this.doAccept(t);
        this.printTrailingComments(t, true);
        this.blankLines(t, false);
    }

    private static int getOldPos(JCTree oldT) {
        return TreeInfo.getStartPos(oldT);
    }

    public int endPos(JCTree t) {
        return TreeInfo.getEndPos((JCTree)t, (Map)((Object)this.diffContext.origUnit.endPositions));
    }

    private void doAccept(JCTree t) {
        Object tag;
        int start = this.toString().length();
        if (!this.handlePossibleOldTrees(Collections.singletonList(t), false)) {
            if (t instanceof FieldGroupTree) {
                FieldGroupTree fgt = (FieldGroupTree)t;
                if (fgt.isEnum()) {
                    this.printEnumConstants(List.from(fgt.getVariables().toArray(new JCTree[0])), !fgt.isEnum() || fgt.moreElementsFollowEnum());
                } else {
                    boolean firstMember = true;
                    for (JCTree.JCVariableDecl var : fgt.getVariables()) {
                        this.oldTrees.remove(var);
                        assert (!VeryPretty.isEnumerator(var));
                        assert (!this.isSynthetic(var));
                        this.toColExactly(this.out.leftMargin);
                        this.printStat(var, true, firstMember);
                        this.newline();
                        firstMember = false;
                    }
                }
            } else {
                t.accept(this);
            }
        }
        int end = this.toString().length();
        Object k = tag = this.tree2Tag != null ? (Object)this.tree2Tag.get(t) : null;
        if (tag != null) {
            this.tag2Span.put(tag, new int[]{start + this.initialOffset, end + this.initialOffset});
        }
    }

    public boolean handlePossibleOldTrees(java.util.List<? extends JCTree> toPrint, boolean includeStartingComments) {
        for (JCTree jCTree : toPrint) {
            if (!this.oldTrees.contains(jCTree)) {
                return false;
            }
            if (jCTree.getKind() != Tree.Kind.ARRAY_TYPE) continue;
            return false;
        }
        JCTree firstTree = toPrint.get(0);
        JCTree jCTree = toPrint.get(toPrint.size() - 1);
        CommentSet old = this.commentHandler.getComments(firstTree);
        int realStart = includeStartingComments ? Math.min(VeryPretty.getOldPos(firstTree), CasualDiff.commentStart(old, CommentSet.RelativePosition.PRECEDING)) : VeryPretty.getOldPos(firstTree);
        final int[] realEnd = new int[]{this.endPos(jCTree)};
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree node, Void p) {
                if (node != null) {
                    CommentSetImpl old = VeryPretty.this.comments.getComments(node);
                    realEnd[0] = Math.max(realEnd[0], Math.max(CasualDiff.commentEnd(old, CommentSet.RelativePosition.INLINE), CasualDiff.commentEnd(old, CommentSet.RelativePosition.TRAILING)));
                    old.clearComments(CommentSet.RelativePosition.INLINE);
                    old.clearComments(CommentSet.RelativePosition.TRAILING);
                }
                return (Void)super.scan(node, p);
            }
        }.scan((Tree)jCTree, (Void)null);
        this.copyToIndented(realStart, realEnd[0]);
        return true;
    }

    private void copyToIndented(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to || from < 0 || to < 0) {
            LOG.log(Level.INFO, "-----\n" + this.origText + "-----\n");
            LOG.log(Level.INFO, "Illegal values: from = " + from + "; to = " + to + "." + "Please, attach your messages.log to new issue!");
            if (to >= 0) {
                this.eatChars(from - to);
            }
            return;
        }
        if (to > this.origText.length()) {
            LOG.severe("-----\n" + this.origText + "-----\n");
            throw new IllegalArgumentException("Copying to " + to + " is greater then its size (" + this.origText.length() + ").");
        }
        String text = this.origText.substring(from, to);
        if (text.contains("\n")) {
            int relativeIndent;
            int originalColumn = 0;
            int originalIndent = 0;
            int originalLeadingWhitespaceChars = 0;
            boolean originalIndented = true;
            for (int i = from - 1; i >= 0; --i) {
                if (this.origText.charAt(i) == ' ') {
                    ++originalColumn;
                    ++originalIndent;
                    ++originalLeadingWhitespaceChars;
                    continue;
                }
                if (this.origText.charAt(i) == '\t') {
                    originalColumn += this.cs.getTabSize();
                    originalIndent += this.cs.getTabSize();
                    ++originalLeadingWhitespaceChars;
                    continue;
                }
                if (this.origText.charAt(i) == '\n') break;
                ++originalColumn;
                originalIndent = 0;
                originalIndented = false;
            }
            int oldIndent = this.getIndent();
            if (text.charAt(0) == '{') {
                relativeIndent = oldIndent - originalIndent;
                this.print(text.substring(0, text.indexOf("\n") + 1));
                text = text.substring(text.indexOf("\n") + 1);
            } else if (originalIndented) {
                if (this.out.isWhitespaceLine()) {
                    text = this.origText.substring(from - originalLeadingWhitespaceChars, from) + text;
                    relativeIndent = this.getIndent() - originalColumn;
                    this.out.toLineStart();
                    this.setIndent(0);
                } else {
                    relativeIndent = this.out.col - originalColumn;
                    this.print(text.substring(0, text.indexOf("\n") + 1));
                    text = text.substring(text.indexOf("\n") + 1);
                }
            } else if (this.out.isWhitespaceLine()) {
                text = this.getIndent(originalColumn) + text;
                relativeIndent = this.getIndent() - originalColumn;
                this.out.toLineStart();
                this.setIndent(0);
            } else {
                relativeIndent = this.out.col - originalColumn;
                this.print(text.substring(0, text.indexOf("\n") + 1));
                text = text.substring(text.indexOf("\n") + 1);
            }
            boolean first = true;
            for (String l : text.split("\n")) {
                int leadingWhitespaceChars;
                if (!first) {
                    this.print("\n");
                }
                first = false;
                if (l.isEmpty()) continue;
                int currentIndent = 0;
                for (leadingWhitespaceChars = 0; leadingWhitespaceChars < l.length(); ++leadingWhitespaceChars) {
                    if (l.charAt(leadingWhitespaceChars) == ' ') {
                        ++currentIndent;
                        continue;
                    }
                    if (l.charAt(leadingWhitespaceChars) != '\t') break;
                    currentIndent += this.cs.getTabSize();
                }
                this.print(this.getIndent(currentIndent + relativeIndent));
                this.print(l.substring(leadingWhitespaceChars));
            }
            this.setIndent(oldIndent);
        } else {
            if (this.out.isWhitespaceLine()) {
                this.toLeftMargin();
            }
            this.print(text);
        }
    }

    private String getIndent(int indent) {
        StringBuilder sb = new StringBuilder();
        int col = 0;
        if (!this.cs.expandTabToSpaces()) {
            int tabSize = this.cs.getTabSize();
            while (col + tabSize <= indent) {
                sb.append('\t');
                col += tabSize;
            }
        }
        while (col < indent) {
            sb.append(' ');
            ++col;
        }
        return sb.toString();
    }

    public String reformat(JCTree t, int fromOffset, int toOffset, int indent) {
        this.reset(indent);
        this.fromOffset = fromOffset;
        this.toOffset = toOffset;
        this.print(t);
        return this.containsError ? null : this.out.toString();
    }

    public void printPackage(JCTree.JCExpression pid) {
        if (pid != null) {
            this.blankLines(this.cs.getBlankLinesBeforePackage());
            this.print("package ");
            this.printExpr(pid);
            this.print(';');
            this.blankLines(this.cs.getBlankLinesAfterPackage());
        }
    }

    public String getMethodHeader(MethodTree t, String s) {
        JCTree.JCMethodDecl tree = (JCTree.JCMethodDecl)t;
        this.printAnnotations(tree.mods.annotations);
        s = this.replace(s, "%annotations");
        this.printFlags(tree.mods.flags);
        s = this.replace(s, "%flags%");
        if (tree.name == this.names.init) {
            this.print(this.enclClassName);
            s = this.replace(s, "%name%");
        } else {
            if (tree.typarams != null) {
                this.printTypeParameters(tree.typarams);
                this.needSpace();
                s = this.replace(s, "%typeparameters%");
            }
            this.print(tree.restype);
            s = this.replace(s, "%type%");
            this.out.clear();
            this.print(tree.name);
            s = this.replace(s, "%name%");
        }
        this.print('(');
        this.wrapTrees(tree.params, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
        this.print(')');
        s = this.replace(s, "%parameters%");
        if (tree.thrown.nonEmpty()) {
            this.print(" throws ");
            this.wrapTrees(tree.thrown, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
            s = this.replace(s, "%throws%");
        }
        return s.replaceAll(REPLACEMENT, "");
    }

    public String getClassHeader(ClassTree t, String s) {
        JCTree.JCClassDecl tree = (JCTree.JCClassDecl)t;
        this.printAnnotations(tree.mods.annotations);
        s = this.replace(s, "%annotations");
        long flags = tree.mods.flags;
        if ((flags & 0x4000L) != 0L) {
            this.printFlags(flags & 0xFFFFFFFFFFFFFDEFL);
        } else {
            this.printFlags(flags & 0xFFFFFFFFFFFFF9FFL);
        }
        s = this.replace(s, "%flags%");
        if ((flags & 0x200L) != 0L) {
            this.print("interface ");
            this.print(tree.name);
            s = this.replace(s, "%name%");
            this.printTypeParameters(tree.typarams);
            s = this.replace(s, "%typeparameters%");
            if (tree.implementing.nonEmpty()) {
                this.print(" extends ");
                this.wrapTrees(tree.implementing, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
                s = this.replace(s, "%extends%");
            }
        } else {
            if ((flags & 0x4000L) != 0L) {
                this.print("enum ");
            } else {
                if ((flags & 0x400L) != 0L) {
                    this.print("abstract ");
                }
                this.print("class ");
            }
            this.print(tree.name);
            s = this.replace(s, "%name%");
            this.printTypeParameters(tree.typarams);
            s = this.replace(s, "%typeparameters%");
            if (tree.extending != null) {
                this.print(" extends ");
                this.print(tree.extending);
                s = this.replace(s, "%extends%");
            }
            if (tree.implementing.nonEmpty()) {
                this.print(" implements ");
                this.wrapTrees(tree.implementing, CodeStyle.WrapStyle.WRAP_NEVER, this.out.col);
                s = this.replace(s, "%implements%");
            }
        }
        return s.replaceAll(REPLACEMENT, "");
    }

    public String getVariableHeader(VariableTree t, String s) {
        JCTree.JCVariableDecl tree = (JCTree.JCVariableDecl)t;
        this.printAnnotations(tree.mods.annotations);
        s = this.replace(s, "%annotations");
        this.printFlags(tree.mods.flags);
        s = this.replace(s, "%flags%");
        this.print(tree.vartype);
        s = this.replace(s, "%type%");
        this.needSpace();
        this.print(tree.name);
        s = this.replace(s, "%name%");
        return s.replaceAll(REPLACEMENT, "");
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        this.printAnnotations((List<JCTree.JCAnnotation>)tree.getPackageAnnotations());
        this.printPackage(tree.pid);
        List<JCTree> l = tree.defs;
        ArrayList<JCTree.JCImport> imports = new ArrayList<JCTree.JCImport>();
        while (l.nonEmpty() && ((JCTree)l.head).getTag() == 2) {
            imports.add((JCTree.JCImport)l.head);
            l = l.tail;
        }
        this.printImportsBlock(imports, !l.isEmpty());
        while (l.nonEmpty()) {
            this.printStat((JCTree)l.head, true, false);
            this.newline();
            l = l.tail;
        }
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        this.print("import ");
        if (tree.staticImport) {
            this.print("static ");
        }
        this.print(this.fullName(tree.qualid));
        this.print(';');
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        int bcol;
        int old;
        Name enclClassNamePrev;
        block28: {
            block25: {
                enclClassNamePrev = this.enclClassName;
                this.enclClassName = tree.name;
                this.toLeftMargin();
                this.printAnnotations(tree.mods.annotations);
                long flags = tree.mods.flags;
                if ((flags & 0x4000L) != 0L) {
                    this.printFlags(flags & 0xFFFFFFFFFFFFFDEFL);
                } else {
                    this.printFlags(flags & 0xFFFFFFFFFFFFF9FFL);
                }
                if ((flags & 0x200L) != 0L || (flags & 0x2000L) != 0L) {
                    if ((flags & 0x2000L) != 0L) {
                        this.print('@');
                    }
                    this.print("interface ");
                    this.print(tree.name);
                    this.printTypeParameters(tree.typarams);
                    if (tree.implementing.nonEmpty()) {
                        this.wrap("extends ", this.cs.wrapExtendsImplementsKeyword());
                        this.wrapTrees(tree.implementing, this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    }
                } else {
                    if ((flags & 0x4000L) != 0L) {
                        this.print("enum ");
                    } else {
                        if ((flags & 0x400L) != 0L) {
                            this.print("abstract ");
                        }
                        this.print("class ");
                    }
                    this.print(tree.name);
                    this.printTypeParameters(tree.typarams);
                    if (tree.extending != null) {
                        this.wrap("extends ", this.cs.wrapExtendsImplementsKeyword());
                        this.print(tree.extending);
                    }
                    if (tree.implementing.nonEmpty()) {
                        this.wrap("implements ", this.cs.wrapExtendsImplementsKeyword());
                        this.wrapTrees(tree.implementing, this.cs.wrapExtendsImplementsList(), this.cs.alignMultilineImplements() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    }
                }
                bcol = old = this.cs.indentTopLevelClassMembers() ? this.indent() : this.out.leftMargin;
                switch (this.cs.getClassDeclBracePlacement()) {
                    case NEW_LINE: {
                        this.newline();
                        this.toColExactly(old);
                        break;
                    }
                    case NEW_LINE_HALF_INDENTED: {
                        this.newline();
                        this.toColExactly(bcol += this.indentSize >> 1);
                        break;
                    }
                    case NEW_LINE_INDENTED: {
                        this.newline();
                        bcol = this.out.leftMargin;
                        this.toColExactly(bcol);
                    }
                }
                if (this.cs.spaceBeforeClassDeclLeftBrace()) {
                    this.needSpace();
                }
                this.print('{');
                boolean emptyClass = true;
                List<JCTree> l = tree.defs;
                while (l.nonEmpty()) {
                    if (!this.isSynthetic((JCTree)l.head)) {
                        emptyClass = false;
                        break;
                    }
                    l = l.tail;
                }
                if (emptyClass) break block25;
                this.blankLines(this.enclClassName.isEmpty() ? this.cs.getBlankLinesAfterAnonymousClassHeader() : this.cs.getBlankLinesAfterClassHeader());
                if ((tree.mods.flags & 0x4000L) != 0L) {
                    this.printEnumConstants(tree.defs, false);
                }
                boolean firstMember = true;
                List<JCTree> l2 = tree.defs;
                while (l2.nonEmpty()) {
                    block27: {
                        block26: {
                            JCTree t = (JCTree)l2.head;
                            if (VeryPretty.isEnumerator(t)) break block26;
                            if (this.isSynthetic(t)) break block27;
                            this.toColExactly(this.out.leftMargin);
                            this.printStat(t, true, firstMember);
                            this.newline();
                        }
                        firstMember = false;
                    }
                    l2 = l2.tail;
                }
                this.blankLines(this.enclClassName.isEmpty() ? this.cs.getBlankLinesBeforeAnonymousClassClosingBrace() : this.cs.getBlankLinesBeforeClassClosingBrace());
                break block28;
            }
            this.printEmptyBlockComments(tree, false);
        }
        this.toColExactly(bcol);
        this.undent(old);
        this.print('}');
        this.enclClassName = enclClassNamePrev;
    }

    private void printEnumConstants(List<JCTree> defs, boolean forceSemicolon) {
        boolean first = true;
        boolean hasNonEnumerator = false;
        List<JCTree> l = defs;
        while (l.nonEmpty()) {
            if (VeryPretty.isEnumerator((JCTree)l.head)) {
                if (first) {
                    this.toColExactly(this.out.leftMargin);
                    first = false;
                } else {
                    this.print(this.cs.spaceBeforeComma() ? " ," : ",");
                    switch (this.cs.wrapEnumConstants()) {
                        case WRAP_IF_LONG: {
                            int rm = this.cs.getRightMargin();
                            if (this.widthEstimator.estimateWidth((JCTree)l.head, rm - this.out.col) + this.out.col + 1 <= rm) {
                                if (!this.cs.spaceAfterComma()) break;
                                this.print(' ');
                                break;
                            }
                        }
                        case WRAP_ALWAYS: {
                            this.newline();
                            this.toColExactly(this.out.leftMargin);
                            break;
                        }
                        case WRAP_NEVER: {
                            if (!this.cs.spaceAfterComma()) break;
                            this.print(' ');
                        }
                    }
                }
                this.printStat((JCTree)l.head, true, false);
            } else if (!this.isSynthetic((JCTree)l.head)) {
                hasNonEnumerator = true;
            }
            l = l.tail;
        }
        if (hasNonEnumerator || forceSemicolon) {
            this.print(";");
            this.newline();
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if ((tree.mods.flags & 0x1000L) == 0L && tree.name != this.names.init || this.enclClassName != null) {
            Name enclClassNamePrev = this.enclClassName;
            this.enclClassName = null;
            this.printAnnotations(tree.mods.annotations);
            this.printFlags(tree.mods.flags);
            if (tree.typarams != null) {
                this.printTypeParameters(tree.typarams);
                this.needSpace();
            }
            if (tree.name == this.names.init || tree.name.contentEquals(enclClassNamePrev)) {
                this.print(enclClassNamePrev);
            } else {
                this.print(tree.restype);
                this.needSpace();
                this.print(tree.name);
            }
            this.print(this.cs.spaceBeforeMethodDeclParen() ? " (" : "(");
            if (this.cs.spaceWithinMethodDeclParens() && tree.params.nonEmpty()) {
                this.print(' ');
            }
            boolean oldPrintingMethodParams = this.printingMethodParams;
            this.printingMethodParams = true;
            this.wrapTrees(tree.params, this.cs.wrapMethodParams(), this.cs.alignMultilineMethodParams() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize(), true);
            this.printingMethodParams = oldPrintingMethodParams;
            if (this.cs.spaceWithinMethodDeclParens() && tree.params.nonEmpty()) {
                this.needSpace();
            }
            this.print(')');
            if (tree.thrown.nonEmpty()) {
                this.wrap("throws ", this.cs.wrapThrowsKeyword());
                this.wrapTrees(tree.thrown, this.cs.wrapThrowsList(), this.cs.alignMultilineThrows() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize(), true);
            }
            if (tree.body != null) {
                this.printBlock(tree.body, tree.body.stats, this.cs.getMethodDeclBracePlacement(), this.cs.spaceBeforeMethodDeclLeftBrace());
            } else {
                if (tree.defaultValue != null) {
                    this.print(" default ");
                    this.printExpr(tree.defaultValue);
                }
                this.print(';');
            }
            this.enclClassName = enclClassNamePrev;
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        boolean notEnumConst = (tree.mods.flags & 0x4000L) == 0L;
        this.printAnnotations(tree.mods.annotations);
        if (notEnumConst) {
            this.printFlags(tree.mods.flags);
            if ((tree.mods.flags & 0x400000000L) != 0L) {
                if (Tree.Kind.ARRAY_TYPE == tree.vartype.getKind()) {
                    this.printExpr(((JCTree.JCArrayTypeTree)tree.vartype).elemtype);
                } else {
                    this.printExpr(tree.vartype);
                }
                this.print("...");
            } else {
                this.print(tree.vartype);
            }
        }
        this.needSpace();
        if (!ERROR.contentEquals(tree.name)) {
            this.print(tree.name);
        }
        if (tree.init != null) {
            if (notEnumConst) {
                this.printVarInit(tree);
            } else {
                JCTree.JCNewClass newClsTree = (JCTree.JCNewClass)tree.init;
                if (newClsTree.args.nonEmpty()) {
                    this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
                    if (this.cs.spaceWithinMethodCallParens()) {
                        this.print(' ');
                    }
                    this.wrapTrees(newClsTree.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    this.print(this.cs.spaceWithinMethodCallParens() ? " )" : ")");
                }
                if (newClsTree.def != null) {
                    Name enclClassNamePrev = this.enclClassName;
                    this.enclClassName = newClsTree.def.name;
                    this.printBlock(null, newClsTree.def.defs, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeClassDeclLeftBrace());
                    this.enclClassName = enclClassNamePrev;
                }
            }
        }
        if (this.prec == -1 && notEnumConst) {
            this.print(';');
        }
    }

    public void printVarInit(final JCTree.JCVariableDecl tree) {
        int col = this.out.col;
        if (!ERROR.contentEquals(tree.name)) {
            col -= tree.name.getByteLength();
        }
        if (this.cs.spaceAroundAssignOps()) {
            this.print(' ');
        }
        this.print('=');
        this.wrapTree(this.cs.wrapAssignOps(), this.cs.spaceAroundAssignOps(), this.cs.alignMultilineAssignment() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize(), new Runnable(){

            @Override
            public void run() {
                VeryPretty.this.printNoParenExpr(tree.init);
            }
        });
    }

    @Override
    public void visitSkip(JCTree.JCSkip tree) {
        this.print(';');
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        this.printFlags(tree.flags, false);
        this.printBlock(tree, tree.stats, this.cs.getOtherBracePlacement(), (tree.flags & 8L) != 0L ? this.cs.spaceBeforeStaticInitLeftBrace() : false);
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        boolean prevblock;
        this.print("do");
        if (this.cs.spaceBeforeDoLeftBrace()) {
            this.print(' ');
        }
        this.printIndentedStat(tree.body, this.cs.redundantDoWhileBraces(), this.cs.spaceBeforeDoLeftBrace(), this.cs.wrapDoWhileStatement());
        boolean bl = prevblock = tree.body.getKind() == Tree.Kind.BLOCK || this.cs.redundantDoWhileBraces() == CodeStyle.BracesGenerationStyle.GENERATE;
        if (this.cs.placeWhileOnNewLine() || !prevblock) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeWhile()) {
            this.needSpace();
        }
        this.print("while");
        this.print(this.cs.spaceBeforeWhileParen() ? " (" : "(");
        if (this.cs.spaceWithinWhileParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.cond);
        this.print(this.cs.spaceWithinWhileParens() ? " );" : ");");
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        this.print("while");
        this.print(this.cs.spaceBeforeWhileParen() ? " (" : "(");
        if (this.cs.spaceWithinWhileParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.cond);
        this.print(this.cs.spaceWithinWhileParens() ? " )" : ")");
        this.printIndentedStat(tree.body, this.cs.redundantWhileBraces(), this.cs.spaceBeforeWhileLeftBrace(), this.cs.wrapWhileStatement());
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        this.print("for");
        this.print(this.cs.spaceBeforeForParen() ? " (" : "(");
        if (this.cs.spaceWithinForParens()) {
            this.print(' ');
        }
        int col = this.out.col;
        if (tree.init.nonEmpty()) {
            if (((JCTree.JCStatement)tree.init.head).getTag() == 5) {
                this.printNoParenExpr((JCTree)tree.init.head);
                List l = tree.init.tail;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl vdef = (JCTree.JCVariableDecl)l.head;
                    this.print(", " + vdef.name + " = ");
                    this.printNoParenExpr(vdef.init);
                    l = l.tail;
                }
            } else {
                this.printExprs(tree.init);
            }
        }
        String sep = this.cs.spaceBeforeSemi() ? " ;" : ";";
        this.print(sep);
        if (tree.cond != null) {
            switch (this.cs.wrapFor()) {
                case WRAP_IF_LONG: {
                    int rm = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(tree.cond, rm - this.out.col) + this.out.col + 1 <= rm) {
                        if (!this.cs.spaceAfterSemi()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.newline();
                    this.toColExactly(this.cs.alignMultilineFor() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterSemi()) break;
                    this.print(' ');
                }
            }
            this.printNoParenExpr(tree.cond);
        }
        this.print(sep);
        if (tree.step.nonEmpty()) {
            switch (this.cs.wrapFor()) {
                case WRAP_IF_LONG: {
                    int rm = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(tree.step, rm - this.out.col) + this.out.col + 1 <= rm) {
                        if (!this.cs.spaceAfterSemi()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.newline();
                    this.toColExactly(this.cs.alignMultilineFor() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterSemi()) break;
                    this.print(' ');
                }
            }
            this.printExprs(tree.step);
        }
        this.print(this.cs.spaceWithinForParens() ? " )" : ")");
        this.printIndentedStat(tree.body, this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        this.toColExactly(this.cs.absoluteLabelIndent() ? 0 : this.out.leftMargin);
        this.print(tree.label);
        this.print(':');
        int old = this.out.leftMargin;
        this.out.leftMargin += this.cs.getLabelIndent();
        this.toColExactly(this.out.leftMargin);
        this.printStat(tree.body);
        this.undent(old);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        this.print("switch");
        this.print(this.cs.spaceBeforeSwitchParen() ? " (" : "(");
        if (this.cs.spaceWithinSwitchParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.selector);
        this.print(this.cs.spaceWithinSwitchParens() ? " )" : ")");
        int bcol = this.out.leftMargin;
        switch (this.cs.getOtherBracePlacement()) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(bcol);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize);
            }
        }
        if (this.cs.spaceBeforeSwitchLeftBrace()) {
            this.needSpace();
        }
        this.print('{');
        if (tree.cases.nonEmpty()) {
            this.newline();
            this.printStats(tree.cases);
            this.toColExactly(bcol);
        }
        this.print('}');
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        int old = this.cs.indentCasesFromSwitch() ? this.indent() : this.out.leftMargin;
        this.toLeftMargin();
        if (tree.pat == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printNoParenExpr(tree.pat);
        }
        this.print(':');
        this.newline();
        this.indent();
        this.printStats(tree.stats);
        this.undent(old);
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        this.print("synchronized");
        this.print(this.cs.spaceBeforeSynchronizedParen() ? " (" : "(");
        if (this.cs.spaceWithinSynchronizedParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.lock);
        this.print(this.cs.spaceWithinSynchronizedParens() ? " )" : ")");
        this.printBlock((JCTree)tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeSynchronizedLeftBrace());
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        this.print("try");
        if (!((List)tree.getResources()).isEmpty()) {
            this.print(" (");
            Iterator it = ((List)tree.getResources()).iterator();
            while (it.hasNext()) {
                JCTree r = (JCTree)it.next();
                this.oldTrees.remove(r);
                this.printPrecedingComments(r, false);
                this.printExpr(r, 0);
                this.printTrailingComments(r, false);
                if (!it.hasNext()) continue;
                this.print(";");
            }
            this.print(") ");
        }
        this.printBlock((JCTree)tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeTryLeftBrace());
        List<JCTree.JCCatch> l = tree.catchers;
        while (l.nonEmpty()) {
            this.printStat((JCTree)l.head);
            l = l.tail;
        }
        if (tree.finalizer != null) {
            this.printFinallyBlock(tree.finalizer);
        }
    }

    @Override
    public void visitCatch(JCTree.JCCatch tree) {
        if (this.cs.placeCatchOnNewLine()) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeCatch()) {
            this.needSpace();
        }
        this.print("catch");
        this.print(this.cs.spaceBeforeCatchParen() ? " (" : "(");
        if (this.cs.spaceWithinCatchParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.param);
        this.print(this.cs.spaceWithinCatchParens() ? " )" : ")");
        this.printBlock((JCTree)tree.body, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeCatchLeftBrace());
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        int rm;
        this.printExpr(tree.cond, 2);
        switch (this.cs.wrapTernaryOps()) {
            case WRAP_IF_LONG: {
                rm = this.cs.getRightMargin();
                if (this.widthEstimator.estimateWidth(tree.truepart, rm - this.out.col) + this.out.col + 1 <= rm) {
                    if (!this.cs.spaceAroundTernaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundTernaryOps()) break;
                this.print(' ');
            }
        }
        this.print(this.cs.spaceAroundTernaryOps() ? "? " : "?");
        this.printExpr(tree.truepart, 3);
        switch (this.cs.wrapTernaryOps()) {
            case WRAP_IF_LONG: {
                rm = this.cs.getRightMargin();
                if (this.widthEstimator.estimateWidth(tree.falsepart, rm - this.out.col) + this.out.col + 1 <= rm) {
                    if (!this.cs.spaceAroundTernaryOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundTernaryOps()) break;
                this.print(' ');
            }
        }
        this.print(this.cs.spaceAroundTernaryOps() ? ": " : ":");
        this.printExpr(tree.falsepart, 3);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        boolean prevblock;
        this.print("if");
        this.print(this.cs.spaceBeforeIfParen() ? " (" : "(");
        if (this.cs.spaceWithinIfParens()) {
            this.print(' ');
        }
        this.printNoParenExpr(tree.cond);
        this.print(this.cs.spaceWithinIfParens() ? " )" : ")");
        boolean bl = prevblock = tree.thenpart.getKind() == Tree.Kind.BLOCK && this.cs.redundantIfBraces() != CodeStyle.BracesGenerationStyle.ELIMINATE || this.cs.redundantIfBraces() == CodeStyle.BracesGenerationStyle.GENERATE;
        if (tree.elsepart != null && this.danglingElseChecker.hasDanglingElse(tree.thenpart)) {
            this.printBlock((JCTree)tree.thenpart, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeIfLeftBrace());
            prevblock = true;
        } else {
            this.printIndentedStat(tree.thenpart, this.cs.redundantIfBraces(), this.cs.spaceBeforeIfLeftBrace(), this.cs.wrapIfStatement());
        }
        if (tree.elsepart != null) {
            this.printElse(tree, prevblock);
        }
    }

    public void printElse(JCTree.JCIf tree, boolean prevblock) {
        if (this.cs.placeElseOnNewLine() || !prevblock) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeElse()) {
            this.needSpace();
        }
        this.print("else");
        if (tree.elsepart.getKind() == Tree.Kind.IF && this.cs.specialElseIf()) {
            this.needSpace();
            this.printStat(tree.elsepart);
        } else {
            this.printIndentedStat(tree.elsepart, this.cs.redundantIfBraces(), this.cs.spaceBeforeElseLeftBrace(), this.cs.wrapIfStatement());
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        this.printNoParenExpr(tree.expr);
        if (this.prec == -1) {
            this.print(';');
        }
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        this.print("break");
        if (tree.label != null) {
            this.needSpace();
            this.print(tree.label);
        }
        this.print(';');
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
        this.print("continue");
        if (tree.label != null) {
            this.needSpace();
            this.print(tree.label);
        }
        this.print(';');
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        this.print("return");
        if (tree.expr != null) {
            this.needSpace();
            this.printNoParenExpr(tree.expr);
        }
        this.print(';');
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        this.print("throw ");
        this.printNoParenExpr(tree.expr);
        this.print(';');
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        this.print("assert ");
        this.printExpr(tree.cond);
        if (tree.detail != null) {
            this.print(this.cs.spaceBeforeColon() ? " :" : ":");
            switch (this.cs.wrapAssert()) {
                case WRAP_IF_LONG: {
                    int rm = this.cs.getRightMargin();
                    if (this.widthEstimator.estimateWidth(tree.detail, rm - this.out.col) + this.out.col + 1 <= rm) {
                        if (!this.cs.spaceAfterColon()) break;
                        this.print(' ');
                        break;
                    }
                }
                case WRAP_ALWAYS: {
                    this.newline();
                    this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                    break;
                }
                case WRAP_NEVER: {
                    if (!this.cs.spaceAfterColon()) break;
                    this.print(' ');
                }
            }
            this.printExpr(tree.detail);
        }
        this.print(';');
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        int prevPrec = this.prec;
        this.prec = 15;
        this.printMethodSelect(tree);
        this.prec = prevPrec;
        this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
        if (this.cs.spaceWithinMethodCallParens() && tree.args.nonEmpty()) {
            this.print(' ');
        }
        this.wrapTrees(tree.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        this.print(this.cs.spaceWithinMethodCallParens() && tree.args.nonEmpty() ? " )" : ")");
    }

    public void printMethodSelect(JCTree.JCMethodInvocation tree) {
        if (tree.meth.getTag() == 34) {
            JCTree.JCFieldAccess left = (JCTree.JCFieldAccess)tree.meth;
            this.printExpr(left.selected);
            this.print('.');
            if (left.selected.getTag() == 26) {
                switch (this.cs.wrapChainedMethodCalls()) {
                    case WRAP_IF_LONG: {
                        int rm = this.cs.getRightMargin();
                        int estWidth = left.name.length();
                        if (tree.typeargs.nonEmpty()) {
                            estWidth += this.widthEstimator.estimateWidth(tree.typeargs, rm - this.out.col - estWidth) + 2;
                        }
                        if ((estWidth += this.widthEstimator.estimateWidth(tree.args, rm - this.out.col - estWidth) + 2) + this.out.col <= rm) break;
                    }
                    case WRAP_ALWAYS: {
                        this.newline();
                        this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                    }
                }
            }
            if (tree.typeargs.nonEmpty()) {
                this.printTypeArguments(tree.typeargs);
            }
            this.print(left.name);
        } else {
            if (tree.typeargs.nonEmpty()) {
                this.printTypeArguments(tree.typeargs);
            }
            this.printExpr(tree.meth);
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        if (tree.encl != null) {
            this.printExpr(tree.encl);
            this.print('.');
        }
        this.print("new ");
        if (tree.typeargs.nonEmpty()) {
            this.print("<");
            this.printExprs(tree.typeargs);
            this.print(">");
        }
        if (tree.encl == null) {
            this.print(tree.clazz);
        } else if (tree.clazz.type != null) {
            this.print(tree.clazz.type.tsym.name);
        } else {
            this.print(tree.clazz);
        }
        this.print(this.cs.spaceBeforeMethodCallParen() ? " (" : "(");
        if (this.cs.spaceWithinMethodCallParens() && tree.args.nonEmpty()) {
            this.print(' ');
        }
        this.wrapTrees(tree.args, this.cs.wrapMethodCallArgs(), this.cs.alignMultilineCallArgs() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
        this.print(this.cs.spaceWithinMethodCallParens() && tree.args.nonEmpty() ? " )" : ")");
        if (tree.def != null) {
            this.printNewClassBody(tree);
        }
    }

    public void printNewClassBody(JCTree.JCNewClass tree) {
        Name enclClassNamePrev = this.enclClassName;
        this.enclClassName = tree.def.name;
        this.printBlock(null, tree.def.defs, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeClassDeclLeftBrace(), true);
        this.enclClassName = enclClassNamePrev;
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        if (tree.elemtype != null) {
            this.print("new ");
            int n = tree.elems != null ? 1 : 0;
            JCTree.JCExpression elemtype = tree.elemtype;
            while (elemtype.getTag() == 38) {
                ++n;
                elemtype = ((JCTree.JCArrayTypeTree)elemtype).elemtype;
            }
            this.printExpr(elemtype);
            List<JCTree.JCExpression> l = tree.dims;
            while (l.nonEmpty()) {
                this.print(this.cs.spaceWithinArrayInitBrackets() ? "[ " : "[");
                this.printNoParenExpr((JCTree)l.head);
                this.print(this.cs.spaceWithinArrayInitBrackets() ? " ]" : "]");
                l = l.tail;
            }
            while (--n >= 0) {
                this.print(this.cs.spaceWithinArrayInitBrackets() ? "[ ]" : "[]");
            }
        }
        if (tree.elems != null) {
            if (this.cs.spaceBeforeArrayInitLeftBrace()) {
                this.needSpace();
            }
            this.print('{');
            if (this.cs.spaceWithinBraces()) {
                this.print(' ');
            }
            this.wrapTrees(tree.elems, this.cs.wrapArrayInit(), this.cs.alignMultilineArrayInit() ? this.out.col : this.out.leftMargin + this.cs.getContinuationIndentSize());
            this.print(this.cs.spaceWithinBraces() ? " }" : "}");
        }
    }

    @Override
    public void visitParens(JCTree.JCParens tree) {
        this.print('(');
        if (this.cs.spaceWithinParens()) {
            this.print(' ');
        }
        this.printExpr(tree.expr);
        this.print(this.cs.spaceWithinParens() ? " )" : ")");
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        int col = this.out.col;
        this.printExpr(tree.lhs, 2);
        boolean spaceAroundAssignOps = this.cs.spaceAroundAssignOps();
        if (spaceAroundAssignOps) {
            this.print(' ');
        }
        this.print('=');
        int rm = this.cs.getRightMargin();
        switch (this.cs.wrapAssignOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(tree.rhs, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!spaceAroundAssignOps) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.cs.alignMultilineAssignment() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!spaceAroundAssignOps) break;
                this.print(' ');
            }
        }
        this.printExpr(tree.rhs, 1);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        int col = this.out.col;
        this.printExpr(tree.lhs, 3);
        if (this.cs.spaceAroundAssignOps()) {
            this.print(' ');
        }
        this.print(this.treeinfo.operatorName(tree.getTag() - 17));
        this.print('=');
        int rm = this.cs.getRightMargin();
        switch (this.cs.wrapAssignOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(tree.rhs, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!this.cs.spaceAroundAssignOps()) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.cs.alignMultilineAssignment() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!this.cs.spaceAroundAssignOps()) break;
                this.print(' ');
            }
        }
        this.printExpr(tree.rhs, 2);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        int ownprec = TreeInfo.opPrec((int)tree.getTag());
        Name opname = this.treeinfo.operatorName(tree.getTag());
        if (tree.getTag() <= 51) {
            if (this.cs.spaceAroundUnaryOps()) {
                this.needSpace();
                this.print(opname);
                this.print(' ');
            } else {
                this.print(opname);
                if (tree.getTag() == 46 && (tree.arg.getTag() == 46 || tree.arg.getTag() == 50) || tree.getTag() == 47 && (tree.arg.getTag() == 47 || tree.arg.getTag() == 51)) {
                    this.print(' ');
                }
            }
            this.printExpr(tree.arg, ownprec);
        } else {
            this.printExpr(tree.arg, ownprec);
            if (this.cs.spaceAroundUnaryOps()) {
                this.print(' ');
                this.print(opname);
                this.print(' ');
            } else {
                this.print(opname);
            }
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        int ownprec = TreeInfo.opPrec((int)tree.getTag());
        Name opname = this.treeinfo.operatorName(tree.getTag());
        int col = this.out.col;
        this.printExpr(tree.lhs, ownprec);
        if (this.cs.spaceAroundBinaryOps()) {
            this.print(' ');
        }
        this.print(opname);
        boolean needsSpace = this.cs.spaceAroundBinaryOps() || tree.getTag() == 69 && (tree.rhs.getTag() == 46 || tree.rhs.getTag() == 50) || tree.getTag() == 70 && (tree.rhs.getTag() == 47 || tree.rhs.getTag() == 51);
        int rm = this.cs.getRightMargin();
        switch (this.cs.wrapBinaryOps()) {
            case WRAP_IF_LONG: {
                if (this.widthEstimator.estimateWidth(tree.rhs, rm - this.out.col) + this.out.col <= this.cs.getRightMargin()) {
                    if (!needsSpace) break;
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.cs.alignMultilineBinaryOp() ? col : this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                if (!needsSpace) break;
                this.print(' ');
            }
        }
        this.printExpr(tree.rhs, ownprec + 1);
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        this.print(this.cs.spaceWithinTypeCastParens() ? "( " : "(");
        this.print(tree.clazz);
        this.print(this.cs.spaceWithinTypeCastParens() ? " )" : ")");
        if (this.cs.spaceAfterTypeCast()) {
            this.needSpace();
        }
        if (this.diffContext.origUnit != null && TreePath.getPath(this.diffContext.origUnit, (Tree)tree.expr) != null) {
            int a = TreeInfo.getStartPos(tree.expr);
            int b = TreeInfo.getEndPos((JCTree)tree.expr, (Map)((Object)this.diffContext.origUnit.endPositions));
            this.print(this.diffContext.origText.substring(a, b));
            return;
        }
        this.printExpr(tree.expr, 14);
    }

    @Override
    public void visitTypeUnion(JCTree.JCTypeUnion that) {
        boolean first = true;
        for (JCTree.JCExpression c : that.getTypeAlternatives()) {
            if (!first) {
                this.print(" | ");
            }
            this.print(c);
            first = false;
        }
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        this.printExpr(tree.expr, 10);
        this.print(" instanceof ");
        this.print(tree.clazz);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        this.printExpr(tree.indexed, 15);
        this.print('[');
        this.printExpr(tree.index);
        this.print(']');
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        this.printExpr(tree.selected, 15);
        this.print('.');
        this.print(tree.name);
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        this.print(tree.name);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        long end;
        long start;
        if (this.diffContext != null && this.diffContext.origUnit != null && (start = this.diffContext.trees.getSourcePositions().getStartPosition(this.diffContext.origUnit, tree)) >= 0L && (end = this.diffContext.trees.getSourcePositions().getEndPosition(this.diffContext.origUnit, tree)) >= 0L && this.origText != null) {
            this.print(this.origText.substring((int)start, (int)end));
            return;
        }
        if (this.diffContext != null && this.diffContext.mainUnit != null && (start = this.diffContext.trees.getSourcePositions().getStartPosition(this.diffContext.mainUnit, tree)) >= 0L && (end = this.diffContext.trees.getSourcePositions().getEndPosition(this.diffContext.mainUnit, tree)) >= 0L && this.diffContext.mainCode != null) {
            this.print(this.diffContext.mainCode.substring((int)start, (int)end));
            return;
        }
        switch (tree.typetag) {
            case 4: {
                this.print(tree.value.toString());
                break;
            }
            case 5: {
                this.print(tree.value.toString() + "L");
                break;
            }
            case 6: {
                this.print(tree.value.toString() + "F");
                break;
            }
            case 7: {
                this.print(tree.value.toString());
                break;
            }
            case 2: {
                this.print("'" + VeryPretty.quote(String.valueOf((char)((Number)tree.value).intValue()), '\"') + "'");
                break;
            }
            case 10: {
                this.print("\"" + VeryPretty.quote((String)tree.value, '\'') + "\"");
                break;
            }
            case 8: {
                this.print(tree.getValue().toString());
                break;
            }
            case 17: {
                this.print("null");
                break;
            }
            default: {
                this.print(tree.value.toString());
            }
        }
    }

    private static String quote(String val, char keep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c != keep) {
                sb.append(Convert.quote(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        this.print(this.symbols.typeOfTag[tree.typetag].tsym.name);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        this.printExpr(tree.elemtype);
        this.print("[]");
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        this.printExpr(tree.clazz);
        this.print('<');
        this.printExprs(tree.arguments);
        this.print('>');
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        this.print(tree.name);
        if (tree.bounds.nonEmpty()) {
            this.print(" extends ");
            this.printExprs(tree.bounds, " & ");
        }
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
        this.print("" + (Object)((Object)tree.kind.kind));
        if (tree.kind.kind != BoundKind.UNBOUND) {
            this.printExpr(tree.inner);
        }
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers tree) {
        this.printAnnotations(tree.annotations);
        this.printFlags(tree.flags);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        boolean oldInsideAnnotation = this.insideAnnotation;
        this.insideAnnotation = true;
        if (!this.printAnnotationsFormatted(List.of(tree))) {
            this.print("@");
            this.printExpr(tree.annotationType);
            if (tree.args.nonEmpty()) {
                this.print(this.cs.spaceBeforeAnnotationParen() ? " (" : "(");
                if (this.cs.spaceWithinAnnotationParens()) {
                    this.print(' ');
                }
                this.printExprs(tree.args);
                this.print(this.cs.spaceWithinAnnotationParens() ? " )" : ")");
            }
        }
        this.insideAnnotation = oldInsideAnnotation;
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        this.print("for");
        this.print(this.cs.spaceBeforeForParen() ? " (" : "(");
        if (this.cs.spaceWithinForParens()) {
            this.print(' ');
        }
        this.printExpr(tree.getVariable());
        String sep = this.cs.spaceBeforeColon() ? " :" : ":";
        this.print(this.cs.spaceAfterColon() ? sep + " " : sep);
        this.printExpr(tree.getExpression());
        this.print(this.cs.spaceWithinForParens() ? " )" : ")");
        this.printIndentedStat(tree.getStatement(), this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        this.print("(let " + tree.defs + " in " + tree.expr + ")");
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        this.print("(ERROR)");
        this.containsError = true;
    }

    @Override
    public void visitTree(JCTree tree) {
        this.print("(UNKNOWN: " + tree + ")");
        this.newline();
    }

    private void print(char c) {
        this.out.append(c);
    }

    private void needSpace() {
        this.out.needSpace();
    }

    private void blankLines(int n) {
        this.out.blanklines(n);
    }

    private void blankLines(JCTree tree, boolean before) {
        if (tree == null) {
            return;
        }
        int n = 0;
        switch (tree.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                int n2 = n = before ? this.cs.getBlankLinesBeforeClass() : this.cs.getBlankLinesAfterClass();
                if (((JCTree.JCClassDecl)tree).defs.nonEmpty() && !before) {
                    n = 0;
                } else {
                    this.out.blanklines(n);
                    this.toLeftMargin();
                }
                return;
            }
            case METHOD: {
                if ((((JCTree.JCMethodDecl)tree).mods.flags & 0x1000L) == 0L && ((JCTree.JCMethodDecl)tree).name != this.names.init || this.enclClassName != null) {
                    n = before ? this.cs.getBlankLinesBeforeMethods() : this.cs.getBlankLinesAfterMethods();
                    this.out.blanklines(n);
                    this.toLeftMargin();
                }
                return;
            }
            case VARIABLE: {
                if (this.enclClassName != null && this.enclClassName != this.names.empty && (((JCTree.JCVariableDecl)tree).mods.flags & 0x4000L) == 0L) {
                    n = before ? this.cs.getBlankLinesBeforeFields() : this.cs.getBlankLinesAfterFields();
                    this.out.blanklines(n);
                    if (before) {
                        this.toLeftMargin();
                    }
                }
                return;
            }
        }
    }

    private void toColExactly(int n) {
        if (n < this.out.col) {
            this.newline();
        }
        this.out.toCol(n);
    }

    private void printQualified(Symbol t) {
        if (t.owner != null && t.owner.name.getByteLength() > 0 && !(t.type instanceof Type.TypeVar) && !(t.owner instanceof Symbol.MethodSymbol)) {
            if (t.owner instanceof Symbol.PackageSymbol) {
                this.printAllQualified(t.owner);
            } else {
                this.printQualified(t.owner);
            }
            this.print('.');
        }
        this.print(t.name);
    }

    private void printAllQualified(Symbol t) {
        if (t.owner != null && t.owner.name.getByteLength() > 0) {
            this.printAllQualified(t.owner);
            this.print('.');
        }
        this.print(t.name);
    }

    private void adjustSpans(Iterable<? extends Tree> original, String code) {
        if (this.tree2Tag == null) {
            return;
        }
        LinkedList linearized = new LinkedList();
        if ((Boolean)new Linearize().scan(original, linearized) == false != Boolean.TRUE) {
            return;
        }
        try {
            ClassPath empty = ClassPathSupport.createClassPath((URL[])new URL[0]);
            ClasspathInfo cpInfo = ClasspathInfo.create(JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries(), empty, empty);
            JavacTaskImpl javacTask = JavacParser.createJavacTask(cpInfo, null, null, null, null, null, null);
            Context ctx = javacTask.getContext();
            JavaCompiler.instance((Context)ctx).genEndPos = true;
            CompilationUnitTree tree = (CompilationUnitTree)javacTask.parse(new JavaFileObject[]{FileObjects.memoryFileObject("", "", code)}).iterator().next();
            SourcePositions sp = JavacTrees.instance(ctx).getSourcePositions();
            ClassTree clazz = (ClassTree)tree.getTypeDecls().get(0);
            new CopyTags(tree, sp).scan(clazz.getModifiers().getAnnotations(), linearized);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static String whitespace(int num) {
        StringBuilder res = new StringBuilder(num);
        while (num-- > 0) {
            res.append(' ');
        }
        return res.toString();
    }

    private boolean printAnnotationsFormatted(List<JCTree.JCAnnotation> annotations) {
        if (this.reallyPrintAnnotations) {
            return false;
        }
        VeryPretty del = new VeryPretty(this.diffContext, this.cs, new HashMap(), new HashMap(), this.origText, 0);
        del.reallyPrintAnnotations = true;
        del.printingMethodParams = this.printingMethodParams;
        del.printAnnotations(annotations);
        String str = del.out.toString();
        int col = this.printingMethodParams ? this.out.leftMargin + this.cs.getContinuationIndentSize() : this.out.col;
        str = Reformatter.reformat(str + " class A{}", this.cs, this.cs.getRightMargin() - col);
        str = str.trim().replaceAll("\n", "\n" + VeryPretty.whitespace(col));
        this.adjustSpans(annotations, str);
        str = str.substring(0, str.lastIndexOf("class")).trim();
        this.print(str);
        return true;
    }

    private void printAnnotations(List<JCTree.JCAnnotation> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        if (this.printAnnotationsFormatted(annotations)) {
            if (!this.printingMethodParams) {
                this.toColExactly(this.out.leftMargin);
            } else {
                this.out.needSpace();
            }
            return;
        }
        while (annotations.nonEmpty()) {
            this.printNoParenExpr((JCTree)annotations.head);
            if (annotations.tail != null && annotations.tail.nonEmpty()) {
                switch (this.cs.wrapAnnotations()) {
                    case WRAP_IF_LONG: {
                        int rm = this.cs.getRightMargin();
                        if (this.widthEstimator.estimateWidth((JCTree)annotations.tail.head, rm - this.out.col) + this.out.col + 1 <= rm) {
                            this.print(' ');
                            break;
                        }
                    }
                    case WRAP_ALWAYS: {
                        this.newline();
                        this.toColExactly(this.out.leftMargin);
                        break;
                    }
                    case WRAP_NEVER: {
                        this.print(' ');
                    }
                }
            } else if (!this.printingMethodParams) {
                this.toColExactly(this.out.leftMargin);
            }
            annotations = annotations.tail;
        }
    }

    public void printFlags(long flags) {
        this.printFlags(flags, true);
    }

    public void printFinallyBlock(JCTree.JCBlock finalizer) {
        if (this.cs.placeFinallyOnNewLine()) {
            this.newline();
            this.toLeftMargin();
        } else if (this.cs.spaceBeforeFinally()) {
            this.needSpace();
        }
        this.print("finally");
        this.printBlock((JCTree)finalizer, this.cs.getOtherBracePlacement(), this.cs.spaceBeforeFinallyLeftBrace());
    }

    public void printFlags(long flags, boolean addSpace) {
        this.print(TreeInfo.flagNames(flags & 0xFFFFFFFFFFFFFDFFL & 0xFFFFFFFFFFFFDFFFL & 0xFFFFFFFFFFFFBFFFL));
        if ((flags & 0xFFFL) != 0L) {
            if (this.cs.placeNewLineAfterModifiers()) {
                this.toColExactly(this.out.leftMargin);
            } else if (addSpace) {
                this.needSpace();
            }
        }
    }

    public void printBlock(JCTree oldT, JCTree newT, Tree.Kind parentKind) {
        switch (parentKind) {
            case ENHANCED_FOR_LOOP: 
            case FOR_LOOP: {
                this.printIndentedStat(newT, this.cs.redundantForBraces(), this.cs.spaceBeforeForLeftBrace(), this.cs.wrapForStatement());
                break;
            }
            case WHILE_LOOP: {
                this.printIndentedStat(newT, this.cs.redundantWhileBraces(), this.cs.spaceBeforeWhileLeftBrace(), this.cs.wrapWhileStatement());
                break;
            }
            case IF: {
                this.printIndentedStat(newT, this.cs.redundantIfBraces(), this.cs.spaceBeforeIfLeftBrace(), this.cs.wrapIfStatement());
                break;
            }
            case DO_WHILE_LOOP: {
                this.printIndentedStat(newT, this.cs.redundantDoWhileBraces(), this.cs.spaceBeforeDoLeftBrace(), this.cs.wrapDoWhileStatement());
                if (this.cs.placeWhileOnNewLine()) {
                    this.newline();
                    this.toLeftMargin();
                    break;
                }
                if (!this.cs.spaceBeforeWhile()) break;
                this.needSpace();
            }
        }
    }

    public void printImportsBlock(java.util.List<? extends JCTree> imports, boolean maybeAppendNewLine) {
        boolean hasImports = !imports.isEmpty();
        CodeStyle.ImportGroups importGroups = null;
        if (hasImports) {
            this.blankLines(Math.max(this.cs.getBlankLinesBeforeImports(), this.diffContext.origUnit.pid != null ? this.cs.getBlankLinesAfterPackage() : 0));
            if (this.cs.separateImportGroups()) {
                importGroups = this.cs.getImportGroups();
            }
        }
        int lastGroup = -1;
        for (JCTree jCTree : imports) {
            if (importGroups != null) {
                int group;
                Name name = this.fullName(((JCTree.JCImport)jCTree).qualid);
                int n = group = name != null ? importGroups.getGroupId(name.toString(), ((JCTree.JCImport)jCTree).staticImport) : -1;
                if (lastGroup >= 0 && lastGroup != group) {
                    this.blankline();
                }
                lastGroup = group;
            }
            this.printStat(jCTree);
            this.newline();
        }
        if (hasImports && maybeAppendNewLine) {
            this.blankLines(this.cs.getBlankLinesAfterImports());
        }
    }

    public void eatChars(int count) {
        this.out.eatAwayChars(count);
    }

    private void printExpr(JCTree tree) {
        this.printExpr(tree, 0);
    }

    private void printNoParenExpr(JCTree tree) {
        while (tree instanceof JCTree.JCParens) {
            tree = ((JCTree.JCParens)tree).expr;
        }
        this.printExpr(tree, 0);
    }

    private void printExpr(JCTree tree, int prec) {
        if (tree == null) {
            this.print("/*missing*/");
        } else {
            int prevPrec = this.prec;
            this.prec = prec;
            this.doAccept(tree);
            this.prec = prevPrec;
        }
    }

    private <T extends JCTree> void printExprs(List<T> trees) {
        String sep = this.cs.spaceBeforeComma() ? " ," : ",";
        this.printExprs(trees, this.cs.spaceAfterComma() ? sep + " " : sep);
    }

    private <T extends JCTree> void printExprs(List<T> trees, String sep) {
        if (trees.nonEmpty()) {
            this.printNoParenExpr((JCTree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                this.print(sep);
                this.printNoParenExpr((JCTree)l.head);
                l = l.tail;
            }
        }
    }

    private void printStat(JCTree tree) {
        this.printStat(tree, false, false);
    }

    private void printStat(JCTree tree, boolean member, boolean first) {
        if (tree == null) {
            this.print(';');
        } else {
            if (!first) {
                this.blankLines(tree, true);
            }
            this.printPrecedingComments(tree, !member);
            this.printExpr(tree, -1);
            int tag = tree.getTag();
            if (26 <= tag && tag <= 90) {
                this.print(';');
            }
            this.printTrailingComments(tree, !member);
            this.blankLines(tree, false);
        }
    }

    private void printIndentedStat(JCTree tree, CodeStyle.BracesGenerationStyle redundantBraces, boolean spaceBeforeLeftBrace, CodeStyle.WrapStyle wrapStat) {
        if (this.fromOffset >= 0 && this.toOffset >= 0 && (TreeInfo.getStartPos(tree) < this.fromOffset || TreeInfo.getEndPos((JCTree)tree, (Map)((Object)this.diffContext.origUnit.endPositions)) > this.toOffset)) {
            redundantBraces = CodeStyle.BracesGenerationStyle.LEAVE_ALONE;
        }
        switch (redundantBraces) {
            case GENERATE: {
                this.printBlock(tree, this.cs.getOtherBracePlacement(), spaceBeforeLeftBrace);
                return;
            }
            case ELIMINATE: {
                List<JCTree.JCStatement> t;
                while (tree instanceof JCTree.JCBlock && !(t = ((JCTree.JCBlock)tree).stats).isEmpty() && !t.tail.nonEmpty() && !(t.head instanceof JCTree.JCVariableDecl)) {
                    this.printPrecedingComments(tree, true);
                    tree = (JCTree)t.head;
                }
            }
            case LEAVE_ALONE: {
                if (tree instanceof JCTree.JCBlock) {
                    this.printBlock(tree, this.cs.getOtherBracePlacement(), spaceBeforeLeftBrace);
                    return;
                }
                final int old = this.indent();
                final JCTree toPrint = tree;
                this.wrapTree(wrapStat, spaceBeforeLeftBrace, this.out.leftMargin, new Runnable(){

                    @Override
                    public void run() {
                        VeryPretty.this.printStat(toPrint);
                        VeryPretty.this.undent(old);
                    }
                });
            }
        }
    }

    private <T extends JCTree> void printStats(List<T> trees) {
        this.printStats(trees, false);
    }

    private <T extends JCTree> void printStats(List<T> trees, boolean members) {
        ArrayList<JCTree> filtered = new ArrayList<JCTree>(trees.size());
        List<Object> l = trees;
        while (l.nonEmpty()) {
            JCTree t = (JCTree)l.head;
            if (!this.isSynthetic(t)) {
                filtered.add(t);
            }
            l = l.tail;
        }
        if (!filtered.isEmpty() && this.handlePossibleOldTrees(filtered, true)) {
            return;
        }
        boolean first = true;
        for (JCTree t : filtered) {
            this.toColExactly(this.out.leftMargin);
            this.printStat(t, members, first);
            first = false;
        }
    }

    private void printBlock(JCTree t, CodeStyle.BracePlacement bracePlacement, boolean spaceBeforeLeftBrace) {
        List<JCTree> stats;
        JCTree block;
        if (t instanceof JCTree.JCBlock) {
            block = t;
            stats = ((JCTree.JCBlock)t).stats;
        } else {
            block = null;
            stats = List.of(t);
        }
        this.printBlock(block, stats, bracePlacement, spaceBeforeLeftBrace);
    }

    private void printBlock(JCTree tree, List<? extends JCTree> stats, CodeStyle.BracePlacement bracePlacement, boolean spaceBeforeLeftBrace) {
        this.printBlock(tree, stats, bracePlacement, spaceBeforeLeftBrace, false);
    }

    private void printBlock(JCTree tree, List<? extends JCTree> stats, CodeStyle.BracePlacement bracePlacement, boolean spaceBeforeLeftBrace, boolean members) {
        int old;
        this.printPrecedingComments(tree, true);
        int bcol = old = this.indent();
        switch (bracePlacement) {
            case NEW_LINE: {
                this.newline();
                this.toColExactly(old);
                break;
            }
            case NEW_LINE_HALF_INDENTED: {
                this.newline();
                this.toColExactly(bcol += this.indentSize >> 1);
                break;
            }
            case NEW_LINE_INDENTED: {
                this.newline();
                bcol = this.out.leftMargin;
                this.toColExactly(bcol);
            }
        }
        if (spaceBeforeLeftBrace) {
            this.needSpace();
        }
        this.print('{');
        boolean emptyBlock = true;
        List<JCTree> l = stats;
        while (l.nonEmpty()) {
            if (!this.isSynthetic((JCTree)l.head)) {
                emptyBlock = false;
                break;
            }
            l = l.tail;
        }
        if (emptyBlock) {
            this.printEmptyBlockComments(tree, members);
        } else {
            if (members) {
                this.blankLines(this.enclClassName.isEmpty() ? this.cs.getBlankLinesAfterAnonymousClassHeader() : this.cs.getBlankLinesAfterClassHeader());
            } else {
                this.newline();
            }
            this.printStats(stats, members);
        }
        this.toColExactly(bcol);
        this.undent(old);
        this.print('}');
        this.printTrailingComments(tree, true);
    }

    private void printTypeParameters(List<JCTree.JCTypeParameter> trees) {
        if (trees.nonEmpty()) {
            this.print('<');
            this.printExprs(trees);
            this.print('>');
        }
    }

    private void printTypeArguments(List<? extends JCTree.JCExpression> typeargs) {
        if (typeargs.nonEmpty()) {
            this.print('<');
            this.printExprs(typeargs);
            this.print('>');
        }
    }

    private void printPrecedingComments(JCTree tree, boolean printWhitespace) {
        CommentSet commentSet = this.commentHandler.getComments(tree);
        java.util.List<Comment> pc = commentSet.getComments(CommentSet.RelativePosition.PRECEDING);
        if (!pc.isEmpty()) {
            for (Comment c : pc) {
                this.printComment(c, true, printWhitespace);
            }
        }
    }

    private void printTrailingComments(JCTree tree, boolean printWhitespace) {
        CommentSet commentSet = this.commentHandler.getComments(tree);
        java.util.List<Comment> cl = commentSet.getComments(CommentSet.RelativePosition.INLINE);
        for (Comment comment : cl) {
            this.printComment(comment, true, printWhitespace);
        }
        java.util.List<Comment> tc = commentSet.getComments(CommentSet.RelativePosition.TRAILING);
        if (!tc.isEmpty()) {
            for (Comment c : tc) {
                this.printComment(c, false, printWhitespace);
            }
        }
    }

    private void printEmptyBlockComments(JCTree tree, boolean printWhitespace) {
        java.util.List<Comment> comments = this.commentHandler.getComments(tree).getComments(CommentSet.RelativePosition.INNER);
        for (Comment c : comments) {
            this.printComment(c, false, printWhitespace);
        }
    }

    public void printComment(Comment comment, boolean preceding, boolean printWhitespace) {
        this.printComment(comment, preceding, printWhitespace, false);
    }

    public void printComment(Comment comment, boolean preceding, boolean printWhitespace, boolean preventClosingWhitespace) {
        boolean onlyWhitespaces = this.out.isWhitespaceLine();
        if (Comment.Style.WHITESPACE == comment.style()) {
            return;
        }
        String body = comment.getText();
        boolean rawBody = body.length() == 0 || body.charAt(0) != '/';
        LinkedList<CommentLine> lines = new LinkedList<CommentLine>();
        int stpos = -1;
        int limit = body.length();
        for (int i = 0; i < limit; ++i) {
            char c = body.charAt(i);
            if (c == '\n') {
                lines.add(new CommentLine(stpos, stpos < 0 ? 0 : i - stpos, body));
                stpos = -1;
                continue;
            }
            if (c <= ' ' || stpos >= 0) continue;
            stpos = i;
        }
        if (stpos >= 0 && stpos < limit) {
            lines.add(new CommentLine(stpos, limit - stpos, body));
        }
        if (comment.indent() == 0) {
            if (!preceding && this.out.lastBlankLines == 0 && comment.style() != Comment.Style.LINE) {
                this.newline();
            }
            this.out.toLineStart();
        } else if (comment.indent() > 0 && !preceding) {
            if (this.out.lastBlankLines == 0 && comment.style() != Comment.Style.LINE) {
                this.newline();
            }
            this.toLeftMargin();
        } else if (comment.indent() < 0 && !preceding) {
            if (this.out.lastBlankLines == 0) {
                this.newline();
            }
            this.toLeftMargin();
        } else {
            this.needSpace();
        }
        if (rawBody) {
            switch (comment.style()) {
                case LINE: {
                    this.print("// ");
                    break;
                }
                case BLOCK: {
                    this.print("/* ");
                    break;
                }
                case JAVADOC: {
                    if (!onlyWhitespaces) {
                        this.newline();
                    }
                    this.toLeftMargin();
                    this.print("/**");
                    this.newline();
                    this.toLeftMargin();
                    this.print(" * ");
                }
            }
        }
        if (!lines.isEmpty()) {
            ((CommentLine)lines.removeFirst()).print(this.out.col);
        }
        while (!lines.isEmpty()) {
            this.newline();
            this.toLeftMargin();
            CommentLine line = (CommentLine)lines.removeFirst();
            if (rawBody) {
                this.print(" * ");
            } else if (line.body.charAt(line.startPos) == '*') {
                this.print(' ');
            }
            line.print(this.out.col);
        }
        if (rawBody) {
            switch (comment.style()) {
                case BLOCK: {
                    this.print(" */");
                    break;
                }
                case JAVADOC: {
                    this.newline();
                    this.toLeftMargin();
                    this.print(" */");
                    this.newline();
                    this.toLeftMargin();
                }
            }
        }
        if (onlyWhitespaces && !preventClosingWhitespace || comment.style() == Comment.Style.LINE) {
            this.newline();
            if (!preventClosingWhitespace) {
                this.toLeftMargin();
            }
        } else if (!preventClosingWhitespace) {
            this.needSpace();
        }
    }

    private void wrap(String s, CodeStyle.WrapStyle wrapStyle) {
        switch (wrapStyle) {
            case WRAP_IF_LONG: {
                if (s.length() + this.out.col <= this.cs.getRightMargin()) {
                    this.print(' ');
                    break;
                }
            }
            case WRAP_ALWAYS: {
                this.newline();
                this.toColExactly(this.out.leftMargin + this.cs.getContinuationIndentSize());
                break;
            }
            case WRAP_NEVER: {
                this.print(' ');
            }
        }
        this.print(s);
    }

    private <T extends JCTree> void wrapTrees(List<T> trees, CodeStyle.WrapStyle wrapStyle, int wrapIndent) {
        this.wrapTrees(trees, wrapStyle, wrapIndent, false);
    }

    private <T extends JCTree> void wrapTrees(List<T> trees, CodeStyle.WrapStyle wrapStyle, int wrapIndent, boolean wrapFirst) {
        boolean first = true;
        List<Object> l = trees;
        while (l.nonEmpty()) {
            if (!first) {
                this.print(this.cs.spaceBeforeComma() ? " ," : ",");
            }
            if (!first || wrapFirst) {
                switch (wrapStyle) {
                    case WRAP_IF_LONG: {
                        int rm = this.cs.getRightMargin();
                        if (this.widthEstimator.estimateWidth((JCTree)l.head, rm - this.out.col) + this.out.col + 1 <= rm) {
                            if (!this.cs.spaceAfterComma() || first) break;
                            this.print(' ');
                            break;
                        }
                    }
                    case WRAP_ALWAYS: {
                        this.newline();
                        this.toColExactly(wrapIndent);
                        break;
                    }
                    case WRAP_NEVER: {
                        if (!this.cs.spaceAfterComma() || first) break;
                        this.print(' ');
                    }
                }
            }
            this.printNoParenExpr((JCTree)l.head);
            first = false;
            l = l.tail;
        }
    }

    private void wrapTree(CodeStyle.WrapStyle wrapStyle, boolean needsSpaceBefore, int colAfterWrap, Runnable print) {
        switch (wrapStyle) {
            case WRAP_NEVER: {
                if (needsSpaceBefore) {
                    this.needSpace();
                }
                print.run();
                return;
            }
            case WRAP_IF_LONG: {
                int oldhm = this.out.harden();
                int oldc = this.out.col;
                int oldu = this.out.used;
                int oldm = this.out.leftMargin;
                try {
                    if (needsSpaceBefore) {
                        this.needSpace();
                    }
                    print.run();
                    this.out.restore(oldhm);
                    return;
                }
                catch (Throwable t) {
                    this.out.restore(oldhm);
                    this.out.col = oldc;
                    this.out.used = oldu;
                    this.out.leftMargin = oldm;
                }
            }
            case WRAP_ALWAYS: {
                if (this.out.col > 0) {
                    this.newline();
                }
                this.toColExactly(colAfterWrap);
                print.run();
            }
        }
    }

    public Name fullName(JCTree tree) {
        switch (tree.getTag()) {
            case 35: {
                return ((JCTree.JCIdent)tree).name;
            }
            case 34: {
                JCTree.JCFieldAccess sel = (JCTree.JCFieldAccess)tree;
                Name sname = this.fullName(sel.selected);
                return sname != null && sname.getByteLength() > 0 ? sname.append('.', sel.name) : sel.name;
            }
        }
        return null;
    }

    private boolean isSynthetic(JCTree tree) {
        if (tree.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)tree).mods.flags & 0x1000000000L) != 0L;
        }
        if (tree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && this.diffContext.origUnit != null) {
            JCTree.JCExpressionStatement est = (JCTree.JCExpressionStatement)tree;
            if (est.expr.getKind() == Tree.Kind.METHOD_INVOCATION) {
                JCTree.JCMethodInvocation mit = (JCTree.JCMethodInvocation)est.getExpression();
                if (mit.meth.getKind() == Tree.Kind.IDENTIFIER) {
                    JCTree.JCIdent it = (JCTree.JCIdent)mit.getMethodSelect();
                    return it.name == this.names._super && this.diffContext.syntheticTrees.contains(tree);
                }
            }
        }
        return false;
    }

    private static boolean isEnumerator(JCTree tree) {
        return tree.getTag() == 5 && (((JCTree.JCVariableDecl)tree).mods.flags & 0x4000L) != 0L;
    }

    private String replace(String a, String b) {
        a = a.replace(b, this.out.toString());
        this.out.clear();
        return a;
    }

    private class CommentLine {
        private int startPos;
        private int length;
        private String body;

        CommentLine(int sp, int l, String b) {
            this.length = l;
            this.startPos = this.length == 0 ? 0 : sp;
            this.body = b;
        }

        public void print(int col) {
            if (this.length > 0) {
                int limit = this.startPos + this.length;
                for (int i = this.startPos; i < limit; ++i) {
                    VeryPretty.this.out.append(this.body.charAt(i));
                }
            }
        }
    }

    private final class CopyTags
    extends TreeScanner<Void, java.util.List<Tree>> {
        private final CompilationUnitTree fake;
        private final SourcePositions sp;

        public CopyTags(CompilationUnitTree fake, SourcePositions sp) {
            this.fake = fake;
            this.sp = sp;
        }

        @Override
        public Void scan(Tree node, java.util.List<Tree> p) {
            if (p.isEmpty()) {
                return null;
            }
            Object tag = VeryPretty.this.tree2Tag.get(p.remove(0));
            if (tag != null) {
                VeryPretty.this.tag2Span.put(tag, new int[]{VeryPretty.this.out.length() + VeryPretty.this.initialOffset + (int)this.sp.getStartPosition(this.fake, node), VeryPretty.this.out.length() + VeryPretty.this.initialOffset + (int)this.sp.getEndPosition(this.fake, node)});
            }
            return (Void)super.scan(node, p);
        }
    }

    private final class Linearize
    extends TreeScanner<Boolean, java.util.List<Tree>> {
        private Linearize() {
        }

        @Override
        public Boolean scan(Tree node, java.util.List<Tree> p) {
            p.add(node);
            super.scan(node, p);
            return VeryPretty.this.tree2Tag.containsKey(node);
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
        }
    }
}

