/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.text.Document;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.AssignComments;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.TranslateIdentifier;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.modules.java.source.save.DiffContext;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public final class GeneratorUtilities {
    private WorkingCopy copy;
    private static final String GENERATED_METHOD_BODY = "Templates/Classes/Code/GeneratedMethodBody";
    private static final String OVERRIDDEN_METHOD_BODY = "Templates/Classes/Code/OverriddenMethodBody";
    private static final String METHOD_RETURN_TYPE = "method_return_type";
    private static final String DEFAULT_RETURN_TYPE_VALUE = "default_return_value";
    private static final String SUPER_METHOD_CALL = "super_method_call";
    private static final String METHOD_NAME = "method_name";
    private static final String CLASS_NAME = "class_name";
    private static final String SIMPLE_CLASS_NAME = "simple_class_name";
    private static final String SCRIPT_ENGINE_ATTR = "javax.script.ScriptEngine";
    private static final String STRING_OUTPUT_MODE_ATTR = "com.sun.script.freemarker.stringOut";
    private static ScriptEngineManager manager;

    private GeneratorUtilities(WorkingCopy copy) {
        this.copy = copy;
    }

    public static GeneratorUtilities get(WorkingCopy copy) {
        return new GeneratorUtilities(copy);
    }

    public CompilationUnitTree createFromTemplate(FileObject sourceRoot, String path, ElementKind kind) throws IOException {
        String[] nameComponent = FileObjects.getFolderAndBaseName(path, '/');
        JavaFileObject sourceFile = FileObjects.templateFileObject(sourceRoot, nameComponent[0], nameComponent[1]);
        FileObject template = FileUtil.getConfigFile((String)this.copy.template(kind));
        FileObject targetFile = this.copy.doCreateFromTemplate(template, sourceFile);
        CompilationUnitTree templateCUT = (CompilationUnitTree)this.copy.impl.getJavacTask().parse(new JavaFileObject[]{FileObjects.nbFileObject(targetFile, targetFile.getParent())}).iterator().next();
        CompilationUnitTree importComments = GeneratorUtilities.get(this.copy).importComments(templateCUT, templateCUT);
        CompilationUnitTree result = this.copy.getTreeMaker().CompilationUnit(importComments.getPackageAnnotations(), sourceRoot, path, importComments.getImports(), importComments.getTypeDecls());
        return result;
    }

    public ClassTree insertClassMember(ClassTree clazz, Tree member) {
        assert (clazz != null && member != null);
        int idx = 0;
        Document doc = null;
        try {
            doc = this.copy.getDocument();
            if (doc == null) {
                DataObject data = DataObject.find((FileObject)this.copy.getFileObject());
                EditorCookie cookie = (EditorCookie)data.getCookie(EditorCookie.class);
                doc = cookie.openDocument();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        CodeStyle codeStyle = DiffContext.getCodeStyle(this.copy);
        ClassMemberComparator comparator = new ClassMemberComparator(codeStyle);
        SourcePositions sp = this.copy.getTrees().getSourcePositions();
        TreeUtilities utils = this.copy.getTreeUtilities();
        CompilationUnitTree compilationUnit = this.copy.getCompilationUnit();
        Tree lastMember = null;
        for (Tree tree : clazz.getMembers()) {
            TreePath path = TreePath.getPath(compilationUnit, tree);
            if (!(path != null && utils.isSynthetic(path) || (codeStyle.getClassMemberInsertionPoint() != CodeStyle.InsertionPoint.FIRST_IN_CATEGORY || comparator.compare(member, tree) > 0) && comparator.compare(member, tree) >= 0)) {
                if (doc == null || !(doc instanceof GuardedDocument)) break;
                int pos = (int)(lastMember != null ? sp.getEndPosition(compilationUnit, lastMember) : sp.getStartPosition(compilationUnit, clazz));
                pos = ((GuardedDocument)doc).getGuardedBlockChain().adjustToBlockEnd(pos);
                long treePos = sp.getStartPosition(compilationUnit, tree);
                if (treePos < 0L || (long)pos <= treePos) break;
            }
            ++idx;
            lastMember = tree;
        }
        return this.copy.getTreeMaker().insertClassMember(clazz, idx, member);
    }

    public ClassTree insertClassMembers(ClassTree clazz, Iterable<? extends Tree> members) {
        assert (members != null);
        for (Tree tree : members) {
            clazz = this.insertClassMember(clazz, tree);
        }
        return clazz;
    }

    public List<? extends MethodTree> createAllAbstractMethodImplementations(TypeElement clazz) {
        return this.createAbstractMethodImplementations(clazz, this.copy.getElementUtilities().findUnimplementedMethods(clazz));
    }

    public List<? extends MethodTree> createAbstractMethodImplementations(TypeElement clazz, Iterable<? extends ExecutableElement> methods) {
        assert (methods != null);
        ArrayList<MethodTree> ret = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : methods) {
            ret.add(this.createAbstractMethodImplementation(clazz, executableElement));
        }
        this.tagFirst(ret);
        return ret;
    }

    public MethodTree createAbstractMethodImplementation(TypeElement clazz, ExecutableElement method) {
        assert (clazz != null && method != null);
        return this.createMethod(method, clazz);
    }

    public List<? extends MethodTree> createOverridingMethods(TypeElement clazz, Iterable<? extends ExecutableElement> methods) {
        assert (methods != null);
        ArrayList<MethodTree> ret = new ArrayList<MethodTree>();
        for (ExecutableElement executableElement : methods) {
            ret.add(this.createOverridingMethod(clazz, executableElement));
        }
        this.tagFirst(ret);
        return ret;
    }

    public MethodTree createOverridingMethod(TypeElement clazz, ExecutableElement method) {
        assert (clazz != null && method != null);
        return this.createMethod(method, clazz);
    }

    public MethodTree createMethod(DeclaredType asMemberOf, ExecutableElement method) {
        TreeMaker make = this.copy.getTreeMaker();
        Set<Modifier> mods = method.getModifiers();
        EnumSet<Modifier> flags = mods.isEmpty() ? EnumSet.noneOf(Modifier.class) : EnumSet.copyOf(mods);
        flags.remove((Object)Modifier.ABSTRACT);
        flags.remove((Object)Modifier.NATIVE);
        ExecutableType et = (ExecutableType)method.asType();
        try {
            et = (ExecutableType)this.copy.getTypes().asMemberOf(asMemberOf, method);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        ArrayList<TypeParameterTree> typeParams = new ArrayList<TypeParameterTree>();
        for (TypeVariable typeVariable : et.getTypeVariables()) {
            ArrayList<ExpressionTree> bounds = new ArrayList<ExpressionTree>();
            TypeMirror bound = typeVariable.getUpperBound();
            if (bound.getKind() != TypeKind.NULL) {
                if (bound.getKind() == TypeKind.DECLARED) {
                    Symbol.ClassSymbol boundSymbol = (Symbol.ClassSymbol)((DeclaredType)bound).asElement();
                    if (boundSymbol.getSimpleName().length() == 0 && (boundSymbol.flags() & 0x1000000L) != 0L) {
                        bounds.add((ExpressionTree)make.Type(boundSymbol.getSuperclass()));
                        for (Type iface : boundSymbol.getInterfaces()) {
                            bounds.add((ExpressionTree)make.Type(iface));
                        }
                    } else if (!boundSymbol.getQualifiedName().contentEquals("java.lang.Object")) {
                        bounds.add((ExpressionTree)make.Type(bound));
                    }
                } else {
                    bounds.add((ExpressionTree)make.Type(bound));
                }
            }
            typeParams.add(make.TypeParameter(typeVariable.asElement().getSimpleName(), bounds));
        }
        Tree returnType = make.Type(et.getReturnType());
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
        boolean isVarArgs = method.isVarArgs();
        Iterator<? extends VariableElement> formArgNames = method.getParameters().iterator();
        Iterator<? extends TypeMirror> formArgTypes = et.getParameterTypes().iterator();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        while (formArgNames.hasNext() && formArgTypes.hasNext()) {
            VariableElement formArgName = formArgNames.next();
            TypeMirror formArgType = formArgTypes.next();
            if (isVarArgs && !formArgNames.hasNext()) {
                parameterModifiers = make.Modifiers(0x400000000L, Collections.emptyList());
            }
            arrayList.add(make.Variable(parameterModifiers, formArgName.getSimpleName(), this.resolveWildcard(formArgType), null));
        }
        ArrayList<ExpressionTree> throwsList = new ArrayList<ExpressionTree>();
        for (TypeMirror typeMirror : et.getThrownTypes()) {
            throwsList.add((ExpressionTree)make.Type(typeMirror));
        }
        ModifiersTree mt = make.Modifiers(flags, Collections.emptyList());
        return make.Method(mt, (CharSequence)method.getSimpleName(), returnType, typeParams, arrayList, throwsList, "{}", null);
    }

    public MethodTree createConstructor(TypeElement clazz, Iterable<? extends VariableElement> fields, ExecutableElement constructor) {
        assert (clazz != null && fields != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(clazz.getKind() == ElementKind.ENUM ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        LinkedList<ExpressionStatementTree> statements = new LinkedList<ExpressionStatementTree>();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        LinkedList<ExpressionTree> throwsList = new LinkedList<ExpressionTree>();
        LinkedList<TypeParameterTree> typeParams = new LinkedList<TypeParameterTree>();
        for (VariableElement variableElement : fields) {
            TypeMirror typeMirror = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), variableElement);
            parameters.add(make.Variable(parameterModifiers, variableElement.getSimpleName(), make.Type(typeMirror), null));
            statements.add(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)make.Identifier("this"), variableElement.getSimpleName()), make.Identifier(variableElement.getSimpleName()))));
        }
        if (constructor != null) {
            ExecutableType constructorType;
            ExecutableType executableType = constructorType = clazz.getSuperclass().getKind() == TypeKind.DECLARED ? (ExecutableType)this.copy.getTypes().asMemberOf((DeclaredType)clazz.getSuperclass(), constructor) : null;
            if (!constructor.getParameters().isEmpty()) {
                Iterator<? extends TypeMirror> parameterTypes;
                ArrayList<IdentifierTree> arrayList = new ArrayList<IdentifierTree>();
                Iterator<? extends VariableElement> iterator = constructor.getParameters().iterator();
                Iterator<? extends TypeMirror> iterator2 = parameterTypes = constructorType != null ? constructorType.getParameterTypes().iterator() : null;
                while (iterator.hasNext()) {
                    VariableElement ve = iterator.next();
                    javax.lang.model.element.Name name = ve.getSimpleName();
                    TypeMirror type = parameterTypes != null ? parameterTypes.next() : ve.asType();
                    parameters.add(make.Variable(parameterModifiers, name, make.Type(type), null));
                    arrayList.add(make.Identifier(name));
                }
                statements.addFirst(make.ExpressionStatement(make.MethodInvocation(Collections.emptyList(), make.Identifier("super"), arrayList)));
            }
            constructorType = constructorType != null ? constructorType : (ExecutableType)constructor.asType();
            for (TypeMirror typeMirror : constructorType.getThrownTypes()) {
                throwsList.add((ExpressionTree)make.Type(typeMirror));
            }
            for (TypeParameterElement typeParameterElement : constructor.getTypeParameters()) {
                LinkedList<ExpressionTree> boundsList = new LinkedList<ExpressionTree>();
                for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                    boundsList.add((ExpressionTree)make.Type(typeMirror));
                }
                typeParams.add(make.TypeParameter(typeParameterElement.getSimpleName(), boundsList));
            }
        }
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), "<init>", null, typeParams, parameters, throwsList, body, null, constructor != null ? constructor.isVarArgs() : false);
    }

    public MethodTree createConstructor(ClassTree clazz, Iterable<? extends VariableTree> fields) {
        assert (clazz != null && fields != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(this.copy.getTreeUtilities().isEnum(clazz) ? Modifier.PRIVATE : Modifier.PUBLIC);
        ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
        ArrayList<ExpressionStatementTree> statements = new ArrayList<ExpressionStatementTree>();
        ModifiersTree parameterModifiers = make.Modifiers(EnumSet.noneOf(Modifier.class));
        for (VariableTree variableTree : fields) {
            parameters.add(make.Variable(parameterModifiers, variableTree.getName(), variableTree.getType(), null));
            statements.add(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)make.Identifier("this"), variableTree.getName()), make.Identifier(variableTree.getName()))));
        }
        BlockTree body = make.Block(statements, false);
        return make.Method(make.Modifiers(mods), (CharSequence)"<init>", null, Collections.emptyList(), parameters, Collections.emptyList(), body, null);
    }

    public MethodTree createGetter(TypeElement clazz, VariableElement field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        if (field.getModifiers().contains((Object)Modifier.STATIC)) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), field);
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, type.getKind() == TypeKind.BOOLEAN ? "is" : "get");
        BlockTree body = make.Block(Collections.singletonList(make.Return(make.Identifier(name))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(type), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    public MethodTree createGetter(VariableTree field) {
        assert (field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        if (field.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getName();
        assert (name.length() > 0);
        Tree type = field.getType();
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, type.getKind() == Tree.Kind.PRIMITIVE_TYPE && ((PrimitiveTypeTree)type).getPrimitiveTypeKind() == TypeKind.BOOLEAN ? "is" : "get");
        BlockTree body = make.Block(Collections.singletonList(make.Return(make.Identifier(name))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, type, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body, null);
    }

    public MethodTree createSetter(TypeElement clazz, VariableElement field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getSimpleName();
        assert (name.length() > 0);
        TypeMirror type = this.copy.getTypes().asMemberOf((DeclaredType)clazz.asType(), field);
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, "set");
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), name, make.Type(type), null));
        BlockTree body = make.Block(Collections.singletonList(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)(isStatic ? make.Identifier(field.getEnclosingElement().getSimpleName()) : make.Identifier("this")), name), make.Identifier(name)))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    public MethodTree createSetter(ClassTree clazz, VariableTree field) {
        assert (clazz != null && field != null);
        TreeMaker make = this.copy.getTreeMaker();
        EnumSet<Modifier> mods = EnumSet.of(Modifier.PUBLIC);
        boolean isStatic = field.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        if (isStatic) {
            mods.add(Modifier.STATIC);
        }
        javax.lang.model.element.Name name = field.getName();
        assert (name.length() > 0);
        StringBuilder sb = GeneratorUtilities.getCapitalizedName(name);
        sb.insert(0, "set");
        List<VariableTree> params = Collections.singletonList(make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), name, field.getType(), null));
        BlockTree body = make.Block(Collections.singletonList(make.ExpressionStatement(make.Assignment(make.MemberSelect((ExpressionTree)(isStatic ? make.Identifier(clazz.getSimpleName()) : make.Identifier("this")), name), make.Identifier(name)))), false);
        return make.Method(make.Modifiers(mods), (CharSequence)sb, make.Type(this.copy.getTypes().getNoType(TypeKind.VOID)), Collections.emptyList(), params, Collections.emptyList(), body, null);
    }

    /*
     * WARNING - void declaration
     */
    public CompilationUnitTree addImports(CompilationUnitTree cut, Set<? extends Element> toImport) {
        ExpressionTree packageName;
        assert (cut != null && toImport != null && toImport.size() > 0);
        ArrayList<Element> elementsToImport = new ArrayList<Element>(toImport.size());
        HashSet<String> staticImportNames = new HashSet<String>();
        for (Element element : toImport) {
            switch (element.getKind()) {
                case METHOD: 
                case ENUM_CONSTANT: 
                case FIELD: {
                    StringBuilder name = new StringBuilder(((TypeElement)element.getEnclosingElement()).getQualifiedName()).append('.').append(element.getSimpleName());
                    if (!staticImportNames.add(name.toString())) break;
                }
                default: {
                    elementsToImport.add(element);
                }
            }
        }
        Trees trees = this.copy.getTrees();
        Elements elements = this.copy.getElements();
        ElementUtilities elementUtilities = this.copy.getElementUtilities();
        CodeStyle cs = DiffContext.getCodeStyle(this.copy);
        int treshold = cs.countForUsingStarImport();
        int staticTreshold = cs.countForUsingStaticStarImport();
        LinkedHashMap<PackageElement, Integer> pkgCounts = new LinkedHashMap<PackageElement, Integer>();
        PackageElement pkg = elements.getPackageElement("java.lang");
        if (pkg != null) {
            pkgCounts.put(pkg, -2);
        }
        PackageElement packageElement = pkg = (packageName = cut.getPackageName()) != null ? (PackageElement)trees.getElement(TreePath.getPath(cut, (Tree)packageName)) : null;
        if (pkg == null && packageName != null) {
            pkg = elements.getPackageElement(elements.getName(packageName.toString()));
        }
        if (pkg == null) {
            pkg = elements.getPackageElement(elements.getName(""));
        }
        pkgCounts.put(pkg, -2);
        LinkedHashMap<TypeElement, Integer> typeCounts = new LinkedHashMap<TypeElement, Integer>();
        Scope scope = trees.getScope(new TreePath(cut));
        Scope.StarImportScope importScope = new Scope.StarImportScope((Symbol)((Object)pkg));
        if (((JCTree.JCCompilationUnit)cut).starImportScope != null) {
            importScope.importAll(((JCTree.JCCompilationUnit)cut).starImportScope);
        }
        for (Element e : elementsToImport) {
            Integer cnt;
            boolean bl = false;
            Element el = null;
            switch (e.getKind()) {
                case PACKAGE: {
                    el = e;
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (e.getEnclosingElement().getKind() != ElementKind.PACKAGE) break;
                    el = e.getEnclosingElement();
                    break;
                }
                case METHOD: 
                case ENUM_CONSTANT: 
                case FIELD: {
                    bl = true;
                    el = e.getEnclosingElement();
                    assert (e.getModifiers().contains((Object)Modifier.STATIC) && trees.isAccessible(scope, e, (DeclaredType)el.asType())) : "Only static accessible members could be imported";
                    break;
                }
                default: {
                    assert (false) : "Illegal element kind: " + (Object)((Object)e.getKind());
                    break;
                }
            }
            if (el == null) continue;
            Integer n = cnt = bl ? (Integer)typeCounts.get((TypeElement)el) : (Integer)pkgCounts.get((PackageElement)el);
            if (cnt == null) {
                cnt = 0;
            }
            if (cnt >= 0) {
                if (el == e) {
                    cnt = -1;
                } else {
                    Integer n2 = cnt;
                    Integer n3 = cnt = Integer.valueOf(cnt + 1);
                    if (bl) {
                        if (cnt >= staticTreshold) {
                            cnt = -1;
                        }
                    } else if (cnt >= treshold || GeneratorUtilities.checkPackagesForStarImport(((PackageElement)el).getQualifiedName().toString(), cs)) {
                        cnt = -1;
                    }
                }
            }
            if (bl) {
                typeCounts.put((TypeElement)el, cnt);
                continue;
            }
            pkgCounts.put((PackageElement)el, cnt);
        }
        ArrayList<? extends ImportTree> imports = new ArrayList<ImportTree>(cut.getImports());
        for (ImportTree importTree : imports) {
            Integer n;
            Integer cnt;
            Element el;
            Element e = this.getImportedElement(cut, importTree);
            if (importTree.isStatic()) {
                if (e.getKind().isClass() || e.getKind().isInterface()) {
                    el = e;
                    while (el != null) {
                        TypeMirror typeMirror;
                        cnt = (Integer)typeCounts.get((TypeElement)el);
                        if (cnt != null) {
                            typeCounts.put((TypeElement)el, -2);
                        }
                        el = (typeMirror = ((TypeElement)el).getSuperclass()).getKind() == TypeKind.DECLARED ? ((DeclaredType)typeMirror).asElement() : null;
                    }
                    continue;
                }
                el = elementUtilities.enclosingTypeElement(e);
                if (el == null || (cnt = (Integer)typeCounts.get((TypeElement)el)) == null) continue;
                if (cnt >= 0) {
                    Integer n4 = cnt;
                    n = cnt = Integer.valueOf(cnt + 1);
                    if (cnt >= staticTreshold) {
                        cnt = -1;
                    }
                }
                typeCounts.put((TypeElement)el, cnt);
                continue;
            }
            el = e.getKind() == ElementKind.PACKAGE ? e : ((e.getKind().isClass() || e.getKind().isInterface()) && e.getEnclosingElement().getKind() == ElementKind.PACKAGE ? e.getEnclosingElement() : null);
            if (el == null || (cnt = (Integer)pkgCounts.get((PackageElement)el)) == null) continue;
            if (el == e) {
                cnt = -2;
            } else if (cnt >= 0) {
                Integer n5 = cnt;
                n = cnt = Integer.valueOf(cnt + 1);
                if (cnt >= treshold) {
                    cnt = -1;
                }
            }
            pkgCounts.put((PackageElement)el, cnt);
        }
        HashSet<Element> explicitNamedImports = new HashSet<Element>();
        block17: for (Element element : elementsToImport) {
            if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
            Scope.Entry e = importScope.lookup((Name)element.getSimpleName());
            while (e.scope != null) {
                if ((e.sym.getKind().isClass() || e.sym.getKind().isInterface()) && e.sym != element) {
                    explicitNamedImports.add(element);
                    continue block17;
                }
                e = e.next();
            }
        }
        Object var19_24 = null;
        for (Map.Entry entry : pkgCounts.entrySet()) {
            if ((Integer)entry.getValue() == -1) {
                for (Element element : ((PackageElement)entry.getKey()).getEnclosedElements()) {
                    void var19_25;
                    if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
                    Scope.Entry starEntry = importScope.lookup((Name)element.getSimpleName());
                    if (starEntry.scope == null) continue;
                    TypeElement te = null;
                    for (Element e : elementsToImport) {
                        if (!e.getKind().isClass() && !e.getKind().isInterface() || element.getSimpleName() != e.getSimpleName()) continue;
                        te = (TypeElement)e;
                        break;
                    }
                    if (te != null) {
                        explicitNamedImports.add(te);
                        continue;
                    }
                    if (var19_25 == null) {
                        Map<javax.lang.model.element.Name, TypeElement> map = this.getUsedTypes(cut);
                    }
                    if ((te = (TypeElement)var19_25.get(element.getSimpleName())) == null) continue;
                    elementsToImport.add(te);
                    explicitNamedImports.add(te);
                }
            }
            if ((Integer)entry.getValue() >= 0 || !(entry.getKey() instanceof Symbol)) continue;
            importScope.importAll(((Symbol)entry.getKey()).members());
        }
        ImportsComparator comparator = new ImportsComparator(cs);
        Collections.sort(elementsToImport, comparator);
        TreeMaker make = this.copy.getTreeMaker();
        int currentToImport = elementsToImport.size() - 1;
        int n = imports.size() - 1;
        while (currentToImport >= 0) {
            void var23_39;
            boolean isStar;
            Integer cnt;
            Element currentToImportElement = (Element)elementsToImport.get(currentToImport);
            boolean isStatic = false;
            Element el = null;
            switch (currentToImportElement.getKind()) {
                case PACKAGE: {
                    el = currentToImportElement;
                    break;
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (currentToImportElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) break;
                    el = currentToImportElement.getEnclosingElement();
                    break;
                }
                case METHOD: 
                case ENUM_CONSTANT: 
                case FIELD: {
                    isStatic = true;
                    el = currentToImportElement.getEnclosingElement();
                }
            }
            Integer n6 = el == null ? Integer.valueOf(0) : (cnt = isStatic ? (Integer)typeCounts.get((TypeElement)el) : (Integer)pkgCounts.get((PackageElement)el));
            if (explicitNamedImports.contains(currentToImportElement)) {
                cnt = 0;
            }
            if (cnt == -2) {
                --currentToImport;
                continue;
            }
            if (cnt == -1) {
                currentToImportElement = el;
                if (isStatic) {
                    typeCounts.put((TypeElement)el, -2);
                } else {
                    pkgCounts.put((PackageElement)el, -2);
                }
            }
            boolean bl = isStar = currentToImportElement.getKind() == ElementKind.PACKAGE || isStatic && (currentToImportElement.getKind().isClass() || currentToImportElement.getKind().isInterface());
            while (var23_39 >= 0) {
                ImportTree imp = (ImportTree)imports.get((int)var23_39);
                Element impElement = this.getImportedElement(cut, imp);
                Element element = imp.isStatic() ? (impElement.getKind().isClass() || impElement.getKind().isInterface() ? impElement : elementUtilities.enclosingTypeElement(impElement)) : (impElement.getKind() == ElementKind.PACKAGE ? impElement : (el = (impElement.getKind().isClass() || impElement.getKind().isInterface()) && impElement.getEnclosingElement().getKind() == ElementKind.PACKAGE ? impElement.getEnclosingElement() : null));
                if (isStatic == imp.isStatic() && (currentToImportElement == impElement || isStar && currentToImportElement == el)) {
                    imports.remove((int)var23_39);
                } else if (comparator.compare(currentToImportElement, imp) > 0) break;
                --var23_39;
            }
            ExpressionTree qualIdent = this.qualIdentFor(currentToImportElement);
            if (isStar) {
                qualIdent = make.MemberSelect(qualIdent, elements.getName("*"));
            }
            imports.add((int)(var23_39 + true), make.Import(qualIdent, isStatic));
            --currentToImport;
        }
        return make.CompilationUnit(cut.getPackageAnnotations(), cut.getPackageName(), imports, cut.getTypeDecls(), cut.getSourceFile());
    }

    public <T extends Tree> T importFQNs(T original) {
        return TranslateIdentifier.importFQNs(this.copy, original);
    }

    public <T extends Tree> T importComments(T original, CompilationUnitTree cut) {
        return GeneratorUtilities.importComments(this.copy, original, cut);
    }

    static <T extends Tree> T importComments(CompilationInfo info, T original, CompilationUnitTree cut) {
        try {
            CommentSetImpl comments = CommentHandlerService.instance(info.impl.getJavacTask().getContext()).getComments(original);
            if (comments.areCommentsMapped()) {
                return original;
            }
            JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)cut;
            TokenSequence seq = ((SourceFileObject)unit.getSourceFile()).getTokenHierarchy().tokenSequence(JavaTokenId.language());
            TreePath tp = TreePath.getPath(cut, original);
            T toMap = tp != null && original.getKind() != Tree.Kind.COMPILATION_UNIT ? tp.getParentPath().getLeaf() : original;
            AssignComments translator = new AssignComments(info, original, (TokenSequence<JavaTokenId>)seq, unit);
            translator.scan(toMap, null);
            return original;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return original;
        }
    }

    public void copyComments(Tree source, Tree target, boolean preceding) {
        CommentHandlerService handler = CommentHandlerService.instance(this.copy.impl.getJavacTask().getContext());
        CommentSetImpl s = handler.getComments(source);
        TreeUtilities.ensureCommentsMapped(this.copy, source, s);
        CommentSetImpl t = handler.getComments(target);
        if (preceding) {
            t.addComments(CommentSet.RelativePosition.PRECEDING, s.getComments(CommentSet.RelativePosition.PRECEDING));
        } else {
            t.addComments(CommentSet.RelativePosition.INLINE, s.getComments(CommentSet.RelativePosition.INLINE));
            t.addComments(CommentSet.RelativePosition.TRAILING, s.getComments(CommentSet.RelativePosition.TRAILING));
        }
    }

    public ModifiersTree appendToAnnotationValue(ModifiersTree modifiers, TypeElement annotation, String attributeName, ExpressionTree ... attributeValuesToAdd) {
        return (ModifiersTree)this.appendToAnnotationValue((Tree)modifiers, annotation, attributeName, attributeValuesToAdd);
    }

    public CompilationUnitTree appendToAnnotationValue(CompilationUnitTree compilationUnit, TypeElement annotation, String attributeName, ExpressionTree ... attributeValuesToAdd) {
        return (CompilationUnitTree)this.appendToAnnotationValue((Tree)compilationUnit, annotation, attributeName, attributeValuesToAdd);
    }

    /*
     * WARNING - void declaration
     */
    private Tree appendToAnnotationValue(Tree modifiers, TypeElement annotation, String attributeName, ExpressionTree ... attributeValuesToAdd) {
        void var8_11;
        TreeMaker make = this.copy.getTreeMaker();
        List<? extends AnnotationTree> annotations = null;
        if (modifiers.getKind() == Tree.Kind.MODIFIERS) {
            annotations = ((ModifiersTree)modifiers).getAnnotations();
        } else if (modifiers.getKind() == Tree.Kind.COMPILATION_UNIT) {
            annotations = ((CompilationUnitTree)modifiers).getPackageAnnotations();
        } else {
            throw new IllegalStateException();
        }
        for (AnnotationTree annotationTree : annotations) {
            TreePath tp = new TreePath(new TreePath(this.copy.getCompilationUnit()), annotationTree.getAnnotationType());
            Element e = this.copy.getTrees().getElement(tp);
            if (!annotation.equals(e)) continue;
            List<? extends ExpressionTree> arguments = annotationTree.getArguments();
            for (ExpressionTree expressionTree : arguments) {
                ExpressionTree expression;
                if (expressionTree.getKind() == Tree.Kind.ASSIGNMENT) {
                    AssignmentTree assignment = (AssignmentTree)expressionTree;
                    if (!((IdentifierTree)assignment.getVariable()).getName().contentEquals(attributeName)) continue;
                    expression = assignment.getExpression();
                } else {
                    if (!"value".equals(attributeName)) continue;
                    expression = expressionTree;
                }
                List<ExpressionTree> currentValues = expression.getKind() == Tree.Kind.NEW_ARRAY ? ((NewArrayTree)expression).getInitializers() : Collections.singletonList(expression);
                assert (currentValues != null);
                ArrayList<ExpressionTree> values = new ArrayList<ExpressionTree>(currentValues);
                values.addAll(Arrays.asList(attributeValuesToAdd));
                NewArrayTree newAssignment = make.NewArray(null, Collections.emptyList(), values);
                return this.copy.getTreeUtilities().translate(modifiers, Collections.singletonMap(expression, newAssignment));
            }
            AnnotationTree newAnnotation = make.addAnnotationAttrValue(annotationTree, make.Assignment(make.Identifier(attributeName), make.NewArray(null, Collections.emptyList(), Arrays.asList(attributeValuesToAdd))));
            return this.copy.getTreeUtilities().translate(modifiers, Collections.singletonMap(annotationTree, newAnnotation));
        }
        ExpressionTree attribute = attributeValuesToAdd.length > 1 ? make.NewArray(null, Collections.emptyList(), Arrays.asList(attributeValuesToAdd)) : attributeValuesToAdd[0];
        if ("value".equals(attributeName)) {
            ExpressionTree expressionTree = attribute;
        } else {
            AssignmentTree assignmentTree = make.Assignment(make.Identifier(attributeName), attribute);
        }
        AnnotationTree newAnnotation = make.Annotation(make.QualIdent(annotation), Collections.singletonList(var8_11));
        if (modifiers.getKind() == Tree.Kind.MODIFIERS) {
            return make.addModifiersAnnotation((ModifiersTree)modifiers, newAnnotation);
        }
        if (modifiers.getKind() == Tree.Kind.COMPILATION_UNIT) {
            return make.addPackageAnnotation((CompilationUnitTree)modifiers, newAnnotation);
        }
        throw new IllegalStateException();
    }

    private MethodTree createMethod(ExecutableElement element, TypeElement clazz) {
        TreeMaker make = this.copy.getTreeMaker();
        MethodTree prototype = this.createMethod((DeclaredType)clazz.asType(), element);
        ModifiersTree mt = prototype.getModifiers();
        if (GeneratorUtilities.supportsOverride(this.copy) && this.copy.getSourceVersion().compareTo(SourceVersion.RELEASE_5) >= 0) {
            boolean generate = true;
            if (this.copy.getSourceVersion().compareTo(SourceVersion.RELEASE_5) == 0) {
                boolean bl = generate = !element.getEnclosingElement().getKind().isInterface();
            }
            if (generate) {
                mt = make.addModifiersAnnotation(prototype.getModifiers(), make.Annotation(make.Identifier("Override"), Collections.emptyList()));
            }
        }
        boolean isAbstract = element.getModifiers().contains((Object)Modifier.ABSTRACT);
        String bodyTemplate = null;
        try {
            bodyTemplate = "{" + GeneratorUtilities.readFromTemplate(isAbstract ? GENERATED_METHOD_BODY : OVERRIDDEN_METHOD_BODY, GeneratorUtilities.createBindings(clazz, element)) + "\n}";
        }
        catch (Exception e) {
            bodyTemplate = "{}";
        }
        MethodTree method = make.Method(mt, (CharSequence)prototype.getName(), prototype.getReturnType(), prototype.getTypeParameters(), prototype.getParameters(), prototype.getThrows(), bodyTemplate, null);
        if (GeneratorUtilities.containsErrors(method.getBody())) {
            this.copy.rewrite(method.getBody(), make.Block(Collections.emptyList(), false));
        } else {
            Trees trees = this.copy.getTrees();
            TreePath path = trees.getPath(clazz);
            if (path == null) {
                path = new TreePath(this.copy.getCompilationUnit());
            }
            Scope s = trees.getScope(path);
            BlockTree body = method.getBody();
            this.copy.getTreeUtilities().attributeTree(body, s);
            body = this.importFQNs(body);
            this.copy.rewrite(method.getBody(), body);
        }
        return method;
    }

    private static boolean supportsOverride(CompilationInfo info) {
        return info.getElements().getTypeElement("java.lang.Override") != null;
    }

    private static StringBuilder getCapitalizedName(CharSequence cs) {
        StringBuilder sb = new StringBuilder(cs);
        while (sb.length() > 1 && sb.charAt(0) == '_') {
            sb.deleteCharAt(0);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(1))) {
            return sb;
        }
        if (sb.length() > 0) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb;
    }

    private Tree resolveWildcard(TypeMirror type) {
        Tree result;
        TreeMaker make = this.copy.getTreeMaker();
        if (type != null && type.getKind() == TypeKind.WILDCARD) {
            WildcardType wt = (WildcardType)type;
            TypeMirror bound = wt.getSuperBound();
            if (bound == null) {
                bound = wt.getExtendsBound();
            }
            if (bound == null) {
                return make.Type("java.lang.Object");
            }
            result = make.Type(bound);
        } else {
            result = make.Type(type);
        }
        final IdentityHashMap translate = new IdentityHashMap();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitWildcard(WildcardTree node, Void p) {
                Tree bound = node.getBound();
                if (bound != null && (bound.getKind() == Tree.Kind.EXTENDS_WILDCARD || bound.getKind() == Tree.Kind.SUPER_WILDCARD)) {
                    translate.put(bound, ((WildcardTree)bound).getBound());
                }
                return (Void)super.visitWildcard(node, p);
            }
        }.scan(result, null);
        return this.copy.getTreeUtilities().translate(result, translate);
    }

    private Element getImportedElement(CompilationUnitTree cut, ImportTree imp) {
        Element element;
        Trees trees = this.copy.getTrees();
        Tree qualIdent = imp.getQualifiedIdentifier();
        if (qualIdent.getKind() != Tree.Kind.MEMBER_SELECT) {
            Element element2 = trees.getElement(TreePath.getPath(cut, qualIdent));
            if (element2 == null) {
                String fqn = qualIdent.toString();
                if (fqn.endsWith(".*")) {
                    fqn = fqn.substring(0, fqn.length() - 2);
                }
                element2 = this.getElementByFQN(fqn);
            }
            return element2;
        }
        javax.lang.model.element.Name name = ((MemberSelectTree)qualIdent).getIdentifier();
        if ("*".contentEquals(name)) {
            Element element3 = trees.getElement(TreePath.getPath(cut, (Tree)((MemberSelectTree)qualIdent).getExpression()));
            if (element3 == null) {
                element3 = this.getElementByFQN(((MemberSelectTree)qualIdent).getExpression().toString());
            }
            return element3;
        }
        if (imp.isStatic()) {
            Element parent = trees.getElement(TreePath.getPath(cut, (Tree)((MemberSelectTree)qualIdent).getExpression()));
            if (parent == null) {
                parent = this.getElementByFQN(((MemberSelectTree)qualIdent).getExpression().toString());
            }
            if (parent != null && (parent.getKind().isClass() || parent.getKind().isInterface())) {
                Scope s = trees.getScope(new TreePath(cut));
                for (Element element2 : parent.getEnclosedElements()) {
                    if (name != element2.getSimpleName() || !element2.getModifiers().contains((Object)Modifier.STATIC) || !trees.isAccessible(s, element2, (DeclaredType)parent.asType())) continue;
                    return element2;
                }
                return parent;
            }
        }
        if ((element = trees.getElement(TreePath.getPath(cut, qualIdent))) == null) {
            element = this.getElementByFQN(qualIdent.toString());
        }
        return element;
    }

    private Element getElementByFQN(String fqn) {
        Elements elements = this.copy.getElements();
        QualifiedNameable element = elements.getTypeElement(fqn);
        if (element == null) {
            element = elements.getPackageElement(fqn);
        }
        if (element == null) {
            element = ClassReader.instance(this.copy.impl.getJavacTask().getContext()).enterClass((Name)elements.getName(fqn));
        }
        return element;
    }

    private Map<javax.lang.model.element.Name, TypeElement> getUsedTypes(CompilationUnitTree cut) {
        final Trees trees = this.copy.getTrees();
        final HashMap<javax.lang.model.element.Name, TypeElement> map = new HashMap<javax.lang.model.element.Name, TypeElement>();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element element;
                if (!map.containsKey(node.getName()) && (element = trees.getElement(this.getCurrentPath())) != null && (element.getKind().isClass() || element.getKind().isInterface()) && element.asType().getKind() != TypeKind.ERROR) {
                    map.put(node.getName(), (TypeElement)element);
                }
                return (Void)super.visitIdentifier(node, p);
            }

            @Override
            public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
                this.scan(node.getPackageAnnotations(), p);
                return (Void)this.scan(node.getTypeDecls(), p);
            }
        }.scan(cut, null);
        return map;
    }

    private ExpressionTree qualIdentFor(Element e) {
        TreeMaker tm = this.copy.getTreeMaker();
        if (e.getKind() == ElementKind.PACKAGE) {
            String name = ((PackageElement)e).getQualifiedName().toString();
            if (e instanceof Symbol) {
                int lastDot = name.lastIndexOf(46);
                if (lastDot < 0) {
                    return tm.Identifier(e);
                }
                return tm.MemberSelect(this.qualIdentFor(name.substring(0, lastDot)), e);
            }
            return this.qualIdentFor(name);
        }
        Element ee = e.getEnclosingElement();
        if (e instanceof Symbol) {
            return ee.getSimpleName().length() > 0 ? tm.MemberSelect(this.qualIdentFor(ee), e) : tm.Identifier(e);
        }
        return ee.getSimpleName().length() > 0 ? tm.MemberSelect(this.qualIdentFor(ee), e.getSimpleName()) : tm.Identifier(e.getSimpleName());
    }

    private ExpressionTree qualIdentFor(String name) {
        Elements elements = this.copy.getElements();
        TreeMaker tm = this.copy.getTreeMaker();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return tm.Identifier(elements.getName(name));
        }
        return tm.MemberSelect(this.qualIdentFor(name.substring(0, lastDot)), elements.getName(name.substring(lastDot + 1)));
    }

    private void tagFirst(List<MethodTree> methods) {
        BlockTree body;
        if (methods.size() > 0 && (body = methods.get(0).getBody()) != null && !body.getStatements().isEmpty()) {
            this.copy.tag(body.getStatements().get(0), "methodBodyTag");
        }
    }

    static boolean checkPackagesForStarImport(String pkgName, CodeStyle cs) {
        for (String s : cs.getPackagesForStarImport()) {
            if (!(s.endsWith(".*") ? pkgName.startsWith(s = s.substring(0, s.length() - 2)) : pkgName.equals(s))) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Object> createBindings(TypeElement clazz, ExecutableElement element) {
        Object value;
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put(CLASS_NAME, clazz.getQualifiedName().toString());
        bindings.put(SIMPLE_CLASS_NAME, clazz.getSimpleName().toString());
        bindings.put(METHOD_NAME, element.getSimpleName().toString());
        bindings.put(METHOD_RETURN_TYPE, ((Object)element.getReturnType()).toString());
        switch (element.getReturnType().getKind()) {
            case BOOLEAN: {
                value = "false";
                break;
            }
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                value = 0;
                break;
            }
            default: {
                value = "null";
            }
        }
        bindings.put(DEFAULT_RETURN_TYPE_VALUE, value);
        StringBuilder sb = new StringBuilder();
        sb.append("super.").append(element.getSimpleName()).append('(');
        Iterator<? extends VariableElement> it = element.getParameters().iterator();
        while (it.hasNext()) {
            VariableElement ve = it.next();
            sb.append(ve.getSimpleName());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        sb.append(')');
        bindings.put(SUPER_METHOD_CALL, sb);
        return bindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFromTemplate(String pathToTemplate, Map<String, Object> values) throws IOException, ScriptException {
        FileObject template = FileUtil.getConfigFile((String)pathToTemplate);
        Charset sourceEnc = FileEncodingQuery.getEncoding((FileObject)template);
        ScriptEngine eng = GeneratorUtilities.engine(template);
        Bindings bind = eng.getContext().getBindings(100);
        bind.putAll((Map<? extends String, ? extends Object>)values);
        Reader is = null;
        try {
            eng.getContext().setAttribute(FileObject.class.getName(), template, 100);
            eng.getContext().setAttribute("javax.script.filename", template.getNameExt(), 100);
            eng.getContext().setAttribute(STRING_OUTPUT_MODE_ATTR, true, 100);
            is = new InputStreamReader(template.getInputStream(), sourceEnc);
            String string = (String)eng.eval(is);
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptEngine engine(FileObject fo) {
        Object obj = fo.getAttribute(SCRIPT_ENGINE_ATTR);
        if (obj instanceof ScriptEngine) {
            return (ScriptEngine)obj;
        }
        if (obj instanceof String) {
            Class<GeneratorUtilities> clazz = GeneratorUtilities.class;
            synchronized (GeneratorUtilities.class) {
                if (manager == null) {
                    ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    manager = new ScriptEngineManager(loader != null ? loader : Thread.currentThread().getContextClassLoader());
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return manager.getEngineByName((String)obj);
            }
        }
        return null;
    }

    private static boolean containsErrors(Tree tree) {
        Boolean b = new TreeScanner<Boolean, Boolean>(){

            @Override
            public Boolean visitErroneous(ErroneousTree node, Boolean p) {
                return true;
            }

            @Override
            public Boolean reduce(Boolean r1, Boolean r2) {
                if (r1 == null) {
                    r1 = false;
                }
                if (r2 == null) {
                    r2 = false;
                }
                return r1 != false || r2 != false;
            }

            @Override
            public Boolean scan(Tree node, Boolean p) {
                return p != false ? p : (Boolean)super.scan(node, p);
            }
        }.scan(tree, (Boolean)false);
        return b != null ? b : false;
    }

    private static class ImportsComparator
    implements Comparator<Object> {
        private CodeStyle.ImportGroups groups;

        private ImportsComparator(CodeStyle cs) {
            this.groups = cs.getImportGroups();
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            boolean isStatic1 = false;
            StringBuilder sb1 = new StringBuilder();
            if (o1 instanceof ImportTree) {
                isStatic1 = ((ImportTree)o1).isStatic();
                sb1.append(((ImportTree)o1).getQualifiedIdentifier().toString());
            } else if (o1 instanceof Element) {
                Element e1 = (Element)o1;
                if (e1.getKind().isField() || e1.getKind() == ElementKind.METHOD) {
                    sb1.append('.').append(e1.getSimpleName());
                    e1 = e1.getEnclosingElement();
                    isStatic1 = true;
                }
                if (e1.getKind().isClass() || e1.getKind().isInterface()) {
                    sb1.insert(0, ((TypeElement)e1).getQualifiedName());
                } else if (e1.getKind() == ElementKind.PACKAGE) {
                    sb1.insert(0, ((PackageElement)e1).getQualifiedName());
                }
            }
            String s1 = sb1.toString();
            boolean isStatic2 = false;
            StringBuilder sb2 = new StringBuilder();
            if (o2 instanceof ImportTree) {
                isStatic2 = ((ImportTree)o2).isStatic();
                sb2.append(((ImportTree)o2).getQualifiedIdentifier().toString());
            } else if (o2 instanceof Element) {
                Element e2 = (Element)o2;
                if (e2.getKind().isField() || e2.getKind() == ElementKind.METHOD) {
                    sb2.append('.').append(e2.getSimpleName());
                    e2 = e2.getEnclosingElement();
                    isStatic2 = true;
                }
                if (e2.getKind().isClass() || e2.getKind().isInterface()) {
                    sb2.insert(0, ((TypeElement)e2).getQualifiedName());
                } else if (e2.getKind() == ElementKind.PACKAGE) {
                    sb2.insert(0, ((PackageElement)e2).getQualifiedName());
                }
            }
            String s2 = sb2.toString();
            int bal = this.groups.getGroupId(s1, isStatic1) - this.groups.getGroupId(s2, isStatic2);
            return bal == 0 ? s1.compareTo(s2) : bal;
        }
    }

    private static class ClassMemberComparator
    implements Comparator<Tree> {
        private CodeStyle.MemberGroups groups;

        public ClassMemberComparator(CodeStyle cs) {
            this.groups = cs.getClassMemberGroups();
        }

        @Override
        public int compare(Tree tree1, Tree tree2) {
            if (tree1 == tree2) {
                return 0;
            }
            return this.groups.getGroupId(tree1) - this.groups.getGroupId(tree2);
        }
    }
}

