/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.AbstractPathArchive;
import org.netbeans.modules.java.source.parsing.FileObjects;

public final class PathArchive
extends AbstractPathArchive {
    PathArchive(@NonNull Path root, @NullAllowed URI rootURI) {
        super(root, rootURI);
    }

    @Override
    @NonNull
    public Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NullAllowed Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter, boolean recursive) throws IOException {
        if (this.separator != '/') {
            folderName = folderName.replace('/', this.separator);
        }
        Path target = this.root.resolve(folderName);
        ArrayList res = new ArrayList();
        try (Stream<Path> s = recursive ? Files.walk(target, FileVisitOption.FOLLOW_LINKS) : Files.list(target);){
            s.filter(p -> (kinds == null || kinds.contains((Object)FileObjects.getKind(FileObjects.getExtension(p.getFileName().toString())))) && Files.isRegularFile(p, new LinkOption[0])).forEach(p -> res.add(FileObjects.pathFileObject(p, this.root, this.rootURI, null)));
        }
        return Collections.unmodifiableCollection(res);
    }

    @Override
    @CheckForNull
    public JavaFileObject getFile(@NonNull String name) throws IOException {
        Path target;
        if (this.separator != '/') {
            name = name.replace('/', this.separator);
        }
        return Files.exists(target = this.root.resolve(name), new LinkOption[0]) ? FileObjects.pathFileObject(target, this.root, this.rootURI, null) : null;
    }

    @Override
    public JavaFileObject create(String relativeName, JavaFileFilterImplementation filter) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Write not supported");
    }
}

