/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.OrganizeImports;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

public final class OrganizeImportsCodeAction
extends CodeActionsProvider {
    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        CompilationController info;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source") && !only.contains("source.organizeImports")) {
            return Collections.emptyList();
        }
        CompilationController compilationController = info = resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
        if (info == null) {
            return Collections.emptyList();
        }
        String uri = Utils.toUri(info.getFileObject());
        return Collections.singletonList(this.createCodeAction(client, Bundle.DN_OrganizeImports(), "source.organizeImports", (Object)uri, null, new Object[0]));
    }

    @Override
    public CompletableFuture<CodeAction> resolve(NbCodeLanguageClient client, CodeAction codeAction, Object data) {
        CompletableFuture<CodeAction> future = new CompletableFuture<CodeAction>();
        try {
            String uri = ((JsonPrimitive)data).getAsString();
            FileObject file = Utils.fromUri(uri);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            if (js == null) {
                throw new IOException("Cannot get JavaSource for: " + uri);
            }
            List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                OrganizeImports.doOrganizeImports((WorkingCopy)wc, null, (boolean)false);
            }));
            if (!edits.isEmpty()) {
                codeAction.setEdit(new WorkspaceEdit(Collections.singletonMap(uri, edits)));
            }
            future.complete(codeAction);
        }
        catch (IOException | IllegalArgumentException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }
}

