/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer.api;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.xbase.lib.Pure;
import org.netbeans.modules.java.lsp.server.explorer.api.NodeChangeType;

public class NodeChangedParams {
    @NonNull
    private int rootId;
    private Integer nodeId;
    private Set<NodeChangeType> types = EnumSet.noneOf(NodeChangeType.class);
    private Set<String> changedProperties;

    public NodeChangedParams(int rootId) {
        this.rootId = rootId;
        this.nodeId = null;
    }

    public NodeChangedParams(int rootId, int nodeId) {
        this.rootId = rootId;
        this.nodeId = nodeId;
    }

    public void addType(NodeChangeType t) {
        this.types.add(t);
    }

    @Pure
    @NonNull
    public Set<NodeChangeType> getTypes() {
        return this.types;
    }

    @Pure
    @NonNull
    public int getRootId() {
        return this.rootId;
    }

    @Pure
    public Integer getNodeId() {
        return this.nodeId;
    }

    public NodeChangedParams() {
    }

    public void setRootId(int rootId) {
        this.rootId = rootId;
    }

    public void setNodeId(Integer nodeId) {
        this.nodeId = nodeId;
    }

    public void addChangedProperty(String name) {
        if (this.changedProperties == null) {
            this.changedProperties = new HashSet<String>();
        }
        this.changedProperties.add(name);
    }

    @Pure
    public Set<String> getChangedProperties() {
        return this.changedProperties;
    }

    public void setChangedProperties(Set<String> changedProperties) {
        this.changedProperties = changedProperties;
    }

    public NodeChangedParams merge(NodeChangedParams other) {
        if (other.getNodeId() != this.getNodeId() || other.getRootId() != this.getRootId()) {
            throw new IllegalArgumentException("Incompatible change: " + other);
        }
        this.types.addAll(other.getTypes());
        return this;
    }
}

