/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.debug.Capabilities;
import org.eclipse.lsp4j.debug.ConfigurationDoneArguments;
import org.eclipse.lsp4j.debug.ContinueArguments;
import org.eclipse.lsp4j.debug.ContinueResponse;
import org.eclipse.lsp4j.debug.DisconnectArguments;
import org.eclipse.lsp4j.debug.EvaluateArguments;
import org.eclipse.lsp4j.debug.EvaluateResponse;
import org.eclipse.lsp4j.debug.ExceptionBreakpointsFilter;
import org.eclipse.lsp4j.debug.ExceptionInfoArguments;
import org.eclipse.lsp4j.debug.ExceptionInfoResponse;
import org.eclipse.lsp4j.debug.InitializeRequestArguments;
import org.eclipse.lsp4j.debug.NextArguments;
import org.eclipse.lsp4j.debug.PauseArguments;
import org.eclipse.lsp4j.debug.RestartFrameArguments;
import org.eclipse.lsp4j.debug.Scope;
import org.eclipse.lsp4j.debug.ScopesArguments;
import org.eclipse.lsp4j.debug.ScopesResponse;
import org.eclipse.lsp4j.debug.SetBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsArguments;
import org.eclipse.lsp4j.debug.SetExceptionBreakpointsResponse;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.SetVariableResponse;
import org.eclipse.lsp4j.debug.Source;
import org.eclipse.lsp4j.debug.SourceArguments;
import org.eclipse.lsp4j.debug.SourceResponse;
import org.eclipse.lsp4j.debug.StackFrame;
import org.eclipse.lsp4j.debug.StackTraceArguments;
import org.eclipse.lsp4j.debug.StackTraceResponse;
import org.eclipse.lsp4j.debug.StepInArguments;
import org.eclipse.lsp4j.debug.StepOutArguments;
import org.eclipse.lsp4j.debug.StoppedEventArguments;
import org.eclipse.lsp4j.debug.Thread;
import org.eclipse.lsp4j.debug.ThreadsResponse;
import org.eclipse.lsp4j.debug.VariablesArguments;
import org.eclipse.lsp4j.debug.VariablesResponse;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.LspSession;
import org.netbeans.modules.java.lsp.server.URITranslator;
import org.netbeans.modules.java.lsp.server.debugging.Bundle;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.NbFrame;
import org.netbeans.modules.java.lsp.server.debugging.NbScope;
import org.netbeans.modules.java.lsp.server.debugging.NbSourceProvider;
import org.netbeans.modules.java.lsp.server.debugging.ThreadObjects;
import org.netbeans.modules.java.lsp.server.debugging.attach.NbAttachRequestHandler;
import org.netbeans.modules.java.lsp.server.debugging.breakpoints.NbBreakpointsRequestHandler;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbDebugSession;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbDisconnectRequestHandler;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbLaunchRequestHandler;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.debugging.variables.NbVariablesRequestHandler;
import org.netbeans.modules.nativeimage.api.debug.EvaluateException;
import org.netbeans.modules.nativeimage.api.debug.NIDebugger;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.util.RequestProcessor;

public final class NbProtocolServer
implements IDebugProtocolServer,
LspSession.ScheduledServer {
    private static final Logger LOGGER = Logger.getLogger(NbProtocolServer.class.getName());
    private static final Level LOGLEVEL = Level.FINE;
    private final DebugAdapterContext context;
    private final NbLaunchRequestHandler launchRequestHandler = new NbLaunchRequestHandler();
    private final NbAttachRequestHandler attachRequestHandler = new NbAttachRequestHandler();
    private final NbDisconnectRequestHandler disconnectRequestHandler = new NbDisconnectRequestHandler();
    private final NbBreakpointsRequestHandler breakpointsRequestHandler = new NbBreakpointsRequestHandler();
    private final NbVariablesRequestHandler variablesRequestHandler = new NbVariablesRequestHandler();
    private final RequestProcessor evaluationRP = new RequestProcessor(NbProtocolServer.class.getName(), 3);
    private final RequestProcessor threadsRP = new RequestProcessor(NbProtocolServer.class.getName(), 1);
    private boolean initialized = false;
    private Future<Void> runningServer;

    public NbProtocolServer(DebugAdapterContext context) {
        this.context = context;
    }

    public CompletableFuture<Capabilities> initialize(InitializeRequestArguments args) {
        if (!this.initialized) {
            this.initialized = true;
            this.context.getThreadsProvider().initialize(this.context, Collections.emptyMap());
        }
        this.context.setClientLinesStartAt1(args.getLinesStartAt1());
        this.context.setClientColumnsStartAt1(args.getColumnsStartAt1());
        String pathFormat = args.getPathFormat();
        if (pathFormat != null) {
            switch (pathFormat) {
                case "uri": {
                    this.context.setClientPathsAreUri(true);
                    break;
                }
                default: {
                    this.context.setClientPathsAreUri(false);
                }
            }
        }
        this.context.setSupportsRunInTerminalRequest(args.getSupportsRunInTerminalRequest());
        Capabilities caps = new Capabilities();
        caps.setSupportsConfigurationDoneRequest(Boolean.valueOf(true));
        caps.setSupportsHitConditionalBreakpoints(Boolean.valueOf(true));
        caps.setSupportsConditionalBreakpoints(Boolean.valueOf(true));
        caps.setSupportsSetVariable(Boolean.valueOf(true));
        caps.setSupportTerminateDebuggee(Boolean.valueOf(true));
        caps.setSupportsCompletionsRequest(Boolean.valueOf(true));
        caps.setSupportsRestartFrame(Boolean.valueOf(true));
        caps.setSupportsLogPoints(Boolean.valueOf(true));
        caps.setSupportsEvaluateForHovers(Boolean.valueOf(true));
        ExceptionBreakpointsFilter uncaught = new ExceptionBreakpointsFilter();
        uncaught.setFilter("uncaught");
        uncaught.setLabel("Uncaught Exceptions");
        ExceptionBreakpointsFilter caught = new ExceptionBreakpointsFilter();
        caught.setFilter("caught");
        caught.setLabel("Caught Exceptions");
        caps.setExceptionBreakpointFilters(new ExceptionBreakpointsFilter[]{uncaught, caught});
        caps.setSupportsExceptionInfoRequest(Boolean.valueOf(true));
        LspServerState lspServerState = (LspServerState)this.context.getLspSession().getLookup().lookup(LspServerState.class);
        if (lspServerState != null) {
            CompletableFuture<Project[]> initDone = lspServerState.openedProjects();
            if (!initDone.isDone()) {
                LOGGER.log(Level.INFO, "Waiting on LS protocol server {0} to finish initialization", lspServerState);
                return lspServerState.openedProjects().thenApply(prjs -> {
                    LOGGER.log(Level.FINE, "LS protocol server {0} initialized, DAP init complete", lspServerState);
                    return caps;
                });
            }
            LOGGER.log(Level.FINE, "LS protocol server {0} ready", lspServerState);
        }
        return CompletableFuture.completedFuture(caps);
    }

    public CompletableFuture<Void> configurationDone(ConfigurationDoneArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        NbDebugSession debugSession = this.context.getDebugSession();
        if (debugSession != null) {
            this.context.getConfigurationSemaphore().notifyCongigurationDone();
            future.complete(null);
        } else {
            ErrorUtilities.completeExceptionally(future, "Failed to launch debug session, the debugger will exit.", ResponseErrorCode.ServerNotInitialized);
        }
        return future;
    }

    public CompletableFuture<Void> launch(Map<String, Object> args) {
        return this.launchRequestHandler.launch(args, this.context);
    }

    public CompletableFuture<Void> attach(Map<String, Object> args) {
        return this.attachRequestHandler.attach(args, this.context);
    }

    public CompletableFuture<Void> disconnect(DisconnectArguments args) {
        return this.disconnectRequestHandler.disconnect(args, this.context);
    }

    public CompletableFuture<SetBreakpointsResponse> setBreakpoints(SetBreakpointsArguments args) {
        return this.breakpointsRequestHandler.setBreakpoints(args, this.context);
    }

    public CompletableFuture<SetExceptionBreakpointsResponse> setExceptionBreakpoints(SetExceptionBreakpointsArguments args) {
        return this.breakpointsRequestHandler.setExceptionBreakpoints(args, this.context);
    }

    public CompletableFuture<ContinueResponse> continue_(ContinueArguments args) {
        ContinueResponse response = new ContinueResponse();
        if (args.getThreadId() > 0) {
            DebuggingView.DVThread dvThread = this.context.getThreadsProvider().getThread(args.getThreadId());
            if (dvThread != null) {
                dvThread.resume();
                this.context.getThreadsProvider().getThreadObjects().cleanObjects(args.getThreadId());
            }
            response.setAllThreadsContinued(Boolean.valueOf(false));
        } else {
            Session session = this.context.getDebugSession().getSession();
            session.getCurrentEngine().getActionsManager().doAction((Object)"continue");
            this.context.getThreadsProvider().getThreadObjects().cleanAll();
            response.setAllThreadsContinued(Boolean.valueOf(true));
        }
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<Void> next(NextArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
        } else {
            ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
            am.doAction((Object)"stepOver");
            future.complete(null);
        }
        return future;
    }

    public CompletableFuture<Void> stepIn(StepInArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
        } else {
            ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
            am.doAction((Object)"stepInto");
            future.complete(null);
        }
        return future;
    }

    public CompletableFuture<Void> stepOut(StepOutArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.context.getDebugSession() == null) {
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
        } else {
            ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
            am.doAction((Object)"stepOut");
            future.complete(null);
        }
        return future;
    }

    public CompletableFuture<Void> pause(PauseArguments args) {
        StoppedEventArguments ev;
        if (args.getThreadId() > 0) {
            DebuggingView.DVThread dvThread = this.context.getThreadsProvider().getThread(args.getThreadId());
            if (dvThread != null) {
                dvThread.suspend();
                ev = new StoppedEventArguments();
                ev.setReason("pause");
                ev.setThreadId(Integer.valueOf(args.getThreadId()));
                ev.setAllThreadsStopped(Boolean.valueOf(false));
            } else {
                ev = null;
            }
        } else {
            Session session = this.context.getDebugSession().getSession();
            session.getCurrentEngine().getActionsManager().doAction((Object)"pause");
            ev = new StoppedEventArguments();
            ev.setReason("pause");
            ev.setThreadId(Integer.valueOf(0));
            ev.setAllThreadsStopped(Boolean.valueOf(true));
        }
        if (ev != null) {
            this.context.getClient().stopped(ev);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<StackTraceResponse> stackTrace(StackTraceArguments args) {
        if (this.context.getDebugSession() == null) {
            CompletableFuture<StackTraceResponse> future = new CompletableFuture<StackTraceResponse>();
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
            return future;
        }
        return CompletableFuture.supplyAsync(() -> {
            LOGGER.log(LOGLEVEL, "stackTrace() START");
            long t1 = System.nanoTime();
            ArrayList<StackFrame> result = new ArrayList<StackFrame>();
            int cnt = 0;
            DebuggingView.DVThread dvThread = this.context.getThreadsProvider().getThread(args.getThreadId());
            if (dvThread != null) {
                cnt = dvThread.getFrameCount();
                int from = args.getStartFrame() != null ? args.getStartFrame() : 0;
                int to = args.getLevels() != null ? from + args.getLevels() : Integer.MAX_VALUE;
                List stackFrames = dvThread.getFrames(from, to);
                for (DebuggingView.DVFrame frame : stackFrames) {
                    int column;
                    int frameId = this.context.getThreadsProvider().getThreadObjects().addObject(args.getThreadId(), new NbFrame(args.getThreadId(), frame));
                    int line = frame.getLine();
                    if (line < 0) {
                        line = 0;
                    }
                    if ((column = frame.getColumn()) < 0) {
                        column = 0;
                    }
                    StackFrame stackFrame = new StackFrame();
                    stackFrame.setId(frameId);
                    stackFrame.setName(frame.getName());
                    URI sourceURI = frame.getSourceURI();
                    if (sourceURI != null) {
                        sourceURI = URI.create(URITranslator.getDefault().uriToLSP(sourceURI.toString()));
                        Source source = new Source();
                        String scheme = sourceURI.getScheme();
                        Path sourcePath = null;
                        if (null == scheme) {
                            sourcePath = Paths.get(sourceURI.getPath(), new String[0]);
                        } else if ("file".equalsIgnoreCase(scheme)) {
                            try {
                                sourcePath = Paths.get(sourceURI);
                            }
                            catch (IllegalArgumentException | SecurityException | FileSystemNotFoundException ex) {
                                sourcePath = null;
                            }
                        }
                        if (sourcePath != null) {
                            source.setName(sourcePath.getFileName().toString());
                            source.setPath(sourcePath.toString());
                            source.setSourceReference(Integer.valueOf(0));
                        } else {
                            int ref = this.context.createSourceReference(sourceURI, frame.getSourceMimeType());
                            String path = sourceURI.getPath();
                            if (path == null || path.isEmpty()) {
                                path = sourceURI.getSchemeSpecificPart();
                                while (path.startsWith("//")) {
                                    path = path.substring(1);
                                }
                            }
                            if (path != null) {
                                int sepIndex = Math.max(path.lastIndexOf(47), path.lastIndexOf(File.separatorChar));
                                source.setName(path.substring(sepIndex + 1));
                                if ("jar".equalsIgnoreCase(scheme)) {
                                    try {
                                        path = new URI(path).getPath();
                                    }
                                    catch (URISyntaxException uRISyntaxException) {
                                        // empty catch block
                                    }
                                }
                                source.setPath(path);
                            }
                            source.setSourceReference(Integer.valueOf(ref));
                        }
                        stackFrame.setSource(source);
                    }
                    stackFrame.setLine(line);
                    stackFrame.setColumn(column);
                    result.add(stackFrame);
                }
            }
            StackTraceResponse response = new StackTraceResponse();
            response.setStackFrames(result.toArray(new StackFrame[0]));
            response.setTotalFrames(Integer.valueOf(cnt));
            long t2 = System.nanoTime();
            LOGGER.log(LOGLEVEL, "stackTrace() END after {0} ns", t2 - t1);
            return response;
        }, (Executor)this.threadsRP);
    }

    public CompletableFuture<Void> restartFrame(RestartFrameArguments args) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        NbFrame stackFrame = (NbFrame)this.context.getThreadsProvider().getThreadObjects().getObject(args.getFrameId());
        String popError = null;
        if (stackFrame != null) {
            try {
                stackFrame.getDVFrame().popOff();
                ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
                am.doAction((Object)"stepInto");
                future.complete(null);
            }
            catch (UnsupportedOperationException ex) {
                popError = Bundle.MSG_FrameRestartUnsupported();
            }
            catch (DebuggingView.PopException ex) {
                popError = Bundle.MSG_FrameRestartFailed(ex.getLocalizedMessage());
            }
        }
        if (popError != null) {
            ErrorUtilities.completeExceptionally(future, popError, ResponseErrorCode.InvalidParams);
        }
        return future;
    }

    public CompletableFuture<ScopesResponse> scopes(ScopesArguments args) {
        ArrayList<Scope> result = new ArrayList<Scope>();
        NbFrame stackFrame = (NbFrame)this.context.getThreadsProvider().getThreadObjects().getObject(args.getFrameId());
        if (stackFrame != null) {
            stackFrame.getDVFrame().makeCurrent();
            NbScope localScope = new NbScope(stackFrame, "Local");
            int localScopeId = this.context.getThreadsProvider().getThreadObjects().addObject(stackFrame.getThreadId(), localScope);
            Scope scope = new Scope();
            scope.setName(localScope.getName());
            scope.setVariablesReference(localScopeId);
            scope.setExpensive(false);
            result.add(scope);
        }
        ScopesResponse response = new ScopesResponse();
        response.setScopes(result.toArray(new Scope[0]));
        return CompletableFuture.completedFuture(response);
    }

    public CompletableFuture<VariablesResponse> variables(VariablesArguments args) {
        return this.variablesRequestHandler.variables(args, this.context);
    }

    public CompletableFuture<SetVariableResponse> setVariable(SetVariableArguments args) {
        return this.variablesRequestHandler.setVariable(args, this.context);
    }

    public CompletableFuture<SourceResponse> source(SourceArguments args) {
        CompletableFuture<SourceResponse> future = new CompletableFuture<SourceResponse>();
        int sourceReference = args.getSourceReference();
        if (sourceReference <= 0) {
            ErrorUtilities.completeExceptionally(future, "SourceRequest: property 'sourceReference' is missing, null, or empty", ResponseErrorCode.InvalidParams);
        } else {
            URI uri = this.context.getSourceUri(sourceReference);
            NbSourceProvider sourceProvider = this.context.getSourceProvider();
            SourceResponse response = new SourceResponse();
            response.setMimeType(this.context.getSourceMimeType(sourceReference));
            response.setContent(sourceProvider.getSourceContents(uri));
            future.complete(response);
        }
        return future;
    }

    public CompletableFuture<ThreadsResponse> threads() {
        if (this.context.getDebugSession() == null) {
            CompletableFuture<ThreadsResponse> future = new CompletableFuture<ThreadsResponse>();
            ErrorUtilities.completeExceptionally(future, "Debug Session doesn't exist.", ResponseErrorCode.InvalidParams);
            return future;
        }
        return CompletableFuture.supplyAsync(() -> {
            LOGGER.log(LOGLEVEL, "threads() START");
            long t1 = System.nanoTime();
            ArrayList result = new ArrayList();
            this.context.getThreadsProvider().visitThreads((id, dvThread) -> {
                Thread thread = new Thread();
                thread.setId(id.intValue());
                thread.setName(dvThread.getName());
                result.add(thread);
            });
            ThreadsResponse response = new ThreadsResponse();
            response.setThreads(result.toArray(new Thread[0]));
            long t2 = System.nanoTime();
            LOGGER.log(LOGLEVEL, "threads() END after {0} ns", t2 - t1);
            return response;
        }, (Executor)this.threadsRP);
    }

    private EvaluateResponse passToApplication(String args) {
        Writer w = this.context.getInputSink();
        if (w != null) {
            try {
                w.write(args);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        EvaluateResponse resp = new EvaluateResponse();
        resp.setResult("");
        return resp;
    }

    public CompletableFuture<EvaluateResponse> evaluate(EvaluateArguments args) {
        return CompletableFuture.supplyAsync(() -> {
            String expression = args.getExpression();
            ThreadObjects obs = this.context.getThreadsProvider().getThreadObjects();
            if (args.getFrameId() == null || obs == null) {
                return this.passToApplication(args.getExpression());
            }
            if (StringUtils.isBlank((CharSequence)expression)) {
                throw ErrorUtilities.createResponseErrorException("Empty expression cannot be evaluated.", ResponseErrorCode.InvalidParams);
            }
            NbFrame stackFrame = (NbFrame)obs.getObject(args.getFrameId());
            if (stackFrame == null) {
                throw ErrorUtilities.createResponseErrorException("Unknown frame " + args.getFrameId(), ResponseErrorCode.InvalidParams);
            }
            stackFrame.getDVFrame().makeCurrent();
            DebuggingView.DVThread dvThread = stackFrame.getDVFrame().getThread();
            int threadId = this.context.getThreadsProvider().getId(dvThread);
            EvaluateResponse response = new EvaluateResponse();
            JPDADebugger debugger = this.context.getDebugSession().getJPDADebugger();
            if (debugger != null) {
                this.evaluateJPDA(debugger, expression, threadId, response);
            } else {
                NIDebugger niDebugger = this.context.getDebugSession().getNIDebugger();
                if (niDebugger == null) {
                    throw ErrorUtilities.createResponseErrorException("No active debugger is found.", ResponseErrorCode.RequestCancelled);
                }
                this.evaluateNative(niDebugger, expression, threadId, response);
            }
            return response;
        }, (Executor)this.evaluationRP);
    }

    private void evaluateJPDA(JPDADebugger debugger, String expression, int threadId, EvaluateResponse response) {
        Variable variable;
        try {
            variable = debugger.evaluate(expression);
        }
        catch (InvalidExpressionException ex) {
            throw ErrorUtilities.createResponseErrorException(ex.getLocalizedMessage(), ResponseErrorCode.ParseError);
        }
        TruffleVariable truffleVariable = TruffleVariable.get((Variable)variable);
        if (truffleVariable != null) {
            int referenceId = this.context.getThreadsProvider().getThreadObjects().addObject(threadId, truffleVariable);
            response.setResult(truffleVariable.getDisplayValue());
            response.setVariablesReference(referenceId);
            response.setType(truffleVariable.getType());
            response.setIndexedVariables(Integer.valueOf(truffleVariable.isLeaf() ? 0 : truffleVariable.getChildren().length));
        } else if (variable instanceof ObjectVariable) {
            String toString;
            int referenceId = this.context.getThreadsProvider().getThreadObjects().addObject(threadId, variable);
            int indexedVariables = ((ObjectVariable)variable).getFieldsCount();
            try {
                toString = ((ObjectVariable)variable).getToStringValue();
            }
            catch (InvalidExpressionException ex) {
                toString = variable.getValue();
            }
            response.setResult(Objects.toString(toString));
            response.setVariablesReference(referenceId);
            response.setType(variable.getType());
            response.setIndexedVariables(Integer.valueOf(Math.max(indexedVariables, 0)));
        } else {
            response.setResult(variable.getValue());
            response.setType(variable.getType());
        }
    }

    private void evaluateNative(NIDebugger niDebugger, String expression, int threadId, EvaluateResponse response) {
        try {
            NIVariable variable = niDebugger.evaluate(expression, null, null);
            int numChildren = variable.getNumChildren();
            if (numChildren > 0) {
                int referenceId = this.context.getThreadsProvider().getThreadObjects().addObject(threadId, variable);
                response.setResult(variable.getValue());
                response.setVariablesReference(referenceId);
                response.setType(variable.getType());
                response.setIndexedVariables(Integer.valueOf(numChildren));
            } else {
                response.setResult(variable.getValue());
                response.setType(variable.getType());
            }
        }
        catch (EvaluateException ex) {
            throw ErrorUtilities.createResponseErrorException(ex.getLocalizedMessage(), ResponseErrorCode.ParseError);
        }
    }

    public CompletableFuture<ExceptionInfoResponse> exceptionInfo(ExceptionInfoArguments args) {
        CompletableFuture<ExceptionInfoResponse> future = new CompletableFuture<ExceptionInfoResponse>();
        Variable exceptionVariable = this.context.getBreakpointManager().getExceptionOn(args.getThreadId());
        if (exceptionVariable == null) {
            ErrorUtilities.completeExceptionally(future, "No exception exists in thread " + args.getThreadId(), ResponseErrorCode.InvalidParams);
        } else {
            Throwable exception = (Throwable)exceptionVariable.createMirrorObject();
            String typeName = exception.getLocalizedMessage();
            String exceptionToString = exception.toString();
            ExceptionInfoResponse response = new ExceptionInfoResponse();
            response.setExceptionId(typeName);
            response.setDescription(exceptionToString);
            future.complete(response);
        }
        return future;
    }

    void setRunningFuture(Future<Void> runningServer) {
        this.runningServer = runningServer;
    }

    @Override
    public Future<Void> getRunningFuture() {
        return this.runningServer;
    }
}

