/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.singlesourcefile;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.file.launcher.api.SourceLauncher;
import org.netbeans.modules.java.file.launcher.spi.SingleFileOptionsQueryImplementation;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;

public abstract class SingleFileOptionsQueryImpl
implements SingleFileOptionsQueryImplementation {
    private final Map<NbCodeLanguageClient, ResultImpl> client2Options = new WeakHashMap<NbCodeLanguageClient, ResultImpl>();
    private final GlobalResultImpl globalOptions = new GlobalResultImpl();

    public SingleFileOptionsQueryImplementation.Result optionsFor(FileObject file) {
        if (SingleFileOptionsQueryImpl.isSingleSourceFile(file)) {
            NbCodeLanguageClient client = (NbCodeLanguageClient)Lookup.getDefault().lookup(NbCodeLanguageClient.class);
            if (client != null) {
                return this.getResult(client);
            }
            return this.globalOptions;
        }
        return null;
    }

    public boolean setConfiguration(NbCodeLanguageClient client, String vmOptions) {
        if (this.getResult(client).setOptions(vmOptions)) {
            this.globalOptions.cs.fireChange();
            return true;
        }
        return false;
    }

    private synchronized ResultImpl getResult(NbCodeLanguageClient client) {
        return this.client2Options.computeIfAbsent(client, cl -> new ResultImpl());
    }

    static boolean isSingleSourceFile(FileObject fObj) {
        Project p = FileOwnerQuery.getOwner((FileObject)fObj);
        if (p != null) {
            return false;
        }
        if (!fObj.isFolder() && !fObj.getExt().equalsIgnoreCase("java")) {
            return false;
        }
        return SourceLauncher.isSourceLauncherFile((FileObject)fObj);
    }

    private final class GlobalResultImpl
    implements SingleFileOptionsQueryImplementation.Result {
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        private GlobalResultImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getOptions() {
            ArrayList<String> options = new ArrayList<String>();
            SingleFileOptionsQueryImpl singleFileOptionsQueryImpl = SingleFileOptionsQueryImpl.this;
            synchronized (singleFileOptionsQueryImpl) {
                for (ResultImpl r : SingleFileOptionsQueryImpl.this.client2Options.values()) {
                    options.add(r.getOptions());
                }
            }
            return SourceLauncher.joinCommandLines(options);
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }
    }

    private static final class ResultImpl
    implements SingleFileOptionsQueryImplementation.Result {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private String options = "";

        private ResultImpl() {
        }

        public synchronized String getOptions() {
            return this.options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setOptions(String options) {
            ResultImpl resultImpl = this;
            synchronized (resultImpl) {
                if (Objects.equals(this.options, options)) {
                    return false;
                }
                this.options = options;
            }
            this.cs.fireChange();
            return true;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }
    }
}

