/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.java.lsp.server.explorer.TreeNodeRegistry;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class DBCommandProvider
extends CodeActionsProvider {
    private static final String COMMAND_GET_PREFERRED_CONNECTION = "java.db.preferred.connection";
    private static final Set<String> COMMANDS = new HashSet<String>(Arrays.asList("java.db.preferred.connection"));

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (!COMMAND_GET_PREFERRED_CONNECTION.equals(command)) {
            return null;
        }
        TreeNodeRegistry r = (TreeNodeRegistry)Lookup.getDefault().lookup(TreeNodeRegistry.class);
        DatabaseConnection conn = ConnectionManager.getDefault().getPreferredConnection(true);
        if (conn == null || r == null) {
            return CompletableFuture.completedFuture(null);
        }
        return r.createProvider("database.connections").thenCompose(m -> {
            Node root = m.getExplorerManager().getRootContext();
            for (Node n : root.getChildren().getNodes(true)) {
                DatabaseConnection d = (DatabaseConnection)n.getLookup().lookup(DatabaseConnection.class);
                if (d == null || !d.getName().equals(conn.getName())) continue;
                return m.getNodeId(n);
            }
            return CompletableFuture.completedFuture(null);
        }).toCompletableFuture();
    }

    @Override
    public Set<String> getCommands() {
        return COMMANDS;
    }
}

