/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.eclipse.lsp4j.CompletionItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.LaunchConfigurationCompletion;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.util.Exceptions;

public class ProjectConfigurationCompletion
implements LaunchConfigurationCompletion {
    private static final String CONFIG_TYPE = "java8+";

    @Override
    public CompletableFuture<List<CompletionItem>> configurations(Supplier<CompletableFuture<Project>> projectSupplier) {
        return projectSupplier.get().thenApply(p -> ProjectConfigurationCompletion.createConfigurationsCompletion(p));
    }

    @Override
    public CompletableFuture<List<CompletionItem>> attributes(Supplier<CompletableFuture<Project>> projectSupplier, Map<String, Object> currentAttributes) {
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    @Override
    public CompletableFuture<List<CompletionItem>> attributeValues(Supplier<CompletableFuture<Project>> projectSupplier, Map<String, Object> currentAttributes, String attribute) {
        if ("launchConfiguration".equals(attribute)) {
            return projectSupplier.get().thenApply(p -> this.createLaunchConfigCompletion((Project)p));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private static List<CompletionItem> createConfigurationsCompletion(Project p) {
        Collection<ProjectConfiguration> configurations = ProjectConfigurationCompletion.getConfigurations(p);
        int size = configurations.size();
        if (size <= 1) {
            return Collections.emptyList();
        }
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>(size - 1);
        boolean skipFirst = true;
        for (ProjectConfiguration c : configurations) {
            if (skipFirst) {
                skipFirst = false;
                continue;
            }
            String configDisplayName = c.getDisplayName();
            String launchName = Bundle.LBL_LaunchJavaConfig(configDisplayName);
            CompletionItem ci = new CompletionItem("Java 8+: " + launchName);
            StringWriter sw = new StringWriter();
            try (JsonWriter w = new JsonWriter((Writer)sw);){
                w.setIndent("\t");
                w.beginObject();
                w.name("name").value(launchName);
                w.name("type").value(CONFIG_TYPE);
                w.name("request").value("launch");
                w.name("mainClass").value("${file}");
                w.name("launchConfiguration").value(configDisplayName);
                w.endObject();
                w.flush();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            ci.setInsertText(sw.toString());
            ci.setDocumentation(Bundle.LBL_LaunchJavaConfig_desc(configDisplayName));
            completionItems.add(ci);
        }
        return completionItems;
    }

    private List<CompletionItem> createLaunchConfigCompletion(Project p) {
        Collection<ProjectConfiguration> configurations = ProjectConfigurationCompletion.getConfigurations(p);
        int size = configurations.size();
        if (size <= 1) {
            return Collections.emptyList();
        }
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>(size - 1);
        boolean skipFirst = true;
        for (ProjectConfiguration c : configurations) {
            if (skipFirst) {
                skipFirst = false;
                continue;
            }
            String configDisplayName = c.getDisplayName();
            CompletionItem ci = new CompletionItem(configDisplayName);
            ci.setInsertText("\"" + Utils.encode2JSON(configDisplayName) + "\"");
            completionItems.add(ci);
        }
        return completionItems;
    }

    private static Collection<ProjectConfiguration> getConfigurations(Project p) {
        ProjectConfigurationProvider provider;
        ProjectConfigurationProvider projectConfigurationProvider = provider = p != null ? (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class) : null;
        if (provider == null) {
            return Collections.emptyList();
        }
        return provider.getConfigurations();
    }
}

