/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.ui;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.lsp.server.protocol.HtmlPageParams;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowInputBoxParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowStatusMessageParams;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;

public abstract class UIContext {
    private static Reference<UIContext> lastCtx = new WeakReference<Object>(null);

    @NonNull
    public static synchronized UIContext find(Lookup lkp) {
        UIContext ctx = (UIContext)lkp.lookup(UIContext.class);
        if (ctx != null) {
            return ctx;
        }
        Lookup def = Lookup.getDefault();
        if (lkp != def) {
            ctx = (UIContext)def.lookup(UIContext.class);
        }
        if (ctx == null && (ctx = lastCtx.get()) != null && !ctx.isValid()) {
            lastCtx.clear();
            ctx = null;
        }
        if (ctx == null) {
            ctx = LogImpl.DEFAULT;
        } else if (lastCtx.get() != ctx) {
            lastCtx = new WeakReference<UIContext>(ctx);
        }
        return ctx;
    }

    @NonNull
    public static synchronized UIContext find() {
        return UIContext.find(Lookup.getDefault());
    }

    protected abstract boolean isValid();

    protected abstract void showMessage(MessageParams var1);

    protected CompletableFuture<String> showHtmlPage(HtmlPageParams msg) {
        this.showMessage(new MessageParams(MessageType.Log, msg.getUri()));
        return CompletableFuture.completedFuture(null);
    }

    protected abstract CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams var1);

    protected abstract void logMessage(MessageParams var1);

    protected abstract StatusDisplayer.Message showStatusMessage(ShowStatusMessageParams var1);

    protected CompletableFuture<String> showInputBox(ShowInputBoxParams params) {
        throw new AbstractMethodError();
    }

    protected CompletableFuture<List<QuickPickItem>> showQuickPick(ShowQuickPickParams params) {
        throw new AbstractMethodError();
    }

    private static final class LogImpl
    extends UIContext {
        static final LogImpl DEFAULT = new LogImpl();

        private LogImpl() {
        }

        @Override
        protected CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams msg) {
            System.err.println(msg.getType() + ": " + msg.getMessage());
            CompletableFuture<Object> ai = CompletableFuture.completedFuture(null);
            return ai;
        }

        @Override
        protected void showMessage(MessageParams msg) {
            System.err.println(msg.getType() + ": " + msg.getMessage());
        }

        @Override
        protected void logMessage(MessageParams msg) {
            System.err.println(msg.getType() + ": " + msg.getMessage());
        }

        @Override
        protected StatusDisplayer.Message showStatusMessage(ShowStatusMessageParams msg) {
            System.out.println(msg.getType() + ": " + msg.getMessage());
            return timeInMillis -> {};
        }

        @Override
        protected boolean isValid() {
            return true;
        }

        @Override
        protected CompletableFuture<String> showHtmlPage(HtmlPageParams msg) {
            System.out.println("Open in browser: " + msg.getUri());
            return CompletableFuture.completedFuture(null);
        }

        @Override
        protected CompletableFuture<String> showInputBox(ShowInputBoxParams params) {
            System.err.println("input: " + params.getPrompt());
            CompletableFuture<Object> ai = CompletableFuture.completedFuture(null);
            return ai;
        }

        @Override
        protected CompletableFuture<List<QuickPickItem>> showQuickPick(ShowQuickPickParams params) {
            System.err.println("quickPick: " + params.getPlaceHolder());
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }
}

