/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.Server;
import org.openide.util.Lookup;

public class LspServerUtils {
    @CheckForNull
    public static final NbCodeLanguageClient findLspClient(Lookup context) {
        NbCodeLanguageClient client;
        NbCodeLanguageClient nbCodeLanguageClient = client = context != null ? (NbCodeLanguageClient)context.lookup(NbCodeLanguageClient.class) : null;
        if (client == null && context != Lookup.getDefault()) {
            client = (NbCodeLanguageClient)Lookup.getDefault().lookup(NbCodeLanguageClient.class);
        }
        return client;
    }

    @NonNull
    public static final NbCodeLanguageClient requireLspClient(Lookup context) {
        NbCodeLanguageClient client = LspServerUtils.findLspClient(context);
        return client != null ? client : Server.getStubClient();
    }

    public static final boolean isClientResponseThread(NbCodeLanguageClient client) {
        return Server.isClientResponseThread(client);
    }

    public static final void avoidClientMessageThread(Lookup context) {
        NbCodeLanguageClient client = LspServerUtils.findLspClient(context);
        if (LspServerUtils.isClientResponseThread(client)) {
            throw new IllegalStateException("Can not block LSP server message loop. Use RequestProcessor to run the calling code, or use notifyLater()");
        }
    }
}

