/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.tree;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.netbeans.modules.diff.tree.TreeEntry;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class RecursiveDiffer {
    private static final Logger LOG = Logger.getLogger(RecursiveDiffer.class.getName());
    private static final RequestProcessor requestProcessor = new RequestProcessor("RecursiveDiffer", 1, false, false);
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private FileObject dir1;
    private FileObject dir2;
    private TreeEntry filteredResult;
    private TreeEntry scanResult;
    private final Map<TreeEntry, TreeEntry> filteredResultMap = new WeakHashMap<TreeEntry, TreeEntry>();
    private boolean flatten = true;
    private boolean scanning = false;
    private volatile boolean cancel = false;
    private List<Pattern> exclusionPatterns = Collections.emptyList();

    public RecursiveDiffer(FileObject dir1, FileObject dir2) {
        this.dir1 = dir1;
        this.dir2 = dir2;
    }

    public FileObject getDir1() {
        return this.dir1;
    }

    public void setDir1(FileObject dir1) {
        this.dir1 = dir1;
    }

    public FileObject getDir2() {
        return this.dir2;
    }

    public void setDir2(FileObject dir2) {
        this.dir2 = dir2;
    }

    public List<Pattern> getExclusionPatterns() {
        return Collections.unmodifiableList(this.exclusionPatterns);
    }

    public void setExclusionPatterns(List<Pattern> exclusionPatterns) {
        this.exclusionPatterns = exclusionPatterns != null ? new ArrayList<Pattern>(exclusionPatterns) : Collections.emptyList();
    }

    public TreeEntry getScanResult() {
        return this.scanResult;
    }

    public TreeEntry getFilteredResult() {
        return this.filteredResult;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        boolean old = this.flatten;
        this.flatten = flatten;
        this.pcs.firePropertyChange("flatten", old, this.flatten);
        requestProcessor.post(() -> this.updateFilteredResult());
    }

    public boolean isScanning() {
        return this.scanning;
    }

    public void setScanning(boolean scanning) {
        this.scanning = scanning;
    }

    public void cancelScan() {
        this.cancel = true;
    }

    public void startScan() {
        this.cancel = false;
        assert (SwingUtilities.isEventDispatchThread());
        if (this.scanning) {
            return;
        }
        this.scanning = true;
        this.pcs.firePropertyChange("scanning", false, true);
        requestProcessor.post(() -> {
            try {
                TreeEntry te = this.scan(this.dir1, this.dir2, this.dir1, this.dir2);
                SwingUtilities.invokeLater(() -> {
                    TreeEntry oldResult = this.scanResult;
                    this.scanResult = te;
                    this.pcs.firePropertyChange("scanResult", oldResult, (Object)this.scanning);
                    requestProcessor.post(() -> this.updateFilteredResult());
                });
            }
            catch (StopScanningException ex) {
                if (this.scanResult == null) {
                    SwingUtilities.invokeLater(() -> {
                        TreeEntry oldResult = this.scanResult;
                        this.scanResult = new TreeEntry(this.dir1, this.dir2, this.dir1, this.dir2, TreeEntry.DIR, TreeEntry.DIR, Collections.emptyList());
                        this.pcs.firePropertyChange("scanResult", oldResult, (Object)this.scanning);
                        requestProcessor.post(() -> this.updateFilteredResult());
                    });
                }
            }
            finally {
                SwingUtilities.invokeLater(() -> {
                    this.scanning = false;
                    this.pcs.firePropertyChange("scanning", true, false);
                });
            }
        });
    }

    private void updateFilteredResult() {
        HashMap<TreeEntry, TreeEntry> filteredMap = new HashMap<TreeEntry, TreeEntry>();
        TreeEntry localInput = this.filterEntry(this.scanResult, filteredMap);
        SwingUtilities.invokeLater(() -> {
            this.filteredResultMap.clear();
            this.filteredResultMap.putAll(filteredMap);
            TreeEntry old = this.filteredResult;
            this.filteredResult = localInput;
            this.pcs.firePropertyChange("filteredResult", old, this.filteredResult);
        });
    }

    private TreeEntry filterEntry(TreeEntry te, Map<TreeEntry, TreeEntry> filteredMap) {
        if (te == null) {
            return null;
        }
        ArrayList<TreeEntry> newChildren = new ArrayList<TreeEntry>();
        if (this.flatten) {
            ArrayList queue = new ArrayList();
            queue.addAll(te.getChildren());
            while (!queue.isEmpty()) {
                TreeEntry cte = (TreeEntry)queue.remove(0);
                if (!cte.isFilesIdentical()) {
                    newChildren.add(new TreeEntry(cte.getFile1(), cte.getFile2(), cte.getBasePath1(), cte.getBasePath2(), cte.getChecksum1(), cte.getChecksum2(), Collections.emptyList()));
                }
                queue.addAll(cte.getChildren());
            }
        } else {
            for (TreeEntry child : te.getChildren()) {
                TreeEntry filteredEntry = this.filterEntry(child, filteredMap);
                if (filteredEntry.isFilesIdentical() && filteredEntry.getChildren().isEmpty()) continue;
                newChildren.add(filteredEntry);
            }
        }
        TreeEntry filteredEntry = new TreeEntry(te.getFile1(), te.getFile2(), te.getBasePath1(), te.getBasePath2(), te.getChecksum1(), te.getChecksum2(), newChildren);
        filteredMap.put(filteredEntry, te);
        return filteredEntry;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    private TreeEntry scan(FileObject fo1, FileObject fo2, FileObject baseDir1, FileObject baseDir2) throws StopScanningException {
        this.checkCanceled();
        byte[] checksum1 = this.getChecksum(fo1);
        byte[] checksum2 = this.getChecksum(fo2);
        HashMap<String, FileObject> dir1Children = new HashMap<String, FileObject>();
        HashMap<String, FileObject> dir2Children = new HashMap<String, FileObject>();
        if (fo1 != null) {
            for (FileObject fo : fo1.getChildren()) {
                dir1Children.put(fo.getNameExt(), fo);
            }
        }
        if (fo2 != null) {
            for (FileObject fo : fo2.getChildren()) {
                dir2Children.put(fo.getNameExt(), fo);
            }
        }
        TreeSet childNames = new TreeSet();
        childNames.addAll(dir1Children.keySet());
        childNames.addAll(dir2Children.keySet());
        ArrayList<TreeEntry> children = new ArrayList<TreeEntry>();
        block2: for (String childName : childNames) {
            FileObject child1 = (FileObject)dir1Children.get(childName);
            FileObject child2 = (FileObject)dir2Children.get(childName);
            if (child1 != null && !child1.isValid()) {
                child1 = null;
            }
            if (child2 != null && !child2.isValid()) {
                child2 = null;
            }
            String relativePath = child1 != null ? child1.getPath().substring(baseDir1.getPath().length() + 1) : child2.getPath().substring(baseDir2.getPath().length() + 1);
            for (Pattern p : this.exclusionPatterns) {
                if (!p.matcher(relativePath).matches()) continue;
                continue block2;
            }
            children.add(this.scan(child1, child2, baseDir1, baseDir2));
        }
        Collections.sort(children);
        return new TreeEntry(fo1, fo2, baseDir1, baseDir2, checksum1, checksum2, children);
    }

    private byte[] getChecksum(FileObject fo) throws StopScanningException {
        byte[] byArray;
        block11: {
            this.checkCanceled();
            if (fo == null) {
                return new byte[0];
            }
            if (fo.isFolder()) {
                return TreeEntry.DIR;
            }
            InputStream is = fo.getInputStream();
            try {
                int read;
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                byte[] buffer = new byte[16384];
                while ((read = is.read(buffer)) >= 0) {
                    this.checkCanceled();
                    md.update(buffer, 0, read);
                }
                byArray = md.digest();
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NoSuchAlgorithmException ex) {
                    LOG.log(Level.INFO, null, ex);
                    return new byte[0];
                }
            }
            is.close();
        }
        return byArray;
    }

    private void checkCanceled() throws StopScanningException {
        if (this.cancel) {
            throw new StopScanningException();
        }
    }

    public void removeTreeEntry(TreeEntry target) {
        TreeEntry original = this.filteredResultMap.getOrDefault(target, target);
        TreeEntry parent = original.getParent();
        boolean contentIdentical = parent.isFilesIdentical();
        ArrayList<TreeEntry> newChildren = new ArrayList<TreeEntry>(parent.getChildren());
        newChildren.remove(original);
        if (newChildren.isEmpty() && contentIdentical) {
            this.removeTreeEntry(original);
        } else {
            parent.removeChild(original);
        }
        this.updateFilteredResult();
    }

    private static final class StopScanningException
    extends Exception {
        private StopScanningException() {
        }
    }
}

