/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.diff;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.spi.diff.DiffControllerImpl;
import org.netbeans.spi.diff.DiffControllerProvider;
import org.openide.util.Lookup;

public final class DiffController {
    public static final String PROP_DIFFERENCES = "(void) differencesChanged";
    private final DiffControllerImpl impl;

    private DiffController(DiffControllerImpl impl) {
        this.impl = impl;
    }

    public static DiffController create(StreamSource base, StreamSource modified) throws IOException {
        DiffControllerProvider provider = (DiffControllerProvider)Lookup.getDefault().lookup(DiffControllerProvider.class);
        if (provider != null) {
            return new DiffController(provider.createDiffController(base, modified));
        }
        DiffView view = Diff.getDefault().createDiff(base, modified);
        return new DiffController(new DiffControllerViewBridge(view));
    }

    public static DiffController createEnhanced(StreamSource base, StreamSource modified) throws IOException {
        DiffControllerProvider provider = (DiffControllerProvider)Lookup.getDefault().lookup(DiffControllerProvider.class);
        if (provider != null) {
            return new DiffController(provider.createEnhancedDiffController(base, modified));
        }
        DiffView view = Diff.getDefault().createDiff(base, modified);
        return new DiffController(new DiffControllerViewBridge(view));
    }

    public static DiffController createEnhanced(DiffController other, StreamSource base, StreamSource modified) throws IOException {
        DiffController newController = DiffController.createEnhanced(base, modified);
        if (other != null) {
            DiffController.copyUIState(other, newController);
        }
        return newController;
    }

    private static void copyUIState(DiffController oldView, DiffController newView) {
        JTabbedPane oldTP = DiffController.findComponent(oldView.getJComponent(), JTabbedPane.class, "diff-view-mode-switcher");
        JTabbedPane newTP = DiffController.findComponent(newView.getJComponent(), JTabbedPane.class, "diff-view-mode-switcher");
        if (newTP != null && oldTP != null) {
            newTP.setSelectedIndex(oldTP.getSelectedIndex());
        }
        JSplitPane oldSP = DiffController.findComponent(oldView.getJComponent(), JSplitPane.class, "diff-view-mode-splitter");
        JSplitPane newSP = DiffController.findComponent(newView.getJComponent(), JSplitPane.class, "diff-view-mode-splitter");
        if (newSP != null && oldSP != null) {
            newSP.setDividerLocation(oldSP.getDividerLocation());
        }
    }

    private static <T extends JComponent> T findComponent(JComponent parent, Class<T> ofType, String withProp) {
        if (ofType.isInstance(parent) && Boolean.TRUE.equals(parent.getClientProperty(withProp))) {
            return (T)parent;
        }
        for (Component child : parent.getComponents()) {
            JComponent jc;
            T comp;
            if (!(child instanceof JComponent) || (comp = DiffController.findComponent(jc = (JComponent)child, ofType, withProp)) == null) continue;
            return comp;
        }
        return null;
    }

    public void setLocation(DiffPane pane, LocationType type, int location) {
        this.impl.setLocation(pane, type, location);
    }

    public JComponent getJComponent() {
        return this.impl.getJComponent();
    }

    public int getDifferenceCount() {
        return this.impl.getDifferenceCount();
    }

    public int getDifferenceIndex() {
        return this.impl.getDifferenceIndex();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.impl.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.impl.removePropertyChangeListener(listener);
    }

    private static class DiffControllerViewBridge
    extends DiffControllerImpl {
        private final DiffView view;

        DiffControllerViewBridge(DiffView view) {
            this.view = view;
        }

        @Override
        public void setLocation(DiffPane pane, LocationType type, int location) {
            if (type == LocationType.DifferenceIndex) {
                this.view.setCurrentDifference(location);
            }
        }

        @Override
        public JComponent getJComponent() {
            return (JComponent)this.view.getComponent();
        }

        @Override
        public int getDifferenceCount() {
            return this.view.getDifferenceCount();
        }
    }

    public static enum DiffPane {
        Base,
        Modified;

    }

    public static enum LocationType {
        LineNumber,
        DifferenceIndex;

    }
}

