/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.access;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.function.IntFunction;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.modules.debugger.jpda.truffle.ast.TruffleNode;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackInfo;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleScope;

public final class CurrentPCInfo {
    public static final String PROP_SELECTED_FRAME = "selectedFrame";
    private final LocalVariable stepCmd;
    private final Reference<JPDAThread> threadRef;
    private final SourcePosition sp;
    private final TruffleScope[] scopes;
    private final TruffleStackFrame topFrame;
    private final TruffleStackInfo stack;
    private final IntFunction<TruffleNode> truffleNodes;
    private volatile TruffleStackFrame selectedStackFrame;
    private PropertyChangeSupport pchs = new PropertyChangeSupport(this);

    CurrentPCInfo(LocalVariable stepCmd, JPDAThread thread, SourcePosition sp, TruffleScope[] scopes, TruffleStackFrame topFrame, TruffleStackInfo stack, IntFunction<TruffleNode> truffleNodes) {
        this.stepCmd = stepCmd;
        this.threadRef = new WeakReference<JPDAThread>(thread);
        this.sp = sp;
        this.scopes = scopes;
        this.topFrame = topFrame;
        this.stack = stack;
        this.truffleNodes = truffleNodes;
        this.selectedStackFrame = topFrame;
    }

    public LocalVariable getStepCommandVar() {
        return this.stepCmd;
    }

    public JPDAThread getThread() {
        return this.threadRef.get();
    }

    public SourcePosition getSourcePosition() {
        return this.sp;
    }

    public TruffleScope[] getScopes() {
        return this.scopes;
    }

    public TruffleStackFrame getTopFrame() {
        return this.topFrame;
    }

    public TruffleStackInfo getStack() {
        return this.stack;
    }

    public TruffleStackFrame getSelectedStackFrame() {
        return this.selectedStackFrame;
    }

    public void setSelectedStackFrame(TruffleStackFrame selectedStackFrame) {
        TruffleStackFrame old = this.selectedStackFrame;
        this.selectedStackFrame = selectedStackFrame;
        if (old != selectedStackFrame) {
            this.pchs.firePropertyChange(PROP_SELECTED_FRAME, old, selectedStackFrame);
        }
    }

    public TruffleNode getAST(TruffleStackFrame frame) {
        return this.truffleNodes.apply(frame.getDepth());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pchs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pchs.removePropertyChangeListener(listener);
    }
}

