/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.TableListNode;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class TableListNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private PropertyChangeListener propertyChangeListener;
    private boolean setup = false;

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    @Override
    protected void initialize() {
        if (this.connection.getConnector().isDisconnected()) {
            this.removeAllNodes();
            this.setup = false;
        } else if (!this.setup) {
            this.setNodesForCurrentSettings();
            this.setup = true;
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("separateSystemTables")) {
                        TableListNodeProvider.this.setNodesForCurrentSettings();
                    }
                }
            };
            this.connection.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyChangeListener, (Object)this.connection));
        }
    }

    private void setNodesForCurrentSettings() {
        ArrayList<Node> newList = new ArrayList<Node>();
        if (this.connection.isSeparateSystemTables()) {
            newList.add((Node)TableListNode.create(this.createLookup(), this, TableListNode.Type.STANDARD));
            newList.add((Node)TableListNode.create(this.createLookup(), this, TableListNode.Type.SYSTEM));
        } else {
            newList.add((Node)TableListNode.create(this.createLookup(), this, TableListNode.Type.ALL));
        }
        this.setNodes(newList);
    }

    private NodeDataLookup createLookup() {
        NodeDataLookup lookup = new NodeDataLookup();
        lookup.add(this.connection);
        MetadataElementHandle schemaHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
        if (schemaHandle != null) {
            lookup.add(schemaHandle);
        }
        return lookup;
    }

    private TableListNodeProvider(Lookup lookup) {
        super(lookup, new TableListNodeComparator());
    }

    private static class TableListNodeComparator
    implements Comparator<Node> {
        private TableListNodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o1 instanceof TableListNode && o2 instanceof TableListNode) {
                return ((TableListNode)o1).getType().equals((Object)TableListNode.Type.SYSTEM) ? 1 : -1;
            }
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public TableListNodeProvider createInstance(Lookup lookup) {
                TableListNodeProvider provider = new TableListNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

