/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.ConnectionProgressListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ConnectPanel
extends ConnectionDialog.FocusablePanel
implements DocumentListener,
ListDataListener {
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private JPanel connectProgressPanel;
    private JCheckBox passwordCheckBox;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JPanel progressContainerPanel;
    private JLabel progressMessageLabel;
    private JLabel userLabel;
    private JTextField userTextField;

    public ConnectPanel(ConnectionDialogMediator mediator, DatabaseConnection connection) {
        this.initComponents();
        this.initAccessibility();
        ConnectionProgressListener progressListener = new ConnectionProgressListener(){

            @Override
            public void connectionStarted() {
                ConnectPanel.this.startProgress();
            }

            @Override
            public void connectionStep(String step) {
                ConnectPanel.this.setProgressMessage(step);
            }

            @Override
            public void connectionFinished() {
                ConnectPanel.this.stopProgress(true);
            }

            @Override
            public void connectionFailed() {
                ConnectPanel.this.stopProgress(false);
            }
        };
        mediator.addConnectionProgressListener(progressListener);
        this.userTextField.setText(connection.getUser());
        if (connection.rememberPassword()) {
            this.passwordField.setText(connection.getPassword());
            this.passwordCheckBox.setSelected(true);
        }
        this.userTextField.getDocument().addDocumentListener(this);
        this.passwordField.getDocument().addDocumentListener(this);
    }

    private void initAccessibility() {
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectDialogUserNameA11yDesc"));
        this.userTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectDialogUserNameTextFieldA11yName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectDialogPasswordA11yDesc"));
        this.passwordField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectDialogPasswordTextFieldA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectionProgressBarA11yName"));
        this.connectProgressPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectionProgressBarA11yDesc"));
    }

    @Override
    public void initializeFocus() {
        this.getInitiallyFocusedComponent().requestFocusInWindow();
    }

    private JComponent getInitiallyFocusedComponent() {
        if (this.userTextField.getText().length() == 0) {
            return this.userTextField;
        }
        if (this.passwordField.getPassword().length == 0) {
            return this.passwordField;
        }
        return this.userTextField;
    }

    private void initComponents() {
        this.userLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.passwordCheckBox = new JCheckBox();
        this.passwordField = new JPasswordField();
        this.userTextField = new JTextField();
        this.connectProgressPanel = new JPanel();
        this.progressMessageLabel = new JLabel();
        this.progressContainerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(ConnectPanel.class, (String)"ConnectDialogUserName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.userLabel, gridBagConstraints);
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(ConnectPanel.class, (String)"ConnectDialogPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.passwordLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.passwordCheckBox, (String)NbBundle.getMessage(ConnectPanel.class, (String)"ConnectDialogRememberPassword"));
        this.passwordCheckBox.setToolTipText(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectDialogRememberPasswordA11yDesc"));
        this.passwordCheckBox.setVerticalTextPosition(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.passwordCheckBox, gridBagConstraints);
        this.passwordField.setToolTipText(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectDialogPasswordTextFieldA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 11);
        this.add((Component)this.passwordField, gridBagConstraints);
        this.userTextField.setToolTipText(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectDialogUserNameTextFieldA11yDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 5, 0, 11);
        this.add((Component)this.userTextField, gridBagConstraints);
        this.connectProgressPanel.setToolTipText(NbBundle.getMessage(ConnectPanel.class, (String)"ACS_ConnectionProgressBarA11yDesc"));
        this.connectProgressPanel.setLayout(new BorderLayout(0, 5));
        Mnemonics.setLocalizedText((JLabel)this.progressMessageLabel, (String)" ");
        this.connectProgressPanel.add((Component)this.progressMessageLabel, "North");
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.progressContainerPanel.setLayout(new BorderLayout());
        this.connectProgressPanel.add((Component)this.progressContainerPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.add((Component)this.connectProgressPanel, gridBagConstraints);
    }

    public String getUser() {
        return this.userTextField.getText();
    }

    public String getPassword() {
        return String.valueOf(this.passwordField.getPassword());
    }

    public void showRememberPasswordOption(boolean flag) {
        this.passwordCheckBox.setVisible(flag);
    }

    public boolean rememberPassword() {
        return this.passwordCheckBox.isSelected();
    }

    public String getTitle() {
        return NbBundle.getMessage(ConnectPanel.class, (String)"ConnectDialogTitle");
    }

    private void startProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectPanel.this.progressHandle = ProgressHandle.createHandle(null);
                ConnectPanel.this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)ConnectPanel.this.progressHandle);
                ConnectPanel.this.progressContainerPanel.add((Component)ConnectPanel.this.progressComponent, "Center");
                ConnectPanel.this.progressHandle.start();
                ConnectPanel.this.progressMessageLabel.setText(NbBundle.getMessage(ConnectPanel.class, (String)"ConnectionProgress_Connecting"));
            }
        });
    }

    private void setProgressMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConnectPanel.this.progressMessageLabel.setText(message);
            }
        });
    }

    private void stopProgress(final boolean connected) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConnectPanel.this.progressHandle == null) {
                    return;
                }
                ConnectPanel.this.progressHandle.finish();
                ConnectPanel.this.progressContainerPanel.remove(ConnectPanel.this.progressComponent);
                ConnectPanel.this.progressContainerPanel.repaint();
                if (connected) {
                    ConnectPanel.this.progressMessageLabel.setText(NbBundle.getMessage(ConnectPanel.class, (String)"ConnectionProgress_Established"));
                } else {
                    ConnectPanel.this.progressMessageLabel.setText(NbBundle.getMessage(ConnectPanel.class, (String)"ConnectionProgress_Failed"));
                }
            }
        });
    }

    private void resetProgress() {
        this.progressMessageLabel.setText("");
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireChange();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireChange();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireChange();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireChange();
    }

    private void fireChange() {
        this.firePropertyChange("argumentChanged", null, null);
        this.resetProgress();
    }
}

