/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.ProcedureParamNode;
import org.netbeans.modules.db.explorer.node.ReturnValueNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Parameter;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ProcedureParamNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Procedure> handle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private static final Comparator<Node> parameterComparator = new Comparator<Node>(){

        @Override
        public int compare(Node node1, Node node2) {
            int p2;
            int p1;
            if (node1 instanceof ReturnValueNode) {
                p1 = 0;
            } else {
                ProcedureParamNode n1 = (ProcedureParamNode)node1;
                p1 = n1.getPosition();
            }
            if (node2 instanceof ReturnValueNode) {
                p2 = 0;
            } else {
                ProcedureParamNode n2 = (ProcedureParamNode)node1;
                p2 = n2.getPosition();
            }
            int result = 1;
            if (p1 < p2) {
                result = -1;
            }
            return result;
        }
    };

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ProcedureParamNodeProvider(Lookup lookup) {
        super(lookup, parameterComparator);
    }

    @Override
    protected synchronized void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = this.connection.isConnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Procedure procedure = (Procedure)ProcedureParamNodeProvider.this.handle.resolve(metaData);
                        if (procedure == null) {
                            return;
                        }
                        Collection parameters = procedure.getParameters();
                        for (Parameter parameter : parameters) {
                            MetadataElementHandle h = MetadataElementHandle.create((MetadataElement)parameter);
                            Collection matches = ProcedureParamNodeProvider.this.getNodes(h);
                            if (matches.size() > 0) {
                                newList.addAll(matches);
                                continue;
                            }
                            NodeDataLookup lookup = new NodeDataLookup();
                            lookup.add(ProcedureParamNodeProvider.this.connection);
                            lookup.add(h);
                            newList.add(ProcedureParamNode.create(lookup, ProcedureParamNodeProvider.this));
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
        this.setNodes(newList);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public ProcedureParamNodeProvider createInstance(Lookup lookup) {
                ProcedureParamNodeProvider provider = new ProcedureParamNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

