/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.utils;

import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;

public class AutoCRLFComparator
extends RawTextComparator {
    public boolean equals(RawText a, int ai, RawText b, int bi) {
        String line1 = a.getString(ai);
        String line2 = b.getString(bi);
        line1 = AutoCRLFComparator.trimTrailingEoL(line1);
        line2 = AutoCRLFComparator.trimTrailingEoL(line2);
        return line1.equals(line2);
    }

    protected int hashRegion(byte[] raw, int ptr, int end) {
        int hash = 5381;
        end = AutoCRLFComparator.trimTrailingEoL(raw, ptr, end);
        while (ptr < end) {
            hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
            ++ptr;
        }
        return hash;
    }

    private static String trimTrailingEoL(String line) {
        int end;
        for (end = line.length() - 1; end >= 0 && AutoCRLFComparator.isNewLine(line.charAt(end)); --end) {
        }
        return line.substring(0, end + 1);
    }

    private static int trimTrailingEoL(byte[] raw, int start, int end) {
        int ptr;
        for (ptr = end - 1; start <= ptr && (raw[ptr] == 13 || raw[ptr] == 10); --ptr) {
        }
        return ptr + 1;
    }

    private static boolean isNewLine(char ch) {
        return ch == '\n' || ch == '\r';
    }
}

