/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.StashCreateCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class StashSaveCommand
extends GitCommand {
    private final boolean includeUntracked;
    private final String message;
    private GitRevisionInfo stash;

    public StashSaveCommand(Repository repository, GitClassFactory accessor, String message, boolean includeUntracked, ProgressMonitor monitor) {
        super(repository, accessor, monitor);
        this.message = message;
        this.includeUntracked = includeUntracked;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            StashCreateCommand cmd = new Git(repository).stashCreate().setIncludeUntracked(this.includeUntracked).setWorkingDirectoryMessage(this.message);
            RevCommit commit = cmd.call();
            this.stash = this.getClassFactory().createRevisionInfo(commit, repository);
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git stash save ");
        if (this.includeUntracked) {
            sb.append("--include-untracked ");
        }
        return sb.append(this.message).toString();
    }

    public GitRevisionInfo getStashedCommit() {
        return this.stash;
    }
}

