/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.xml.cookies;

import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class CookieMessage {
    private final Lookup details;
    private final String message;
    private final int level;
    public static final int INFORMATIONAL_LEVEL = 0;
    public static final int WARNING_LEVEL = 1;
    public static final int ERROR_LEVEL = 2;
    public static final int FATAL_ERROR_LEVEL = 3;

    public CookieMessage(String message) {
        this(message, 0, null);
    }

    public CookieMessage(String message, int level) {
        this(message, level, null);
    }

    public CookieMessage(String message, Object detail) {
        this(message, 0, detail);
    }

    public CookieMessage(String message, int level, Object detail) {
        this(message, level, Lookups.singleton((Object)detail));
    }

    public CookieMessage(String message, int level, Lookup details) {
        if (message == null) {
            throw new NullPointerException();
        }
        if (level < 0 || level > 3) {
            throw new IllegalArgumentException();
        }
        this.message = message;
        this.level = level;
        this.details = details == null ? Lookup.EMPTY : details;
    }

    public String getMessage() {
        return this.message;
    }

    public final int getLevel() {
        return this.level;
    }

    public Object getDetail(Class klass) {
        return this.details.lookup(klass);
    }

    public Lookup getDetails() {
        return this.details;
    }
}

