/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.border;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.widget.ResourceTable;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.RenderUtil;

public final class LineBorder
implements Border {
    private Insets insets;
    private Color color;
    private ResourceTableListener listener = null;

    public LineBorder(int top, int left, int bottom, int right, Color color) {
        this.insets = new Insets(top, left, bottom, right);
        this.color = color;
    }

    public LineBorder(int top, int left, int bottom, int right, String property, Widget attachedWidget) {
        this(top, left, bottom, right, property, attachedWidget.getResourceTable());
    }

    public LineBorder(int top, int left, int bottom, int right, String property, ResourceTable table) {
        this.insets = new Insets(top, left, bottom, right);
        Object value = table.getProperty(property);
        if (value instanceof Color) {
            this.color = (Color)value;
        }
        this.listener = new ResourceTableListener();
        table.addPropertyChangeListener(property, this.listener);
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void paint(Graphics2D gr, Rectangle bounds) {
        gr.setColor(this.color);
        RenderUtil.drawRect(gr, bounds);
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public class ResourceTableListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            LineBorder.this.color = (Color)event.getNewValue();
        }
    }
}

