/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.Widget;

public final class FlowLayout
implements Layout {
    private boolean verticalOrientation;
    private LayoutFactory.SerialAlignment alignment;
    private int gap;

    public FlowLayout(boolean verticalOrientation, LayoutFactory.SerialAlignment alignment, int gap) {
        this.verticalOrientation = verticalOrientation;
        this.alignment = alignment;
        this.gap = gap;
    }

    @Override
    public void layout(Widget widget) {
        int max = 0;
        List<Widget> children = widget.getChildren();
        if (this.verticalOrientation) {
            for (Widget widget2 : children) {
                if (!widget2.isVisible()) continue;
                Rectangle preferredBounds = widget2.getPreferredBounds();
                int i = preferredBounds.width;
                if (i <= max) continue;
                max = i;
            }
            int pos = 0;
            for (Widget child : children) {
                Rectangle preferredBounds = child.getPreferredBounds();
                int x = preferredBounds.x;
                int y = preferredBounds.y;
                int width = preferredBounds.width;
                int height = preferredBounds.height;
                int lx = -x;
                int ly = pos - y;
                switch (this.alignment) {
                    case CENTER: {
                        lx += (max - width) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        width = max;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        lx += max - width;
                    }
                }
                if (child.isVisible()) {
                    child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, width, height));
                    pos += height + this.gap;
                    continue;
                }
                child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, 0, 0));
            }
        } else {
            for (Widget widget3 : children) {
                if (!widget3.isVisible()) continue;
                Rectangle preferredBounds = widget3.getPreferredBounds();
                int i = preferredBounds.height;
                if (i <= max) continue;
                max = i;
            }
            int pos = 0;
            for (Widget child : children) {
                Rectangle preferredBounds = child.getPreferredBounds();
                int x = preferredBounds.x;
                int y = preferredBounds.y;
                int width = preferredBounds.width;
                int height = preferredBounds.height;
                int lx = pos - x;
                int ly = -y;
                switch (this.alignment) {
                    case CENTER: {
                        ly += (max - height) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        height = max;
                        break;
                    }
                    case LEFT_TOP: {
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        ly += max - height;
                    }
                }
                if (child.isVisible()) {
                    child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, width, height));
                    pos += width + this.gap;
                    continue;
                }
                child.resolveBounds(new Point(lx, ly), new Rectangle(x, y, 0, 0));
            }
        }
    }

    @Override
    public boolean requiresJustification(Widget widget) {
        return true;
    }

    @Override
    public void justify(Widget widget) {
        Rectangle parentBounds = widget.getClientArea();
        int totalWeight = 0;
        int totalGap = 0;
        List<Widget> children = widget.getChildren();
        for (int a = 0; a < children.size(); ++a) {
            Widget child = children.get(a);
            if (!child.isVisible()) continue;
            totalWeight += FlowLayout.resolveWeight(widget, child);
            if (a > 0) {
                totalGap -= this.gap;
            }
            if (this.verticalOrientation) {
                totalGap -= child.getBounds().height;
                continue;
            }
            totalGap -= child.getBounds().width;
        }
        if ((totalGap += this.verticalOrientation ? parentBounds.height : parentBounds.width) < 0) {
            totalGap = 0;
            totalWeight = 0;
        }
        int gapAdd = 0;
        int weightAdd = 0;
        int parentX1 = parentBounds.x;
        int parentX2 = parentX1 + parentBounds.width;
        int parentY1 = parentBounds.y;
        int parentY2 = parentY1 + parentBounds.height;
        for (Widget child : widget.getChildren()) {
            int gap;
            int weight;
            Point childLocation = child.getLocation();
            Rectangle childBounds = child.getBounds();
            if (this.verticalOrientation) {
                switch (this.alignment) {
                    case CENTER: {
                        childLocation.x = (parentX1 + parentX2 - childBounds.width) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        childLocation.x = parentX1;
                        childBounds.width = parentX2 - parentX1;
                        break;
                    }
                    case LEFT_TOP: {
                        childLocation.x = parentX1;
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        childLocation.x = parentX2 - childBounds.width;
                    }
                }
                if (totalWeight > 0 && child.isVisible()) {
                    childLocation.y += gapAdd;
                    weight = FlowLayout.resolveWeight(widget, child);
                    gap = (weightAdd + weight) * totalGap / totalWeight;
                    childBounds.height += gap - gapAdd;
                    gapAdd = gap;
                    weightAdd += weight;
                }
                childLocation.x -= childBounds.x;
                childLocation.y += parentY1;
            } else {
                switch (this.alignment) {
                    case CENTER: {
                        childLocation.y = (parentY1 + parentY2 - childBounds.height) / 2;
                        break;
                    }
                    case JUSTIFY: {
                        childLocation.y = parentY1;
                        childBounds.height = parentY2 - parentY1;
                        break;
                    }
                    case LEFT_TOP: {
                        childLocation.y = parentY1;
                        break;
                    }
                    case RIGHT_BOTTOM: {
                        childLocation.y = parentY2 - childBounds.height;
                    }
                }
                if (totalWeight > 0 && child.isVisible()) {
                    childLocation.x += gapAdd;
                    weight = FlowLayout.resolveWeight(widget, child);
                    gap = (weightAdd + weight) * totalGap / totalWeight;
                    childBounds.width += gap - gapAdd;
                    gapAdd = gap;
                    weightAdd += weight;
                }
                childLocation.y -= childBounds.y;
                childLocation.x += parentX1;
            }
            child.resolveBounds(childLocation, childBounds);
        }
    }

    private static int resolveWeight(Widget widget, Widget child) {
        int weight;
        Object o = widget.getChildConstraint(child);
        if (o instanceof Number && (weight = ((Number)o).intValue()) > 0) {
            return weight;
        }
        return 0;
    }
}

