/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search;

public final class SearchPattern {
    private String searchExpression;
    private boolean wholeWords;
    private boolean matchCase;
    private boolean regExp;

    private SearchPattern(String searchExpression, boolean wholeWords, boolean matchCase, boolean regExp) {
        this.searchExpression = searchExpression;
        this.wholeWords = wholeWords;
        this.matchCase = matchCase;
        this.regExp = regExp;
    }

    public static SearchPattern create(String searchExpression, boolean wholeWords, boolean matchCase, boolean regExp) {
        return new SearchPattern(searchExpression, wholeWords, matchCase, regExp);
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public boolean isMatchCase() {
        return this.matchCase;
    }

    public boolean isRegExp() {
        return this.regExp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SearchPattern)) {
            return false;
        }
        SearchPattern sp = (SearchPattern)obj;
        return this.searchExpression.equals(sp.getSearchExpression()) && this.wholeWords == sp.isWholeWords() && this.matchCase == sp.isMatchCase() && this.regExp == sp.isRegExp();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.wholeWords ? 1 : 0);
        result = 37 * result + (this.matchCase ? 1 : 0);
        result = 37 * result + (this.regExp ? 1 : 0);
        result = 37 * result + this.searchExpression.hashCode();
        return result;
    }

    public SearchPattern changeSearchExpression(String expression) {
        if (expression == null && this.searchExpression == null || expression != null && expression.equals(this.searchExpression)) {
            return this;
        }
        return SearchPattern.create(expression, this.wholeWords, this.matchCase, this.regExp);
    }

    public SearchPattern changeWholeWords(boolean wholeWords) {
        if (this.wholeWords == wholeWords) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, wholeWords, this.matchCase, this.regExp);
    }

    public SearchPattern changeMatchCase(boolean matchCase) {
        if (this.matchCase == matchCase) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, this.wholeWords, matchCase, this.regExp);
    }

    public SearchPattern changeRegExp(boolean regExp) {
        if (this.regExp == regExp) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, this.wholeWords, this.matchCase, regExp);
    }

    String toCanonicalString() {
        char m = this.isMatchCase() ? (char)'M' : 'm';
        char r = this.isRegExp() ? (char)'R' : 'r';
        char w = this.isWholeWords() ? (char)'W' : 'w';
        return "" + m + r + w + "-" + this.getSearchExpression();
    }

    static SearchPattern parsePattern(String canonicalString) {
        if (canonicalString == null || Character.toUpperCase(canonicalString.charAt(0)) != 'M' || Character.toUpperCase(canonicalString.charAt(1)) != 'R' || Character.toUpperCase(canonicalString.charAt(2)) != 'W' || canonicalString.charAt(3) != '-') {
            return null;
        }
        boolean matchCase = Character.isUpperCase(canonicalString.charAt(0));
        boolean regExp = Character.isUpperCase(canonicalString.charAt(1));
        boolean wholeWords = Character.isUpperCase(canonicalString.charAt(2));
        String findWhat = canonicalString.substring(4);
        return new SearchPattern(findWhat, wholeWords, matchCase, regExp);
    }
}

