/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.lsp;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lsp.Command;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.lsp.CompletionAccessor;
import org.netbeans.spi.lsp.CompletionCollector;

public final class Completion {
    private final String label;
    private final String labelDetail;
    private final String labelDescription;
    private final Kind kind;
    private final List<Tag> tags;
    private final CompletableFuture<String> detail;
    private final CompletableFuture<String> documentation;
    private final boolean preselect;
    private final String sortText;
    private final String filterText;
    private final String insertText;
    private final TextFormat insertTextFormat;
    private final TextEdit textEdit;
    private final Command command;
    private final CompletableFuture<List<TextEdit>> additionalTextEdits;
    private final List<Character> commitCharacters;

    private Completion(String label, String labelDetail, String labelDescription, Kind kind, List<Tag> tags, CompletableFuture<String> detail, CompletableFuture<String> documentation, boolean preselect, String sortText, String filterText, String insertText, TextFormat insertTextFormat, TextEdit textEdit, Command command, CompletableFuture<List<TextEdit>> additionalTextEdits, List<Character> commitCharacters) {
        this.label = label;
        this.labelDetail = labelDetail;
        this.labelDescription = labelDescription;
        this.kind = kind;
        this.tags = tags;
        this.detail = detail;
        this.documentation = documentation;
        this.preselect = preselect;
        this.sortText = sortText;
        this.filterText = filterText;
        this.insertText = insertText;
        this.insertTextFormat = insertTextFormat;
        this.textEdit = textEdit;
        this.command = command;
        this.additionalTextEdits = additionalTextEdits;
        this.commitCharacters = commitCharacters;
    }

    @NonNull
    public String getLabel() {
        return this.label;
    }

    @CheckForNull
    public String getLabelDetail() {
        return this.labelDetail;
    }

    @CheckForNull
    public String getLabelDescription() {
        return this.labelDescription;
    }

    @CheckForNull
    public Kind getKind() {
        return this.kind;
    }

    @CheckForNull
    public List<Tag> getTags() {
        return this.tags != null ? Collections.unmodifiableList(this.tags) : null;
    }

    @CheckForNull
    public CompletableFuture<String> getDetail() {
        return this.detail;
    }

    @CheckForNull
    public CompletableFuture<String> getDocumentation() {
        return this.documentation;
    }

    public boolean isPreselect() {
        return this.preselect;
    }

    @CheckForNull
    public String getSortText() {
        return this.sortText;
    }

    @CheckForNull
    public String getFilterText() {
        return this.filterText;
    }

    @CheckForNull
    public String getInsertText() {
        return this.insertText;
    }

    @CheckForNull
    public TextFormat getInsertTextFormat() {
        return this.insertTextFormat;
    }

    @CheckForNull
    public TextEdit getTextEdit() {
        return this.textEdit;
    }

    @CheckForNull
    public Command getCommand() {
        return this.command;
    }

    @CheckForNull
    public CompletableFuture<List<TextEdit>> getAdditionalTextEdits() {
        return this.additionalTextEdits;
    }

    @CheckForNull
    public List<Character> getCommitCharacters() {
        return this.commitCharacters != null ? Collections.unmodifiableList(this.commitCharacters) : null;
    }

    public static boolean collect(@NonNull Document doc, int offset, @NullAllowed Context context, @NonNull Consumer<Completion> consumer) {
        boolean isComplete = true;
        MimePath mimePath = MimePath.parse((String)DocumentUtilities.getMimeType((Document)doc));
        for (CompletionCollector collector : MimeLookup.getLookup((MimePath)mimePath).lookupAll(CompletionCollector.class)) {
            isComplete &= collector.collectCompletions(doc, offset, context, consumer);
        }
        return isComplete;
    }

    static {
        CompletionAccessor.setDefault(new CompletionAccessor(){

            @Override
            public Completion createCompletion(String label, String labelDetail, String description, Kind kind, List<Tag> tags, CompletableFuture<String> detail, CompletableFuture<String> documentation, boolean preselect, String sortText, String filterText, String insertText, TextFormat insertTextFormat, TextEdit textEdit, Command command, CompletableFuture<List<TextEdit>> additionalTextEdits, List<Character> commitCharacters) {
                return new Completion(label, labelDetail, description, kind, tags, detail, documentation, preselect, sortText, filterText, insertText, insertTextFormat, textEdit, command, additionalTextEdits, commitCharacters);
            }
        });
    }

    public static enum TextFormat {
        PlainText,
        Snippet;

    }

    public static enum Tag {
        Deprecated;

    }

    public static enum Kind {
        Text,
        Method,
        Function,
        Constructor,
        Field,
        Variable,
        Class,
        Interface,
        Module,
        Property,
        Unit,
        Value,
        Enum,
        Keyword,
        Snippet,
        Color,
        File,
        Reference,
        Folder,
        EnumMember,
        Constant,
        Struct,
        Event,
        Operator,
        TypeParameter;

    }

    public static enum TriggerKind {
        Invoked,
        TriggerCharacter,
        TriggerForIncompleteCompletions;

    }

    public static final class Context {
        private final TriggerKind triggerKind;
        private final Character triggerCharacter;

        public Context(@NonNull TriggerKind triggerKind, @NullAllowed Character triggerCharacter) {
            this.triggerKind = triggerKind;
            this.triggerCharacter = triggerCharacter;
        }

        @NonNull
        public TriggerKind getTriggerKind() {
            return this.triggerKind;
        }

        @CheckForNull
        public Character getTriggerCharacter() {
            return this.triggerCharacter;
        }
    }
}

