/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.junit.platform.commons.util.AnnotationUtils;
import org.neo4j.test.extension.StatefulFieldExtension;
import org.neo4j.test.extension.SuppressOutput;

public class SuppressOutputExtension
extends StatefulFieldExtension<SuppressOutput>
implements BeforeEachCallback,
AfterEachCallback {
    static final String SUPPRESS_OUTPUT = "suppressOutput";
    static final ExtensionContext.Namespace SUPPRESS_OUTPUT_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"suppressOutput"});

    @Override
    protected String getFieldKey() {
        return SUPPRESS_OUTPUT;
    }

    @Override
    protected Class<SuppressOutput> getFieldType() {
        return SuppressOutput.class;
    }

    @Override
    protected SuppressOutput createField(ExtensionContext extensionContext) {
        return SuppressOutput.suppressAll();
    }

    @Override
    protected ExtensionContext.Namespace getNameSpace() {
        return SUPPRESS_OUTPUT_NAMESPACE;
    }

    public void afterEach(ExtensionContext context) {
        ((SuppressOutput)this.getStoredValue(context)).releaseVoices(context.getExecutionException().isPresent());
        this.removeStoredValue(context);
    }

    public void beforeEach(ExtensionContext context) {
        this.assertHasResourceLock(context);
        ((SuppressOutput)this.getStoredValue(context)).captureVoices();
    }

    private void assertHasResourceLock(ExtensionContext context) {
        ArrayList resourceLocks = new ArrayList();
        context.getTestMethod().ifPresent(method -> resourceLocks.addAll(AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)method, ResourceLock.class)));
        context.getTestClass().ifPresent(testClass -> {
            Class<?> cls;
            Class<?> host = testClass;
            do {
                cls = host;
                resourceLocks.addAll(AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)cls, ResourceLock.class));
            } while ((host = cls.getEnclosingClass()) != null);
        });
        if (resourceLocks.stream().noneMatch(resourceLock -> "java.lang.System.out".equals(resourceLock.value()))) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " requires `@ResourceLock( Resources.SYSTEM_OUT )` annotation.");
        }
    }
}

